/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 1999, 2001 SIL International. All rights reserved.

Distributable under the terms of either the Common Public License or the
GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: SimpleTextSrc.cpp
Responsibility: Sharon Correll
Last reviewed: Not yet.

Description:
	A simple text source that shows how to use this interface within Graphite.
-------------------------------------------------------------------------------*//*:End Ignore*/

//:>********************************************************************************************
//:>	Include files
//:>********************************************************************************************
#pragma hdrstop
// any other headers (not precompiled)

#include "GrClient.h"
#include "ITextSource.h"
#include "SimpleTextSrc.h"

#undef THIS_FILE
DEFINE_THIS_FILE

//:>********************************************************************************************
//:>	Forward declarations
//:>********************************************************************************************

//:>********************************************************************************************
//:>	Initialization and destruction
//:>********************************************************************************************

/*----------------------------------------------------------------------------------------------
	Constructors.
----------------------------------------------------------------------------------------------*/
SimpleTextSrc::SimpleTextSrc(gr::utf16 * pszText)
{
	//Assert(ichFontVar < isizeof(m_rgchFontVar));

	m_cref = 1; // COM-like behavior

	m_cchLength = wcslen(pszText);
	m_prgchText = new gr::utf16[m_cchLength + 1];
	memcpy(m_prgchText, pszText, isizeof(gr::utf16) * m_cchLength);
	m_prgchText[m_cchLength] = 0; // zero-terminate

	//memset(m_rgchFontVar, 0, isizeof(m_rgchFontVar));
	//memcpy(m_rgchFontVar, prgchFontVar, min(ichFontVar, isizeof(m_rgchFontVar)));
}


/*----------------------------------------------------------------------------------------------
	Destructor.
----------------------------------------------------------------------------------------------*/
SimpleTextSrc::~SimpleTextSrc()
{
	delete[] m_prgchText;
}

//:>********************************************************************************************
//:>	Interface methods
//:>********************************************************************************************
/*----------------------------------------------------------------------------------------------
	Get the specified range of text
----------------------------------------------------------------------------------------------*/
size_t SimpleTextSrc::fetch(toffset ichMin, size_t cch, gr::utf16 * prgchwBuffer)
{
	size_t ichRet = min(cch, m_cchLength - ichMin);
	memcpy(prgchwBuffer, m_prgchText, isizeof(gr::utf16) * ichRet);
	return ichRet;
}

/*----------------------------------------------------------------------------------------------
	Return true if the text uses a right-to-left writing system.
----------------------------------------------------------------------------------------------*/
bool SimpleTextSrc::getRightToLeft(int ich)
{
	return false;
}

/*----------------------------------------------------------------------------------------------
	Return the depth of embedding of the writing system.
----------------------------------------------------------------------------------------------*/
unsigned int SimpleTextSrc::getDirectionDepth(int ich)
{
	//if (m_fRtl)
	//	return 1;
	//else;
		return 0;
}

/*----------------------------------------------------------------------------------------------
	Return the vertical offset of the text. This simple implementation provides no
	vertical offset.
----------------------------------------------------------------------------------------------*/
float SimpleTextSrc::getVerticalOffset(int ich)
{
	return 0;
}
