/* Copyright (c) 2008-2015. The SimGrid Team.
 * All rights reserved.                                                     */

/* This program is free software; you can redistribute it and/or modify it
 * under the terms of the license (GNU LGPL) which comes with this package. */

/* simgrid/modelchecker.h - Formal Verification made possible in SimGrid    */

#ifndef SIMGRID_MC_REPLAY_H
#define SIMGRID_MC_REPLAY_H

#include <xbt/base.h>

SG_BEGIN_DECL()

/** Replay path (if any) in string representation
 *
 *  This is using the format generated by traceToString().
 */
XBT_PUBLIC_DATA(char*) MC_record_path;

/** Whether the replay mode is enabled */
static inline int MC_record_replay_is_active(void) {
  return MC_record_path != 0;
}

SG_END_DECL()

#endif
