#define XERR
#include "incidence.ih"

    // Incidence parameters: Male, Female, Breast.
    // BRCA1 and BRCA2 are configured, but not used because their
    // probabilities are 0.

void Incidence::setIncidence()
{
    SimulationType simulationType = Globals::simulationType();

    StringVect base{ "Tumor:", "Incidence:" };

    switch (simulationType)
    {
        case BREAST:
            base.resize(4);                         // set [2] and [3] in
        break;                                      // setincidence2.cc

        case MALE:
            base.push_back(Globals::label(MALE));
        break;

        case FEMALE:
            base.push_back(Globals::label(FEMALE));
        break;
    }

    if (simulationType != BREAST)
    {
        base.push_back("");
        setIncidence(base, 0, false);               // no probability
        d_cumProb.push_back(1);
    }
    else
    {
        for (size_t idx = 0; idx != s_incidence.size(); ++idx)
        {
            base[2] = s_incidence[idx];
            setIncidence(base, idx, true);          // set probability
        }

        if (not valid(sumProbs()))                  // probs must sum to 1
        {
            Err::msg(Err::INCIDENCE_SUM_PROB) << endl;
            return;
        }
    }
}
