#include "basicmessages.h"
#include "messagecomplextypes.h"
#include "messagebasictypes.h"
using namespace std;
using namespace Msg;


void commandParserGetSoftwareDescriptionRequest(Message & returnMessage, Message & message)
{
  pushFrontstring8(returnMessage,string(PACKAGE_NAME));
}


void commandParserGetSoftwareVersionRequest(Message & returnMessage, Message & message)
{
  pushFrontstring8(returnMessage,string(PACKAGE_VERSION));
}


void commandParserGetCompileDateRequest(Message & returnMessage, Message & message)
{
  pushFrontstring8(returnMessage,string( __DATE__ " " __TIME__ ));
}


void commandParserMessageEchoRequest(Message & returnMessage, Message & message)
{
  returnMessage.setMessage(message.size(),message.getDataPtr());
}


void basicMessagesParser(Message & returnMessage, Message & message)
{
  uint8 messageID;
  popFrontuint8(message, messageID);

  switch (messageID)
  {
  case 1:
    commandParserGetSoftwareDescriptionRequest(returnMessage, message);
    pushFrontuint8(returnMessage,2);
    break;

  case 3:
    commandParserGetSoftwareVersionRequest(returnMessage, message);
    pushFrontuint8(returnMessage,4);
    break;

  case 5:
    commandParserGetCompileDateRequest(returnMessage, message);
    pushFrontuint8(returnMessage,6);
    break;

  case 7:
    commandParserMessageEchoRequest(returnMessage, message);
    pushFrontuint8(returnMessage,8);
    break;
  }
}
