=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: postgresql module, dbi import frame
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module  SiSU_DBI                                                                 #% database building
  require "#{SiSU_lib}/help"
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  include SiSU_Screen
  require "#{SiSU_lib}/param"
  include SiSU_Param
  require "#{SiSU_lib}/common_db"
  include SiSU_DB
  require "#{SiSU_lib}/common_db_flatfile"
  include SiSU_Format_Shared
  class SiSU_SQL
    def initialize(cf,inst,fns='')
      SiSU_Env::Load.new('dbi',true).prog
      @cf,@instruct,@fns=cf,inst,fns
      @db=SiSU_Env::Info_db.new
      @instruct ||='help'
      if cf=~/D/:     @sql_type='pg'
      elsif cf =~/d/: @sql_type='sqlite'
      end
    end
    def read_psql
      begin
        db,user,dbi=@db.db_psql,@db.user,@db.dbi_psql
        @conn=DBI.connect(dbi,user,db) 
      rescue
        SiSU_DB::Case.new(@cf,@conn,'createdb',@sql_type,@fns).cases
        @conn=DBI.connect(dbi,user,db) 
      ensure
      end
    end
    def read_sqlite
      begin
        sql_type='sqlite'
        dbi=@db.dbi_sqlite
        @conn=DBI.connect(dbi) 
      rescue
      ensure
      end
    end
    def connect
      case @sql_type
      when /pg/:     read_psql
      when /sqlite/: read_sqlite
      end
      tell=SiSU_Screen::Ansi.new(@cf,"DBI (#@sql_type) #@instruct")
      tell.dbiTitle unless @cf =~/q/
      begin
        if @fns: SiSU_DB::Case.new(@cf,@conn,@instruct,@sql_type,@fns).cases
        else     SiSU_DB::Case.new(@cf,@conn,@instruct,@sql_type).cases
        end
      rescue:    SiSU_Errors::Info_error.new($!,$@,@cf,@fns).error
      ensure
      end
      @conn.disconnect if @sql_type =~/sqlite/
    end
  end
end
__END__

