=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: Default values (reset by skins)
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
$latex_run=nil
module SiSU_Viz
  require 'uri'
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  require "#{SiSU_lib}/css"
  include SiSU_Style
  class JavaScript
    attr_reader :sponsor,:catalogue,:books,:journals,:conferences,:services,:mail
    def initialize
      @sponsor=@catalogue=@books=@journals=@conferences=@services=@mail=nil
    end
  end
  class Glyph
    def bullet # &bullet;
      '&#149;&nbsp;' # [&#149; flagged]
    end
  end
  class Html
    def hardspace
      '&nbsp;'
    end
  end
  class Php #
    def persist
    end
  end
  class Javascript #kxjs knxjs
    def infobox
    end
    def knxjs
    end
    def head
    end
    def top
    end
    def sisu
    end
    def home
    end
    def sponsor
    end
    def books
    end
    def journals
    end
    def conferences
    end
    def services
    end
    def catalogue
    end
    def doc
    end
    def toc
    end
    def seg
    end
    def mail
    end
    def manifest
    end
    def status
    end
    def next
    end
    def prev
    end
    def portrait
    end
    def landscape
    end
    def pdf
    end
    def wmap
    end
    def instruments
    end
    def external
    end
    def gopher
    end
    def ftp
    end
    def law
    end
    def disclaimer
    end
    def old
    end
  end
  class Path < SiSU_Env::Info_dir
    def stylesheet_home
      dir=SiSU_Env::Info_dir.new
      %{  <link rel="stylesheet" href="./#{dir.style}/index.css" type="text/css" />}
    end
  end
  class Url < Path
    def initialize
      @js=Javascript.new #
    end
    def urify(uri)
      URI.parse(uri)
    end
    def sisu
      'http://www.jus.uio.no/sisu'
    end
    def root
      '/sisu' #watch
    end
    def root_http
      'http://www.jus.uio.no/sisu' #watch
    end
    def home
      'http://www.jus.uio.no/sisu' # used in pdf header
    end
    def site #used as stub... where there are subdirectories and is different from home
      home
    end
    def server_alias
    end
    def txt
      'www.jus.uio.no/sisu'
    end
    def path_image_base #used for html image display
      '../_sisu/image_local'
    end
    def path_image #used for html image display
      '../_sisu/image'
    end
    def path_ebook_dir
      './ebook'
    end
    def path_ebook_images
      '.'
    end
    def books_amazon
      ''
    end
    def books_barnes_noble
      ''
    end
    def promo
      ''
    end
    def promo_home
      ''
    end
  end
  class Color < SiSU_Style::Color 
    def shadow
      '"4"'
    end
    def body
      %{<body bgcolor="#ffffff" text="#000000" link="#003090" lang="en" xml:lang="en">}
      #%{\n<body bgcolor="#ffffff" text="#000000" link="#003090" vlink"#0044cc" lang="en">\n}
    end
  end
  class Icon
    def ico
      'rb7.ico'
    end
    def sisu
      'sisu.png'
    end
    def manifest
      'bullet_red.png'
    end
    def doc
      'b_doc.png'
    end
    def toc
      'b_toc.png'
    end
    def wmp
      'b_wmp.png'
    end
    def pdf
      'b_pdf.png'
    end
    def pdf_portrait
      'b_pdf.png'
    end
    def pdf_landscape
      'b_pdf.png'
    end
    def status
      'b_status.png'
    end
    def external
      'b_ext.png'
    end
    def external_toc
      'b_ext_toc.png'
    end
    def seg_toc
      'b_bluebell.png'
    end
    def crosslink_toc
      'b_amber.png'
    end
    def mail
      'b_mail.png'
    end
    def para
      'b_para.png'
    end
    def pdf
      'b_pdf.png'
    end
    def ftp
      'b_ftp.png'
    end
    def gopher
      'b_gopher.png'
    end
    def choice
      'b_choice.png'
    end
    def new
      'b_new.png'
    end
    def law
      'b_law.png'
    end
    def book
      'b_amber.png' 
      # b_book.png
    end
    def nav_endnote
      'b_itm.page.png'
    end
    def chapters
      'b_itm.chapters.png'
    end
    def dot_clear
      'dot_clear.png'
    end
    def dot_white
      'dot_white.png'
    end
    def dot
      dot_white
    end
    def amber
      'b_amber.png'
    end
    def rose
      'b_rose.png'
    end
    def bluebell
      'b_bluebell.png'
    end
    def home_button
      'sisu.png'
    end
    def home_banner
      'sisu.png'
    end
    def bluedot
      'blueband.png'
    end
    def next
      #'next.png'
      #'arrow_next_blue.png'
      'arrow_next_red.png'
    end
    def previous
      #'previous.png'
      #'arrow_prev_blue.png'
      'arrow_prev_red.png'
    end
    def up
      #'toctoc.png'
      #'arrow_up_blue.png'
      'arrow_up_red.png'
    end
  end
  class Font
    def initialize
      @css=SiSU_Env::CSS_default.new
      @fonts='verdana, arial, georgia, tahoma, sans-serif, helvetica, times, roman'
      #@fonts='verdana, arial, georgia, tahoma, sans-serif, helvetica, "times new roman", times, roman'
      #@fonts="verdana, sans-serif, arial, 'times new roman', times, roman, helvetica"
    end
    def fonts
      @fonts
    end
    def face
      %{face="#{fonts}"}  
    end
    def lmtoc_face
      %{face="#{fonts}"} 
    end
    def ebook_face
      %{face="#{fonts}"} 
    end
    def face_lmtoc
      %{face="#{fonts}"} 
    end
    def color
      'color="#000000"'
    end
    def size
      'size="4"'
    end
    def size_title
      'size="4"'
    end
    def size_header_1
      'size="4"'
    end
    def size_header_2
      'size="4"'
    end
    def size_header_3
      'size="4"'
    end
    def size_header_4
      'size="4"'
    end
    def size_header_5
      'size="4"'
    end
    def size_header_6 
      'size="4"'
    end
    def size_txt
      'size="4"'
    end
    def size_txt_00
      'size="3"'
    end
    def size_endnote
      'size="3"'
    end
    def small
      'size="3"'
    end
    def tiny
      'size="2"'
    end
  end
  class Txt
    def generator
      v=SiSU_Env::Info_version.new.get_version
      %{  <meta name="generator" content="#{v[:project]} #{v[:version]} of #{v[:date_stamp]} (#{v[:date]}) (n*x and Ruby!)" />
  <link rel="generator" href="http://www.jus.uio.no/sisu" />}
    end
    def generator_comment
      v=SiSU_Env::Info_version.new.get_version
      %{  <!-- #{v[:project]} #{v[:version]} of #{v[:date_stamp]} (#{v[:date]}) (n*x and Ruby!)" http://www.jus.uio.no/sisu -->}
    end
    def hp
      '&nbsp;SiSU'
    end
    def hp_alias
      'SiSU'
    end
    def home
      'SiSU'
    end
    def signature # used in latex/pdf footer
      'SiSU'
    end
  end
  class Markup
    def italics_list #regular expression of words to be italised
    end
    def bold_list #regular expression of words to be made bold
      'SiSU'
    end
    def make_italic
      if defined? italics_list and italics_list
        #make=italics_list.split(/;\s+/).join('|').strip
        make=Hash.new
        if italics_list
          r=italics_list.dup
          x=case r
          when /\/i$/: 'i'
          else         ''
          end
          r.gsub!(/^\/(.+?)\/i?/,"\\1")
          r.gsub!(/\(/,'(?:') # avoid need to escape use of brackets within regex provided
          m='\b(' + r + ')\b'
          make[:str]
          make[:regx]=if x =~/i/: /#{m}/i
          else                    /#{m}/
          end
        else nil
        end
      end
    end
    def make_bold
      if defined? bold_list and not bold_list.empty?
        make=Hash.new
        if bold_list
          #make=bold_list.split(/;\s+/).join('|').strip
          r=bold_list.dup
          x=case r
          when /\/i$/: 'i'
          else         ''
          end
          r.gsub!(/^\/(.+?)\/i?/,"\\1")
          r.gsub!(/\(/,'(?:') # avoid need to escape use of brackets within regex provided
          m='\b(' + r + ')\b'
          make[:str]
          make[:regx]=if x =~/i/: /#{m}/i
          else                    /#{m}/
          end
        else nil
        end
        make
      end
    end
  end
  class Paragraph
    def initialize
      @font=Font.new
    end
    def txt
      %{<p align="justify"><font #{@font.size_txt} #{@font.color} #{@font.face}>}
    end
    def txt_00
      %{<p align="justify"><font #{@font.size_txt_00} #{@font.color} #{@font.face}>}
    end
    def font_citation
      %{<font #{@font.size_txt} #{@font.face}>}
    end
    def endnote
      %{<p align="justify"><font #{@font.size_endnote} #{@font.color} #{@font.face}>}
    end
    def table
      %{<p align="left"><font #{@font.small} #{@font.color} #{@font.face}>}
    end
    def table_xml
    end
    def tiny
      %{<p align="justify"><font #{@font.tiny} #{@font.color} #{@font.face}>}
    end
    def small
      %{<p align="justify"><font #{@font.small} #{@font.color} #{@font.face}>} # keep but not used?
    end
    def fontTiny
      %{<font #{@font.tiny} #{@font.face}>}
    end
    def fontSmall
      %{<font #{@font.small} #{@font.face}>}
    end
    def header_title
      %{<p align="justify"><font #{@font.size_title} color="#0000ff" #{@font.face}>}
    end
    def header_1
      %{<p align="center"><font #{@font.size_header_1} color="#000000" #{@font.face}>}
    end
    def header_2
      %{<p align="center"><font #{@font.size_header_2} color="#000000" #{@font.face}>}
    end
    def header_3
      %{<p align="center"><font #{@font.size_header_3} color="#990000" #{@font.face}>}
    end
    def header_4
      %{<p align="center"><font #{@font.size_header_4} color="#ff0000" #{@font.face}>}
    end
    def header_5
      %{<p align="center"><font #{@font.size_header_5} color="#ff0000" #{@font.face}>}
    end
    def header_6
      %{<p align="center"><font #{@font.size_header_6} color="#ff0000" #{@font.face}>}
    end
  end
  class Table
    def close
      "</td></tr>
</table>"
    end
    def close_centered_table
    end
    def align_A
    end
    def align_B
    end
    def align_C
    end
    def width_1
      '"100%"'
    end
    def width_2
      '"99%"'
    end
    def width_3
      '"94%"'
    end
    def width_4
      '"90%"'
    end
    def width_txt
      '"94%"'  
    end
    def width_txt_avgo
      '"100%"'
    end
    def width_txt_r
      '"96%"'
    end
    def cellpad_small_paper_margins
      '"6"'
    end
    def cellpad_paper_margins
      '"36"'
    end
    def cellpad_A
      '"0"'
    end
    def cellpad_B
      '"20"'
    end
    def cellpad_shadow
      '"4"'
    end
    def cellpad_band
      '"16"'
    end
    def cellpad_box
      '"20"'
    end
    def table_align_A
      '<center>'
    end
    def table_align_B
      '<center>'
    end
    def table_align_C
      ' '
    end
  end
  class Table_do
    def initialize
      @color=Color.new
      @table=Table.new
    end
    def table_paper
      %{#{@table.align_C} <table summary="table paper" width=#{@table.width_2} border="0" cellpadding=#{@table.cellpad_paper_margins} bgcolor=#{@color.paper} align="Justify"><tr><td>\n<font color="#000000"><p />\n}
    end
    def table_surround
      %{<table summary="table surround" width="100%" border="0" cellpadding="0" bgcolor="#ffffff" align="center"><tr><td>\n}
    end
  end
  class Indent
    def level_0
      '"1%"'
    end
    def level_0_c2w100
      '"99%"'
    end
    def level_1
      '"4%"'
    end
    def level_1_c2w100
      '"96%"'
    end
    def level_2
      '"6%"'
    end
    def level_2_c2w100
      '"94%"'
    end
    def level_3
      '"8%"'
    end
    def level_3_c2w100
      '"92%"'
    end
    def level_4
      '"10%"'
    end
    def level_4_c2w100
      '"90%"'
    end
    def level_5
      '"12%"'
    end
    def level_6
      '"14%"'
    end
  end
  class Margin
    def initialize
      @indent=Indent.new
      @table=Table.new
      @color=Color.new
    end
    def num
      %{</font> </td><td width="4%" align="right" valign="top">}
    end
    def numless
      %{</td><td width="4%" align="right" valign="top">}
    end
    def num_css
      %{</td>
<td width="2%" align="right" valign="top">  }
    end
    def num_header
      %{</td>
<td width="4%" align="right" valign="top">}
    end
    def txt_num_0
      %{<td width=#{@indent.level_0} align="right">
</td>
<td valign="top" align="justify">}
    end
    def txt_num_1
      %{<td width=#{@indent.level_1} align="right">
</td>
<td valign="top" align="justify">}
    end
    def txt_num_2
      %{<td width=#{@indent.level_2} align="right">
</td>
<td valign="top" align="justify">}
    end
    def txt_00_0
      %{<table summary="" width=#{@table.width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{@indent.level_0} align="right">
</td>
<td valign="top" align="left" width=#{@indent.level_0_c2w100}>}
    end
    def txt_00_1
      %{<table summary="" width=#{@table.width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{@indent.level_1} align="right">
</td>
<td valign="top" align="left" width=#{@indent.level_1_c2w100}>}
    end
    def txt_00_2
      %{<table summary="" width=#{@table.width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{@indent.level_2} align="right">
</td>
<td valign="top" align="left" width=#{@indent.level_2_c2w100}>}
    end
    def txt_w0
      %{<table summary="" width=#{@table.width_txt_r} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width="2%" align="right">&nbsp;</td>
<td width="94%" valign="top" align="justify">}
    end
    def txt_w1
      %{<table summary="" width=#{@table.width_txt_r} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width="6%" align="right">&nbsp;</td>
<td width="90%" valign="top" align="justify">}
    end
    def txt_w2
      %{<table summary="" width=#{@table.width_txt_r} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width="10%" align="right">&nbsp;</td>
<td width="86%" valign="top" align="justify">}
    end
    def txt_0
      %{<table summary="" width=#{@table.width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{@indent.level_0} align="right">
</td><td valign="top" align="justify">}
    end
    def txt_1
      %{<table summary="" width=#{@table.width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{@indent.level_1} align="right"></td><td valign="top" align="justify">}
    end
    def txt_2
      %{<table summary="" width=#{@table.width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{@indent.level_2} align="right">
</td>
<td valign="top" align="justify">}
    end
    def txt_3
      %{<table summary="" width=#{@table.width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{@indent.level_3} align="right">
</td>
<td valign="top" align="justify">}
    end
    def txt_4
      %{<table summary="" width=#{@table.width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{@indent.level_4} align="right">
</td><td valign="top" align="justify">}
    end
    def txt_5
      %{<table summary="" width=#{@table.width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{@indent.level_5} align="right">
</td>
<td valign="top" align="justify">}
    end
    def txt_6
      %{<table summary="" width=#{@table.width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{@indent.level_6} align="right">
</td>
<td valign="top" align="justify">}
    end
    def css
      %{<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td valign="top" align="justify"> }
    end
    def table_paper_nomargin
      %{<table summary="" width=#{@table.width_3} border="0" cellpadding=#{@table.cellpad_shadow} bgcolor=#{@color.nav_penumbra} align="center">
<tr><td>
  #{@table.align_C}
<table summary="" width="100%" border="0" cellpadding=#{@table.cellpad_shadow} bgcolor=#{@color.nav_umbra} align="center">
<tr><td>
#{@vz['table']['align_C']}
<table summary="" width=#{@table.width_2} border="0" cellpadding="0" bgcolor=#{@color.paper} align="justify">
<tr><td>
  <font color="#000000">
  <p />}
    end
    def paper
      %{<table summary="" width="100%" border="0" cellpadding=#{@table.cellpad_paper_margins} bgcolor=#{@color.paper} align="justify">
<tr><td>
  <font color="#000000"><p />}
    end
    def paper_small
      %{<table summary="" width="100%" border="0" cellpadding=#{@table.cellpad_small_paper_margins} bgcolor=#{@color.paper} align="justify">\n<tr><td>\n<font color="#000000"><p />\n}
    end
  end
  class Png
    def initialize
      @url=Url.new
      @icon=Icon.new
      @txt=Txt.new
    end
    def ico
      %{  <link rel="shortcut icon" href="../_sisu/image/#{@icon.ico}" />}
    end
    def sisu
      %{  <a href="#{@url.sisu}"> 
    <img border="0" width="160" height="60" src="#{@url.path_image}/#{@icon.sisu}" alt="SiSU" />
  </a>}
    end
    def hp
      dir=SiSU_Env::Info_dir.new #(@fns)
      %{  <a href="#{@url.site}">
    <img border="0" width="160" height="60" src="#{dir.url_images_local}/#{@icon.home_banner}" alt="#{@txt.home}" />
  </a>}
    end
    def hp_nav
      %{<img border="0" height="15" width="15" src="#{@url.path_image}/#{@icon.bluebell}" alt="LM" />}
    end
    def nav
      %{<img border="0" height="15" width="15" src="#{@url.path_image}/#{@icon.bluebell}" alt="Contents" />}
    end
    def manifest
      %{<img border="0" height="12" width="12" src="#{@url.path_image}/#{@icon.manifest}" alt="Document Manifest" />}
    end
    def doc
      %{<img border="0" height="15" width="15" src="#{@url.path_image}/#{@icon.doc}" alt="Full Text" />}
    end
    def toc
      %{<img border="0" height="18" width="15" src="#{@url.path_image}/#{@icon.toc}" alt="TOC linked" />}
    end
    def pdf
      %{<img border="0" height="18" width="15" src="#{@url.path_image}/#{@icon.pdf}" alt="PDF" />}
    end
    def pdf_portrait
      %{<img border="0" height="18" width="15" src="#{@url.path_image}/#{@icon.pdf}" alt="PDF portrait" />}
    end
    def pdf_landscape
      %{<img border="0" height="15" width="18" src="#{@url.path_image}/#{@icon.pdf}" alt="PDF landscape" />}
    end
    def wmp
      %{<img border="0" height="15" width="15" src="#{@url.path_image}/#{@icon.wmp}" alt="Word Map" />}
    end
    def para
      %{<img border="0" height="15" width="15" src="#{@url.path_image}/#{@icon.para}" alt="Segment" />}
    end
    def status
      %{<img border="0" height="15" width="15" src="#{@url.path_image}/#{@icon.status}" alt="Membership status" />}
    end
    def mark
      %{<img border="0" height="15" width="15" src="#{@url.path_image}/#{@icon.rose}" alt="*" />}
    end
    def doc_tiny
      %{<img border="0" height="8" width="8" src="#{@url.path_image}/#{@icon.doc}" alt="Doc" />}
    end
    def toc_tiny
      %{<img border="0" height="8" width="8" src="#{@url.path_image}/#{@icon.toc}" alt="TOC" />}
    end
    def status_tiny
      %{<img border="0" height="8" width="8" src="#{@url.path_image}/#{@icon.status}" alt="Status, Member States" />}
    end
    def law
      %{<img border="0" height="15" width="15" src="#{@url.path_image}/#{@icon.law}" alt="LM TOC" />}
    end
    def ftp
      %{<img border="0" height="15" width="15" src="#{@url.path_image}/#{@icon.ftp}" alt="FTP" />}
    end
    def gopher
      %{<img border="0" height="15" width="15" src="#{@url.path_image}/#{@icon.gopher}" alt="Gopher" />}
    end
    def crosslink
      %{<img border="0" height="15" width="15" src="#{@url.path_image}/#{@icon.crosslink_toc}" alt="lateral hop" />}
    end
    def crosslink_ext
      %{<img border="0" height="15" width="15" src="#{@url.path_image}/#{@icon.external_toc}" alt="lateral hop" />}
    end
    def home
      dir=SiSU_Env::Info_dir.new #(@fns)
      %{<img border="0" src="#{dir.url_images_local}/#{@icon.home_button}" alt="#{@txt.home} --&gt;" />}
    end
    def site
      dir=SiSU_Env::Info_dir.new #(@fns)
      %{<img src="#{dir.url_images_local}/#{@icon.home_banner}" alt="#{@url.txt}" border="0" />}
    end
    def book
      %{<img border="2" height="15" width="15" src="#{@url.path_image}/#{@icon.book}" alt="Cameron May Books" />}
    end
  end
  class Nav_txt
    def initialize
      @png=Png.new
      @font=Font.new
      @txt=Txt.new
    end
    def home
    end
    def manifest_link                                                  #decide whether to hard link
      #<a href="sisu_manifest.html">
      %{  <font face="#{@font.fonts}" size="2">
    #{@png.manifest}&nbsp;&nbsp;manifest&nbsp;
  </font> }
    end
    def toc_link
      %{  <font face="#{@font.fonts}" size="2">
    #{@png.toc}&nbsp;&nbsp;segments'&nbsp;toc&nbsp;
  </font> }
    end
    def doc_link
      %{  <font face="#{@font.fonts}" size="2">
    #{@png.doc}&nbsp;&nbsp;scroll&nbsp;
  </font> }
    end
    def wmap
      %{  <font face="#{@font.fonts}" size="2">
    &nbsp;&nbsp;index&nbsp;
  </font> }
    end
    def previous
      %{  <font face="" size="2">
    &nbsp;&nbsp;<b>&lt;&lt;</b>&nbsp;Previous&nbsp;&nbsp;
  </font> 
  Full&nbsp;Text&nbsp;}
    end
    def next
      %{  <font face="#{@font.fonts}" size="2">
    &nbsp;&nbsp;Next&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>&gt;&gt;</b>&nbsp;&nbsp;
  </font> }
    end
    def pdfs
      %{  <font face="#{@font.fonts}" size="2">
    pdfs&nbsp;&nbsp;
  </font> }
    end
    def pdf_portrait
      %{  <font face="#{@font.fonts}" size="2">
    #{@png.pdf_portrait}
    &nbsp;&nbsp;portrait&nbsp;
  </font> }
    end
    def pdf_landscape
      %{  <font face="#{@font.fonts}" size="2">
    #{@png.pdf_landscape}
    &nbsp;&nbsp;landscape&nbsp;
  </font> }
    end
  end
  class Nav_png
    def initialize
      @url=Url.new
      @icon=Icon.new
    end
    def home
    end
    def toc
      %{<img border="0" width="22" height="22" src="#{@url.path_image}/#{@icon.up}" alt="TOC" />}
    end
    def doc
    end
    def previous
      %{<img border="0" width="22" height="22" src="#{@url.path_image}/#{@icon.previous}" alt="&lt;&lt;&nbsp;previous" />}
    end
    def next
      %{<img border="0" width="22" height="22" src="#{@url.path_image}/#{@icon.next}" alt="next&nbsp;&gt;&gt;" />}
    end
    def pre
      previous
    end
    def nxt
      self.next
    end
    def pdf_portrait
      %{<img border="0" width="15" height="18" src="#{@url.path_image}/#{@icon.pdf}" alt="pdf portrait" />}
    end
    def pdf_landscape
      %{<img border="0" width="18" height="15" src="#{@url.path_image}/#{@icon.pdf}" alt="pdf landscape" />}
    end
    def dot_toc
      %{<img border="0" width="100%" height="20" src="#{@url.path_image}/#{@icon.dot}" alt="~/." />}
    end
    def dot_previous
      %{<img border="0" width="100%" height="20" src="#{@url.path_image}/#{@icon.dot}" alt="&lt;&lt; Pre" />}
    end
    def dot_next
      %{<img border="0" width="100%" height="20" src="#{@url.path_image}/#{@icon.dot}" alt="Nxt &gt;&gt;" />}
    end
    def dot_pre
      dot_previous
    end
    def dot_nxt
      dot_next
    end
  end
  class Banner
    def initialize
      @url=Url.new
      @icon=Icon.new
      @table=Table.new
      @png=Png.new
      @color=Color.new
      @font=Font.new
      @table=SiSU_Viz::Table.new
      @js=SiSU_Viz::Javascript.new
    end
    def blueband
      #%{<center><img border="0" height="2" width="240" src="#{@url.path_image}/#{@icon.bluedot}"></center>}
      %{<img border="0" height="2" width="240" src="#{@url.path_image}/#{@icon.bluedot}" />}
    end
    def open_blue
      %{  <center>
<table summary="blueband" border="0" cellpadding="0" bgcolor="#ffffff" align="center" width="240">
<tr><td align="center">}
    end
    def close_blue
      %{#{@table.close}
  </center>}
    end
    def sisu
      v=SiSU_Env::Info_version.new.get_version
      %{  <center>
  <a href="#{@url.sisu}" target="_top">
    #{@png.sisu}
  </a>
  <br />
  <font size="2" color="#444444">
    an
    <br />
    #{v[:project]}
  </font>
</center>}
    end
    def home
      %{  <center>
    <a href="#{@url.site}/" target="_top" #{@js.home}>
      #{@png.site}
    </a>
  <br />
  <font size="2" color="#444444">
    an
  <br />
    (&nbsp;international&nbsp;|&nbsp;transnational&nbsp;)
  <br />
    commercial&nbsp;law&nbsp;&&nbsp;e-commerce
  <br />
    infrastructure monitor</font></center>}
    end
    def home_guide
      %{  <br />
    <a href="#{@url.site}/" target="_top" #{@js.home}>
      #{@png.doc} LM toc
    </a> 
    <a href="../treaties.and.organisations/lm.chronological" target="_top" #{@js.instruments}>
      #{@png.doc} LM 20**
    </a>
  <br />}
    end
    def home_button #yellow_dark now white
      %{<table summary="home button" width="100%" border="0" cellpadding="3" bgcolor= "#ffffff" align="center">
<tr><td align="left" valign="middle" bgcolor="#{@color.white}" width="10%">
  <a href="#{@url.site}/" #{@js.home}>
    #{@png.home}
  </a>
</td>
<td width="90%">
#{@table.close}}
    end
    def home_and_index_buttons #yellow_dark now white
      %{<table summary="home and index buttons" bgcolor=#{@color.band1}>
<tr><td width="20%">
<table summary="home button" width="100%" border="0" cellpadding="3" align="center">
<tr><td align="center" valign="middle" bgcolor="#{@color.white}">
  <a href="#{@url.site}/" target="_top" #{@js.home}>
    #{@png.home}
  </a>
</td></tr>
</table>
</td>
<td width="60%">
<table summary="other contents buttons" border="0" cellpadding="3" cellspacing="0">
<tr><td align="center" bgcolor=#{@color.band2}>
  <font face="arial" size="2">
    <a href="toc" target="_top" #{@js.toc}>
      &nbsp;This&nbsp;text's&nbsp;sub-&nbsp;
    <br />
      &nbsp;Table&nbsp;of&nbsp;Contents&nbsp;
    </a>
  </font>
</td></tr>
</table>
</td>
<td width="20%">
  &nbsp;
#{@table.close}}
    end
    def url_txt_sisu
      %{<a href="#{@url.sisu}/sisu" target="_top" #{@js.home}>SiSU</a>}
    end
    def url_txt_org
      %{<a href="#{@url.site}/" target="_top" #{@js.home}>#{@txt.url}</a>}
    end
    def ebook_blueband
      %{<center><img border="0" height="2" width="240" src="./#{@icon.bluedot}" /></center>}
    end
    def credit_band
      %{<table summary="credits table yellow" width="80%" border="1" cellpadding="0" bgcolor="#{@color.yellow_dark}" align="center">
<tr><td align="center">
<table summary="salmon" width="100%" border="0" cellpadding="0" bgcolor="#ffdec9">
<tr><td align="center">
<table summary="credits white background" width="100%" border="0" cellpadding="6" bgcolor="#ffffff">
<tr><td align="center">}
    end
    def credit_lmtoc_band
      %{<table summary="" width="58%" border="1" cellpadding="0" bgcolor=#{@color.yellow_dark}>
<tr><td>
<table summary="" width="100%" border="1" cellpadding="12" bgcolor="#ffffff">
<tr><td align="justify">} #\n
    end
    def band #yellow_dark now white
      %{<table summary="home button" width="100%" border="0" cellpadding="3" bgcolor= "#ffffff" align="center">
<tr><td align="left" valign="middle" bgcolor="#{@color.white}">
  <a href="#{@url.site}/" target="_top" #{@js.home}>
    #{@png.home}
  </a>
</td>
<td width="90%">
#{@table.close}}
    end
    def band_hardlink #watch and possibly remove, used though
      %{<table summary="hardlink band" width="30%" border="0" cellpadding="3" cellspacing="0" bgcolor= "#ffffff" align="center">
<tr><td align="center" valign="middle" bgcolor="#{@color.yellow_dark}">
  <font face="arial" size="2">
    <a href="#{@url.site}/" target="_top" #{@js.home}>
      <b>#{@txt.alias}</b>
    </a>
  </font>
</td>
<td align="center" valign="middle" bgcolor=#{@color.beige}>
  <font face="arial" size="2">
    <a href="http://www.jus.uio.no/lm/information.technology/information.technology" target="_top" #{@js.home}>
      Information
    <br />
      Technology
    </a>
    </font>
#{@table.close}}
    end
    def band_lmtoc
      %{<table summary="lm toc band" width="100%" border="0" cellpadding="3" cellspacing="0" bgcolor= "#ffffff" align="center">
<tr><td align="left" valign="middle" bgcolor="#{@color.yellow_dark}">
  <font face="arial" size="2">
    <a href="index" target="_top" #{@js.toc}>
      #{@png.nav}&nbsp;<b>LM</b>
    <br />
      home
    </a>
  </font>
#{@table.close}}
    end
    def nav_tocseg
      ''
    end
    def nav_toc
      %{<table summary="navigation, home icon" width="100%" border="0" cellpadding="3" bgcolor="#ffffff">
<tr><td align="left" bgcolor="#{@color.yellow_dark}" width="10%">
  <a href="#{@url.site}/" target="_top" #{@js.home}>
    #{@png.home}
  </a>
</td>
<td align="right" width="90%">
  &nbsp;
</td></tr>
<tr><td>
  &nbsp;
#{@table.close}\n} #browser bug? cannot have align left for table or causes text to move behind table 
    end
    def book_cover_band
      %{<table summary="book cover band" width="100%" border="0" cellpadding="8" bgcolor="#ffffff" align="center">
<tr><td align="center">}
    end
    def instrument_cover_band
      %{<table summary="generic instrument cover band" width="100%" border="0" cellpadding="8" bgcolor="#ffffff" align="center">
<tr><td align="center">}
    end
    def instrument_cover_band_scr
      %{<table summary="scroll instrument cover band" width="100%" border="0" cellpadding="8" bgcolor="#ffffff" align="center">
<tr><td align="center">}
    end
    def instrument_cover_band_seg
      %{<table summary="segment instrument cover band, title, author, location" width="100%" border="0" cellpadding="8" bgcolor="#ffffff" align="center">
<tr><td align="center">}
    end
    def reserve
      %{  <p />
  <center>
  <br />
  <font color="white">
    <i>E-presentation</i> <sup>&copy;</sup> Ralph Amissah<br /><i>- & for his personal use only!</i>
  <br />
    <i>W3 since October 3 1993</i>
  </center>}
    end
    def control
      %{  <center>
  <font #{@font.face}>
    #{@url.hp}
      #{@png.nav} #{@txt.home}
    </a>
  <br />
    <a href="doc" target="_top">
      #{@png.doc} Full text of this Document
    </a>
  <br />
    <a href="index" target="_top">
      #{@png.toc} Table of Contents
    </a>
  </center>}
    end
    def control_lm
      "  <center>
  <font>
    #{@png.hp_nav}
      #{txt.home}
    </a></center>"
    end
    def control_mini
      %{  <br />
  <center>
  <font #{@font.face}>
  #{@url.hp}
    #{@png.doc_tiny} LM A-Z
  </a> \n<br />#{@url.hp} #{@png.toc_tiny} LM toc</a> \n<a href="./toc/itl.chronological" target="_top">#{@png.doc_tiny} LM 20**</a></center>\n}
    end
  end
  class Widget
    def initialize
      @url=SiSU_Viz::Url.new
      @font=SiSU_Viz::Font.new
      @txt=SiSU_Viz::Txt.new
      @table=SiSU_Viz::Table.new
      @js=SiSU_Viz::Javascript.new
      @date=SiSU_Env::Info_date.new
    end
    def browsers
#tidy 7 warnings here
<<WOK
<tr align="center"><td align="center">
<table summary="browser suggestions" bgcolor="#ffffff" cellpadding="4" border="0">
<tr><td>
  <p>
  <font color="#666666" size="2">
    If you have problems viewing pages on this site please update your browser:
  </font>
  </p>
#{@table.close}
<table summary="browser suggestions" bgcolor="#ffffff" cellpadding="4" border="0">
<tr><td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.gnome.org/projects/epiphany/" target="external">
      <img border="0" width="25" height="25" src="../_sisu/image/gnome.png" alt="Epiphany" />
        &nbsp;Epiphany
      </a>
      <sup>&reg;</sup>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://galeon.sourceforge.net/" target="external">
    <img border="0" width="24" height="24" src="../_sisu/image/galeon.png" alt="Galeon" />
      &nbsp;Galeon
    </a>
    <sup>&reg;</sup>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.microsoft.com/windows/ie/default.asp" target="external">
    <img border="0" width="29" height="25" src="../_sisu/image/internet.explorer.png" alt="MS I-Explorer" />
      I-Explorer
    </a>
    <sup>&reg;</sup>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://kazehakase.sourceforge.jp/" target="external">
     Kazehakase</a>
    <sup>&reg;</sup>&nbsp;|</font></p></td>
<td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.konqueror.org/" target="external">
    <img border="0" width="29" height="25" src="../_sisu/image/konqueror.png" alt="Konqueror" />
    Konqueror</a>
    <sup>&reg;</sup>&nbsp;|</font></p></td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.mozilla.org/" target="external">
    <img border="0" width="30" height="24" src="../_sisu/image/mozilla.png" alt="Mozilla" />
      Mozilla
    </a>
    <a href="http://www.mozilla.org/products/firefox/" target="external">
      <img border="0" width="25" height="25" src="../_sisu/image/firefox.png" alt="Firefox" />
      <b>Firefox</b>
    </a>
    <sup>&reg;</sup>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://home.netscape.com/comprod/mirror/client_download.html" target="external">
      <img border="0" width="29" height="25" src="../_sisu/image/netscape.png" alt="Netscape" />
      Netscape
    </a>
    <sup>&reg;</sup>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.opera.com/" target="external">
      <img border="0" width="29" height="25" src="../_sisu/image/opera.png" alt="Opera" />
      Opera
    </a>
    <sup>&reg;</sup>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.apple.com/safari/" target="external">
      <img border="0" width="24" height="25" src="../_sisu/image/safari.png" alt="Safari" />
      Safari
    </a>
    <sup>&reg;</sup>
  </font>
  </p>
#{@table.close}
<table summary="lightweight browser and text browser suggestions" bgcolor="#ffffff" cellpadding="4" border="0">
<tr><td>
  <p>
  <font color="#666666" size="1">
    for console/text viewing:
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://elinks.or.cz/" target="external">
      <b>elinks</b>
    </a>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://atrey.karlin.mff.cuni.cz/~clock/twibright/links" target="external">
      <b>links2</b>
    </a>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://w3m.sourceforge.net/" target="external">
      <b>w3m</b>
    </a>
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    for lightweight gui (X) viewing try:
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.dillo.org/" target="external">
      Dillo
    </a>
    &nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.gnome.org/projects/epiphany/" target="external">
      <img border="0" width="25" height="25" src="../_sisu/image/gnome.png" alt="Epiphany" />
      &nbsp;Epiphany
    </a>
    <sup>&reg;</sup>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://galeon.sourceforge.net/" target="external">
    <img border="0" width="24" height="24" src="../_sisu/image/galeon.png" alt="Galeon" />
      &nbsp;Galeon
    </a>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://atrey.karlin.mff.cuni.cz/~clock/twibright/links" target="external">
      <b>links2 -g</b>
    </a>
  </font>
  </p>
#{@table.close}
</td></tr>
WOK
    end
    def pdfviewers
<<WOK
<tr align="center"><td align="center">
<table summary="pdf viewer suggestions" bgcolor="#ffffff" cellpadding="4" border="0">
<tr><td>
  <p class="center">
  <font color="#666666" size="1">
    &amp; for 
    <a href="http://www.adobe.com/products/acrobat/adobepdf.html" target="external">
      pdf
    </a> 
    viewings of this site we recommend stand alone viewers
    <br />
    (rather than web browser plugins):
  </font>
  </p>
#{@table.close}
<table summary="" bgcolor="#ffffff" cellpadding="4" border="0" align="center">
<tr align="center"><td align="center">
  <p class="center">
  <font color="#666666" size="1">
    <a href="http://www.adobe.com/products/acrobat/readstep2.html" target="external">
      <img border="0" height="18" width="15" src="../_sisu/image/b_pdf.png" alt="Adobe Acrobat Reader" />
      Acrobat Reader
    </a>
    <sup>&reg;</sup>
    &nbsp;|
  </font>
  </p>
</td>
<td>
  <p class="center">
  <font color="#666666" size="1">
    <a href="http://www.gnome.org/projects/evince/" target="external">
      <img border="0" width="25" height="25" src="../_sisu/image/gnome.png" alt="Evince" />
      <b>Evince</b>
    </a>
    <sup>&reg;</sup>
  </font>
  </p>
</td>
<td>
  <p class="center"><font color="#666666" size="1">
    <a href="http://www.cs.wisc.edu/~ghost/gv/" target="external">
    &nbsp;GhostView<sup>&reg;</sup>&nbsp;</a>, 
    <a href="http://wwwthep.physik.uni-mainz.de/~plass/gv/" target="external">
      GV<sup>&reg;</sup>
    </a>
    &amp; 
    <a href="http://www.cs.wisc.edu/~ghost/gsview/" target="external">
      GSview<sup>&reg;</sup>
    </a>
    &nbsp;|
  </font>
  </p>
</td>
<td>
  <p class="center">
  <font color="#666666" size="1">
    <a href="http://www.foolabs.com/xpdf/" target="external">
    <img border="0" width="16" height="16" src="../_sisu/image/xpdf.png" alt="Xpdf" />
      &nbsp;Xpdf
    </a>
    <sup>&reg;</sup>
  </font>
  </p>
#{@table.close}
WOK
    end
    def googlegroups
<<WOK
<table style="border:1px solid #aa0033; font-size:small" align=center>
<tr><td rowspan=3>
  <img src="http://groups-beta.google.com/groups/img/groups_medium.gif" height=58 width=150 alt="Google Groups" />
</td>
<td colspan=2 align=center>
  <b>Subscribe to SiSU e-docs</b>
</td>
</tr>
<form action="http://groups-beta.google.com/group/SiSU_e-docs/boxsubscribe">
  <tr><td>
    Email: 
    <input type=text name=email>
  </td>
  <td>
  <table style="background-color:#ffcc33;padding:2px;border:2px outset #ffcc33;">
  <tr><td>
    <input type=submit name="sub" value="Subscribe">
  </td></tr>
  </table>
  </td></tr>
</form>
<tr><td colspan=2 align=center>
  <a href="http://groups-beta.google.com/group/SiSU_e-docs">
    Browse Archives
  </a> at 
  <a href="http://groups-beta.google.com/">
    groups-beta.google.com</a>
  </td></tr>
</table>
WOK
    end
    def sisu
      v=SiSU_Env::Info_version.new.get_version
<<WOK
<table summary="" bgcolor="#ffffff" cellpadding="4" border="0" align="center">
<tr align="center"><td align="center">
  <p class="center">
  <font color="#666666" size="2">
    presentations' look and feel
  <br />
    generated by
  <br />
    <a href="#{@url.sisu}" #{@js.sisu}>
      <img border="0" src="../_sisu/image/sisu.png" alt="SiSU on Debian/Gnu/Linux or a FreeBSD &amp; Ruby - better ways, well actually, Way Better!" width="120" height="39" />
    </a>
    <br />
    <a href="#{@url.sisu}" #{@js.sisu}>
      #{v[:project]}
    </a>
  <br />
    version #{v[:version]}
  <br />
    #{v[:date_stamp]} (#{v[:date]})
  <br />
  </font>
  </p>
<table summary="SiSU rights" bgcolor="#ffffff" cellpadding="4" border="0" align="center" width="40%">
<tr align="center"><td align="left">
  <p class="left">
  <font color="#666666" size="2">
    Generated by 
    <a href="#{@url.sisu}" #{@js.sisu}>
      SiSU
    </a>
  <br />
    #{v[:project]} #{v[:version]} #{v[:date_stamp]}
  <br />
    <a href="#{@url.sisu}" #{@js.sisu}>
      www.jus.uio.no/sisu
    </a>
  <br />
    Using:
  <br />
    Standard SiSU markup syntax,
  <br />
    Standard SiSU meta-markup syntax, and the
  <br />
    Standard SiSU <u>object citation numbering</u> and system, (object/text positioning system)
  <br />
    <sup>&copy;</sup> Ralph Amissah 1997, current #{@date.year}.
  <br />
    All Rights Reserved.
  <br />
    SiSU is the result of several years of research and development in electronic
    publishing, commenced in 1993 and under active development since 1997. There
    is always more to be done. <b>SiSU is released under 
    <a href="http://www.gnu.org/copyleft/gpl.html">
      GPL 2
    </a> 
    or later</b> 
    <a href="http://www.gnu.org/copyleft/gpl.html">
      http://www.gnu.org/copyleft/gpl.html
    </a>
    (SiSU's first public release on January 4<sup>th</sup> 2005)
  <br />
  </font>
  </p>
  <p class="center">
  <font color="#666666" size="3">
    <sup>&copy;</sup> Ralph Amissah
  <br />
    1993, current #{@date.year}
  <br />
    All Rights Reserved
  <br />
    <i>w3 since October 3 1993</i>
  <br />
    <a href="mailto://ralph@amissah.com" #{@js.mail}>
      ralph@amissah.com
    </a>
  <br />
  </font>
  </p>
WOK
    end
    def wayBetter_old
<<WOK
<table summary="" bgcolor="#ffffff" cellpadding="4" border="0" align="center">
<tr align="center"><td align="center">
  <p class="center">
  <font color="#666666" size="2">
    using 
    <a href="http://www.ruby-lang.org/en/" alt="Ruby Programming Language">
      Ruby
    </a>
  <br />
    on the 
    <a href="http://www.debian.org/" alt="Debian/Gnu/Linux">
      Debian/Gnu/Linux
    </a>
  <br />
    software infrastructure
  <br />
    think the usual GPL (or OSS) suspects
  <br />
  <br />
    Get With the Future
  <br />
    &lt;&lt;
    <a href="http://www.jus.uio.no/sisu/">
      Way Better!
    </a>
    &gt;&gt;
  </font>
  </p>
#{@table.close}
#{@table.close}
WOK
    end
    def wayBetter
<<WOK
  <p class="center">
  <font color="#666666" size="2">
    Developed
  <br />
    using 
    <a href="http://www.ruby-lang.org/en/">
      Ruby
    </a>
  <br />
    on 
    <a href="http://www.debian.org/">
      Debian/Gnu/Linux
    </a> 
    software infrastructure,
  <br />
    &amp; with the usual GPL (or OSS) suspects.
  <br />
    Linux 
    (<a href="http://www.debian.org/">Debian</a>)
    &amp; Unix, 
    (<a href="http://www.freebsd.org/">FreeBSD</a>/ 
    <a href="http://www.dragonflybsd.org/main/">Dragonfly</a>)
  <br />
    Better - "performance, reliability, scalability, security
  <br />
    &amp; total cost of ownership"
  <br />
    [not to mention flexibility &amp; choice]
  <br />
  <br />
    Get With the Future
  <br />
    &lt;&lt;
    <a href="http://www.jus.uio.no/sisu/">
      Way Better!
    </a>
    &gt;&gt;
  </font>
  </p>
#{@table.close}
#{@table.close}
WOK
    end
  end
  class Credits
    def initialize
      @js=SiSU_Viz::Javascript.new
      @txt=SiSU_Viz::Txt.new
      @url=SiSU_Viz::Url.new
      @png=SiSU_Viz::Png.new
      @icon=SiSU_Viz::Icon.new
      @font=SiSU_Viz::Font.new
      @table=SiSU_Viz::Table.new
      @banner=SiSU_Viz::Banner.new
      @widget=SiSU_Viz::Widget.new
    end
    def itl_cover_band
      %{<table summary="itl cover band" width="88%" border="0" cellpadding="0" bgcolor="blue">
<tr><td>
<table summary="" width="100%" border="0" cellpadding="8" bgcolor="#000099">
<tr><td>
<table summary="" width="99%" border="1" cellpadding="0" bgcolor="#ffcc00">
<tr><td>
<table summary="" width="100%" border="1" cellpadding="0" bgcolor="#ffffff">
<tr><td align="center">
  <font #{@font.face}>
    <br />
      \@
    <br />
      #{@txt.home}
    <br />
      #{@banner.url_txt_sisu}
    <br />
  </font>
#{@table.close*4}}
    end
    def credits
      %{  <center>
<table align="center"bgcolor="#ffffff">
<tr><td>
  #{@widget.sisu}#{@widget.wayBetter}#{@widget.browsers}#{@widget.pdfviewers}
</td></tr>
</table>
</center>}
    end
  end
  class Bottom
    def initialize
      @banner=Banner.new
      @table=Table.new
      @credits=Credits.new
    end
    def surround
      %{</td>
<td align="center" valign="bottom">#{@table.close}<table summary="" border="0" width="100%" valign="top">
<tr><td valign="top" width="20%"><table summary="" width="100%" border="0" cellpadding="0" bgcolor="#e3ecef" align="center">
<tr><td valign="top">
#{@table.close}
</td>
<td align="center" valign="top">
  #{@banner.band}
#{@table.close}
<table summary="" border="0" width="100%" valign="top">
<tr><td valign="top" width="20%">
<table summary="" width="100%" border="0" cellpadding="0" bgcolor="#e3ecef" align="center">
<tr><td valign="top">
  #{@table.close}
</td>
<td align="center" valign="top">
  #{@credits.credits}
#{@table.close}
</body>
</html>}
    end
    def surround_hardlink
       %{</td>
<td align="center" valign="bottom">
</td></tr>
</table>
<table summary="" border="0" width="100%" valign="top">
<tr><td valign="top" width="20%"><table summary="" width="100%" border="0" cellpadding="0" bgcolor="#e3ecef" align="center">
<tr><td valign="top"></td></tr></table></td><td align="center" valign="top">
  #{@banner.band_hardlink}
#{@table.close}
<table summary="" border="0" width="100%" valign="top">
<tr><td valign="top" width="20%">
<table summary="" width="100%" border="0" cellpadding="0" bgcolor="#e3ecef" align="center">
<tr><td valign="top">
  #{@table.close}
</td><td align="center" valign="top">
  #{@credits.credits}
#{@table.close*3}
</body>
</html>} # check table close times value
    end
  end
  class Home
    def initialize
      @font=Font.new
      @v=SiSU_Env::Info_version.new.get_version
      @dir=SiSU_Env::Info_dir.new
    end
    def sisu
<<WOK
<html><head>
  <title>SiSU</title>
  <meta http-equiv="refresh" content="0, url=http://www.jus.uio.no/sisu">
</head>
<body>
  SiSU informtion provided at <a href="http://www.jus.uio.no/sisu">www.jus.uio.no/sisu</a><p />
  If your browser supports redirection, you will be escorted there shortly.
</body>
</html>
WOK
    end
    def index
      #meta_sisu_version=Txt.new.generator
      <<WOK
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>SiSU - Simple information Structuring Universe - Structured
information, Serialized Units - software for electronic texts,
documents, books, digital libraries in plaintext, html, xhtml, XML,
ODF (OpenDocument), LaTeX, pdf, SQL (PostgreSQL and SQLite), and
for search</title>
<meta name="dc.title" content=
"SiSU information Structuring Universe - Simple - information Structuring Universe, SiSU is Structuring Unit programme &amp; program description, 2005" />
<meta name="dc.creator" content="Ralph Amissah" />
<meta name="dc.subject" content=
"ebook, publishing, pdf, LaTeX, XML, ODF, SQL, postgresql, sqlite, electronic book, electronic publishing, electronic document, electronic citation, data structure, citation systems, search, digital library" />
<meta name="dc.publisher" content=
"SiSU http://www.jus.uio.no/sisu" />
<meta name="dc.language" content="en" />
<meta name="dc.rights" content="Copyright Ralph Amissah" />
<meta name="generator" content="#{@v[:project]} #{@v[:version]} of #{@v[:date_stamp]} (#{@v[:date]}) (n*x and Ruby!)" />
<link rel="generator" href="http://www.jus.uio.no/sisu/SiSU" />
<link rel="stylesheet" href="./#{@dir.style}/html.css" type="text/css" />      
<link rel="shortcut icon" href="./_sisu/image/rb7.ico" />
</head>
<body>
<div id="top_band">
<p class="top_band_image">
  <a href="http://www.jus.uio.no/sisu/SiSU" target="_top" >
    <img border="0" src="./_sisu/image/sisu.png" alt="SiSU &gt;&gt;">
  </a>
</p>
<h1 class="top_band">
  SiSU information Structuring Universe
</h1>
<h2 class="top_band_tiny">
  Structured information, Serialized Units
</h2>
<h2 class="top_band_tiny">
software for electronic texts, document collections, books, digital libraries, and search
</h2>
<h2 class="top_band_tiny">
 with "atomic search" and text positioning system (shared text citation numbering: "<i>ocn</i>")
</h2>
<h2 class="top_band_tiny">
outputs include: plaintext, html, xhtml, XML, ODF (OpenDocument), LaTeX, pdf, SQL (PostgreSQL and SQLite)
</h2>
</div>
<div id="column_left">
<p class="bold">
  <a href="http://www.jus.uio.no/sisu/SiSU" target="_top" >
    SiSU
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_description/1#summary" target="_top" >
    What does SiSU do? Summary
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/1#summary" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_examples/1#books" target="_top" >
    Book Samples
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/2#books" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_examples/1#markup" target="_top" >
    Markup Examples
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/2#markup" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_description/1#ocn" target="_top" >
    Object Citation Numbering - <i>ocn</i>
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/1#ocn" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p class="tiny">(a text positioning system)</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_description/1#search" target="_top" >
    Search - "<i>Atomic</i>"
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/1#search" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p class="tiny">
  Of interest is the ease of streaming documents to a relational database, at an object (roughly paragraph) level and the potential for increased precision in the presentation of matches that results thereby. The ability to serialise html, LaTeX, XML, SQL, (whatever) is also inherent in / incidental to the design. For a description see the
  <a href="http://www.jus.uio.no/sisu/sisu_provisional_patent_application_200408" target="_top" >
    abandoned U.S. provisional patent application
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_license/license" target="_top" >
    License
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/license" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_download/download" target="_top" >
    <b>Download</b>
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/download" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_changelog/changelog" target="_top" >
    Changelog
  </a>
  <a href="http://www.jus.uio.no/sisu/SiSU/changelog" target="_top" >
    <sup>[*]</sup>
  </a>
</p>
<p>
  Gnu / Linux / Unix
</p>
<p class="tiny">
  =============
</p>
<p>
  man pages: 
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/man/sisu.1" target="_top" >
    sisu.1
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/man/sisu.8" target="_top" >
    sisu.8
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/man/sisu_examples.1" target="_top" >
    sisu_examples.1
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/man/sisu_webrick.1" target="_top" >
    sisu_webrick.1
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/man/sisu_vim.1" target="_top" >
    sisu_vim.1
  </a>
</p>
<p class="tiny">
  document preparation can be on any platform, in any editor:
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sample" target="_top" >
    Markup Syntax
  </a>
</p>
<p class="tiny">
  =============
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/SiSU" target="_top" >
    * Composite document
  </a>
</p>
<p class="tiny">
  the composite document is a superset of the following documents:
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_description" target="_top" >
    SiSU description
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_examples" target="_top" >
    SiSU examples
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_chronology" target="_top" >
    SiSU chronology
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_technical_info" target="_top" >
    SiSU technical
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_faq" target="_top" >
    SiSU FAQ
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_download" target="_top" >
    SiSU download
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_changelog" target="_top" >
    SiSU changelog
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_license" target="_top" >
    SiSU license
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_standard" target="_top" >
    SiSU standard
  </a>
</p>
<p>
  <a href="http://www.jus.uio.no/sisu/sisu_provisional_patent_application_200408" target="_top" >
    SiSU abandoned provisional patent
  </a>
</p>
<p class="tiny">
  Note: the placement of SiSU documents on the Net predate the release of SiSU.
</p>
</div>
<div id="column_center">
<p class="bold">
  For less markup than the most elementary HTML you can have so much more.
</p>
<p><a href="http://www.jus.uio.no/sisu/SiSU" target="_top" ><b>SiSU</b> - Structured information, Serialized Units</a> for Electronic Documents, is a document creation/management framework with the following features:</p>
<p><b>(i)</b> markup syntax: (a) simpler than html, (b) mnemonic, influenced by mail/messaging/wiki markup practices, (c) human readable, and easily writable,</p>
<p><b>(ii)</b> (a) minimal markup requirement, (b) single file marked up for multiple outputs,</p>
<p><b>(iii)</b> (a) multiple outputs include amongst others: html; pdf via LaTeX; (structured) XML; ODF (OpenDocument); sql - currently PostgreSQL (and SQLite); ascii, (also texinfo), (b) takes advantage of the strengths implicit in these very different output types, (e.g. pdfs produced using typsetting of LaTeX, databases populated with documents at an individual object/paragraph level, with implications for search possibilities...)</p>
<p><b>(iv)</b> provides a common object positioning and citation system for all outputs, which is human relevant and machine usable: <u><i>object citation numbering</i></u>, all objects (paragraphs, headings, verse, tables etc. and images) are numbered identically, for citation purposes, in all outputs (html, pdf, sql etc.),</p>
<p><b>(v)</b> use of Dublin Core and other meta-tags to permit the addition of some semantic information on documents, and making easy integration of rdf/rss feeds etc.,</p>
<p><b>(vi)</b> creates organised directory/file structure for (file-system) output, easily mapped with its clearly defined structure, with all text objects numbered, you know in advance where in each document output type, a bit of text will be found (eg. from an sql search, you know where to go to find the prepared html output or pdf etc.)... there is more; easy directory management and document associations, the document preparation (sub-)directory may be used to determine output (sub-)directory, the skin used, and the sql database used,</p>
<p><b>(vii)</b> search of document sets, at object/paragraph level, the relational database retains information on the document structure, and citation numbering makes it possible for example to present search matches as an index of documents and locations within the document where the match is found,</p>
<p><b>(viii)</b> "word maps" rudimentary index, consisting of all the words in a document and their (text/ object) locations within the text, (and the possibility of adding vocabularies),</p>
<p><b>(ix)</b> document content certification and comparison considerations: (a) the document and each object within it stamped with an md5 hash making it possible to easily check or guarantee that the substantive content of a document is unchanged, (b) version control, documents integrated with time based version control system, default RCS or CVS with use of $Id$ tag, which SiSU checks
<p><b>(x)</b> SiSU's minimalist markup makes for meaningful "diffing" of the substantive content of markup-files,</p>
<p><b>(xi)</b> easily skinnable, document appearance on a project/site wide, directory wide, or document instance level easily controlled/changed,</p>
<p><b>(xii)</b> in many cases a regular expression may be used (once in the document header) to define all or part of a documents structure obviating or reducing the need to provide structural markup within the document,</p>
<p><b>(xiii)</b> is a batch processor for handling large document sets, ... though once generated they need not be re-generated, unless changes are made to the desired presentation of a particular output type,</p>
<p><b>(xiv)</b> possible to pre-process, which permits: the easy creation of standard form documents, and templates/term-sheets, or; building of composite documents (master documents) from other sisu marked up documents, or marked up parts, i.e. import documents or parts of text into a main document should this be desired</p>
<p><b>(xv)</b> future proofing, a framework for adding further capability or updating existing capability as required: (a) modular, (thanks in no small part to Ruby) another output format required, write another module....(b) easy to update output formats (eg html, xhtml, latex/pdf produced can be updated in program and run against whole document set), (c) easy to add, modify, or have alternative syntax rules for input, should you need to,</p>
<p><b>(xvi)</b> scalability, dependent on your file-system (in my case Reiserfs) and on the relational database used (currently Postgresql and SQLite), and your hardware,</p>
<p><b>(xvii)</b> only marked up files need be backed up, to secure the larger document set produced,</p>
<p><b>(xviii)</b> document management,</p>
<p><b>(xix)</b> use your favourite editor, syntax highlighting files for markup, primarily (g)vim so far,</p>
<p><b>(xx)</b> remote operations: (a) run SiSU on a remote server, (having prepared sisu markup documents locally or on that server, i.e. this solution where sisu is installed on the remote server, would work whatever type of machine you chose to prepare your markup documents on), (b) alternatively, (assuming sisu is available to you locally but not installed on the remote server) configure sisu to securely copy (scp) its output to your remote host and run sisu locally, (c) request a remotely located sisu markup file and process it locally by identifying it by its' url.</p>
<br />
<p>More information on <a href="http://www.jus.uio.no/sisu/SiSU/"><b>SiSU</b></a> provided at <a href="http://www.jus.uio.no/sisu/SiSU/">www.jus.uio.no/sisu/SiSU</a></p>
</div>
<div id="column_right">
<p>
  More information on <a href="http://www.jus.uio.no/sisu/SiSU/"><b>SiSU</b></a> provided at:
  <a href="http://www.jus.uio.no/sisu/SiSU/">
    www.jus.uio.no/sisu/SiSU
  </a>
</p>
<p>SiSU was developed in relation to legal documents, and is strong across a wide variety of texts (law, literature...(humanities, law and part of the social sciences)). SiSU handles images but is not suitable for formulae/ statistics, or for technical writing at this time.</p>
<p>SiSU has been developed and has been in use for several years. Requirements to cover a wide range of documents within its use domain have been explored.</p>
<p>Some modules are more mature than others, the most mature being Html and LaTeX / pdf. PostgreSQL and search functions are useable and together with <i>ocn</i> unique (to the best of my knowledge). The XML output document set is "well formed" but largely proof of concept, as is the OpenDocument output which is a limited SiSU feature set (SiSU is interested in a very limited ODF feature set).</p>
<p>
<a href="mailto://ralph@amissah.com">
ralph@amissah.com
</a>
</p>
<p>
<a href="mailto://ralph.amissah@gmail.com">
ralph.amissah@gmail.com
</a>
</p>
<p class="tiny">
w3 since October 3 1993
</p>
</div>
</body>
</html>      
WOK
    end
    def toc
      ' '
    end
  end
end
__END__

