=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: share sisu source markup file, copy it to output directory!
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Notes: tidy -ascii index.xml >> index.tidy

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Markup
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  pwd=Dir.pwd
  class Source
    require 'fileutils'
    include FileUtils
    def initialize(fns,cf)
      @fns,@cf=fns,cf
      env=SiSU_Env::Env_call.new(@fns) #revisit, remove need
      @dir=SiSU_Env::Info_dir.new(@fns)
      @output_path="#{@dir.data_o}/#{env.fnb}"
    end
    def read
      tell=SiSU_Screen::Ansi.new(@cf,'Share Document Source!',@fns)
      tell.greenHiBlue unless @cf =~/q/
      tell=SiSU_Screen::Ansi.new(@cf,"Copy sisu markup file to output directory","#@fns -> #@output_path")
      tell.warn unless @cf =~/q/
      File.mkpath(@dir.data_o) unless FileTest.directory?(@dir.data_o)
      File.mkpath(@output_path) unless FileTest.directory?(@output_path)
      if FileTest.directory?(@output_path)
        unless @fns =~/\._sst$/: cp(@fns,@output_path)
        else req=@fns.gsub(/(.+)?\._sst$/,"\\1.ssm")
          if FileTest.file?(req):  cp(req,@output_path)
          end
        end
      else
        tell=SiSU_Screen::Ansi.new(@cf,"Output directory does not exist","#@fns -> #@output_path")
        tell.warn unless @cf =~/q/
        exit
      end
    end
  end
end
__END__
