=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: texinfo processing
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_TexInfo
  $program ||= 'tbl'
  require "#{SiSU_lib}/html"
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  #include Stamp ... needed removed arbitrarily 2005w05/1 (warnings about undefined flags)
  require "#{SiSU_lib}/texinfo_format"
  include TexInfoFormat
  @tex_file=Array.new
  @@tex_backslash="\\\\"
  @@tabular="{tabular}"
  @@table_pagebreak_counter,@@tex_endnote_call_counter,@@tex_table_flag,@@tex_counter,@@tex_column,@@tex_columns,@@counting=0,0,0,0,0,0,0
  @@column_instruct,@@tex_line_mode,@@tex_word_mode,@@startTable,@@line_mode='','','','',''
  @@n,@@copyright,@@tableheader=nil,nil,nil
  @@tex_col_w=Array.new
  @@tex_pattern_margin_number="\\\\marginpar.+?\s+"
  class Source #Songsheet
    include SiSU_Param
    include SiSU_Viz
    include SiSU_TexInfo
    def initialize(sf,cf)
      @fns,@cf=sf,cf
      @fnb=sf[/(.+?)\.[_-]?sst$/,1]
      @dir=SiSU_Env::Info_dir.new(@fns)
      @vz=Hash.new
      @vz['tex']=Hash.new
      @tex=TexInfoFormat::Texinfo.new
      @url=SiSU_Viz::Url.new
    end
    def directories
      begin
        case @fns
        when /\.[_-]?sst$/
          Dir.mkdir(@dir.data_o) unless FileTest.directory?("#{@dir.data_o}")
          Dir.mkdir(@dir.texi) unless FileTest.directory?(@dir.tex)
          @@filename_texinfo=File.new(%{#{@dir.texi}/#@fnb.texinfo},'w+')
        end
      rescue: STDERR.puts SiSU_Screen::Ansi.new(@cf,$!,$@).rescue
      ensure
      end
    end
    def read
      songsheet
    end
    def songsheet
      begin
        tell=SiSU_Screen::Ansi.new(@cf,'TexInfo')
        tell.greenTitleHi unless @cf =~/q/
        data=IO.readlines(@fns,'')
        @md=SiSU_Param::Parameters.new(@fns,@cf).get
        puts "\t#{@@cX.grey}TexInfo#{@@cX.off}"
        #@@copyright="\n #{@@tex_backslash*2}[3]\\ \\linebreak \\copyright \\ #{@md.copyright_tex}" if @md.copyright_tex #appears to be redundant ! remove 2004w19
        if @md.markup.to_s !~ /url_png/
          my_make=SiSU_Env::Create_file.new(@cf,@fns)
          directories
          @marshalfile=my_make.marshal_meta
          if FileTest.file?(@marshalfile)==true
            File.open(@marshalfile) { |f| @@tuned_file=Marshal.load(f)}
            tell.metaVerseSkipped unless @cf =~/q/
          else
            tex_array=IO.readlines(@fns,'')
            SiSU_Metaverse.songsheet(tex_array)
          end
          tex_array=@@tuned_file
          Texinfo_make.new(tex_array,@md,@fns,@cf).songsheet
          tex_array=''
        end
        #@@filename_texinfo.close if @@filename_texinfo
        @@filename_texinfo=nil
      rescue: STDERR.puts SiSU_Screen::Ansi.new(@cf,$!,$@).rescue
      ensure
        @@filename_texinfo.close if @@filename_texinfo
      end
    end
  end
  class Texinfo_make
    include SiSU_Param
    include TexInfoFormat
    @@tex_1='(?:.+?)+~' #?? debug
    @@tabular="{tabular}"
    @@tex_pattern_margin_number="\\\\marginpar.+?\s+"
    def initialize(data,md,fns,cf)
      @data,@md,@fns,@cf=data,md,fns,cf
      @dir=SiSU_Env::Info_dir.new(@fns)
      @vz=Hash.new
      @vz['tex']=Hash.new
      #@tex=TexInfoFormat::Texinfo.new
      @url=SiSU_Viz::Url.new
    end
    def songsheet
      begin
        data=Texinfo_make.new(@data,@md,@fns,@cf).pre
        data=Texinfo_make.new(data.collect,@md,@fns,@cf).endnote
        data=Texinfo_make.new(data.collect,@md,@fns,@cf).markup
        data=Texinfo_make.new(data.collect,@md,@fns,@cf).tail
        Texinfo_make.new(data.collect,@md,@fns,@cf).output
        Texinfo_make.new(data.collect,@md,@fns,@cf).makeinfo
      rescue: STDERR.puts SiSU_Screen::Ansi.new(@cf,$!,$@).rescue
      ensure
      end
    end
    def pre
      @tex_file=Array.new
      data=@data
      data.each do |para|
        para.gsub!(/&/, '<=and>')
        # DEBUG 2003w16 this is a kludge, because i could not get parameters
        # from param, Sort out ... revert to more elegant solution
        if (para =~ /<!Th?¡\s+c/i) 
          @@flag['tables']='y' # KLUDGE get from param
        end
        para.gsub!(/<:p[bn]>/,'')
        doMono=TexInfoFormat::Texinfo.new(para,@md)
        @tex_file << doMono.specChar
      end
      data=@tex_file.delete_if {|x| x =~ /^0(?:\\)+~/m}
      data=@tex_file # ...
    end
    def endnote
      data=@data
      @tex_file=Array.new
      data.each do |para|
        # BUG bug -> have problems with endnotes in headers
        if para =~ /\\~\\\{\d+\s+/ #if para =~ /<!e\s+/ # watch
          para.gsub!(/\s*\\~\\\{(\d+)\s+(.+?)<[0-9a-f]{32}>\\\}\\~/m, " @footnote{ \\2} ")
        end
        @tex_file << para
      end
      @tex_file
    end
    def poem
      data=@data
      @tex_file=Array.new
      @@counting=0
      data.each do |para|
        if (para =~ /<:code>/i)
          @@flag['code']=1
          @@counting=1
        end
        if (para =~ /<:poem>/i)
          @@flag['poem']=1
        end
        if (@@flag['code']==1)
          if (@@flag['code']==1 and para =~ /<:code[-_](?:end|close)>/i) #watch change not tested 200501
            @@flag['code']=0
          end
          if (@@flag['code']==1 and para =~ /\S/)
            sub_array=para.dup
            @@line_mode=sub_array.scan(/.+/)
            Tune.code_lines(@@line_mode)
            para=@@line_mode.join
          end
        elsif (@@flag['poem']==1)
          if (@@flag['poem']==1 and para =~ /<:poem[-_](?:end|close)>/i) #watch change not tested 200501
            @@flag['poem']=0
          end
          if (@@flag['poem']==1 and para =~ /\S/)
            sub_array=para.dup
            @@line_mode=sub_array.scan(/.+/)
            Tune.code_lines(@@line_mode)
            para=@@line_mode.join
          end
        end
        @tex_file << para
      end
    end
    def code_lines
      data=@data
      data.each do |line|
        if line =~ /\S/ and line !~ /<:(code|poem).+/ 
          if @@flag['code']==1
            line.gsub!(/^\s*(.+)/m, "\\noindent \\marginpar\[left-text\]{\\begin{tiny}#{@@counting}\\end{tiny}}\\1\\")
            @@counting+=1 if @@flag['code']==1
          else line.gsub!(/(.+)/m, "\\noindent\\1\\")
          end
        end
      end
    end
    def tables
      data=@data
      @tex_file=Array.new
      @@tableheader=0
      data.each do |para|
        if para =~ /¡|<!T/i
          doMono=TexInfoFormat::Texinfo.new(para,@md)
          para=doMono.longtable # using longtable latex package
          #para=doMono.scopedtable # old tables work, estimate of number of rows on page coded in ruby, though not incorporated table footer, todo
        end
        @tex_file << para 
      end
    end
    def markup
      data=@data
      @tex_file=Array.new
      md=Hash.new
#%~mdument head title headers
      @tex_file << TexInfoFormat::Texinfo.new('',@md).head
      #@tex_file << Texinfo.new(@md[:title], @md[:subtitle], @md[:creator]).head
#%~
      mono=TexInfoFormat::Texinfo.new(@md.title,@md)
      @tex_file << mono.topnode
      texinfo_menu=Array.new
      n_menu,n_submenu=0,0
      @submenu=Hash.new
      @subsubmenu=Hash.new
      data.each do |para|
        if para =~ /^[1-3]\\+~\S*(.+?)\s*$/
          toc=TexInfoFormat::Texinfo.new($1,@md)
          texinfo_menu << toc.menu
        end
        if para =~ /^[4-6]\\+~\S+\s*(.+?)\s*$/
          toc=TexInfoFormat::Texinfo.new($1,@md)
          texinfo_menu << toc.menu
          case para 
          when /^[4]\\+~\S+\s+(.+?)\s*$/
            n_menu+=1 
            @submenu[n_menu]=Array.new
          when /^[5]\\+~\S+\s+(.+?)\s*$/
            n_submenu+=1
            @subsubmenu[n_menu]=Array.new
            @submenu[n_menu] << toc.menu
          when /^[6]\\+~\S+\s+(.+?)\s*$/
            @subsubmenu[n_submenu] << toc.menu
          end
        end
      end
      texinfo_menu.compact!
      texinfo_menu << "* Dublin Core::"
      @tex_file << texinfo_menu
      @tex_file << "* Index::\n" +
        "@end menu\n\n" +
        "@c {{{ 5\n\n"
      n_menu,n_submenu=0,0
      @@do_submenu,@@do_subsubmenu=1,1
      data.each do |para|
        mono=TexInfoFormat::Texinfo.new(para,@md)
        case para
        when /^1\\+/: mono.level1
        when /^2\\+/: mono.level2
        when /^3\\+/: mono.level3
        when /^4\\+~/
          mono.level4
          n_menu+=1
          @@do_submenu,@@do_subsubmenu=1,1
        when /^5\\+/
          n_submenu+=1
          @@do_subsubmenu=1
          if @@do_submenu==1
            menu=TexInfoFormat::Texinfo.new(@submenu[n_menu],@md)
            para="#{menu.submenu}#{mono.level5}"
            @@do_submenu=0
          else mono.level5
          end
        when /^6\\+/
          if @@do_submenu==1
            menu=TexInfoFormat::Texinfo.new(@subsubmenu[n_menu],@md)
            para="#{menu.subsubmenu}#{mono.level6}"
            @@do_subsubmenu=0
          else
            mono.level6
          end
        #  when /^<!i1!>/
        #    mono.indent1
        #  when /^<!i2!>/
        #    mono.indent2
        #  when /<!:\s+/
        #    mono.graphics
        #  when /^\s*<!image\s+/
        #    mono.image
        #  when /\}image/
        #    mono.png
        #  when /\}http/
        #    mono.http
        else
          if para !~/\S/
            para=nil 
          else
            para.gsub!(/<\\~(\d+);\w\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/, "~[\\1]")
            #para.gsub!(/[1-3]\\\\\{\\\\\{\\\\\{\s+/, '')
            #para.gsub!(/[1-3]\\\\\{\s+/, '')
            para=para
          end
          #para.gsub!(/^\s+$/mi, "")
        end
#%case with endnotes
        para.gsub!(/\s*[0-8]\\+(\S+)?\s+/,' ') if para
        @tex_file << para if para
      end
      data=@tex_file
    end
    def numbering
      data=@data
      data=Texinfo_make.new(data,@md,@fns,@cf).number_titles
      #TOGGLE to SWITCH PARAGRAPH NUMBERING (ON & OFF)
      data=Texinfo_make.new(data,@md,@fns,@cf).number_paras \
        if (@md.fns !~ /\.e[pdr]00/ \
        and @md.markup !~ /not_to/i)
    end
    def number_titles
      data=@data
      @tex_file=Array.new
      input=%{#{@md.markup}}[/(num_top\s*=\s*(\d?))?/m,2] # else default usually 4  # this was a bit of a trick required to pass nil to input if nothing matched... #puts input
      #input=/(num_top\s*=\s*(\d?))?/m.match(@md[:markup]) [2] # else default usually 4  # this was a bit of a trick required to pass nil to input if nothing matched... #puts input
      num_top=input.to_i
      t_no1=0;  t_no2=0;  t_no3=0;  t_no4=0;
      no1=num_top; no2=(num_top + 1); no3=(num_top + 2);  no4=(num_top + 3);
      data.each do |para|
        if (@md.markup =~ /num_top/i \
        and para !~ /0\\+/)
          if (para =~ /[1-6]\\+(?:~\S+)?\s*<!h-.+?-!>/ \
          and para !~ /<:\d-endnotes>/i)
            header=para[/<!h-(.+?)-!>/im, 1].gsub!(/-/m, ".")
            para.gsub!(/(?:[1-6]\\+(?:~\S+)|<:([12356]|4-.+?-)>)\s*<!h-.+?-!>/i,
              "\\1 #{header} ")
          end
        elsif (para =~ /<!h!>|<!h\d!>|<!h.+?!>|<!!h.+?!>/i)
          if (para =~ /<!h-.+?-!>/i)
            para.gsub!(/<!h-(.+?)-!>/i, "\\1 ")
          end
        end
        @tex_file << para
      end
      data=@tex_file
    end
    def number_paras
      data=@data
      @tex_file=Array.new
      paranumber=0
      data.each do |para|
        if para =~/<\\~(\d+);\w\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/ and para !~ /<EOF>/
        #if para =~/<\\~\d+?>/ and para !~ /<EOF>/
          parablock,paranum=/(.+?)<\\~(\d+);\w\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/im.match(para)[1,2]
          doDuo=TexInfoFormat::DuoTex.new(parablock,paranum) ###is BUG
          para=doDuo.paraNum if parablock
        end
        @tex_file << para
      end
      data=@tex_file
    end
    def tail
      data=@data
      tex=TexInfoFormat::Texinfo.new('',@md)
      data << tex.dublincore
      data << tex.tail
    end
    def output
      data=@data
      data.compact!
      data.each {|para| (@@filename_texinfo.puts para,"\n") if para}
      @@filename_texinfo.close
    end
    def makeinfo
      if @fns =~/\.[_-]?sst$/
        m=/(.+?)\.[_-]?sst$/.match(@fns)
        fnb,sfx=m[1],m[2]
    	  pwd=Dir.pwd
        case sfx
        when /[_-]?sst$/
          @dir=SiSU_Env::Info_dir.new(@fns,@cf)
          Dir.chdir("#{@dir.texi}")
          texinfo=SiSU_Env::System_call.new("#{fnb}.texinfo")
          texinfo.makeinfo
        end
        Dir.chdir(pwd)
      end
    end
  end
end
__END__

