#!/usr/bin/env ruby 
module Post_install
  require 'fileutils'
  require 'rbconfig.rb'
  include FileUtils
  class Setup
    def initialize(dir='')
      @dir=dir
    end
    def pi_actions_note
      <<WOK
    -------- Notes on actions to be taken
      The post install script will make sure the following directories exist and use them,
      for processing: 
        #{@dir[:out]}/processing
      for output:
        #{@dir[:out]}/www
      these directories can be changed in the file:
        ~/.sisu/sisurc.yaml
      a sample of which is provided in:
        #{@dir[:conf]}/#{@dir[:proj]}/sisurc.yaml.sample_disabled

      It will then attempt to generate a document from the samples provided in the directory:
        ./data/#{@dir[:proj_eg]}/sample/document_samples_sisu_markup
      first changing to that directory and then, initialising the directory by running the command:
        sisu -CC
      and then using the following command string to generate the document:
        sisu -mHpxXawv gpl2.fsf.s3

      [NB: sisu should be run from within the directory in which marked up documents are placed]
WOK
    end
    def post_install_sample(run=true)
      Dir.pwd
      doc_samples="data/#{@dir[:proj_eg]}/sample/document_samples_sisu_markup"
      sisu_note_init =<<WOK
      
      initialise output directory for document samples
      * run
        sisu -CC
        from within directory ./#{doc_samples} 
WOK
  sisu_note_run =<<WOK 

  initial run of sisu using sample data
  * run
    sisu -mHpxXawv gpl2.fsf.s3
    from within directory ./#{doc_samples} 

  * check the urls provided for output

WOK
  sisu_note =<<WOK 
  * SiSU document samples are to be found in: ./#{doc_samples}
  
  * For help with SiSU 
    sisu                  (for interactive help)
    sisu help commands    (for help on commands)

  * Note: to create documents sisu should be run from within the same directory as the work documents
      for the sample documents you should run sisu in from within directory ./#{doc_samples}

  * For help with rant as used by SiSU
    rant help             (for basic help with rant)
    rant -T               (for list of commands)

WOK
  sisu_gen =<<WOK 
  SiSU attempted to generate a document and to produce html, ascii, xml, (latex) and pdf output
  check console for the urls provided above for output/content scroll up if necessary (and/or for error messages)
  output should be in #@dir_out/www (unless the directory is not writable in which case ~/sisu_www )
  
Welcome to SiSU :-)
WOK
  sisu_note_dir =<<WOK

  Install SiSU in the following directories:
    bin:                                          #{@dir[:bin]}
    lib (site-ruby):                              #{@dir[:lib]}/#{@dir[:proj]}/#{@dir[:version]}
    conf [etc] (resource config. sample, skins):  #{@dir[:conf]}/#{@dir[:proj]}
    data (document samples, images, README):      #{@dir[:data]}/#{@dir[:proj_eg]} and #{@dir[:data]}/doc/#{@dir[:proj_eg]}
    man (manual pages):                           #{@dir[:man]}
    output:                                       #{@dir[:out]}
      processing:                                 #{@dir[:out]}/processing
      www:                                        #{@dir[:out]}/www
WOK
      sisu_note_help="  * run\n    sisu help commands"
      sisu_note_did="  have tried to do the following: -->"
      if run==true
        cd(doc_samples)
        puts sisu_note_help
        system('sisu help commands')
        puts sisu_note_init
        system('sisu -CC')
        puts sisu_note_run
        system('sisu -mHpxXawv gpl2.fsf.s3')
      end
      puts "\nNotes follow: -------------------------------------"
      puts sisu_note_did if run==true
      puts sisu_note_dir
      puts sisu_note_help
      puts sisu_note_init
      puts sisu_note_run
      puts sisu_note
      puts sisu_gen if run ==true
      system('sisu -v')
    end
    def post_install
      username='sisu_install'
      until username=~/^skip|exit|zzzz$/
        print "
    --------
    At this stage the basic SiSU setup should be complete.
    There are however, a few steps required on the initial running of sisu.
    SiSU will now attempt to initialise a work directory and to generate a test file.

      The actions that follow should not be executed as root, a user name will be requested.

    #{pi_actions_note}
    --------
        "
        print " 
    SiSU may now be run under ordinary user privilages, to do so
     * provide your normal username, or "
     print "
     * type 'root' to proceed as root, with output directory permissions set to 777
    
    or you may skip the initial preparation and generation of a document, (not advised, however if you wish to do post installation setup manually, see the notes provied above)
     * type 'skip' or 'exit'
    
    Select an option [provide your username|root|exit]: "
        username=File.new("/dev/tty").gets.strip
        if username !~/^root|ok|skip|exit?$/ and username.length > 1
          File.mkpath("#{@dir[:out]}/processing") unless FileTest.directory?("#{@dir[:out]}/processing")
          File.mkpath("#{@dir[:out]}/www") unless FileTest.directory?("#{@dir[:out]}/www")
          system("chown -R #{username} #{@dir[:out]}")
          system("su -p #{username} ruby install post_install_sample")
          username='zzzz'
        elsif username =~/^root$/
          File.mkpath("#{@dir[:out]}/processing") unless FileTest.directory?("#{@dir[:out]}/processing")
          File.mkpath("#{@dir[:out]}/www") unless FileTest.directory?("#{@dir[:out]}/www")
          File.chmod(0755, @dir[:out])
          Post::Fix.new(@dir).post_install_sample(true)
          system("chmod -R 777 #{@dir[:out]}/processing #{@dir[:out]}/www")
          username='skip'
        else
          Post_install::Setup.new(@dir).post_install_sample(false) if username !='zzzz'
        end
      end
    end
  end
end
