=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: generates naive cgi search form for search of sisu database (pgsql sqlite)

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah mailto:ralph@amissah.com
   Ralph Amissah mailto:amissah@gmail.com

=end
module  SiSU_CGI_sqlite                                                            #% database building documents
  require SiSU_lib + '/sysenv'
  require SiSU_lib + '/cgi_sql_common'
  include SiSU_CGI_sql
  class SiSU_search_sqlite
    def initialize(opt,webserv)
      @opt,@webserv=opt,webserv
      webrick_port=SiSU_Env::Info_dir.new.webrick_port
      @port=case @opt.mod_s
      when /--webserve?r?=webrick/
        @webrick_port=":#{webrick_port}"
        "        '#@webrick_port'\n"
      else
        @webrick_port=''
        "        ''\n"
      end
      @url_base="#{SiSU_Env::Info_dir.new.webserv_url_base}/_sisu/image"
      @env=SiSU_Env::Info_dir.new
      @common=SiSU_CGI_sql::SiSU_CGI_common.new(@webserv,@opt.cmd,@port,@webrick_port,@url_base,@env)
    end
    def sqlite
      serve=Array.new
      Dir.foreach(@env.webserv_path) do |x| 
        if x !~/^\./ and FileTest.directory?("#{@env.webserv_path}/#{x}") 
          if FileTest.file?("#{@env.webserv_path}/#{x}/sisu_sqlite.db"): serve << x unless x =~/^_\S+/ 
          end
        end
      end
      serve.sort!
      f1,f2,f3=Array.new,Array.new,Array.new
      #f1
      serve.each do |x|
        f1 << %{              <option value="SiSU_#{x}">#{x}</option>\n}
      end
      f2 <<  %{          selected_db=case cgi['db']\n}
      serve.each do |x|
        f2 << %{           when /SiSU_#{x}/: '<option value="SiSU_#{x}">#{x}</option>'\n}
      end
      f2 << "          end\n"
      #f3
      f3 << %{          db_name='sisu_sqlite.db'\n}
      f3 << %{          db_sqlite=case cgi['db']\n}
      serve.each do |x|
        f3 << %{          when /SiSU_#{x}/:                      "#{@env.webserv_path}/#{x}/sisu_sqlite.db"\n}
      end
      f3 << "          end\n"
      if FileTest.writable?('.') 
        output=File.open('sisu_sqlite.cgi','w')
        output << header0 << header1 << @port << header2 << f1 << buttons << search_request << search_statement << @common.tail << @common.main1 << f2 << f3 << dbi_connect << @common.main2
        a=%{        generated sisu_sqlite.cgi, 
            BASED ON ALREADY CREATED sisu_sqlite.db OUTPUT, (-d) 
        }
        tell=SiSU_Screen::Ansi.new(@opt.cmd,a) 
        tell.print_grey
        c=case @webserv
        when /pwd/: ''
        else "sudo cp -vi #{Dir.pwd}/sisu_sqlite.cgi /usr/lib/cgi-bin 
                  sudo chmod -v 755 /usr/lib/cgi-bin/sisu_sqlite.cgi
                  (copy sisu_sqlite.cgi to your cgi directory) and set file permissions to 755"
        end
        a=%{#{c}
                  http://localhost#@webrick_port/cgi-bin/sisu_sqlite.cgi
        }
        b='(to create sisu sqlite database see "man sisu" and in particular the -d flag)'
        tell=SiSU_Screen::Ansi.new(@opt.cmd,a,b) 
        tell.warn
      else puts 'failed in attempt to write sisu_sqlite.cgi to present directory, is directory writable?'
      end
    end
    def header0
      <<-WOK_SQL
#!/usr/bin/env ruby
=begin
 * Name: SiSU - Simple information Structuring Universe   
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: generates naive cgi search form for search of sisu database (sqlite)
   * $Id$

 Copyright (C) 2006 Ralph Amissah
 Copyright (C) 2005 Ralph Amissah (first release edition)
 Copyright (C) 1997 Ralph Amissah (first edition)

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah ralph@amissah.com
   Ralph Amissah ralph.amissah@gmail.com

=end
      require 'cgi'
      require 'fcgi'
      require 'dbi'
      @version='sisu_sqlite'
      @url_base="#{SiSU_Env::Info_dir.new.webserv_url_base}/_sisu/image"
      WOK_SQL
    end
    def header1
      <<-'WOK_SQL'
      host='localhost'
      #host=%x{echo $HOSTNAME}.chomp!
      @hosturl="http://#{host}" +
      WOK_SQL
    end
    def header2
      <<-'WOK_SQL'
      @base="#@hosturl/cgi-bin/#@version.cgi"
      class Form
        def initialize(base,search_field,selected_db,checked_index,checked_text,checked_tip,checked_searched,checked_url,checked_echo,checked_sql,checked_all,checked_none,checked_ignore,search_note,the_can='')
          search_note='' if checked_searched !~/\S/
          the_can='' if checked_url !~/\S/
          search_field='' if checked_echo !~/\S/
          @base,@search_field,@selected_db,@checked_index,@checked_text,@checked_tip,@checked_searched,@checked_url,@checked_echo,@checked_sql,@checked_all,@checked_none,@checked_ignore,@search_note,@the_can=base,search_field,selected_db,checked_index,checked_text,checked_tip,checked_searched,checked_url,checked_echo,checked_sql,checked_all,checked_none,checked_ignore,search_note,the_can
          @tip=if checked_tip =~/\S/
            '<font size="2" color="#666666">text:__; keywords:__; title:__; author:__; subject:__; description:__; publisher:__; contributor:__; date:__; type:__; format:__; identifier:__; source:__; language:__; relation:__; coverage:__; rights:__; comment:__; abstract:__; </font>'
          else '' 
          end
        end
        def submission_form
            search_form=<<-WOK
      <label for="find"><b>SiSU SQLite Search Form (sample):</b></label>
      <table cellpadding="2">
      <tr><td valign=\"top\">
        <table cellpadding="2">
          <form action="#@base" id="Test Form" method="post">
          <tr><td valign=\"top\">
            <!input type="text" id="find" name="find" value="#@search_field" />
            <!input type="text" id="find" name="find" value="" />
            <textarea id="find" name="find" type="text" rows="4" cols="30" maxlength="256">#@search_field</textarea><br />
          </td><td valign=\"top\"><p>
            <select name="db" size="1">
              #@selected_db
      WOK_SQL
    end
    def buttons
      <<-'WOK_SQL'
            </select><br />
            <font size="2" color="#222222">
            <input type="radio" name="view" value="index" #@checked_index> index
            <input type="radio" name="view" value="text" #@checked_text>  text
            </font>
            </p>
            <p><input type="submit" value="submit" /></p>
          </td></tr>
        </table>
          #@search_note
        </td><td valign=\"top\">
          #@tip
        </td></tr>
      </table>           
            <font size="2" color="#222222">
            <input type="checkbox" name="echo" #@checked_echo> echo
            <input type="checkbox" name="searched" #@checked_searched> searched
            <input type="checkbox" name="url" #@checked_url> url
            <input type="checkbox" name="tip" #@checked_tip> search fields available
            <input type="checkbox" name="sql" #@checked_sql> sql statement
            </font>
            <br />
            <input type="radio" name="checks" value="check_ignore" #@checked_ignore> use selected
            <input type="radio" name="checks" value="check_all" #@checked_all> check all
            <input type="radio" name="checks" value="check_none" #@checked_none> check none
            <br />
        </form>
      #@the_can
      WOK
        end
      end
      WOK_SQL
    end
    def search_request
      <<-'WOK_SQL'
      class Search_request                                                       #% search_for
        attr_accessor :text1,:keywords,:title,:author,:subject,:description,:publisher,:contributor,:date,:type,:format,:identifier,:source,:language,:relation,:coverage,:rights,:comment,:abstract,:owner,:date_created,:date_issued,:date_modified,:date_available,:date_valid
        def initialize(search_field='',q='')
          @search_field,@q=search_field,q
          @text1=@keywords=@title=@author=@subject=@description=@publisher=@contributor=@date=@type=@format=@identifier=@source=@language=@relation=@coverage=@rights=@comment=@abstract=@owner=@date_created=@date_issued=@date_modified=@date_available=@date_valid=''
          if @search_field=~/\S/
            @text1=text_to_match('text:')
            @keywords=text_to_match('key(?:words?)?:')
            @title=text_to_match('title:')                  # DublinCore 1  - title
            @author=text_to_match('(?:author|creator)s?:')  # DublinCore 2  - creator/author
            @subject=text_to_match('subj(?:ect)?:')         # DublinCore 3  - subject
            @description=text_to_match('description:')      # DublinCore 4  - description
            @publisher=text_to_match('pub(?:lisher)?:')     # DublinCore 5  - publisher
            @contributor=text_to_match('contributor:')      # DublinCore 6  - contributor
            @date=text_to_match('date:')                    # DublinCore 7  - date dd-mm-yy
            @type=text_to_match('type:')                    # DublinCore 8  - type
            @format=text_to_match('format:')                # DublinCore 9  - format
            @identifier=text_to_match('identifier:')        # DublinCore 10 - identifier
            @source=text_to_match('source:')                # DublinCore 11 - source
            @language=text_to_match('language:')            # DublinCore 12 - language
            @relation=text_to_match('relation:')            # DublinCore 13 - relation
            @coverage=text_to_match('coverage:')            # DublinCore 14 - coverage
            @rights=text_to_match('rights:')                # DublinCore 15 - rights
            @comment=text_to_match('comment:')
            @abstract=text_to_match('abs(?:tract)?:')
            @owner=text_to_match('owner:')
            @date_created=text_to_match('date_created:')
            @date_issued=text_to_match('date_issued:')
            @date_modified=text_to_match('date_modified:')
            @date_available=text_to_match('date_available:')
            @date_valid=text_to_match('date_valid:')
            @text1=text_to_match unless @keywords or @author or @title or @text1 or @comment or @abstract or @rights or @subject or @publisher or @date
          else
            @text1=q['s1'] if q['s1']=~/\S/
            @keywords=q['key'] if q['key']=~/\S/
            @title=q['ti'] if q['ti']=~/\S/
            @author=q['au'] if q['au']=~/\S/
            @subject=q['sj'] if q['sj']=~/\S/
            @description=q['dsc'] if q['dsc']=~/\S/
            @publisher=q['pb'] if q['pb']=~/\S/
            @contributor=q['cntr'] if q['cntr']=~/\S/
            @date=q['dt'] if q['dt']=~/\S/
            @type=q['ty'] if q['ty']=~/\S/
            @identifier=q['id'] if q['id']=~/\S/
            @source=q['src'] if q['src']=~/\S/
            @language=q['lang'] if q['lang']=~/\S/
            @relation=q['rel'] if q['rel']=~/\S/
            @coverage=q['cov'] if q['cov']=~/\S/
            @rights=q['cr'] if q['cr']=~/\S/
            @comment=q['co'] if q['co']=~/\S/
            @abstract=q['ab'] if q['ab']=~/\S/
            @date_created=q['dtc'] if q['dtc']=~/\S/
            @date_issued=q['dti'] if q['dti']=~/\S/
            @date_modified=q['dtm'] if q['dtm']=~/\S/
            @date_available=q['dta'] if q['dta']=~/\S/
            @date_valid=q['dtv'] if q['dtv']=~/\S/
          end
        end
        def text_to_match(identifier='')
          m=Hash.new
          m[:string]=/#{identifier}\s*(.+?)/
          m[:string]=/#{identifier}\s*(.+?)(?:;|\n|\r|$)/
          m[:word]=/#{identifier}[\s(]*(\S+)/
          search_string=if @search_field =~m[:word]
            search_string=if @search_field =~m[:braces]: m[:braces].match(@search_field)[1]
            elsif @search_field =~m[:string]:            m[:string].match(@search_field)[1]
            else
              str=m[:word].match(@search_field)[1]
              str.gsub!(/[()]/,'')
              str
            end
            search_string.strip!
            search_string.gsub!(/\s+/,'+')
            search_string
          #else
          #  "__"
          end
        end
      end
      WOK_SQL
    end
    def search_statement
      <<-'WOK_SQL'
      class Dbi_search_string
        def initialize(l,t,q)
          @l,@t,@q=l,t,q
        end
        def string
          search=Hash.new
          search[:search]=Array.new
          search[:flag]=false
          if @t =~/\S+/ or @q =~/\S+/
            if @t =~/\S+/:     unescaped_search=CGI.unescape(@t)
            elsif @q =~/\S+/:  unescaped_search=CGI.unescape(@q)
            end
            search_construct=Array.new
            unescaped_search.gsub!(/\s*(AND|OR)\s*/,"%' \) \\1 #@l LIKE \( '%")
            unescaped_search.gsub!(/(.+)/,"#@l LIKE \( '%\\1%' \)")
            search_construct << unescaped_search
            search_construct=search_construct.join(' ')
            search[:search]                    << search_construct
            search[:flag]=true
            search
          end
          search
        end
      end
      class Dbi_search_statement
        attr_reader :text_search_flag,:sql_select_body_format,:sql_select_endnotes_format
        def initialize(conn,search_for,q)
          @conn=conn
          @text_search_flag=false
          search=Hash.new
          search[:text],search[:endnotes]=Array.new,Array.new
          st=Dbi_search_string.new('documents.clean',search_for.text1,q['s1']).string
          se=Dbi_search_string.new('endnotes.clean',search_for.text1,q['s1']).string
          @text_search_flag=st[:flag]
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << se[:search]
          end
          st=Dbi_search_string.new('metadata.keywords',search_for.keywords,q['key']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.title',search_for.title,q['ti']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.creator',search_for.author,q['au']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.subject',search_for.subject,q['sj']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.description',search_for.description,q['dsc']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.publisher',search_for.publisher,q['pb']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.contributor',search_for.contributor,q['cntr']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.date',search_for.date,q['dt']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.type',search_for.type,q['ty']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.identifier',search_for.identifier,q['id']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.source',search_for.source,q['src']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.language',search_for.language,q['lang']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.relation',search_for.relation,q['rel']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.coverage',search_for.coverage,q['cov']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.rights',search_for.rights,q['cr']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.comment',search_for.comment,q['co']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.abstract',search_for.abstract,q['ab']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          @search_text,@search_endnotes=Array.new,Array.new
                                                                                 #%
          search[:text].each{|x| @search_text << "#{x} AND " }
          search[:endnotes].each{|x| @search_endnotes << "#{x} AND " }
          @search_text=@search_text.to_s.gsub!(/AND\s+$/,'')
          @search_endnotes=@search_endnotes.to_s.gsub!(/AND\s+$/,'')
        end
        def sql_select_body
          %{SELECT metadata.title, metadata.creator, metadata.filename, metadata.suffix, documents.body, documents.seg, documents.ocn, metadata.tid FROM documents, metadata WHERE #{@search_text} AND documents.metadata_tid = metadata.tid ORDER BY metadata.title, documents.ocn ;}
        end
        def sql_select_endnotes
          %{SELECT metadata.title, metadata.creator, metadata.filename, endnotes.body, endnotes.nr, endnotes.ocn, endnotes.metadata_tid FROM metadata, endnotes WHERE #{@search_endnotes} AND metadata.tid = endnotes.metadata_tid ORDER BY metadata.title, endnotes.nr ;}
        end
        def sql_select_body_format
          %{<font color="#666666" size="2">#{sql_select_body}</font>} 
        end
        def sql_select_endnotes_format
          %{<font color="#666666" size="2">#{sql_select_endnotes}</font>} 
        end
        def contents
          @conn.select_all(sql_select_body)
        end
        def endnotes
          @conn.select_all(sql_select_endnotes)
        end
      end
      WOK_SQL
    end
    def dbi_connect
      <<-'WOK_SQL'
          @dbi="DBI:SQLite:#{db_sqlite}" #sqlite3 ?
          @conn=DBI.connect(@dbi) 
      WOK_SQL
    end
  end
end
__END__
