=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: parameters extracted from input file(s) for program use

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Param
  require 'uri'
  require 'pstore'
  require 'ftools'
  require SiSU_lib + '/sysenv'
  include SiSU_Env
  require SiSU_lib + '/help'
  include SiSU_Help
  @@date=SiSU_Env::Info_date.new
  @@symlnk=Create_system_link.new
  @@proc=@@filename_txt=@@filename_texinfo=@@filename_lout_portrait=@@filename_lout_landscape=@@filename_html_scroll=@@filename_html_index=@@filename_html_segtoc=@@filename_semantic=@@filename_rss=@@newfile=@@drr=nil
  @doc=Hash.new
  @doc[:initialise]=nil
  @doc[:markup],@doc[:lnks],@doc[:stmp]='','',''
  @doc[:req]=Hash.new
  @@yaml=@@yamladdr=nil
  @@trigger=nil
  @@lv,@@flag=Hash.new,Hash.new
  @@tex_backslash="\\\\"
  class Parameters
    @@publisher='SiSU scribe'
    @@md=@@fns=nil
    def initialize(opt)
      @cX||=SiSU_Screen::Ansi.new(opt.cmd)
      @cmd,@mod=opt.cmd,opt.mod
      @fns=opt.fns.gsub(/\.ssm$/,'._sst') #revisit
      Instantiate.new.param_instantiate
      @env=SiSU_Env::Info_dir.new(@fns)
      @pstorefile="#{@env.metaverse}/#@fns.pstore"
    end
    def get
      unless @@fns==@fns
        @@fns=@fns
        @@md=nil
      end
      if @@md.nil? or @cmd =~/M/ #not particularly helpful, as current cycle is through output types, with files changing, only helpful if deal with a file all output types before going to next file
        if File.exist?(@pstorefile)
          param_msg='Parameters from pstore'
          store=PStore.new(@pstorefile)
          store.transaction do |s| 
            @md=s['md']
            s.commit
          end
        else #if @fns =~/\.s[123]/
          param_msg='Parameters extracted'
          fns_array=IO.readlines(@fns,'')
          @md=SiSU_Param::Instructions.new(fns_array,@fns,@cmd)
        end
        @@md=@md
      else
        @@md
      end
      tell=SiSU_Screen::Ansi.new(@cmd,param_msg,@@md.title)
      tell.txt_grey if @cmd =~/[MV]/
      @@md.cmd=@cmd
      @@md
    end
    class Instructions
      @doc=Hash.new
      @doc[:lv]=Array.new
      @doc[:fns],@doc[:fnb],@doc[:scr_suffix]='','',''
      @@publisher='SiSU scribe'
      attr_accessor :cmd,:mod,:mod_s,:env,:fn,:fns,:fnb,:fnn,:fnt,:fnl,:flv,:fnstex,:ocn,:sfx_src,:sfx,:pdf,:file_type,:dir_out,:dir_tex,:dir_lout,:txt_path,:site_skin,:sisu,:sisu_version,:ruby_version,:title,:dc_title,:html_title,:subtitle,:subtitle_tex,:creator_home,:dc_creator,:translator,:illustrator,:prepared_by,:digitized_by,:dc_subject,:dc_description,:dc_publisher,:dc_contributor,:dc_date,:dc_date_created,:dc_date_issued,:dc_date_available,:dc_date_valid,:dc_date_modified,:date_scheme,:date_created_scheme,:date_issued_scheme,:date_available_scheme,:date_valid_scheme,:date_modified_scheme,:dc_type,:dc_format,:dc_identifier,:dc_source,:dc_language,:language_original,:dc_relation,:dc_coverage,:dc_rights,:keywords,:comments,:abstract,:cls_loc,:cls_dewey,:cls_pg,:cls_isbn,:papersize,:toc,:lv1,:lv2,:lv3,:lv4,:lv5,:lv6,:pagenew,:pagebreak,:num_top,:toc_lev_limit,:flag_endnotes,:flag_auto_endnotes,:flag_separate_endnotes,:flag_separate_endnotes_make,:flag_auto_heading_num,:markup,:make_bold,:make_italic,:flag_pdf,:flag_tables,:vocabulary,:doc_skin,:doc_css,:yaml,:lnk,:prefix_a,:prefix_b,:suffix,:information,:contact,:icon,:image,:ad_url,:ad_png,:ad_alt,:ad_began,:ad_advertise,:ad_home,:stmp,:stmpd,:sc_filename,:sc_number,:sc_date,:sc_time,:sc_info,:yamladdr,:locale,:wc_lines,:wc_words,:wc_bytes,:file_encoding,:file_size,:user,:home,:hostname,:pwd,:firstseg,:programs,:creator_copymark,:lang,:en,:dgst,:dgst_skin,:generated,:tags,:tag_array,:concord_make,:seg_names,:seg_autoname_safe,:set_header_title,:set_heading_top,:set_heading_seg,:heading_seg_first,:heading_seg_first_flag,:base_program
      def initialize(fns_array,opt)
        @env=@fn=@fns=@fnb=@fnn=@fnt=@fnl=@flv=@fnstex=@ocn=@sfx_src=@sfx=@pdf=@file_type=@dir_out=@dir_tex=@dir_lout=@txt_path=@flag_endnotes=@flag_auto_endnotes=@flag_separate_endnotes=@flag_separate_endnotes_make=@site_skin=@sisu=@sisu_version=@ruby_version=@title=@dc_title=@html_title=@subtitle=@subtitle_tex=@creator_home=@dc_creator=@translator=@illustrator=@prepared_by=@digitized_by=@dc_subject=@dc_description=@dc_publisher=@dc_contributor=@dc_date=@dc_date_created=@dc_date_issued=@dc_date_available=@dc_date_valid=@date_scheme=@date_created_scheme=@date_issued_scheme=@date_available_scheme=@date_valid_scheme=@date_modified_scheme=@dc_type=@dc_format=@dc_identifier=@dc_source=@dc_language=@language_original=@dc_relation=@dc_coverage=@dc_rights=@keywords=@comments=@abstract=@cls_loc=@cls_dewey=@cls_pg=@cls_isbn=@papersize=@toc=@lv1=@lv2=@lv3=@lv4=@lv5=@lv6=@pagenew=@pagebreak=@num_top=@toc_lev_limit=@flag_auto_heading_num=@make_bold=@make_italic=@flag_pdf=@flag_tables=@vocabulary=@doc_skin=@doc_css=@yaml=@lnk=@prefix_a=@prefix_b=@suffix=@information=@contact=@icon=@ad_url=@ad_png=@ad_alt=@ad_began=@ad_advertise=@ad_home=@stmp=@stmpd=@sc_filename=@sc_number=@sc_date=@sc_time=@sc_info=@yamladdr=@locale=@wc_lines=@wc_words=@wc_bytes=@file_encoding=@file_size=@firstseg=@programs=@creator_copymark=@lang=@en=@dgst=@dgst_skin=@generated=@heading_seg_first=@base_program=nil
        @data,@fns,@cmd,@mod,@mod_s=fns_array,opt.fns,opt.cmd,opt.mod,opt.mod_s #@data used as data
        @flag_tables,@set_header_title,@set_heading_top,@set_heading_seg,@heading_seg_first_flag=false,false,false,false,false
        @seg_autoname_safe=true
        @markup=@image='' #check which other values should be set to empty rather than nil
        @flv,@lang=Array.new,Array.new
        @seg_names=Array.new
        @tags,@tag_array=Array.new,Array.new
        @tag_a=Array.new
        @tag_hash=Hash.new
        @doc,@fn,@make_italic,@make_bold=Hash.new,Hash.new,Hash.new,Hash.new,Hash.new
        begin
        rescue: SiSU_Errors::Info_error.new($!,$@,@cmd,@fns).error
        ensure
        end
      end
      protected
      def determine_papersize(l)
        l=case l
        when /eu|europe|uk/i:           'A4'                 #European default, SiSU default 
        when /(?:us-)?legal|legal/i:    'US_legal'           #U.S. alternative
        when /(?:us-)?letter|u.s.|us/i: 'US_letter'          #U.S. default
        when /book_a5|a5/i:             'book_a5'
        when /book_b5|b5|book/i:        'book_b5'            #book default - larger
        else                            'A4'
        end
      end
      def extract
        @user,@home,@hostname,@pwd=ENV['USER'],ENV['HOME'],ENV['HOSTNAME'],ENV['PWD']
        @programs,@wc,@en,@dc_language,@language_original=Hash.new,Hash.new,Hash.new,Hash.new,Hash.new
        @en[:sum],@en[:mark],@en[:note],@en[:mismatch]=0,0,0,0
        @prog=SiSU_Env::Info_settings.new
        @sys=SiSU_Env::System_call.new
        @env=SiSU_Env::Info_dir.new(@fns) #watch
        if @prog.wc !=false and @sys.wc !=false
          wc=%x{wc #{fns}}
          wca=wc.scan(/\d+/)
          @wc_lines,@wc_words,@wc_bytes=wca[0].to_i,wca[1].to_i,wca[2].to_i
        else
          fns_a=@data.dup
          tmp=fns_a.join
          fns_a=tmp.scan(/\S+/)
          @wc_words=fns_a.length
          fns_a=tmp=nil
        end
        @concord_make=if @wc_words > @env.concord_max: false
        else true
        end
        @locale=@sys.locale
        @file_encoding=@sys.file_encoding(fns,@cmd)
        # programs set here for things that affect output appearance only
        @programs[:pdf]=SiSU_Env::System_call.new.program_found?('pdflatex')
        if @env.multilingual
          m=/((.+?)(?:\~\w{2,3})?)\.([_-]?sst)$/ #watch added match for sss
          @fnn,@fnb,@fnt=@fns[m,1],@fns[m,2],@fns[m,3]
          @flv=@env.document_language_versions_found[:f]
        else m=/(.+?)\.([_-]?sst)$/
          @fnb=@fnn=@fns[m,1]
          @fnt=@fns[m,2]
          @flv<<@fns
        end
        @papersize=@env.papersize #'A4' #default size #get first from SiSU_Env:: # @env is probably no longer most appropriate name! as default info is more general
        @sfx_src=@fns[m,2]
        @sfx=nil
        @flag_pdf=true #watch
        @flag_auto_heading_num=false
#watch
        if @fns =~ /[_-]?sst$/ #watch
          @env_out_root=@env.data_o
          @dir_out="#{@env.data_o}/#@fnb"
          @dir_tex=@env.tex
          @dir_lout=@env.lout
          @@publisher='SiSU http://www.jus.uio.no/sisu'
        end
        @txt_path=@txt_path ||= @env.data_o
        @stmp=%{#@fns}[/^(.+?)\..*/im, 1]
        @fnstex=@fns.gsub(/_/,'\_')
        @flag_separate_endnotes=false
        @flag_separate_endnotes_make=true
        regx_date=/^\d{4}(?:-(?:[0][0-9]|1[0-2])(-(?:[0-2][0-9]|3[01]))?)?$/
        ver=SiSU_Env::Info_version.new
        @sisu_version=ver.get_version
        @ruby_version=ver.rbversion
        @generated=Time.now
        fns_array=@data.dup
        skip unless fns_array                                                    # consider
        fns_array.each do |par|                                                  #% Scan document
          para=par.gsub(/\n/,' ')
          if para !~/^\%+\s/ and para =~/<![abcdeghijklmnopqrstuvwxyz]/i # <!f not included
            raise "Old markup style in file #@fns, current version #{@sisu_version[:project]} #{@sisu_version[:version]} #{@sisu_version[:date_stamp]} #{@sisu_version[:date]}:\n\t\t#{para}\n\n" 
          end
	        regx_header=/^(?:0~|@\S+?:[+-]?\s)/
          if para =~regx_header or para=~/^(?:1|:?A)~/
            case para
            when /^(?:0~ocn|@ocn:)\s+(.+?)$/im:  @ocn=$1 
            when /^(?:0~title|@title:)\s+(.+?)$/im                               #% Dublin Core - dublin core within
              @title=$1.strip
              @dc_title=@title.dup
              @html_title=@title.gsub(/(<p>|<p \/>|<br>|<br \/>)/i,'')
              @set_header_title=true
              @title.chomp!(' ')
              @html_title.chomp!(' ')
              tell=SiSU_Screen::Ansi.new(@cmd,'Parameters',@html_title)
              tell.txt_grey unless @cmd =~/q/
            when /^(?:0~subtitle|@subtitle:)\s+(.+?)$/im
              @subtitle=$1.strip
              @dc_title="#{@title} - #{@subtitle}"
              @subtitle_tex=@subtitle
            when /^(?:0~(creator|author)-?|@(creator|author)-?:)\s+/i
              if para[/(?:0~|@)(?:creator|author):?\s+((?:https?|ftp)\S+)\s+(.+?)$/im]
                @creator_home, @dc_creator=$1,$2
              else @dc_creator=/(?:0~|@)(?:creator|author)-?:?\s+(.+?)$/im.match(para)[1]
              end
              @creator_copymark=if para=~/(?:0~|@)(?:creator|author)-:?/: false
              else                                                true
              end
              @dc_creator.strip!
            when /^(?:0~(?:translator|translated_by)|@(?:translator|translated_by):)\s+(.+?)$/im:     @translator=$1
            when /^(?:0~(?:illustrator|illustrated_by)|@(?:illustrator|illustrated_by):)\s+(.+?)$/im: @illustrator=$1
            when /^(?:0~prepared_by|@prepared_by:)\s+(.+?)$/im:                                       @prepared_by=$1
            when /^(?:0~digitized_by|@digitized_by:)\s+(.+?)$/im:                                     @digitized_by=$1
            when /^(?:0~subject|@subject:)\s+(.+?)$/im:                                               @dc_subject=$1
            when /^(?:0~description|@description:)\s+(.+?)$/im:                                       @dc_description=$1
            when /^(?:0~contributor|@contributor:)\s+(.+?)$/im:                                       @dc_contributor=$1
            when /^(?:0~publisher|@publisher:)\s+(.+?)$/im:                                           @dc_publisher=$1
            when /^(?:0~|@)date.+?$/im
              if para =~/(?:0~date|@date:)\s+(.+?)$/im 
                @dc_date=$1.strip
                if @dc_date !~regx_date and not @dc_date.empty?
                  tell=SiSU_Screen::Ansi.new(@cmd,'Date Format should be','YYYY-MM-DD','please correct document','Date','field, current value:',@dc_date)
                  tell.instruct if @cmd =~/v/
                end
                @date_scheme='scheme="ISO-8601"' if @dc_date =~/\d{4}-\d{2}-\d{2}/
              end
              if para =~/(?:0~date\.created|@date\.created:)\s*(.+?)$/im 
                date=$1.strip
                if date !~regx_date and not date.empty?
                  tell=SiSU_Screen::Ansi.new(@cmd,'Date Format should be','YYYY-MM-DD','please correct document','Date','field, current value:',date)
                  tell.instruct if @cmd =~/v/
                end
                @dc_date_created=date
                @date_created_scheme='scheme="ISO-8601"' if date =~/\d{4}-\d{2}-\d{2}/
              end
              if para =~/(?:0~date\.issued|@date\.issued:)\s*(.+?)$/im 
                date=$1.strip
                if date !~regx_date and not date.empty?
                  tell=SiSU_Screen::Ansi.new(@cmd,'Date Format should be','YYYY-MM-DD','please correct document','Date','field, current value:',date)
                  tell.instruct if @cmd =~/v/
                end
                @dc_date_issued=date
                @date_issued_scheme='scheme="ISO-8601"' if date =~/\d{4}-\d{2}-\d{2}/
              end
              if para =~/(?:0~date\.available|@date\.available:)\s*(.+?)$/im 
                date=$1.strip
                if date !~regx_date and not date.empty?
                  tell=SiSU_Screen::Ansi.new(@cmd,'Date Format should be','YYYY-MM-DD','please correct document','Date','field, current value:',date)
                  tell.instruct if @cmd =~/v/
                end
                @dc_date_available=date
                @date_available_scheme='scheme="ISO-8601"' if date =~/\d{4}-\d{2}-\d{2}/
              end
              if para =~/^(?:0~date\.valid|@date\.valid:)\s*(.+?)$/im 
                date=$1.strip
                if date !~regx_date and not date.empty?
                  tell=SiSU_Screen::Ansi.new(@cmd,'Date Format should be','YYYY-MM-DD','please correct document','Date','field, current value:',date)
                  tell.instruct if @cmd =~/v/
                end
                @dc_date_valid=date
                @date_valid_scheme='scheme="ISO-8601"' if date =~/\d{4}-\d{2}-\d{2}/
              end
              if para =~/^(?:0~date\.modified|@date\.modified:)\s*(.+?)$/im
                date=$1.strip
                if date !~regx_date and not date.empty?
                  tell=SiSU_Screen::Ansi.new(@cmd,'Date Format should be','YYYY-MM-DD','please correct document','Date','field, current value:',date)
                  tell.instruct if @cmd =~/v/
                end
                @dc_date_modified=date
                @date_modified_scheme='scheme="ISO-8601"' if date =~/\d{4}-\d{2}-\d{2}/
              end
            when /^(?:0~type|@type:)\s+(.+?)$/im:             @dc_type=$1 
            when /^(?:0~format|@format:)\s+(.+?)$/im:         @dc_format=$1 
            when /^(?:0~identifier|@identifier:)\s+(.+?)$/im: @dc_identifier=$1 
            when /^(?:0~source|@source:)\s+(.+?)$/im:         @dc_source=$1 
            when /^(?:0~language(?:\.document)?|@language(?:\.document)?:)\s+(.+?)$/im 
              x=$1.strip
              lang=SiSU_Env::Standardise_language.new(x.dup)
              @dc_language[:code]=lang.code
              @dc_language[:name]=lang.title
            when /^(?:0~language\.original|@language\.original:)\s+(.+?)$/im
              x=$1.strip
              lang=SiSU_Env::Standardise_language.new(x.dup)
              @language_original[:name]=lang.title
            when /^(?:0~relation|@relation:)\s+(.+?)$/im:     @dc_relation=$1 
            when /^(?:0~coverage|@coverage:)\s+(.+?)$/im:     @dc_coverage=$1
            when /^(?:0~rights|@rights:)\s+(.+?)$/im:         @dc_rights=$1    #copyright, public domain, copyleft, creative commons, etc.
            when /^(?:0~papersize|@papersize:)\s+(.+?)$/im 
              l=$1
              if @mod_s !~/--papersize='\S+'/
                l=determine_papersize(l.dup)
                @papersize=l
              end
            when /^(?:0~keywords?|@keywords?:?)\s+(.+?)$/im:  @keywords=$1
            when /^(?:0~comments?|@comments?:?)\s+(.+?)$/im:  @comments=$1
            when /^(?:0~abstract|@abstract)\s+(.+?)$/im:      @abstract=$1
            when /^(?:0~tags?|@tags?:)\s+\S/im
              tags=par.match(/^(?:0~tags?|@tags?:)\s+(.+)$/im)[1]
              tags.split(/,|$/).each do |tag| 
                tag.strip!
                @tags << tag
                @tag_array << tag.split(/:/)
                tag_a = tag.downcase.gsub(/\s+/,'_').gsub(/(.+)/,'[\1]')
                tag_a=tag_a.split(/:/).join('][')
                #tag_a='[' + tag_a.split(/:/).join('][') + ']'
                @tag_a << tag_a
              end
              #p @tags
              #p @tag_array
              #p @tag_a
              #@tag_a.each{|x| p x }
              #p @tag_a.join(',')
            when /^(?:0~catalogue|@catalogue:)\s+(.+)?$/im
              m=$1
              m.split(/;?\s+/) #spaces within a catalogue category not permitted, e.g. isbn
              #tags=par.match(/^(?:0~tags?|@tags?:)\s+(.+)$/im)[1]
              ###
              m.each do |c|
                case c
                when /pg=/: @cls_pg=c.match(/pg=(\S+)/)[1]
                when /isbn=/: @cls_isbn=c.match(/isbn=(\S+)/)[1]
                when /dewey=/: @cls_dewey=c.match(/dewey=(\S+)/)[1]
                when /loc=/: @cls_loc=c.match(/loc=(\S+)/)[1]
                end
              end
            # @catalogue: preferred
            when /^(?:0~class(?:ify)?_loc|@class(?:ify)?_loc:)\s+(.+?)$/im:             @cls_loc=$1
            when /^(?:0~class(?:ify)?_dewey|@class(?:ify)?_dewey:)\s+(.+?)$/im:         @cls_dewey=$1
            when /^(?:0~class(?:ify)?_pg|@class(?:ify)?_pg)\s+(.+?)$/im:                @cls_pg=$1
            when /^(?:0~(?:class(?:ify)?_)?isbn|@(?:class(?:ify)?_)?isbn)\s+(\S+?)$/im: @cls_isbn=$1
            # @catalogue: preferred
            when /^(?:0~images?|@images?:)\s+(.+?)$/im:                                 @image=$1
            when /^(?:0~(?:toc|structure)|@(?:toc|structure):)\s+(.+?)$/im                            #% Processing Instructions
              doc_toc_str=$1
              @toc=doc_toc_str.split(/;\s*/)
              #@toc.each {|x| x.gsub!(/\{/, '\{') } #FIX~
              lv1=@toc[0] ||='1~ '                                        #some arbitrary changes made
              @lv1=/^#{lv1}\b/
              lv2=@toc[1] ||='2~ '
              @lv2=/^#{lv2}\b/
              lv3=@toc[2] ||='3~ '
              @lv3=/^#{lv3}\b/
              lv4=@toc[3] ||='4~ '
              @lv4=/^#{lv4}\b/
              lv5=@toc[4] ||='5~ '
              @lv5=/^#{lv5}\b/
              lv6=@toc[5] ||='6~ '
              @lv6=/^#{lv6}\b/
            when /^(?:0~(?:level|page|markup)|@(?:level|page|markup):)\s+(.+?)$/im # revisit..., use syntax 0~level new=1,2,3; break=4
              if para =~/(?:0~|@)(?:markup|level|page):?\s+(.+?)$/im
                page_break_str=$1
                pagebreaks=page_break_str.split(/;\s*/)
                page_new,page_break,num_top=toc_lev_limit=nil
                pagebreaks.each do |x|
                  page_new = x[/(:?[\dA-C],?)+/] if x=~/new|clear/ 
                  page_break = x[/(:?[\dA-C],?)+/] if x =~/break/
                  num_top = x[/:?[\dA-C]/].to_i if x =~/num_top/
                  toc_lev_limit = x[/:?[\dA-C]/].to_i if x =~/toc_limit/
                end
                @pagenew=page_new if page_new
                @pagebreak=page_break if page_break
                @num_top=num_top if num_top
                @toc_lev_limit=toc_lev_limit if toc_lev_limit
                @flag_auto_heading_num=true if para =~/num_top/
              end
              if para =~/^(?:0~markup|@markup:)\s+(.+?)$/im               #use of markup depreciated for num_top
                @markup=$1
                @flag_auto_heading_num=true if para =~/num_top/
                @flag_pdf=false if para =~/pdf_no/ or para =~/url_png/
              end
            when /^(?:0~bold|@bold:)\s+(.+?)$/im
              m=$1.strip
              x=case m
              when /\/i$/: 'i'
              else         ''
              end
              m.gsub!(/^\/(.+?)\/i?/,'\1')
              m.gsub!(/\(/,'(?:') # avoid need to escape use of brackets within regex provided
              rgx='\b(' + m + ')\b'
              @make_bold[:str]='\b(?:' + m + ')\b'
              @make_bold[:regx]=if x =~/i/: /#{rgx}/i
              else                          /#{rgx}/
              end
              @make_bold
            when /^(?:0~(?:italics?|itali[sz]e)|@(?:italics?|itali[sz]e):)\s+(.+?)$/im
              m=$1.strip
              x=case m
              when /\/i$/: 'i'
              else         ''
              end
              m.gsub!(/^\/(.+?)\/i?/,'\1')
              m.gsub!(/\(/,'(?:') # avoid need to escape use of brackets within regex provided
              rgx='\b(' + m + ')\b'
              @make_italic[:str]='\b(?:' + m + ')\b'
              @make_italic[:regx]=if x =~/i/: /#{rgx}/i
              else                            /#{rgx}/
              end
              @make_italic
            when /^(?:0~(?:vocabulary|wordlist)|@(?:vocabulary|wordlist):)\s+(.+?)$/im 
                @vocabulary=$1                                                   #not actually used by concordance
            when /^(?:0~skin|@skin:)\s+(.+?)$/i: @doc_skin=$1.strip
            when /^(?:0~(?:css|stylesheet)|@(?:css|stylesheet):)\s+(.+?)$/i: @doc_css=$1.strip
            when /^(?:0~links|@links:)\s+(.+?)$/im
              doc_links_str=$1
              @lnk=Array.new
              if doc_links_str=~/\{.+?\}(?:(?:https?|ftp):\/|\.\.)\/\S+(?:\s|$)/
                doc_links=doc_links_str.scan(/\{.+?\}(?:(?:https?|ftp):\/|\.\.)\/\S+/)
                count=1
                doc_links.each do |x| 
                  @lnk[count]=Hash.new
                  @lnk[count][:say],@lnk[count][:url]=/\{\s*(.+?)\s*\}((?:(?:https?|ftp):\/|\.\.)\/\S+)/im.match(x)[1,2]
                  count +=1
                end
              else
                lnks=doc_links_str.split(/;\s+/)
                count=1
                lnks.each do |x|
                  @lnk[count]=Hash.new
                  if x =~/^\s*(?:(?:https?|ftp):\/\/|\.\.\/)/: @lnk[count][:url]=x
                  else
                    @lnk[count][:say]=x
                    count +=1
                  end
                end
              end
            when /^(?:0~prefix(?:_[ab])?|@prefix(?:_[ab])?:)\s/i
              if para =~/prefix_a:?\s+/
                @prefix_a=para[/(?:0~prefix_a|@prefix_a:)\s+(.+?)$/im,1]
              end
              if para =~/prefix(?:_b)?:?\s+/
                @prefix_b=para[/(?:0~prefix(?:_b)?|@prefix(?:_b)?:)\s+(.+?)$/im,1]
              end
            when /^(?:0~suffix|@suffix:)\s+(.+?)$/im:           @suffix=$1
            when /^(?:0~information|@information:)\s+(.+?)$/im: @information=$1
            when /^(?:0~contact|@contact:)\s+(.+?)$/im:         @contact=$1
            when /^(?:0~icon|@icon:)\s+(.+?)$/im:               @icon=$1
            when /^(?:0~ad|@ad:)\s+(\S+)?\s+(\S+\.png)?\s+(.+?!)\s+(\d+)\s*$/im
              @ad_url,@ad_png,@ad_alt,@ad_began=$1,$2,$3,$4
              @ad_advertise="1"
            when /0~ad\.home\s+(.+)?\s*$/im 
              ad_home_str=$1
              @ad_home=ad_home_str.split(/\s+!/)
            when /^(?:0~sta?mp(?:ed)?|@sta?mp(?:ed)?:)\s+(.+?)$/im:  @stmp= $1.downcase!
            when /^(?:0~(?:rcs|cvs)|@(?:rcs|cvs):)\+?\s+/ 
              m=/(?:0~(?:rcs|cvs)|@(?:rcs|cvs):)\+?\s+/ #note the + sign to turn on use of rcs or cvs id
              ver=para[/#{m}(.+)/,1] #RCS or CVS ID tag # eg. # $Id$
              contains=/[\$]Id:\s+(\S+),v\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+Exp\s+(?:\S+\s+)?[\$]/ # reason for [$] which is apparently unnecessary is that rcs or cvs will otherwise expand id!
              if contains.match(ver)
                filename,vnumber,date,time,operator=contains.match(ver).captures
                @sc_filename,@sc_number,@sc_date,@sc_time=filename,vnumber,date,time
              end
              @sc_info=true if para[/(?:0~(?:rcs|cvs)|@(?:rcs|cvs):)\+/] 
            when /^(?:1|:?A)~/
              if para=~/^:?A~/
                if @markup.nil? or @markup.empty?:  @markup='0.38'
                elsif @markup !~/0\.38/:            @markup=@markup.strip + '; 0.38'
                end
              end
              if (para=~/^:?A~/ and @markup =~/0\.38/) or (para=~/^1~/ and @markup !~/0\.38/)
                if @title.nil?
                  @title=para[/^:?[A1]~\S*(.+)$/im,1]
                  @html_title=@title.gsub(/(<p>|<p \/>|<br>|<br \/>)/i,'')
                  @title.chomp!("\n")
                  @html_title.chomp!("\n")
                  tell=SiSU_Screen::Ansi.new(@cmd,'Parameters',@html_title)
                  tell.txt_grey if @cmd =~/v/
                end
              end
            when /^@base_program:\s+(.+?)$/: @base_program=$1
              #break                                                             #% break, not necessary to process headers further :-) but necessary to extract endnotes etc. ;-(
            end
            @lv1 ||=/^1~/
            @lv2 ||=/^2~/
            @lv3 ||=/^3~/
            @lv4 ||=/^4~/
            @lv5 ||=/^5~/
            @lv6 ||=/^6~/
            if @dc_creator
              @dc_rights ||=if @dc_date =~/([12][890]\d{2})/                     #matches years 1800 through 20\d\d 2004w19
                ('Copyright ' + @dc_creator) + ' ' + $1
              else 'Copyright ' + @dc_creator 
              end
            end
          else
            case para
            when /~\{\s+.+?\}~/
              en=para.scan(/~\{.+?\}~/)
              en.each { |e| @en[:sum] +=1 }
            when /~\^(\s|$)/:
              mk=para.scan(/~\^(\s|$)/)
              mk.each { |e| @en[:mark] +=1 }
            when /^\^~\s+\S/: @en[:note] +=1
            end
          end
          if para =~/~\{|\^~ |~\^|<:ee>/i: @flag_auto_endnotes,@flag_endnotes=true,true
          end
          unless @flag_auto_endnotes
            if para =~/(4~endnotes\b|<:ee>)/i
              @flag_separate_endnotes=true
              @flag_endnotes=true
            end
          end
          if para =~/(?:4~endnotes|<:ee>)/i:           @flag_separate_endnotes_make=false
          end
          if para =~/<!!e[#0-9]+?!>\s*.+/i:            @flag_endnotes=true
          end
          if para =~/table\{|<!tableh?\s+c\d+;.+?!>/i: @flag_tables=true
          end
          if (@markup =~/0\.38/ and para =~/^:A~/) or (@markup !~/0\.38/ and para =~/^1~/)
            @set_heading_top=true
          end
          if (@markup =~/0\.38/ and para =~/^1~/) or (@markup !~/0\.38/ and para =~/^4~/)
            m=nil
            if @markup =~/0\.38/ and para =~/1~(\S+)\s+(.+)$/:    m,t=$1,$2
            elsif @markup !~/0\.38/ and para =~/4~(\S+)\s+(.+)$/: m,t=$1,$2
            elsif @markup =~/0\.38/ and para =~/1~\s+(.+)$/:      t=$1
            elsif @markup !~/0\.38/ and para =~/4~\s+(.+)$/:      t=$1
            end
            unless @heading_seg_first_flag                          # extract first segment name
              @heading_seg_first=t
              @heading_seg_first_flag=true
            end
            if m                                                     # list all segment names
              @seg_names << m
              @set_heading_seg=true
              @seg_autoname_safe=false if m=~/^\d{1,3}/ and m !~/^0/
            end
          end
        end #% here endeth the document loop
        unless @title
          if @heading_seg_first #revisit
            #@title=@heading_seg_first
            #@dc_title=@heading_seg_first
          end
        end
        if @markup =~/0\.38/ #convert to internal representation
          translated=Array.new
          translate_list=[@pagenew,@pagebreak,@num_top,@toc_lev_limit]
          translate_list.each do |t|
            translate = t.to_s if t
            translated << if translate
              translate.gsub!(/1/,'4')
              translate.gsub!(/2/,'5')
              translate.gsub!(/3/,'6')
              translate.gsub!(/:?A/,'1')
              translate.gsub!(/:?B/,'2')
              translate.gsub!(/:?C/,'3')
              translate=if translate =~/^\d+$/: translate.to_i
              else translate
              end
            else nil
            end
          end
          @pagenew,@pagebreak,@num_top,@toc_lev_limit=translated
          @markup.gsub!(/page_new\s*=\s*([\dA-C])/,"page_new=#@pagenew")
          @markup.gsub!(/page_break\s*=\s*([\dA-C])/,"page_break=#@pagebreak")
          @markup.gsub!(/num_top\s*=\s*([\dA-C])/,"num_top=#@num_top")
          @markup.gsub!(/toc_lev_limit\s*=\s*([\dA-C])/,"toc_lev_limit=#@toc_lev_limit")
        end
        if @mod_s =~/--papersize=\S+|--pdf=\S+|--(?:a4|letter|legal|book|a5|b5)\b/ #command line config/header override
          @papersize=determine_papersize(@mod_s)
        end
        if @sys.openssl !=false
          skin=if @doc_skin: SiSU_Env::Info_skin.new(@doc_skin).select
          else               SiSU_Env::Info_skin.new.select
          end
          @dgst,@dgst_skin=Array.new,Array.new
          if @env.digest =~/sha256/
            @dgst=@sys.sha256(@fns)
            @dgst_skin=if skin: @sys.sha256(skin)
            else                nil
            end
          else
            @dgst=@sys.md5(@fns)
            @dgst_skin=if skin: @sys.md5(skin)
            else                nil
            end
          end
        end
        @dc_publisher ||= "#@@publisher (this copy)" 
        fn_set_lang=SiSU_Env::Standardise_language.new.file_to_language(@fns)
        unless @dc_language[:code] and @dc_language[:name]
          lang=@env.language #default language settings for directory by name, or in sysrc.yaml
          @dc_language[:code] ||= lang.code
          @dc_language[:name] ||= lang.title
        end
        unless fn_set_lang[:d]==true #decide, naming convention overrides other settings, within document, etc.
          @dc_language[:code]=fn_set_lang[:c]
          @dc_language[:name]=fn_set_lang[:l]
        end
        @fnl=@env.lang_filename(fn_set_lang[:c])
        @flv.each do |l|
          lang=SiSU_Env::Standardise_language.new.file_to_language(l)
          c=Hash.new
          c[:a],c[:b],c[:c]='','',''
          if @fnl[:pre] =~/\S/:     c[:a]="#{lang[:c]}."
          elsif @fnl[:mid] =~/\S/:  c[:b]=".#{lang[:c]}"
          elsif @fnl[:post] =~/\S/: c[:c]=".#{lang[:c]}"
          end
          @lang << [lang[:l],"#{c[:a]}sisu_manifest#{c[:b]}.html#{c[:c]}"]
        end if @flv
        @lang.uniq!
        @fn=SiSU_Env::Env_call.new(@fns).lang(fn_set_lang[:c])
        if @en[:note] > 0 and @en[:sum] > 0
          if @en[:sum] > 0
          else tell=SiSU_Screen::Ansi.new(@cmd,'both endnote styles used',"~{ #{@en[:sum]} }~ and ^~ #{@en[:mark]}")
            tell.warn if @cmd !~/q/
          end
        end
        if @en[:mark] != @en[:note] and @en[:note] > 0
          @en[:mismatch]=@en[:note] - @en[:mark]
          tell=SiSU_Screen::Ansi.new(@cmd,'endnote number mismatch',"endnotes: #{@en[:note]} != endnote reference marks: #{@en[:mark]} (difference = #{@en[:mismatch]})")
          tell.warn if @cmd !~/q/
        end
        if @title !~/[\S]/
          tell=SiSU_Screen::Ansi.new(@cmd,'Document Title Missing','please provide it')
          tell.warn if @cmd =~/v/
        end
        if @dc_creator !~/[\S]/
          tell=SiSU_Screen::Ansi.new(@cmd,'Document Creator/Author Missing','please provide it')
          tell.warn if @cmd =~/v/
        end
        ## code for inclusion of addresses of promulgating authority
        #require 'yaml'
        #home=%x{echo $HOME}.chomp!
        #yamladdr="#{home}/.sisu/skin/yaml/skin_lexAddress.yaml"
                                                                                 #% workround looks at scripts dir before develpment tree regardless of which is being used
        #y=%x{echo $RUBYPATH}
        #if FileTest.file?(yamladdr)
        #  yamladdr=YAML::load(File::open(yamladdr)) 
        #  @stmpd=%{#{yamladdr['address'][@stmp]}} if yamladdr['address'][@stmp] #checkon 2004w03 !
        #end
        ## Here we have Elementary Document Structure Analysis
        ## Adds complexity may need to remove - certainly will need to develop - appears to work
        ## Proof of Concept !
        if @title.nil?
          title_trigger=nil
          fns_array.each do |para|
            if para !~/0~|@\S+:[+-]?\s/ and para =~/\S/ and title_trigger.nil?
              @title=para[/(\S.+)/im, 1]
              @html_title=@title.gsub(/(<p>|<p \/>|<br>|<br \/>)/i,'')
              @title.chomp!("\n")
              @html_title.chomp!("\n")
              title_trigger=1
              tell=SiSU_Screen::Ansi.new(@cmd,@html_title)
              tell.txt_cyan unless @cmd =~/q/
              tell=SiSU_Screen::Ansi.new(@cmd,'Parameters')
              tell.txt_grey unless @cmd =~/q/
            end
          end
        end
        @struct=Hash.new
        doc_struct=Hash.new(0)
        if @lv1.nil?
          fns_array.each do |para|
            if para =~/^(Part|Chapter|Section|Article)\b/i
              case para
              when /^(Part|PART)\b/
                @struct[:part]=doc_struct[:part]
                doc_struct[:part]=doc_struct[:part] + 1
              when /^(Chapter|CHAPTER)\b/
                @struct[:chapter]=doc_struct[:chapter]
                doc_struct[:chapter]=doc_struct[:chapter] + 1
              when /^(Section|SECTION)\b/
                @struct[:section]=doc_struct[:section]
                doc_struct[:section]=doc_struct[:section] + 1
              when /^(Article|ARTICLE)\b/
                @struct[:article]=doc_struct[:article]
                doc_struct[:article]=doc_struct[:article] + 1
              when /^(Clause|CLAUSE)\b/
                @struct[:clause]=doc_struct[:clause]
                doc_struct[:clause]=doc_struct[:clause] + 1
              when /^\d\..*[^\.]$/
                @struct[:number]=doc_struct[:number]
                doc_struct[:number]=doc_struct[:number] + 1
              end
            end
          end
          if doc_struct[:article] > 2                                            #%~level 4
            @lv4=/^(?:Article|ARTICLE)\b/
          elsif doc_struct[:chapter] > 2 and doc_struct[:article] and doc_struct[:article] < 3 # check logic added (and doc_struct[:article]) 2004w05
            @lv4=/^(?:Chapter|CHAPTER)\b/
          elsif doc_struct[:clause] > 2
            @lv4=/^(?:Clause|CLAUSE)\b/
          elsif doc_struct[:number] > 2
            @lv4="^\d\..*[^\.]$"
          end
          if doc_struct["section"] > 2                                           #%~level 3
            @lv3=/^(?:Section|SECTION)\b/
          end
          if doc_struct[:chapter] > 2 and doc_struct[:article] and doc_struct[:article] > 2 #%~level 2 # check logic added (and doc_struct[:article]) 2004w05   
            @lv2=/^(?:Chapter|CHAPTER)\b/
          end
          if doc_struct[:part] > 2 and @lv[2].nil?
            @lv2=/^(?:Part|PART)\b/
          end
          if doc_struct[:part] > 2 and @lv[2].to_s !~/Part/ and @lv[1].nil?      #%~level 1 #changed 2004w05 debug
            @lv1=/^(Part|PART)\b/
          end
        end
        @lnk=@lnk.compact if @lnk
        @lv1 ||=/^1~/
        @lv2 ||=/^2~/
        @lv3 ||=/^3~/
        @lv4 ||=/^4~/
        @lv5 ||=/^5~/
        @lv6 ||=/^6~/
        if @doc_skin
          tell=SiSU_Screen::Ansi.new(@cmd,"doc_skin <- #@doc_skin")
          tell.txt_grey if @cmd =~/v/
        end
        @data=nil                                                                #else whole file's contents are stored in md pstore & is not required to be... big waste actually
        Store.new(self,@env).store                                           #% pstore 
        self
      end
      private
      class Store
        def initialize(md,dir)
          @md=md
          @pstorefile="#{dir.metaverse}/#{md.fns}.pstore"
        end
        def store
          File.unlink(@pstorefile) if FileTest.file?(@pstorefile)
          tell=SiSU_Screen::Ansi.new(@md.cmd,"PStore -> #@pstorefile")
          tell.txt_grey if @md.cmd =~/v/
          store=PStore.new(@pstorefile)
          store.transaction do |s| 
            s['md']=@md 
            #doc.each{|x,y| puts "#{x}, #{y}; "}
            s.commit
          end
          @@md=@md=nil
        end
      end
      #remove format_instructions #the old 'doc' hash, unused
    end
  end
  class Instantiate
    def param_instantiate
      @@date=SiSU_Env::Info_date.new
      @@symlnk=SiSU_Env::Create_system_link.new
      @@proc=@@filename_txt=@@filename_texinfo=@@filename_lout_portrait=@@filename_lout_landscape=@@filename_html_scroll=@@filename_html_index=@@filename_html_segtoc=@@filename_semantic=@@filename_rss=@@newfile=@@drr=nil
      @doc=Hash.new
      @doc[:initialise]=nil
      @doc[:markup]=@doc[:lnks]=@doc[:stmp]=@doc[:prefix_a]=@doc[:prefix_b]=''
      @doc[:req]=Hash.new
      @@yaml=@@yamladdr=nil
      @@flag=Hash.new
      @@publisher="SiSU scribe"
    end
  end
end
__END__
