=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
 * Description: Kdissert
 * License: Same as SiSU see http://www.jus.uio.no/sisu
 * Notes: Site default appearance variables set in defaults.rb
     Generic site wide modifications set here scribe_skin.rb, and this file required by other "scribes" instead of defaults.rb
=end
module SiSU_Viz
  require "#{SiSU_lib}/defaults"
  class Home
    def index
    end
    def toc
    end
  end
  class Path
    def root
      './sisu/'  # the only parameter that cannot be changed here
    end
    def rel
      '../'
    end
  end
  class Url
    def home
      'http://www.jus.uio.no/sisu'
    end
    def site                                                                     # used in pdf header
      home
    end
    def txt                                                                      # text to go with url usually stripped url
      'www.jus.uio.no/sisu'
      home
    end
    def hp
      'http://freehackers.org/~tnagy/kdissert'
    end
    def home_url
      '../index.html'
    end
    #def root_http
      #root server path info, used in document information
    #end
  end
  class Color
    def band1
      '"#ffffff"'      
    end
  end
  class Txt
    def hp
    	'Kdissert, Document Mapping'
    end
    def home                                                                     # this should be the name of the site eg. Lex Mercatoria or if you prefer to see a url the url in text form copy & ...
      #"www.jus.uio.no/sisu/" 
    	'SiSU (document prepared using Kdissert)'
    end
  end
  class Icon
    def home_button
      'kdissert.png'
    end
    def home_banner
      self.home_button
    end
  end
  class Banner
    def home_button
		  %{<table border="0" summary="home button" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#000070"><a href="#{@url.hp}/">#{@png.home}</a></td></tr></table>\n}
    end
    def home_and_index_buttons
	    %{<table><tr><td width="20%"><table summary="home and index buttons" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#000070"><a href="#{@url.hp}/" target="_top">#{@png.home}</a>#{@table.close}</td><td width="60%"><center><table summary="buttons" border="1" cellpadding="3" cellspacing="0"><tr><td align="center" bgcolor="#f1e8de"><font face="arial" size="2"><a href="toc" target="_top">&nbsp;This&nbsp;text&nbsp;sub-&nbsp;<br />&nbsp;Table&nbsp;of&nbsp;Contents&nbsp;</a></font>#{@table.close}</center></td><td width="20%">&nbsp;#{@table.close}}
    end
    def band
      %{<table summary="band" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#ffffff"><a href="#{@url.hp}/" target="_top">#{@png.home}</a>#{@table.close}}
    end
    def home_guide
    end
  end
  class Credits
    def credits
      %{<center><table summary="credits" align="center"bgcolor="#ffffff"><tr><td>#{@widget.sisu}#{@widget.wayBetter}#{@widget.browsers}#{@widget.pdfviewers}#{@table.close}</center>}
    end
  end
  class Tex
    def header_center
	    "\\chead{\\href{#{@url.site}/}{www.jus.uio.no/sisu/}}"
    end
    def home_url
	    "\\href{#{@url.site}/}{www.fsf.org}"
    end
    def home
	    "\\href{#{@url.site}/}{Free Software Foundation}"
    end
    def owner_chapter
      "Document owner details"
    end
  end
  class Stamp
    def stmp
  	  "\\copyright Ralph Amissah to be released under the GPL (or QT License equivalent as to be decided) \\\\\n ralph@amissah.com \\\\\n www.jus.uio.no/sisu/"
    end
  end
end
