=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: html scroll generation, processing

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_HTML_scroll
  require SiSU_lib + '/html'
  require SiSU_lib + '/shared_html'
  class Scroll
    @@dp=nil
    def initialize(data='',md='')
      @data,@md=data,md
      @margin=SiSU_Viz::Margin.new
      @@dp ||=SiSU_Env::Info_env.new.digest.pattern
    end
    def songsheet
      begin
        scr=Scroll.new(@data,@md).markup
        scr[:tails]=Scroll.new('',@md).tails
        scr
      rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
      ensure
      end
    end
  protected
    def markup
      data=@data
      @rcdc=false
      @scr={ :body=>[],:metadata=>[],:owner_details=>[] }
      data.each do |para|
        if para =~/Document Information/
          para.gsub!(/(Document Information)/,'\1<a name="docinfo"></a>')
        end
        if para =~/MetaData/
          para.gsub!(/(MetaData)/,'\1<a name="metadata"></a>')
        end
        @rcdc=true if @rcdc==false and (para =~/~metadata/ or para =~/1~\s+Document Information/)
        if para !~/(^0~|<ENDNOTES>|<EOF>)/ 
          para.gsub!(/~[{\[].+?[}\]]~\s+/m,' ')
          if para =~/.+?<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>.*/
            paranum=para[/.+?<~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>.*/,1]
            @p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,paranum)
          end
          @sto=SiSU_HTML::Source::Split_text_object.new(@md,para).lev_segname_para_ocn
          unless @rcdc
            m=/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
            if para =~m
              format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,@sto.text) if @sto.format =~/[12]|_1?\*|<!i[12]!>\s*_\*|null/
              case @sto.format
              when /^1~\S*/; para=@sto.scroll_lev_para_ocn.heading_body1
              when /^2~\S*/; para=@sto.scroll_lev_para_ocn.heading_body2
              when /^3~\S*/; para=@sto.scroll_lev_para_ocn.heading_body3
              when /^4~\S+/;      para=@sto.scroll_lev_para_ocn.heading_body4 # work on see Split_text_object4
              when /^5~\S*/; para=@sto.scroll_lev_para_ocn.heading_body5
              when /^6~\S*/; para=@sto.scroll_lev_para_ocn.heading_body6
              when /^_\*$/;       para=@sto.scroll_lev_para_ocn.bullet
              when /^_1\*$/
                format_txt_obj.gsub_body
                para=@sto.scroll_lev_para_ocn.bullet_indent1
              when /^_2\*$/
                format_txt_obj.gsub_body
                para=@sto.scroll_lev_para_ocn.bullet_indent2
              when /^i1$/
                format_txt_obj.gsub_body
                para=@sto.scroll_lev_para_ocn.indent1
              when /^i2$/
                format_txt_obj.gsub_body
                para=@sto.scroll_lev_para_ocn.indent2
              when /^center$/;               para=@sto.scroll_lev_para_ocn.center
              when /^(?:b|bold)$/;           para=@sto.scroll_lev_para_ocn.bold
              when /^(?:verse|group|alt)$/;  para=@sto.scroll_lev_para_ocn.para
              when /^code$/;                 para=@sto.scroll_lev_para_ocn.code
              when /null/ # see whether u can improve
                if para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/
                  format_txt_obj.gsub_body
                  para=@sto.scroll_lev_para_ocn.para
                  if para =~/<!Th?.+/ # tables come as single block
                    table=SiSU_HTML_shared::Table.new(para)
                    para=table.table_split
                  end
                end
              end
            elsif para =~/Endnotes?/ and para !~/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
              format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,'<br /><a name="notes">Note</a>')
              para=format_txt_obj.bold_para
            elsif para =~/Owner Details/ and para !~/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
              format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,'<br /><a name="owner.details">Owner Details</a>')
              @scr[:owner_details]=format_txt_obj.bold_para
              para=''
            elsif para =~/(.*)<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>(.*)/ #watch
              one,two=$1,$2
              format_seg=SiSU_HTML_Format_type::Format_seg.new(@md,one,two)
              para=format_seg.no_paranum
            end
            para=para.gsub(/ [2-6]~\S+ /,'') #and @md.cmd =~/[VM]/ #arbitrary, watch problematic as too general
            para='' if (para =~/<a name="n\d+">/ and para =~/^(?:\^~\d+\s|<!e[:_]\d+!>)/) # hmmm re-adjusted 200507, for alt endnote which should again be matched ^~ ... not in response to problem though
            if para =~/<:center>/ #rules changed now a <p class="center" problems may arise 2005w11 !
              one,two=/(.*)<:center>(.*)/.match(para).captures
              format_scroll=SiSU_HTML_Format_type::Format_scroll.new(@md,one,two)
            end
          else # this is crazy rethink and redo later with some form of inject
            m=/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
            if para =~m
              format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,@sto.text) if @sto.format =~/[12]|null/
              meta=case @sto.format
              when /^1~/;    @sto.scroll_lev_para_ocn.heading_body1
              when /^2~/;    @sto.scroll_lev_para_ocn.heading_body2
              when /^3~/;    @sto.scroll_lev_para_ocn.heading_body3
              when /^4~\S+/; @sto.scroll_lev_para_ocn.heading_body4 # work on see Split_text_object
              when /^5~/;    @sto.scroll_lev_para_ocn.heading_body5
              when /^6~/;    @sto.scroll_lev_para_ocn.heading_body6
              when /^i1$/
                format_txt_obj.gsub_body
                @sto.scroll_lev_para_ocn.indent1
              when /^i2$/
                format_txt_obj.gsub_body
                @sto.scroll_lev_para_ocn.indent2
              when /^center$/;   @sto.scroll_lev_para_ocn.center
              when /^(b|bold)$/; @sto.scroll_lev_para_ocn.bold
              when /null/ # see whether u can improve
                if para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/
                  format_txt_obj.gsub_body
                  @sto.scroll_lev_para_ocn.para
                  if para =~/<!Th?.+/ # tables come as single block
                    table=Table.new(para)
                    para=table.table_split
                  end
                end
              end
            elsif para =~/(Endnotes?)/ and para !~/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
              format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,'<br /><a name="notes">Note</a>')
              meta=format_txt_obj.bold_para
            elsif para =~/MetaData/ and para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/ #debug 2003w46 add rc info
              format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,'<br /><a name="metadata">MetaData</a>')
              meta=format_txt_obj.bold_para
            elsif para =~/Owner Details/ and para !~/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
              format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,'<br /><a name="owner.details">Owner Details</a>')
              @scr[:owner_details]=format_txt_obj.bold_para
              meta=''
            elsif para =~/(¡|<!Th?)/
              table=Table.new(para)
              para=table.table
            elsif para =~/(.*)<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>(.*)/ #ok - bug in equiv for seg 2004w46
              one,two=$1,$2
              format_scroll=SiSU_HTML_Format_type::Format_scroll.new(@md,one,two) #watch #fix
              meta=format_scroll.no_paranum
            end
            meta='' if para =~/<a name="n\d+">/ and para =~/^(\^~\d+ |<!e[:_]\d+!>)/ # -endnote
            if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
              case para
              when /<:i1>/
                gsub(/<:i1>/,'')
                format_scroll=SiSU_HTML_Format_type::Format_scroll.new(@md,para)
                meta=format_scroll.indent_one_no_paranum
              when /<:i2>/
                gsub(/<:i2>/,'')
                format_scroll=SiSU_HTML_Format_type::Format_scroll.new(@md,para)
                meta=format_scroll.indent_one_no_paranum
              end
            end
            if para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/
            end
            if para =~/<:center>/
              one,two=/(.*)<:center>(.*)/.match(para).captures
              format_scroll=SiSU_HTML_Format_type::Format_scroll.new(@md,one,two)
            end
          end
          para.gsub!(/<!.+!>/,' ')
          para.gsub!(/^<:\S?>/,'')
          para.gsub!(/<:\S?>/,' ')
          unless meta; @scr[:body] << para
          else         @scr[:metadata] << meta
          end
        end
      end
      @scr
    end
    def tails
      scr_tail=[]
      format_head_scroll=SiSU_HTML_Format_type::Head_toc.new(@md)
      scr_tail  << format_head_scroll.scroll_tail
      scr_tail
    end
  end
end
__END__
