=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: SiSU information Structuring Universe, processing

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU
  require SiSU_lib + '/sysenv'
  include SiSU_Screen
  @@pwd=Dir.pwd
  class Remote_download
    def initialize(requested_file)
      @requested_file=requested_file
    end
    def pod
      @re_p_div=/http:\/\/([^\/]+)(\/\S+?)\/(sisupod(?:\.zip)?|[^\/]+?\.ssp)$/
      @re_p=/(sisupod(?:\.zip)?|[^\/]+?\.ssp)$/
      if @requested_file =~ @re_p_div
        @site,@pth,@pod= @re_p_div.match(@requested_file).captures
      elsif @requested_file =~ @re_p
        @pod= @re_p.match(@requested_file).captures
      end
      @re_p_stub=/.+?([^\/]+)$/
      def site
        @site
      end
      def path
        @pth
      end
      def dir_stub
        pod_stub= @re_p_stub.match(path).captures.join if path
      end
      def name_source
        @pod
      end
      def name
        pod_download_as=if name_source=~/(?:sisupod\.(?:zip|ssp))/; dir_stub + '.ssp'
        else                                                        name_source
        end
      end
      self
    end
  end
  class Op
    @@env=SiSU_Env::Info_env.new
    def initialize(opt,req,message)
      @opt,@req,@message=opt,req,message
      @n_do=0
    end
    def pod_output(fns_pod)
      dir_pwd=@@env.path.pwd
      dir_pod=@@env.sisupod_gen(fns_pod)
      Dir.chdir(dir_pod)
      content=Dir.glob("*.ss[mt]").join(' ')
      if content =~/\.ss[mt]/
        Dir.chdir(dir_pwd)
        @opt.fns=content #check
        system("cd #{dir_pod}
          sisu -CC #{@opt.cmd} #{@opt.mod.join(' ')} #{content}
          cd -
        ")
      end
      @pwd=`pwd`.strip
      Dir.chdir(@pwd)
    end
    def select
      require SiSU_lib + "/#@req"
      if @req =~/^conf$/;           SiSU_Initialize::Source.new(@opt).read    # -C
      end
      if not @opt.files.empty?
        @opt.files.each do |fns|
          if fns =~ /(?:sisupod(?:\.zip)?|\.ssp)$/
            pod_name=Remote_download.new(fns).pod.name
            tell=SiSU_Screen::Ansi.new(@opt.cmd,pod_name)
            tell.puts_blue unless @opt.cmd =~/q/
            @opt.files.shift
            pod_output(pod_name)
            break
          else
            put=fns.gsub(/(.+)?\._sst$/,'\1.ssm')
            @opt.fns=fns
            if @req !~/(?:urls|remote_put)$/
              if FileTest.file?(@opt.fns)
        	      case @opt.fns
        	      when /\.(?:[_-]?sst|ssm)$/
                  case @req
                  when /^metaverse$/
        	          if fns =~ /\.ssm$/; require SiSU_lib + '/composite'  #pre-processing
                      SiSU_Assemble::Composite.new(@opt).read
                      @opt.fns=fns.gsub(/\.ssm$/,'._sst')
                    end
                                            SiSU_Metaverse::Source.new(@opt).read     # -m
                  when /^concordance$/;     SiSU_Concordance::Source.new(@opt).read   # -w
                  when /^share_src$/;       SiSU_Markup::Source.new(@opt).read        # -s
                  when /^sisupod_make$/;    SiSU_Doc::Source.new(@opt).read           # -S
                  when /^source_kdissert$/; SiSU_Kdi_source::Source.new(@opt).read    ## -S
                  when /^digests$/;         SiSU_Digest_view::Source.new(@opt).read   # -N
                  when /^plaintext$/;       SiSU_Plaintext::Source.new(@opt).read     # -a -e -f
                  when /^odf$/;             SiSU_ODF::Source.new(@opt).read           # -o
                  when /^texpdf$/;          SiSU_TeX::Source.new(@opt).read           # -p
                  when /^texinfo$/;         SiSU_TexInfo::Source.new(@opt).read       # -I
                  when /^docbook$/;         SiSU_Docbook::Source.new(@opt).read       # -B
                  when /^html$/;            SiSU_HTML::Source.new(@opt).read          # -h -H
                  when /^xml$/;             SiSU_XML_SAX::Source.new(@opt).read       # -x
                  when /^xml_dom$/;         SiSU_XML_DOM::Source.new(@opt).read       # -X
                  when /^xhtml$/;           SiSU_XHTML::Source.new(@opt).read         # -b
                  when /^manifest$/;        SiSU_Manifest::Source.new(@opt).read      # -y
                  when /^sitemaps$/;        SiSU_Sitemaps::Source.new(@opt).read      # -Y
                  when /^zap$/;             SiSU_Zap::Source.new(@opt).read           # -Z
                  when /^dbi$/;             SiSU_DBI::SiSU_SQL.new(@opt).connect      # -D -d
                  end
    	            @n_do=@n_do+1
                  tell=SiSU_Screen::Ansi.new(@opt.cmd,@n_do,"#{@req.upcase} processed")
                  tell.files_processed unless @opt.cmd =~/q/
                  ObjectSpace.garbage_collect
        	      else                    #print "not processed --> ", fns, "\n"
        	      end
              else                      Operations.new(@opt).not_found
              end
            elsif FileTest.file?(put)
              case @req
              when /^urls$/;           SiSU_urls::Source.new(@opt).read           # -u -v -V -M
              when /^remote_put$/
                case @message
                when /scp/;            SiSU_Remote::Put.new(@opt).scp             # -r
                when /rsync/;          SiSU_Remote::Put.new(@opt).rsync           # -R
                else                   #SiSU_Remote::Put.new(put,@opt.cmd).scp
                end
              end
            else                       Operations.new(@opt).not_found
            end
          end
        end
      elsif @req =~/^dbi$/;            SiSU_DBI::SiSU_SQL.new(@opt).connect      # -D -d
      elsif @req=~/^sisupod_make$/;    SiSU_Doc::Source.new(@opt).read           # -S
      end
      Operations.new.counter
    end
  end
  class Operations
    @@n_do=0
    def initialize(opt='')
      @opt=opt
      @cX=SiSU_Screen::Ansi.new(@opt).cX
    end
    def counter
      @@n_do=0
    end
    def remote_put_base_site_rsync                                   # -CR
p "here #{__FILE__} #{__LINE__}" if @opt =~/M/
      require SiSU_lib + '/remote_put'
      SiSU_Remote::Put.new(@opt).rsync_base
    end
    def remote_put_base_site_rsync_match                             # -CCRZ
p "here #{__FILE__} #{__LINE__}" if @opt =~/M/
      require SiSU_lib + '/remote_put'
      SiSU_Remote::Put.new(@opt).rsync_base_sync
    end
    def remote_put_base_site                                         # -Cr
p "here #{__FILE__} #{__LINE__}" if @opt =~/M/
      require SiSU_lib + '/remote_put'
      SiSU_Remote::Put.new(@opt).scp_base
    end
    def remote_put_base_site_all                                     # -CCr
p "here #{__FILE__} #{__LINE__}" if @opt =~/M/
      require SiSU_lib + '/remote_put'
      SiSU_Remote::Put.new(@opt).scp_base_all
    end
    def cgi                                                          # -F
      require SiSU_lib + '/cgi'
      SiSU_CGI::SiSU_search.new(@opt).read
    end
    def encoding                                                     # -K build character encoding db (uses KirbyBase)
      require SiSU_lib + '/character_encoding'
      SiSU_character_encode::Create.new.db
    end
    def termsheet                                                    # -t
      system("sisu_termsheet #{@opt.cmd} #{@opt.fns}\n")
    	@@n_do=@@n_do+1
      tell=SiSU_Screen::Ansi.new(@opt.cmd,@@n_do,'Termsheet(s) processed')
      tell.term_sheet_title unless @opt.cmd =~/q/
    end
    def webrick                                                      # -W
      port=prt=@fns
      prt=if prt !~/\d+/; 'webrick default (sysenv)' 
      else                "webrick port set to #{prt}"
      end
    	puts 	%{#{@cX.blue}<<#{@cX.off}#{@cX.green}Start Webrick web server on port: #{prt}#{@cX.off}#{@cX.blue}>> #{@cX.off*2} }
      system("sisu_webrick #{port}&\n")
    end
    def semantics
    end
    def not_found
      puts "\n#{@cX.fuschia}FILE NOT FOUND:#{@cX.off} << #{@opt.fns} >> - requested #{@opt.cmd} processing skipped\n"
    end
    def convert_name_message(fns,type,i,o,rune)
      %{\nIn filename: "#{@cX.fuschia}#{fns}#{@cX.off}" << #{type} >> #{@cX.fuschia}is apre 0.36 markup filename.#{@cX.off} #{@cX.brown}Please rename your file.#{@cX.off}\n\tAs of sisu-0.37, SiSU markup files with #{@cX.brown}the extensions #{i} should be re-named #{o}#{@cX.off}\n\tif you have the program called 'rename' installed, the following rune should do the trick:\n\t\t#{rune}\n\talternatively try:\n\t\tsisu --convert --36to37 #{fns}\n\trequested #{@opt.cmd} processing skipped\n}
    end
    def not_recognised
      case @opt.fns
      when /(\.s[123])$/
        type=@opt.fns.gsub(/\S+?(#{$1})/,'\1')
        rune=%q{rename 's/\.s[123]$/\.sst/' *.s{1,2,3}}
        puts convert_name_message(@opt.fns,type,'.s1 .s2 and .s3','.sst',rune)
      when /(\.r[123])$/
        type=@opt.fns.gsub(/\S+?(#{$1})/,'\1')
        rune=%q{rename 's/\.r[123]$/\.ssm/' *.r{1,2,3}}
        puts convert_name_message(@opt.fns,type,'.r1 .r2 and .r3','.sst',rune)
        puts %{\n\tNote also that you will need to change the names of the files called/required\n\twithin the document text to build the composite document\n\t\t.s1 .s2 .s3 should be .sst \n\t\t.si should be .ssi\n\trequested #{@opt.cmd} processing skipped\n}
      when /(\.ssi)$/
        puts "\n#{@cX.fuschia}component filetype:#{@cX.off} << #{@opt.fns} >> - is not a processed filetype, (it may be used as a component of a .ssm markup file)\n\trequested #{@opt.cmd} processing skipped\n"
      else
        puts "\n#{@cX.fuschia}FILETYPE NOT RECOGNISED:#{@cX.off} << #{@opt.fns} >> - is not a recognized filetype,\n\trequested #{@opt.cmd} processing skipped\n"
      end
    end
  end
  class Processing
    require 'fileutils'
    include FileUtils
    @@env=SiSU_Env::Info_env.new
    attr_accessor :op
    def initialize(opt)
      @opt=opt
      @msg,@msgs='',nil
      @tell=lambda { SiSU_Screen::Ansi.new(@opt.cmd,@msg,"#{@msgs.inspect if @msgs}") }
    end
    def op(req,msg)
      Op.new(@opt,req,msg).select if req and msg
    end
    def actions
      if @opt.mod.inspect =~/--convert|--to|--from/; require SiSU_lib + '/sst_convert_markup'
      end
      if @opt.cmd =~/([AabCcDdEeFfGHhIiLMmNnoprRSsTtQqUuVvwWXxYyZ_0-9])/ and
         @opt.cmd =~/^-/ and
         @opt.mod.inspect !~/--sitemaps/ or
         @opt.mod.inspect =~/--(?:(?:sq)?lite|pg(?:sql)?)/ #and
        @@tell=SiSU_Screen::Ansi.new(@opt.cmd)
        @cX=SiSU_Screen::Ansi.new(@opt.cmd).cX
        flag=SiSU_Env::Info_processing_flag.new
        extra=''
        if @opt.cmd !~/[mn]/
          extra+=if @opt.cmd =~/[abBehHhINoptwXxz]/ and @opt.cmd !~/[mn]/; 'm'           #% add metaverse
          elsif (@opt.cmd =~/[Dd]/ or @opt.mod.inspect =~/--(?:(?:sq)?lite|pg(?:sql)?)/) \
          and @opt.mod.inspect !~/^(?:remove|(?:re)?create(?:all)?|dropall|drop)$/ \
          and @opt.cmd !~/[mn]/
            'm'                                                                          #% add metaverse
          else ''
          end
        end
        if @opt.cmd !~/y/
          extra+=if @opt.cmd =~/[abehHhINopsSstwXxz]/ and @opt.cmd !~/y/; 'y'            #% add manifest
          elsif (@opt.cmd =~/[Dd]/  or @opt.mod.inspect =~/--(?:(?:sq)?lite|pg(?:sql)?)/) and @opt.files[0] !~/^remove$/ and @opt.cmd !~/y/; 'y' #% add manifest
          else ''
          end
        end
        @opt.cmd=@opt.cmd + extra  
        if @opt.cmd =~/[vVM]/                                                             #% version information
          version={}
          version=SiSU_Env::Info_version.new.get_version
          rb_ver=SiSU_Env::Info_version.new.rbversion
          if version[:version]
            tell=SiSU_Screen::Ansi.new(@opt.cmd,version[:project],version[:version],version[:date_stamp],version[:date],rb_ver)
            tell.version
          else puts 'SiSU version information not available'
          end
        end
        if @opt.cmd =~/^-L$/; SiSU_Help::Help.new('license',opt).help_request           #% version information
        end
        if @opt.cmd =~/m/i                                           #% -m for -C
          path_css="#{@@env.path.output}/_sisu/css"
          path_dtd="#{@@env.path.output}/_sisu/dtd"
          unless FileTest.directory?(path_css) and FileTest.directory?(path_dtd)
            @opt.cmd=@opt.cmd +='C' unless @opt.cmd =~/C/
          end
          if @opt.cmd =~/M/; $VERBOSE=false                          #debug $VERBOSE=true
            # -M test other expected directories including images
          end
        end
        if @opt.cmd =~/C/                                            #% -C initialize/configure
          op('conf','configure site')
          if @opt.cmd =~/R/
            if @opt.mod.inspect =~/--init(?:ialize)?=site/ and
               @opt.cmd =~/RZ/
              Operations.new(@opt).remote_put_base_site_rsync_match
            else Operations.new(@opt).remote_put_base_site_rsync
            end
          elsif @opt.cmd =~/r/
            if @opt.mod.inspect =~/--init(?:ialize)?=site/ and
               @opt.cmd =~/CCr/
              Operations.new(@opt).remote_put_base_site_all
            else Operations.new(@opt).remote_put_base_site
            end
          end
        end
        if @opt.cmd =~/F/                                            #% -F cgi sample search form
          Operations.new(@opt).cgi
        end
        if @opt.cmd =~/W/; Operations.new(@opt).webrick              #% -W webrick #@argv==port
        end
        if @opt.cmd =~/k/                                            #% -k dummy, build character encoding table
          #Operations.new(@opt.cmd).encoding
        end
        if @opt.cmd =~/Z/; op('zap','Zap, deletions')                #% -Z wipe previous output clean
        end
        if @opt.cmd =~/s/; op('share_src','SiSU markup source')      #% -s sisu source
        end
        if @opt.cmd =~/m/                                            #% -m is remote url requested? (download if)
          @retry_count= -1
          begin
            path_image='./_sisu/processing/external_document/image'
            path_skin='./_sisu/processing/external_document/skin/doc'
            @get_s,@get_p=[],[]
            re_s=/(http:\/\/\S+?\.sst)/
            re_p=/(http:\/\/\S+?(?:\/sisupod(?:\.zip)?|\.ssp))/
        	  @opt.files.each do |fns|
              if fns =~re_s
                @get_s << re_s.match(fns)[1] if re_s 
              end
              if fns =~re_p
                @get_p << re_p.match(fns)[1] if re_p 
              end
            end
            if @get_s.length > 0                                     #% remote markup file .sst
              require 'open-uri'
              require 'pp'
              require SiSU_lib + '/composite'
              @rgx_image=/\{\s*(\S+?\.(?:png|jpg|gif))/
              @rgx_skin=/0~skin\s+(\S+)/
              threads = []
              for requested_page in @get_s
                threads << Thread.new(requested_page) do |url|
                  open(url) do |f|
                    raise "#{url} not found" unless f
                    re_fnb=/(http:\/\/[^\/ ]+?\/[^\/ ]+?)\/\S+?\/([^\/]+?)\.ss(t)/ #revisit and remove DO
                    base_uri,fnb,instr=re_fnb.match(url)[1..3] if re_fnb
                    imagedir = base_uri + '/_sisu/image_local' #check on
                    doc_skin_dir = /(http:\/\/\S+?)\/[^\/]+?\.sst$/.match(url).captures.join + '/_sisu/skin/doc'
                    #"Got file, and ready to process: #{fnb}.t#{instr}"
                    downloaded_file=File.new("#{fnb}.-sst",'w+')
                    images=SiSU_Assemble::Remote_image.new.image(imagedir)
                    skin=SiSU_Assemble::Remote_image.new.image(doc_skin_dir)
                    f.collect.each do |r|                            # work area
                      skin << r.scan(@rgx_skin).uniq if r =~@rgx_skin     
                      images << r.scan(@rgx_image).uniq if r =~@rgx_image     
                      downloaded_file << r
                    end
                    if skin and skin.length > 0
                      SiSU_Assemble::Remote_image.new.download_doc_skin(skin)
                    end
                    if images and images.length > 1
                      images.flatten!.uniq! 
                      @msg,@msgs='downloading images:', [ images.join(',') ]
                      @tell.call.warn unless @opt.cmd =~/q/
                      SiSU_Assemble::Remote_image.new.download_images(images)
                      @msg,@msgs='downloading done',nil
                      @tell.call.warn unless @opt.cmd =~/q/
                    end
                    downloaded_file.close
                  end
                end
              end
              Operations.new.counter
            end
            threads.each {|thr| thr.join} if threads #and threads.length > 0
            if @get_p.length > 0                                     #% remote sisupod
               require 'net/http'
              for requested_pod in @get_p
                pod_info=Remote_download.new(requested_pod)
                @opt.fns=pod_info.pod.name
                Net::HTTP.start(pod_info.pod.site) do |http|
                  resp = http.get("#{pod_info.pod.path}/#{pod_info.pod.name_source}")
                  open(pod_info.pod.name,'wb') do |file|
                    file.write(resp.body)
                   end
                end
              end
            end
          rescue; SiSU_Errors::Info_error.new($!,$@,@opt,@fns).error #ok
            @retry_count +=1
            retry unless @retry_count > 1
          ensure
          end
          @opt.files=@opt.files.collect {|x| x=x.gsub(/http:\/\/\S+\/(\S+)\.sst/,'\1.-sst') }
        end
        if @opt.cmd=~/m/; op('metaverse','metaverse')                #% -m metaverse
        end
        @opt.files=@opt.files.collect {|x| x=x.gsub(/\.ssm$/,'._sst') }
        if @opt.cmd =~/S/
          op('sisupod_make','sisupod (zip)')                         #% -S make sisupod
          if @opt.fns=~/\.kdi._sst/
            op('share_src_kdissert','kdissert (kdi)')                #% -S share kdissert source
          end
        end
        if @opt.cmd =~/N/; op('digests','digests')                   #% -N digest tree
        end
        if @opt.cmd =~/[hHz]/; op('html','html')                     #% -h -H -z html css
        end
        if @opt.cmd =~/[aAfeE]/; op('plaintext','plaintext')         #% -a -A -f -e -E plaintext -a creates ms-dos type; -A creates unix type, plaintext file
        end
        if @opt.cmd =~/o/; op('odf','OpenDocument')                  #% -o opendocument
        end
        if @opt.cmd =~/x/; op('xml','xml sax')                       #% -x xml sax type
        end
        if @opt.cmd =~/X/; op('xml_dom','xml dom')                   #% -X xml dom type
        end
        if @opt.cmd =~/b/; op('xhtml','xhtml sax')                   #% -b xhtml sax type
        end
        if @opt.cmd =~/B/; op('docbook','docbook xml')               #% -B docbook xml
        end
        if @opt.cmd =~/w/; op('concordance','Concordance')           #% -w concordance
        end
        if @opt.cmd =~/t/                                            #% -t termsheet/standard form
          SiSU_Help::Help.new('termsheet').help_request 
        	@opt.files.each do |fns|
            if FileTest.file?(fns)
              @opt.fns=fns
        		  case @opt.fns
        		  when /\.(termsheet.rb)$/;            Operations.new(@opt).termsheet
        		  else              		  	           #print "not processed --> ", fns, "\n"
        		  end
            else                                   Operations.new(@opt).not_found
            end
        	end
          Operations.new.counter
        end
        if @opt.cmd =~/p/; op('texpdf','LaTeX pdf')                  #% -p latex/ texpdf
        end
        if @opt.cmd =~/I/; op('texinfo','TeX Info')                  #% -I texinfo (i taken by db import)
        end
        if @opt.cmd =~/D/ or @opt.mod.inspect =~/--pgsql/; op('dbi','postgresql')                    #% -D DB postgresql
        end
        if @opt.cmd =~/d/ or @opt.mod.inspect =~/--sqlite/; op('dbi','sqlite')                        #% -d DB sqlite
        end
        if @opt.cmd =~/G/; Operations.new(@opt).cgi                  #% -G cgi - used to make dbi intecface
        end
        if @opt.cmd =~/y/; op('manifest','Manifest')                 #% -y manifest
        end
        if @opt.cmd =~/Y/; op('sitemaps','Sitemap')                  #% -Y sitemap
        end
        if @opt.cmd =~/r/; op('remote_put','scp')                    #% -r copy to remote server
        end
        if @opt.cmd =~/R/; op('remote_put','rsync')                  #% -R copy to remote server
        end
        if @opt.cmd =~/[QuUvVM]/; op('urls','urls')                  #% -Q -u -v -V -M urls
        end
        @msg,@msgs="\tsisu -W [to start ruby web-server on output directory]\n",nil
        @tell.call.print_brown if @opt.cmd =~/[uUvVM]/ unless @opt.files.join.empty?
        if defined? @@env.path.processing and FileTest.directory?(@@env.path.processing) and @@env.path.processing =~/#{@@env.user}$/ #clean temporary processing directory of content as is located in public area
          cd(@@env.path.processing_base_tmp) do
            rm_rf(@@env.user) unless @opt.cmd =~/M/
          end
        end
      elsif @opt.mod.inspect =~/--query/
        require SiSU_lib + '/sst_identify_markup'
        puts SiSU_Markup::Markup_history.new(@opt).query
      elsif @opt.mod.inspect =~/--identify/
        require SiSU_lib + '/sst_identify_markup'
        markup_version=SiSU_Markup::Markup_identify.new(@opt).markup_version?
      elsif  @opt.mod.inspect =~/--about/                            #% help instructions
        if @opt.mod.inspect =~/--about/ and not @opt.what.empty?; SiSU_Help::Help.new(@opt.what,'color_off').help_request 
        else SiSU_Help::Help.new('list','color_off').help_request 
        end
      elsif  @opt.mod.inspect =~/--sitemaps/                         #% sitemaps
        require SiSU_lib + '/sitemaps'
        SiSU_Sitemaps::Source.new(@opt).read
        if @opt.cmd =~/R/
          require SiSU_lib + '/remote_put'
          SiSU_Remote::Put.new(@opt).rsync_sitemaps
        end
      else                                                           #% help instructions
        unless @opt.mod.inspect =~/--convert|--to|--from/
          if @opt.mod.inspect =~/--help/ and not @opt.what.empty?; SiSU_Help::Help.new(@opt.what).help_request 
          else SiSU_Help::Help.new('list').help_request 
          end
        end
      end
      @opt.files.each do |fns|
        if FileTest.file?(fns)
          @opt.fns=fns
          unless @opt.fns =~ /(?:\.(?:[_-]?sst|ssp|sx[sdn]\.xml|termsheet.rb)|sisupod(?:\.zip)?)$/
            if @opt.fns=~/\.kdi$/ and @opt.mod.inspect =~/--(?:convert|from)=kdi/
            elsif @opt.fns=~/\.sx[sdn]\.xml$/ and @opt.mod.inspect =~/--(?:convert|to)=xml2sst/
            else Operations.new(@opt).not_recognised
            end
          end
          if @opt.fns =~/\._sst$/ and @opt.cmd !~/[S_M]/ # rework necessry, revist, the _ flag is a hack, to keep ._sst files
            @msg,@msgs='temporary file removed',nil
            @tell.call.warn unless @opt.cmd =~/V/
            File.unlink(@opt.fns) if File.exists?(@opt.fns) #CONSIDER
          end
        else                          #Operations.new(fns,'html').not_found
        end
      end
    end
  end
  begin                                                              #% select what to do
    require 'jcode'
    $KCODE='UTF8'
    require SiSU_lib + '/options'
    require SiSU_lib + '/sysenv'
    include SiSU_Env
    include SiSU_Screen
    require SiSU_lib + '/param'
    include SiSU_Param
    require SiSU_lib + '/defaults'
    include SiSU_Viz
    require SiSU_lib + '/help'
    include SiSU_Help
    require 'uri'
    home=ENV['HOME']
    argv=$*
    @opt=SiSU_commandline::Options.new(argv)
    Processing.new(@opt).actions
  rescue; STDERR.puts SiSU_Screen::Ansi.new(@opt,$!,$@,nil).rescue #fix
  ensure
    Dir.chdir(@@pwd)
  end
end
__END__
