=begin
 * Name: SiSU information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: generates naive cgi search form for search of sisu database (pgsql sqlite)

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2007.
  All Rights Reserved.

 * Ralph Amissah mailto:ralph@amissah.com
   Ralph Amissah mailto:amissah@gmail.com

=end
module SiSU_CGI_sql
  class SiSU_CGI_common
    def initialize(webserv,cmd,image_src,dir)
      @webserv,@cmd,@image_src,@env=webserv,cmd,image_src,dir
    end
    def about
      <<-'WOK_SQL'
 * Name: SiSU information Structuring Universe
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
      WOK_SQL
    end
    def gpl
      <<-'WOK_SQL'

 Copyright (C) 2007 Ralph Amissah
 Copyright (C) 2005 Ralph Amissah (first release edition)
 Copyright (C) 1997 Ralph Amissah (first edition)

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:

  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2007.
  All Rights Reserved.

 * Ralph Amissah ralph@amissah.com
   Ralph Amissah ralph.amissah@gmail.com
      WOK_SQL
    end
    def header1
      <<-'WOK_SQL'
#Common TOP
      @@limit,@@offset=1000,0
      @base="#@hosturl_db/cgi-bin/#@version.cgi"
      @@canned_search_url=@base
      @color_heading='#DDFFAA'
      @color_match='#ffff48'
      class Form
        def initialize(base,search_field,selected_db,checked_index,checked_text,checked_tip,checked_searched,checked_url,checked_echo,checked_sql,checked_all,checked_none,checked_ignore,search_note,the_can='')
          search_note='' if checked_searched !~/\S/
          the_can='' if checked_url !~/\S/
          search_field='' if checked_echo !~/\S/
          @base,@search_field,@selected_db,@checked_index,@checked_text,@checked_tip,@checked_searched,@checked_url,@checked_echo,@checked_sql,@checked_all,@checked_none,@checked_ignore,@search_note,@the_can=base,search_field,selected_db,checked_index,checked_text,checked_tip,checked_searched,checked_url,checked_echo,checked_sql,checked_all,checked_none,checked_ignore,search_note,the_can
          @tip=if checked_tip =~/\S/
            '<font size="2" color="#666666">text:__; keywords:__; title:__; author:__; subject:__; description:__; publisher:__; contributor:__; date:__; type:__; format:__; identifier:__; source:__; language:__; relation:__; coverage:__; rights:__; comment:__; abstract:__; filename:__;</font>'
          else ''
          end
        end
        def submission_form
            search_form=<<-WOK
      WOK_SQL
    end
    def header_desc
      <<-WOK_SQL
    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml">
    <head>
    <title>
    SiSU search form (sample): SiSU information Structuring Universe
    </title>
    <meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
    <meta name="sourcefile" content="SiSU._sst" />
    <link rel="generator" href="http://www.jus.uio.no/sisu" />
    <link rel="shortcut icon" href="#@image_src/rb7.ico" />
    <link rel="stylesheet" href="../_sisu/css/html.css" type="text/css" />
    </head>
    <body bgcolor="#ffffff" text="#000000" link="#003090" lang="en" xml:lang="en">
    <table summary="band" border="0" cellpadding="3" cellspacing="0">
    <tr><td align="left" bgcolor="#ffffff"><a href="http://www.jus.uio.no/sisu/" target="_top"><img border="0" src="#@image_src/sisu.png" alt="SiSU --&gt;" /></a></td><td>
<!--    <p class="tiny"><a href="http://www.jus.uio.no/sisu/SiSU/">&nbsp;http://www.jus.uio.no/sisu/SiSU/</a></p> -->
      <label for="find"><b>#{@env.sample_search_form_title}</b></label>
    </td></tr>
    </table>
      WOK_SQL
    end
    def header2
      <<-'WOK_SQL'
      <table cellpadding="0">
      <tr><td valign=\"top\">
          <form action="#@base" id="Test Form" method="post">
            <!input type="text" id="find" name="find" value="#@search_field" />
            <!input type="text" id="find" name="find" value="" />
            <font size="2" color="#222222">
            select which database to search
            </font>
            <br />
            <select name="db" size="1">
              #@selected_db
      WOK_SQL
    end
    def buttons1
      <<-'WOK_SQL'
            </select>
            <font size="2" color="#222222">
            <input type="radio" name="view" value="index" #@checked_index> index
            <input type="radio" name="view" value="text" #@checked_text> text / grep
            </font>
      </td></tr></table>
      <table cellpadding="2">
      <tr><td valign=\"top\">
            <textarea id="find" name="find" type="text" rows="4" cols="30" maxlength="256">#@search_field</textarea>
            <br /><input type="submit" value="SiSU search" />
      WOK_SQL
    end
    def buttons2
      <<-'WOK_SQL'
      </td>
      <td valign=\"top\">
        #@tip
        #@search_note
        #@the_can
      </td></tr></table><table><tr><td>
            <font size="2" color="#222222">
            <input type="checkbox" name="echo" #@checked_echo> echo previous search
            <input type="checkbox" name="searched" #@checked_searched> search result stats
            <input type="checkbox" name="url" #@checked_url> url for search
            <input type="checkbox" name="tip" #@checked_tip> available search fields
            <input type="checkbox" name="sql" #@checked_sql> sql statement
      <br />
            checks:
            <input type="radio" name="checks" value="check_ignore" #@checked_ignore> selected
            <input type="radio" name="checks" value="check_all" #@checked_all> all
            <input type="radio" name="checks" value="check_none" #@checked_none> none
            </font>

      </td></tr>
      </table>
        </form>
      WOK
        end
      end
      WOK_SQL
    end
    def search_request
      <<-'WOK_SQL'
      class Search_request                                                       #% search_for
        attr_accessor :text1,:keywords,:title,:author,:subject,:description,:publisher,:contributor,:date,:type,:format,:identifier,:source,:language,:relation,:coverage,:rights,:comment,:abstract,:owner,:date_created,:date_issued,:date_modified,:date_available,:date_valid,:filename
        def initialize(search_field='',q='')
          @search_field,@q=search_field,q
          @text1=@keywords=@title=@author=@subject=@description=@publisher=@contributor=@date=@type=@format=@identifier=@source=@language=@relation=@coverage=@rights=@comment=@abstract=@owner=@date_created=@date_issued=@date_modified=@date_available=@date_valid=@filename=''
          if @search_field=~/\S/
            @text1=text_to_match('text:')
            @keywords=text_to_match('key(?:words?)?:')
            @title=text_to_match('title:')                  # DublinCore 1  - title
            @author=text_to_match('(?:author|creator)s?:')  # DublinCore 2  - creator/author
            @subject=text_to_match('subj(?:ect)?:')         # DublinCore 3  - subject
            @description=text_to_match('description:')      # DublinCore 4  - description
            @publisher=text_to_match('pub(?:lisher)?:')     # DublinCore 5  - publisher
            @contributor=text_to_match('contributor:')      # DublinCore 6  - contributor
            @date=text_to_match('date:')                    # DublinCore 7  - date dd-mm-yy
            @type=text_to_match('type:')                    # DublinCore 8  - type
            @format=text_to_match('format:')                # DublinCore 9  - format
            @identifier=text_to_match('identifier:')        # DublinCore 10 - identifier
            @source=text_to_match('source:')                # DublinCore 11 - source
            @language=text_to_match('language:')            # DublinCore 12 - language
            @relation=text_to_match('relation:')            # DublinCore 13 - relation
            @coverage=text_to_match('coverage:')            # DublinCore 14 - coverage
            @rights=text_to_match('rights:')                # DublinCore 15 - rights
            @comment=text_to_match('comment:')
            @abstract=text_to_match('abs(?:tract)?:')
            @owner=text_to_match('owner:')
            @date_created=text_to_match('date_created:')
            @date_issued=text_to_match('date_issued:')
            @date_modified=text_to_match('date_modified:')
            @date_available=text_to_match('date_available:')
            @date_valid=text_to_match('date_valid:')
            @filename=text_to_match('filename:')
            @text1=text_to_match unless @keywords or @author or @title or @text1 or @comment or @abstract or @rights or @subject or @publisher or @date or @filename
          else
            @text1=q['s1'] if q['s1']=~/\S/
            @keywords=q['key'] if q['key']=~/\S/
            @title=q['ti'] if q['ti']=~/\S/
            @author=q['au'] if q['au']=~/\S/
            @subject=q['sj'] if q['sj']=~/\S/
            @description=q['dsc'] if q['dsc']=~/\S/
            @publisher=q['pb'] if q['pb']=~/\S/
            @contributor=q['cntr'] if q['cntr']=~/\S/
            @date=q['dt'] if q['dt']=~/\S/
            @type=q['ty'] if q['ty']=~/\S/
            @identifier=q['id'] if q['id']=~/\S/
            @source=q['src'] if q['src']=~/\S/
            @language=q['lang'] if q['lang']=~/\S/
            @relation=q['rel'] if q['rel']=~/\S/
            @coverage=q['cov'] if q['cov']=~/\S/
            @rights=q['cr'] if q['cr']=~/\S/
            @comment=q['co'] if q['co']=~/\S/
            @abstract=q['ab'] if q['ab']=~/\S/
            @date_created=q['dtc'] if q['dtc']=~/\S/
            @date_issued=q['dti'] if q['dti']=~/\S/
            @date_modified=q['dtm'] if q['dtm']=~/\S/
            @date_available=q['dta'] if q['dta']=~/\S/
            @date_valid=q['dtv'] if q['dtv']=~/\S/
            @filename=q['fns'] if q['fns']=~/\S/
            @@limit=q['ltd'] if q['ltd']=~/\d+/  # 1000
            @@offset=q['off'] if q['off']=~/\d+/ # 0
          end
        end
        def text_to_match(identifier='')
          m={
            :string => /#{identifier}\s*(.+?)/,
            :string => /#{identifier}\s*(.+?)(?:;|\n|\r|$)/,
            :word => /#{identifier}[\s(]*(\S+)/
          }
          search_string=if @search_field =~m[:word]
            search_string=if @search_field =~m[:braces]; m[:braces].match(@search_field)[1]
            elsif @search_field =~m[:string];            m[:string].match(@search_field)[1]
            else
              str=m[:word].match(@search_field)[1]
              str.gsub!(/[()]/,'')
              str
            end
            search_string.strip!
            search_string.gsub!(/\s+/,'+')
            search_string
          #else
          #  "__"
          end
        end
      end
      WOK_SQL
    end
    def search_statement_common
      <<-'WOK_SQL'
      class Dbi_search_statement
        attr_reader :text_search_flag,:sql_select_body_format,:sql_select_endnotes_format,:sql_offset,:sql_limit
        def initialize(conn,search_for,q)
          @conn=conn
          @text_search_flag=false
          @sql_statement={ :body=>'',:endnotes=>'',:range=>'' }
          #@offset||=@@offset
          #@offset+=@@limit
          search={ :text => [],:endnotes => [] }
          st=Dbi_search_string.new('documents.clean',search_for.text1,q['s1']).string
          se=Dbi_search_string.new('endnotes.clean',search_for.text1,q['s1']).string
          @text_search_flag=st[:flag]
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << se[:search]
          end
          st=Dbi_search_string.new('metadata.keywords',search_for.keywords,q['key']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.title',search_for.title,q['ti']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.creator',search_for.author,q['au']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.subject',search_for.subject,q['sj']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.description',search_for.description,q['dsc']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.publisher',search_for.publisher,q['pb']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.contributor',search_for.contributor,q['cntr']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.date',search_for.date,q['dt']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.type',search_for.type,q['ty']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.identifier',search_for.identifier,q['id']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.source',search_for.source,q['src']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.language',search_for.language,q['lang']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.relation',search_for.relation,q['rel']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.coverage',search_for.coverage,q['cov']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.rights',search_for.rights,q['cr']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.comment',search_for.comment,q['co']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.abstract',search_for.abstract,q['ab']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          st=Dbi_search_string.new('metadata.filename',search_for.filename,q['fns']).string
          if st[:flag]
            search[:text]                    << st[:search]
            search[:endnotes]                << st[:search]
          end
          @@limit=q['ltd'] if q['ltd']=~/\d+/  # 1000
          @@offset=q['off'] if q['off']=~/\d+/ # 0
      WOK_SQL
    end
    def pages
      <<-'WOK_SQL'
        def sql_offset
          @@offset
        end
        def sql_limit
          @@limit
        end
        def sql_canned_search
          @offset_next=sql_offset.to_i + sql_limit.to_i
          @offset_previous=sql_offset.to_i - sql_limit.to_i
          def current
            @@canned_search_url.to_s + '&ltd=' + sql_limit.to_s + '&off=' + sql_offset.to_s
          end
          def next
            @@canned_search_url.to_s + '&ltd=' + sql_limit.to_s + '&off=' + @offset_next.to_s
          end
          def previous
            @offset_previous >= 0 ? (@@canned_search_url.to_s + '&ltd=' + sql_limit.to_s + '&off=' + @offset_previous.to_s) : ''
          end
          def start
            @@canned_search_url.to_s + '&ltd=' + sql_limit.to_s + '&off=' + 0.to_s
          end
          self
        end
        def sql_canned_search_url
          can=sql_canned_search
          page=(sql_offset.to_i + sql_limit.to_i)/sql_limit.to_i
          case page.to_s
          when /^1$/
            %{<hr /><br /><center>
            pg. #{page.to_s}
            <a href="#{can.next}">&nbsp;&nbsp;&gt;</a>
            </center>}
          when /^2$/
            %{<hr /><br /><center>
            <a href="#{can.previous}">&lt;&nbsp;&nbsp;</a>
            pg. #{page.to_s}
            <a href="#{can.next}">&nbsp;&nbsp;&gt;</a>
            </center>}
          else
            %{<hr /><br /><center>
            <a href="#{can.start}">|&lt;&nbsp;&nbsp;</a>
            <a href="#{can.previous}">&lt;&nbsp;&nbsp;</a>
            pg. #{page.to_s}
            <a href="#{can.next}">&nbsp;&nbsp;&gt;</a>
            </center>}
          end
        end
      WOK_SQL
    end
    def tail
      <<-WOK_SQL
      def tail
        <<-'WOK'
    <br /><hr /><br />
    <center><table align="center"bgcolor="#ffffff"><tr><td><font color="#666666"><table summary="" bgcolor="#ffffff" cellpadding="4" border="0" align="center">

    <tr align="center">
      <td align="center"><p class="center"><font color="#666666" size="2">
      presentations' look and feel<br />
      generated by<br />
      <a href="http://www.jus.uio.no/sisu" ><img border="0" src="#@image_src/sisu.png" alt="SiSU in Ruby with the usual GPL (or OSS) suspects - Way Better!" width="120" height="38"></a><br />
      <a href="http://www.jus.uio.no/sisu" >SiSU</a><br />
      version 0.50<br />2007w11/1 (2007-03-12)<br />

      <table summary="SiSU rights" bgcolor="#ffffff" cellpadding="4" border="0" align="center" width="40%">
        <sup>&copy;</sup> Ralph Amissah<br />
      1993, current 2007<br />
      GPL 2<br />
      <i>w3 since October 3 1993</i><br />
      <a href="mailto://ralph@amissah.com" >ralph@amissah.com</a><br />
    </font></p>
    </td></tr></table>

    <p><center><font color="#666666" size="2">the usual GPL (or OSS) suspects:<br />Better - "performance, reliability, scalability, security<br />& total cost of ownership"<br /><i>[not to mention flexibility &amp; choice]</i><br /><br />&lt;&lt;<a href="http://www.jus.uio.no/sisu/">Way Better!</a>&gt;&gt;</font></center></p><tr align="center"><td align="center">

    </font></center></td></tr></table></center> <a name="bottom" id="bottom"></a><a name="down" id="down"></a><a name="end" id="end"></a><a name="finish" id="finish"></a><a name="stop" id="stop"></a><a name="credits" id="credits"></a>
    </body></html>
    WOK
      end
      WOK_SQL
    end
    def main1
      <<-'WOK_SQL'
      @tail=tail
      @counter_txt_doc,@counter_txt_ocn,@counter_endn_doc,@counter_endn_ocn=0,0,0,0
      @counters_txt,@counters_endn,@sql_select_body,@sql_select_endnotes='','','',''
      FCGI.each_cgi do |cgi|
        begin # all code goes in begin section
          @search={ :text => [],:endnotes => [] }
          q=CGI.new
          @db=if cgi['db'] =~/\S+/;
            @stub=/SiSU_(\S+)/.match(cgi['db'])[1]
            cgi['db']
          else
            @stub='sisu'
            'SiSU_sisu'
          end
          checked_url,checked_searched,checked_tip,checked_echo,checked_sql,checked_all,checked_none,checked_ignore,selected_db='','','','','','','',''
          if cgi['view']=~/text/; checked_index,checked_text='','checked'
          else                    checked_index,checked_text='checked',''
          end
          checked_url='checked' if cgi['url'] =~/\S/ or cgi['u'].to_i==1
          checked_searched='checked' if cgi['searched'] =~/\S/
          checked_tip='checked' if cgi['tip'] =~/\S/
          checked_echo='checked' if cgi['echo'] =~/\S/
          checked_sql='checked' if cgi['sql'] =~/\S/
          if cgi['checks'] =~/check_all/ or cgi['check_all'] =~/\S/ or cgi['a'].to_i==1
            checked_all=checked_url=checked_searched=checked_tip=checked_echo=checked_sql='checked'
            checked_none=''
          elsif cgi['checks'] =~/check_none/ #or cgi['a'].to_i==0
            checked_none='checked'
            checked_all=checked_url=checked_searched=checked_tip=checked_echo=checked_sql=''
          else checked_ignore='checked'
          end
      WOK_SQL
    end
    def main2
      <<-'WOK_SQL'
          search_field=cgi['find'] if cgi['find'] # =~/\S+/
          @search_for=Search_request.new(search_field,q) #.analyze               #% search_for
                                                                                 #% searches
          #Canned_search.new(@base,@search_for.text1,cgi)
          if @search_for.text1=~/\S+/ or @search_for.author=~/\S+/ #and search_field =~/\S/
            s1='s1=' + CGI.escape(@search_for.text1) if @search_for.text1=~/\S/
            key='key=' + CGI.escape(@search_for.keywords) if @search_for.keywords=~/\S/
            ti='&ti=' + CGI.escape(@search_for.title) if @search_for.title=~/\S/
            au='&au=' + CGI.escape(@search_for.author) if @search_for.author=~/\S/
            sj='&sj=' + CGI.escape(@search_for.subject) if @search_for.subject=~/\S/
            dsc='&dsc=' + CGI.escape(@search_for.description) if @search_for.description=~/\S/
            pb='&pb=' + CGI.escape(@search_for.publisher) if @search_for.publisher=~/\S/
            cntr='&cntr=' + CGI.escape(@search_for.contributor) if @search_for.contributor=~/\S/
            dt='&dt=' + CGI.escape(@search_for.date) if @search_for.date=~/\S/
            ty='&ty=' + CGI.escape(@search_for.type) if @search_for.type=~/\S/
            id='&id=' + CGI.escape(@search_for.identifier) if @search_for.identifier=~/\S/
            src='&src=' + CGI.escape(@search_for.source) if @search_for.source=~/\S/
            lang='&lang=' + CGI.escape(@search_for.language) if @search_for.language=~/\S/
            rel='&rel=' + CGI.escape(@search_for.relation) if @search_for.relation=~/\S/
            cov='&cov=' + CGI.escape(@search_for.coverage) if @search_for.coverage=~/\S/
            cr='&cr=' + CGI.escape(@search_for.rights) if @search_for.rights=~/\S/
            co='&co=' + CGI.escape(@search_for.comment) if @search_for.comment=~/\S/
            ab='&ab=' + CGI.escape(@search_for.abstract) if @search_for.abstract=~/\S/
            dtc='&dtc=' + CGI.escape(@search_for.date_created) if @search_for.date_created=~/\S/
            dti='&dti=' + CGI.escape(@search_for.date_issued) if @search_for.date_issued=~/\S/
            dtm='&dtm=' + CGI.escape(@search_for.date_modified) if @search_for.date_modified=~/\S/
            dta='&dta=' + CGI.escape(@search_for.date_available) if @search_for.date_available=~/\S/
            dtv='&dtv=' + CGI.escape(@search_for.date_valid) if @search_for.date_valid=~/\S/
            fns='&fns=' + CGI.escape(@search_for.filename) if @search_for.filename=~/\S/
            @@canned_search_url=if checked_all =~/checked/
              "#@base?#{s1}#{key}#{ti}#{au}#{sj}#{dsc}#{pb}#{cntr}#{dt}#{ty}#{id}#{src}#{lang}#{rel}#{cov}#{cr}#{co}#{ab}#{dtc}#{dti}#{dtm}#{dta}#{dtv}#{fns}&db=#{cgi['db']}&view=#{cgi['view']}&a=1"
            else "#@base?#{s1}#{key}#{ti}#{au}#{sj}#{dsc}#{pb}#{cntr}#{dt}#{ty}#{id}#{src}#{lang}#{rel}#{cov}#{cr}#{co}#{ab}#{dtc}#{dti}#{dtm}#{dta}#{dtv}#{fns}&db=#{cgi['db']}&view=#{cgi['view']}&u=1&e=1"
            end
            @search[:text][1]=%{documents.clean~'#{@search_for.text1}'} #s1
            @search[:endnotes][1]=%{endnotes.clean~'#{@search_for.text1}'} #s1
            canned_note='previous search url:'
          else
            @@canned_search_url="#@base?s1=United+Nations&db=documents&view=index"
            canned_note='search url example:'
          end
          if search_field =~/\S+/
            analyze_format=search_field.gsub(/\s*\n/,'; ')
          elsif checked_all =~/checked/ or checked_url =~/checked/
            canned_search=@@canned_search_url.scan(/(?:s1|au|ti|fns)=[^&]+/)
            af=canned_search.join('; ')
            af.gsub!(/s1=/,'text: ')
            af.gsub!(/au=/,'author: ')
            af.gsub!(/ti=/,'title: ')
            af.gsub!(/fns=/,'filename: ')
            af.gsub!(/%2B/,' ')
            analyze_format=af
            st=af.split(/\s*;\s*/)
            search_field=st.join("\n")
          end
          green=%{<font size="2" color="#004000">}
          canned_search_url_txt=CGI.escapeHTML(@@canned_search_url)
          the_can=%{<font size="2" color="#666666">#{canned_note}<br /> <a href="#{@@canned_search_url}">#{canned_search_url_txt}</a></font><br />}
          p_text=p_keywords=p_title=p_author=p_subject=p_description=p_publisher=p_contributor=p_date=p_type=p_format=p_identifier=p_source=p_language=p_relation=p_coverage=p_rights=p_comment=p_abstract=p_subject=p_filename=''
          p_text=%{text: #{green}#{@search_for.text1}</font><br />} if @search_for.text1 =~/\S+/
          p_keywords=%{keywords: #{green}#{@search_for.keywords}</font><br />} if @search_for.keywords =~/\S+/
          p_title=%{title: #{green}#{@search_for.title}</font><br />} if @search_for.title =~/\S+/
          p_author=%{author: #{green}#{@search_for.author}</font><br />} if @search_for.author =~/\S+/
          p_subject=%{subject: #{green}#{@search_for.subject}</font><br />} if @search_for.subject =~/\S+/
          p_description=%{description: #{green}#{@search_for.description}</font><br />} if @search_for.description =~/\S+/
          p_publisher=%{publisher: #{green}#{@search_for.publisher}</font><br />} if @search_for.publisher =~/\S+/
          p_contributor=%{contributor: #{green}#{@search_for.contributor}</font><br />} if @search_for.contributor =~/\S+/
          p_date=%{date: #{green}#{@search_for.date}</font><br />} if @search_for.date =~/\S+/
          p_type=%{type: #{green}#{@search_for.type}</font><br />} if @search_for.type =~/\S+/
          p_format=%{format: #{green}#{@search_for.format}</font><br />} if @search_for.format =~/\S+/
          p_identifier=%{identifier: #{green}#{@search_for.identifier}</font><br />} if @search_for.identifier =~/\S+/
          p_source=%{source: #{green}#{@search_for.source}</font><br />} if @search_for.source =~/\S+/
          p_language=%{language: #{green}#{@search_for.language}</font><br />} if @search_for.language =~/\S+/
          p_relation=%{relation: #{green}#{@search_for.relation}</font><br />} if @search_for.relation =~/\S+/
          p_coverage=%{coverage: #{green}#{@search_for.coverage}</font><br />} if @search_for.coverage =~/\S+/
          p_rights=%{rights: #{green}#{@search_for.rights}</font><br />} if @search_for.rights =~/\S+/
          p_comment=%{comment: #{green}#{@search_for.comment}</font><br />} if @search_for.comment =~/\S+/
          p_abstract=%{abstract: #{green}#{@search_for.abstract}</font><br />} if @search_for.abstract =~/\S+/
          p_filename=%{filename: #{green}#{@search_for.filename}</font><br />} if @search_for.filename =~/\S+/
          search_note=<<-WOK
      <font size="2" color="#666666">
      <br /><b>previous selection</b>:<br />
      database: #{green}#@db</font>; selected view: #{green}#{cgi['view']}</font><br />
      search string: "#{green}#{analyze_format}</font>"<br />
      #{p_text} #{p_keywords} #{p_title} #{p_author} #{p_subject} #{p_description} #{p_publisher} #{p_contributor} #{p_date} #{p_type} #{p_format} #{p_identifier} #{p_source} #{p_language} #{p_relation} #{p_coverage} #{p_rights} #{p_comment} #{p_abstract} #{p_filename}
      </font>
      WOK
          #eg = %{canned search e.g.:<br /> <a href="#{url}">#{url}</a><br />find: #{analyze}<br />database: #{database}}
          #dbi_canning
          @header=Form.new(@base,search_field,selected_db,checked_index,checked_text,checked_tip,checked_searched,checked_url,checked_echo,checked_sql,checked_all,checked_none,checked_ignore,search_note,the_can).submission_form #% form
          unless q['s1'] =~/\S/ or q['au'] =~/\S/ or @search[:text][1] =~/\S/
            print "Content-type: text/html\n\n"
            puts (@header+@tail)
          else #% searches
            s1=if @search_for.text1 =~/\S/
              @search_for.text1
            else 'Unavailable'
            end
            @search[:text]<<%{documents.clean~'#{CGI.unescape(s1)}'}
            @search[:endnotes]<<%{endnotes.clean~'#{CGI.unescape(s1)}'}
          #dbi_request
            dbi_statement=Dbi_search_statement.new(@conn,@search_for,q)
            @text_search_flag=false
            @text_search_flag=dbi_statement.text_search_flag
            s_contents=dbi_statement.contents
            s_endnotes=dbi_statement.endnotes
            @body_main,@endnotes=[],[]
            @search_regx=nil
            oldtid=0
            if @text_search_flag
              if checked_sql =~/\S/
                sql_select_body=dbi_statement.sql_select_body_format
                sql_select_endnotes=dbi_statement.sql_select_endnotes_format
              else sql_select_body,sql_select_endnotes='',''
              end
              @body_main << '<p><hr><br /><b>Main Text:</b><br />' << sql_select_body
              @endnotes  << '<p><hr><br /><b>Endnotes:</b><br />'  << sql_select_endnotes
            else
            end
            #text_objects_body
            s_contents.each do |c|                                               #% text body
              location=c['filename'][/(.+?)\.(?:_?sst|ssm)$/,1]
              file_suffix=c['filename'][/.+?\.(_?sst|ssm)$/,1]
              lang=if location =~ /\S+?~(\S\S\S?)$/
                l=location[/\S+?~(\S\S\S?)$/,1]
                location.gsub!(/(\S+?)~\S\S\S?/,'\1')
                l=".#{l}"
              else ''
              end
            #metadata_found_body
              if c['tid'].to_i != oldtid.to_i
                title=%{<span style="background-color: #@color_heading"><a href="#@hosturl_files/#@stub/#{location}/toc#{lang}.html">#{c['title']}</a></span> by #{c['creator']} <a href="#@hosturl_files/#@stub/#{location}/portrait#{lang}.pdf"><img border="0" width="15" height="18" src="#@image_src/b_pdf.png" alt="pdf portrait"></a><a href="#@hosturl_files/#@stub/#{location}/landscape#{lang}.pdf"><img border="0" width="18" height="15" src="#@image_src/b_pdf.png" alt="pdf landscape"></a> <a href="#@hosturl_files/#@stub/#{location}/sisu_manifest#{lang}.html"><img border="0" width="12" height="12" src="#@image_src/bullet_red.png" alt="manifest"><font size="2">&nbsp;?</font></a><br />}  if file_suffix=~/s/ #hmm watch file_suffix
                 if @text_search_flag; title='<br /><hr>'+title
                 else                  title='<br />'+title
                 end
                 @counter_txt_doc+=1
                 oldtid=c['tid'].to_i
                else                    title=''
                end
                if @text_search_flag
                  if cgi['view']=~/text/                                         #% txt body
                    text=if c['suffix'] !~/1/ #seg
                      if @search_for.text1 =~/\S+/ or q['s1'] =~/\S+/                         #% only this branch is working !!
                        unescaped_search=if @search_for.text1 =~/\S+/; CGI.unescape(@search_for.text1)
                        elsif q['s1'] =~/\S+/;                         CGI.unescape(q['s1'])
                        else nil
                        end
                        @search_regx=if unescaped_search                                     #check
                          search_regex=[]
                          build=unescaped_search.scan(/\S+/).each do |g|
                             if g.to_s =~/(AND|OR)/
                               search_regex << '|'
                             else search_regex << %{#{g.to_s}}
                             end
                          end
                          search_regex=search_regex.join(' ')
                          search_regex=search_regex.gsub(/\s*\|\s*/,'|')
                          search_regex.to_s
                        else nil
                        end
                      else nil
                      end
                      matched_para=if (@search_regx.to_s.class==String && @search_regx.to_s=~/\S\S+/)
                        matched=if c['body'] =~/<a href="https?:\/\//mi; c['body']
                        else (c['body'].gsub(/(#@search_regx)/,%{<span style="background-color: #@color_match">\\1</span>})) 
                        end
                        matched
                      else c['body']
                      end
                      %{<hr><p><font size="2">ocn <b><a href="#@hosturl_files/#@stub/#{location}/#{c['seg']}#{lang}.html##{c['ocn']}">#{c['ocn']}</a></b>:</font></p>#{matched_para}}
                    elsif c['suffix'] =~/1/ #doc
                      %{#{title}<hr><p><font size="2">ocn #{c['ocn']}:#{c['body']}}
                    end
                    @counter_txt_ocn+=1
                    output=if c['seg'] =~/\S+/; title+text
                    else                        text
                    end
                  elsif cgi['view']=~/index/                                     #% idx body
                    if c['suffix'] !~/1/ #seg
                      index=%{<a href="#@hosturl_files/#@stub/#{location}/#{c['seg']}#{lang}.html##{c['ocn']}">#{c['ocn']}</a>, } if @text_search_flag
                    elsif c['suffix'] =~/1/ #doc
                      index=%{<a href="#@hosturl_files/#@stub/#{location}/doc#{lang}.html##{c['ocn']}">#{c['ocn']}</a>, }
                    end
                    if c['seg'] =~/\S+/
                      if @text_search_flag
                        @counter_txt_ocn+=1
                        output=title+index
                      end
                    else
                      @counter_txt_ocn+=1
                      output=unless c['suffix'] =~/1/; title+index
                      else %{#{title}#{c['ocn'].sort}, }
                      end
                    end
                  end
                else output=title
                end
              @counters_txt=if @counter_txt_doc > 0
                %{<font size="2" color="#666666">Found in the main body of #@counter_txt_doc documents, and at #@counter_txt_ocn locations within.</font><br />}
              else ''
              end
              @body_main << output #+ details
            end
            #text_objects_endnote
            oldtid = 0
            s_endnotes.each do |e|                                               #% endnotes
              location=e['filename'][/(.+?)\.(?:_?sst|ssm)$/,1]
              file_suffix=e['filename'][/.+?\.(_?sst|ssm)$/,1]
              lang=if location =~ /\S+?~(\S\S\S?)$/
                l=location[/\S+?~(\S\S\S?)$/,1]
                location.gsub!(/(\S+?)~\S\S\S?/,'\1')
                l=".#{l}"
              else ''
              end
            #metadata_found_endnotes
              if @text_search_flag
                if e['metadata_tid'].to_i != oldtid.to_i
                  title=%{<br /><hr><span style="background-color: #@color_heading"><a href="#@hosturl_files/#@stub/#{location}/toc#{lang}.html">#{e['title']}</a></span> by #{e['creator']} <a href="#@hosturl_files/#@stub/#{location}/portrait.pdf"><img border="0" width="15" height="18" src="#@image_src/b_pdf.png" alt="pdf portrait"></a><a href="#@hosturl_files/#@stub/#{location}/landscape.pdf"><img border="0" width="18" height="15" src="#@image_src/b_pdf.png" alt="pdf landscape"></a> <a href="#@hosturl_files/#@stub/#{location}/sisu_manifest#{lang}.html"><img border="0" width="12" height="12" src="#@image_src/bullet_red.png" alt="manifest"><font size="2">&nbsp;?</font></a><br />}  if file_suffix=~/s/
                  @counter_endn_doc+=1
                  oldtid=e['metadata_tid'].to_i
                else title = ''
                end
                if cgi['view']=~/text/                                           #% txt endnotes
                  @counter_endn_ocn+=1
                  matched_endnote=if (@search_regx.to_s.class==String && @search_regx.to_s=~/\S\S+/)
                    matched=if e['body'] =~/<a href="https?:\/\//mi; e['body']
                    else e['body'].gsub(/(#@search_regx)/,%{<span style="background-color: #@color_match">\\1</span>})
                      #e['body']
                    end
                    matched
                  else e['body']
                  end
                  output=%{#{title}<hr><font size="2">note <b><a href="#@hosturl_files/#@stub/#{location}/endnotes.html##{e['nr']}">#{e['nr']}</a></b> referred to from ocn <a href="#@hosturl_files/#@stub/#{location}/doc.html##{e['ocn']}">#{e['ocn']}</a>:</font> #{matched_endnote}}
                elsif cgi['view']=~/index/                                       #% idx endnotes
                  @counter_endn_ocn+=1
                  output=%{#{title}<a href="#@hosturl_files/#@stub/#{location}/endnotes.html#_#{e['nr']}">#{e['nr']}</a> [&sect; <a href="#@hosturl_files/#@stub/#{location}/doc.html##{e['ocn']}">#{e['ocn']}</a>], }
                end
                @counters_endn=if @counter_endn_doc > 0
                %{<font size="2" color="#666666">Found in the endnotes of #@counter_endn_doc documents, and at #@counter_endn_ocn locations within.</font><br />}
                end
                @endnotes << output #+ details
              else @endnotes=[] #does not take out yet
              end
            end
            offset=dbi_statement.sql_offset.to_s
            limit=dbi_statement.sql_limit.to_s
            canned=dbi_statement.sql_canned_search_url.to_s
            limit=dbi_statement.sql_limit.to_s
            cgi.out{@header + @counters_txt + @counters_endn + @body_main.join + @endnotes.join + canned + @tail} #% print cgi_output_header+counters+body+endnotes
          end
        rescue Exception => e
          s='<pre>' + CGI::escapeHTML(e.backtrace.reverse.join("\n"))
          s << CGI::escapeHTML(e.message) + '</pre>'
          cgi.out{s}
          next
        ensure # eg. disconnect from server
          @conn.disconnect if @conn
        end
      end
      WOK_SQL
    end
  end
end
__END__
#@counter_txt_ocn
#@counter_endn_ocn


  if cgi['checks'] =~/check_all/ or cgi['check_all'] =~/\S/ or cgi['a'].to_i==1
    checked_all=checked_url=checked_searched=checked_tip=checked_echo=checked_sql='checked'
    checked_none=''
  #elsif cgi['checks'] =~/check_fixed/ or cgi['check_fixed'] =~/\S/
  #  #checked_ignore='checked'
  #  checked_fixed='checked'
  #  checked_url='checked'
  #  checked_searched='checked'
  #  checked_echo='checked'
  #  #checked_tip='checked'
  #  #checked_sql='checked'
  #  checked_tip=checked_sql=checked_none=''
  #elsif cgi['checks'] =~/check_ignore/ or cgi['check_ignore'] =~/\S/
  #  checked_ignore='checked'
  #  checked_url='checked' if cgi['url'] =~/\S/ or cgi['u'].to_i==1
  #  checked_searched='checked' if cgi['searched'] =~/\S/
  #  checked_tip='checked' if cgi['tip'] =~/\S/
  #  checked_echo='checked' if cgi['echo'] =~/\S/
  #  checked_sql='checked' if cgi['sql'] =~/\S/
  #  checked_none=''
  elsif cgi['checks'] =~/check_none/ or cgi['a'].to_i==0
    checked_none='checked'
    checked_all=checked_url=checked_searched=checked_tip=checked_echo=checked_sql=''
  else checked_ignore='checked'
  end
