=begin
 * Name: SiSU information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: modules shared by the different db types, dbi, postgresql, sqlite

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:

  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2007.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_DB_index
  class Index                                           # create documents Indexes def initialize(opt,conn='',sql_type='')
    def initialize(opt,conn='',sql_type='')
      @opt,@conn,@sql_type=opt,conn,sql_type
    end
    def create_indexes                                                           # check added from pg not tested
      def base
        print '
          create documents common indexes
        ' unless @opt.cmd =~/q/
        @conn.execute('
          CREATE INDEX object_nr ON documents(ocn);
          CREATE INDEX digest_clean ON documents(digest_clean);
          CREATE INDEX digest_all ON documents(digest_all);
          CREATE INDEX lev1 ON documents(lev1);
          CREATE INDEX lev2 ON documents(lev2);
          CREATE INDEX lev3 ON documents(lev3);
          CREATE INDEX lev4 ON documents(lev4);
          CREATE INDEX lev5 ON documents(lev5);
          CREATE INDEX lev6 ON documents(lev6);
          CREATE INDEX endnote_nr ON endnotes(nr);
          CREATE INDEX digest_en ON endnotes(digest_clean);
          CREATE INDEX endnote_nr_asterisk ON endnotes_asterisk(nr);
          CREATE INDEX endnote_asterisk ON endnotes_asterisk(clean);
          CREATE INDEX digest_en_asterisk ON endnotes_asterisk(digest_clean);
          CREATE INDEX endnote_nr_plus ON endnotes_plus(nr);
          CREATE INDEX endnote_plus ON endnotes_plus(clean);
          CREATE INDEX digest_en_plus ON endnotes_plus(digest_clean);
          CREATE INDEX title ON metadata(title);
          CREATE INDEX filename ON metadata(filename)
        ') unless @opt.cmd =~/q/
      end
      def text
        print '
          create documents text indexes
        ' unless @opt.cmd =~/q/
        @conn.execute('
          CREATE INDEX clean ON documents(clean);
          CREATE INDEX endnote ON endnotes(clean);
        ') unless @opt.cmd =~/q/
      end
      base
      @opt.cmd=~/D/ || @opt.mod=~/psql/ ? '' : text
    end
  end
end
__END__
