=begin
 * Name: SiSU information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: modules shared by the different db types, dbi, postgresql, sqlite

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:

  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2007.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_DB_select
  class Case
    def initialize(opt,conn='',sql_type='pg')
      @opt,@conn,@sql_type=opt,conn,sql_type
      #@sdb=Create.new(@conn)
      @sdb=SiSU_DB::Create.new(@opt,@conn,@sql_type)
      @index=SiSU_DB::Index.new(@opt,@conn,@sql_type)
      @sdb_no=SiSU_DB::Drop.new(@opt,@conn,@sql_type)
      @sdb_import=SiSU_DB::Import.new(@opt,@conn,@sql_type) if @opt.mod.inspect =~/update|import/
      @remove=SiSU_DB::Remove.new(@opt,@conn) if @opt.mod.inspect =~/update|remove/
      @db=SiSU_Env::Info_db.new
    end
    def cases
      @opt.mod.each do |mod|
        case mod
        when /^--createdb$/
          @sdb.output_dir?
          begin
          @sdb.create_db
          rescue; @sdb.output_dir?
          end
        when /^--(?:init(?:ialize)?|create(?:all)?)$/
          @sdb.output_dir?
          #@sdb.create_db
          begin
          @sdb.create_table_metadata
          @sdb.create_table
          @sdb.create_table_endnotes
          @sdb.create_table_endnotes_asterisk
          @sdb.create_table_endnotes_plus
          @sdb.create_table_urls
          @index.create_indexes
          rescue;  SiSU_Errors::Info_error.new($!,$@,'-D').error; @sdb.output_dir?
          end
        when /^--createtable(s)?$/
          @sdb.output_dir?
          begin
          @sdb.create_table_metadata
          @sdb.create_table
          @sdb.create_table_endnotes
          @sdb.create_table_endnotes_asterisk
          @sdb.create_table_endnotes_plus
          @sdb.create_table_urls
          @index.create_indexes
          rescue; @sdb.output_dir?
          end
        when /^--recreate$/
          @sdb.output_dir?
          begin
          @sdb_no.drop_tables
          @sdb.create_table_metadata
          @sdb.create_table
          @sdb.create_table_endnotes
          @sdb.create_table_endnotes_asterisk
          @sdb.create_table_endnotes_plus
          @sdb.create_table_urls
          @index.create_indexes
          rescue; @sdb.output_dir?
          end
        when /^--cr(eate)?lex$/
          @sdb.output_dir?
          begin
          @sdb.create_table
          rescue; @sdb.output_dir?
          end
        when /^--cr(eate)?metadata$/
          @sdb.output_dir?
          begin
          @sdb.create_table_metadata
          rescue; @sdb.output_dir?
          end
        when /^--import$/
          @sdb_import.marshal_load
          tell=case @sql_type
          when /sqlite/; SiSU_Screen::Ansi.new(@opt.cmd,"sqlite #{@db.db_sqlite} database?")
          when /pg/;     SiSU_Screen::Ansi.new(@opt.cmd,"pgaccess or psql #{@db.db_psql} database?")
          else '???'
          end
          tell.puts_grey if @opt.cmd =~/v/
        when /^--remove$/
          @remove.remove
        when /^--update$/
          @remove.remove
          @sdb_import.marshal_load
          tell=SiSU_Screen::Ansi.new(@opt.cmd,"pgaccess or psql #{@db.db_psql} database?")
          tell.puts_grey if @opt.cmd =~/v/
        when /^--index$/
          @index.create_indexes
        when /^droptable(s)?$/
          @sdb_no.drop_tables
        when /^--dropindex(es)?$/
          @sdb_no.drop_indexes
        when /^--(?:dropall|drop)$/
          @sdb_no.drop_tables
          #@sdb_no.drop_indexes
        when /^--(?:db=)?(?:(?:sq)?lite|pg(?:sql)?|my(?:sql)?)$/
        else
          help=SiSU_Help::Help.new
          help.summary
          help.commands
        end
      end
      begin
      @conn.commit if @sql_type =~/sqlite/
      rescue; @sdb.output_dir?
      end
    end
  end
end
__END__
