=begin
 * Name: SiSU information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: document summary processing, available outputs and metadata

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:

  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2007.
  All Rights Reserved.

 * Notes: tidy -ascii index.xml >> index.tidy

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Translate
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  include SiSU_Param
  class Source
    def initialize(md,doc_lang,trans_str='')
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
      @lang_class=case @doc_lang
      when /American/i;                  English.new(md,doc_lang,trans_str)    # tag depreciated, see iso 639-2
      when /English/i;                   English.new(md,doc_lang,trans_str)
      when /French/i;                    French.new(md,doc_lang,trans_str)
      when /German/i;                    German.new(md,doc_lang,trans_str)
      when /Italian/i;                   Italian.new(md,doc_lang,trans_str)
      when /Spanish/i;                   Spanish.new(md,doc_lang,trans_str)
      when /Brazilian(?: Portuguese)?/i; Portuguese.new(md,doc_lang,trans_str) # tag depreciated, see iso 639-2
      when /Portuguese/i;                Portuguese.new(md,doc_lang,trans_str)
      when /Swedish/i;                   Swedish.new(md,doc_lang,trans_str)
      when /Danish/i;                    Danish.new(md,doc_lang,trans_str)
      when /Finnish/i;                   Finnish.new(md,doc_lang,trans_str)
      when /Norwegian/i;                 Norwegian.new(md,doc_lang,trans_str)
      when /Icelandic/i;                 Icelandic.new(md,doc_lang,trans_str)
      when /Dutch/i;                     Dutch.new(md,doc_lang,trans_str)
      when /Estonian/i;                  Estonian.new(md,doc_lang,trans_str)
      when /Hungarian/i;                 Hungarian.new(md,doc_lang,trans_str)
      when /Polish/i;                    Polish.new(md,doc_lang,trans_str)
      when /Romanian/i;                  Romanian.new(md,doc_lang,trans_str)
      when /Russian/i;                   Russian.new(md,doc_lang,trans_str)
      when /Greek/i;                     Greek.new(md,doc_lang,trans_str)
      when /Ukranian/i;                  Ukranian.new(md,doc_lang,trans_str)
      when /Turkish/i;                   Turkish.new(md,doc_lang,trans_str)
      when /Slovenian/i;                 Slovenian.new(md,doc_lang,trans_str)
      when /Croatian/i;                  Croatian.new(md,doc_lang,trans_str)
      when /Slovak(?:ian)?/i;            Slovak.new(md,doc_lang,trans_str)
      when /Czech/i;                     Czech.new(md,doc_lang,trans_str)
      when /Bulgarian/i;                 Bulgarian.new(md,doc_lang,trans_str)
      else                               English.new(md,doc_lang,trans_str)
      end
    end
    def filename
      @lang_class.filename
    end
    def description
      @lang_class.description
    end
    def metadata
      @lang_class.metadata
    end
    def file_size
      @lang_class.file_size
    end
    def sourcefile
      @lang_class.sourcefile
    end
    def sourcefile_digest
      @lang_class.sourcefile_digest
    end
    def dc_title
      @lang_class.dc_title
    end
    def title
      @lang_class.title
    end
    def subtitle
      @lang_class.subtitle
    end
    def creator
      @lang_class.creator
    end
    def contributor
      @lang_class.contributor
    end
    def translator
      @lang_class.translator
    end
    def illustrator
      @lang_class.illustrator
    end
    def publisher
      @lang_class.publisher
    end
    def prepared_by
      @lang_class.prepared_by
    end
    def digitized_by
      @lang_class.digitized_by
    end
    def subject
      @lang_class.subject
    end
    def dc_description
      @lang_class.dc_description
    end
    def abstract
      @lang_class.abstract
    end
    def type
      @lang_class.type
    end
    def rights
      @lang_class.rights
    end
    def digitized_by
      @lang_class.digitized_by
    end
    def date
      @lang_class.date
    end
    def date_created
      @lang_class.date_created
    end
    def date_available
      @lang_class.date_available
    end
    def date_valid
      @lang_class.date_valid
    end
    def date_modified
      @lang_class.date_modified
    end
    def date_issued
      @lang_class.date_issued
    end
    def language
      @lang_class.language
    end
    def language_original
      @lang_class.language_original
    end
    def format
      @lang_class.format
    end
    def identifier
      @lang_class.identifier
    end
    def source
      @lang_class.source
    end
    def relation
      @lang_class.relation
    end
    def coverage
      @lang_class.coverage
    end
    def keywords
      @lang_class.keywords
    end
    def comments
      @lang_class.comments
    end
    def cls_loc
      @lang_class.cls_loc
    end
    def cls_dewey
      @lang_class.cls_dewey
    end
    def cls_gutenberg
      @lang_class.cls_gutenberg
    end
    def cls_isbn
      @lang_class.cls_isbn
    end
    def prefix_a
      @lang_class.prefix_a
    end
    def prefix_b
      @lang_class.prefix_b
    end
    def fns
      @lang_class.fns
    end
    def word_count
      @lang_class.word_count
    end
    def dgst
      @lang_class.dgst
    end
    def sc_number
      @lang_class.sc_number
    end
    def sc_date
      @lang_class.sc_date
    end
    def last_generated
      @lang_class.last_generated
    end
    def sisu_version
      @lang_class.sisu_version
    end
    def ruby_version
      @lang_class.ruby_version
    end
    def suggested_links
      @lang_class.suggested_links
    end
    def language_version_list
      @lang_class.language_version_list
    end
    def language
      @lang_class.language
    end
    def manifest_description_output
      @lang_class.manifest_description_output
    end
    def manifest_description_metadata
      @lang_class.manifest_description_metadata
    end
    def language_list_translated
      @lang_class.language_list
    end
    def language_list
      lang=case @trans_str
      when /American/i;                  'American English'                    # tag depreciated, see iso 639-2
      when /English/i;                   'English'
      when /French/i;                    'français'
      when /German/i;                    'Deutsch'
      when /Italian/i;                   'Italiano'
      when /Spanish/i;                   'español'
      when /Brazilian(?: Portuguese)?/i; 'Brazilian Português'                 # tag depreciated, see iso 639-2
      when /Portuguese/i;                'Português'
      when /Swedish/i;                   'svenska'
      when /Danish/i;                    'dansk'
      when /Finnish/i;                   'suomi'
      when /Norwegian/i;                 'norsk'
      when /Icelandic/i;                 'Icelandic'
      when /Dutch/i;                     'Nederlands'
      when /Estonian/i;                  'Estonian'
      when /Hungarian/i;                 'Hungarian'
      when /Polish/i;                    'polski'
      when /Romanian/i;                  'română'
      when /Russian/i;                   'Русский (Russkij)'
      when /Greek/i;                     'Ελληνικά (Ellinika)'
      when /Ukranian/i;                  'українська (ukrajins\'ka)'
      when /Turkish/i;                   'Türkçe'
      when /Slovenian/i;                 'Slovenian'
      when /Croatian/i;                  'Croatian'
      when /Slovak(?:ian)?/i;            'slovensky'            #slovensky ?
      when /Czech/i;                     'česky'
      when /Bulgarian/i;                 'Български (Bəlgarski)'
      when /Japanese/i;                  '日本語 (Nihongo)'
      when /Korean/i;                    '한국어 (Hangul)'
      #when /Catalan/i;                   'català'
      else                               'English'
      end
      #check on 中文  and عربي
    end
  end
  class English
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
      'filename'
    end
    def description
      'description'
    end
    def metadata
      'metadata'
    end
    def file_size
      'file size'
    end
    def dc_title
      'DC Title'
    end
    def title
      'Title'
    end
    def subtitle
      'Subtitle'
    end
    def creator
      'DC Creator'
    end
    def contributor
      'DC Contributor'
    end
    def translator
      'Translator'
    end
    def illustrator
      'Illustrator'
    end
    def publisher
      'DC Publisher'
    end
    def prepared_by
      'Prepared by'
    end
    def digitized_by
      'Digitized by'
    end
    def subject
      'DC Subject'
    end
    def dc_description
      'DC Description'
    end
    def abstract
      'DC Abstract'
    end
    def type
      'DC Type'
    end
    def rights
      'DC Rights'
    end
    def date
      'DC Date'
    end
    def date_created
      'DC Date created'
    end
    def date_issued
      'DC Date issued'
    end
    def date_available
      'DC Date available'
    end
    def date_modified
      'DC Date modified'
    end
    def date_valid
      'DC Date valid'
    end
    def language
      'DC Language'
    end
    def language_original
      'Original Language'
    end
    def format
      'DC Format'
    end
    def identifier
      'DC Identifier'
    end
    def source
      'DC Source'
    end
    def relation
      'DC Relation'
    end
    def coverage
      'DC Coverage'
    end
    def keywords
      'Keywords'
    end
    def comments
      'Comments'
    end
    def cls_loc
      'Classify Library of Congress'
    end
    def cls_dewey
      'Classify Dewey'
    end
    def cls_gutenberg
      'Classify Project Gutenberg'
    end
    def cls_isbn
      'Classify ISBN'
    end
    def prefix_a
      'Prefix (a)'
    end
    def prefix_b
      'Prefix (b)'
    end
    def sourcefile
      'Sourcefile'
    end
    def word_count
      'Word Count approximate'
    end
    def sourcefile_digest
      'Sourcefile Digest'
    end
    def digest_md5
      'Sourcefile Digest (md5)'
    end
    def digest_sha256
      'Sourcefile Digest (sha256)'
    end
    def sc_number
      'Document (RCS/CVS) number'
    end
    def sc_date
      'Document (RCS/CVS) number'
    end
    def last_generated
      'Document (metaverse) last generated'
    end
    def sisu_version
      'Generated by'
    end
    def ruby_version
      'Ruby version'
    end
    def suggested_links
      'metadata suggested links'
    end
    def language_version_list
      'Document Language Versions, manifests'
    end
    def manifest_description_output
      'SiSU manifest of generated output'
    end
    def manifest_description_metadata
      'SiSU manifest of document metadata'
    end
    def language_list_translated
      lang=case @trans_str
      when /American/i;                  'American English'                    # tag depreciated, see iso 639-2
      when /English/i;                   'English'
      when /French/i;                    'French'
      when /German/i;                    'German'
      when /Italian/i;                   'Italian'
      when /Spanish/i;                   'Spanish'
      when /Brazilian(?: Portuguese)?/i; 'Brazilian Portuguese'                # tag depreciated, see iso 639-2
      when /Portuguese/i;                'Portuguese'
      when /Swedish/i;                   'Swedish'
      when /Danish/i;                    'Danish'
      when /Finnish/i;                   'Finnish'
      when /Norwegian/i;                 'Norwegian'
      when /Icelandic/i;                 'Icelandic'
      when /Dutch/i;                     'Dutch'
      when /Estonian/i;                  'Estonian'
      when /Hungarian/i;                 'Hungarian'
      when /Polish/i;                    'Polish'
      when /Romanian/i;                  'Romanian'
      when /Russian/i;                   'Russian'
      when /Greek/i;                     'Greek'
      when /Ukranian/i;                  'Ukranian'
      when /Turkish/i;                   'Turkish'
      when /Slovenian/i;                 'Slovenian'
      when /Croatian/i;                  'Croatian'
      when /Slovak(?:ian)?/i;            'Slovakian'
      when /Czech/i;                     'Czech'
      when /Bulgarian/i;                 'Bulgarian'
      else @trans_str
      end
    end
  end
  class French
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
      'nom de fichier'
    end
    def description
      'description'
    end
    def metadata
      'metadonnées'
    end
    def file_size
      'taille'
    end
    def dc_title
      'Titre (DC)'
    end
    def title
      'Titre'
    end
    def subtitle
      'Sous titre'
    end
    def creator
      'Auteur (DC)'
    end
    def contributor
      'Contributeur (DC)'
    end
    def translator
      'Traducteur'
    end
    def illustrator
      'Illustrateur'
    end
    def publisher
      'Éditeur (DC)'
    end
    def prepared_by
      'Préparé par'
    end
    def digitized_by
      'Numérisé par'
    end
    def subject
      'Sujet (DC)'
    end
    def dc_description
      'Description (DC)'
    end
    def abstract
      'Résumé (DC)'
    end
    def type
      'Type (DC)'
    end
    def rights
      'Droits relatifs à la ressource (DC)'
    end
    def date
      'Date (DC)'
    end
    def date_created
      'Date de création (DC)'
    end
    def date_issued
      'Date de publication (DC)'
    end
    def date_available
      'Date de mise à disposition (DC)'
    end
    def date_modified
      'Date de modification (DC)'
    end
    def date_valid
      'Date de validité (DC)'
    end
    def language
      'Langue (DC)'
    end
    def language_original
      'Langue originale'
    end
    def format
      'Format (DC)'
    end
    def identifier
      'Identifiant (DC)'
    end
    def source
      'Source (DC)'
    end
    def relation
      'Lien (DC)'
    end
    def coverage
      'Portée du document (DC)'
    end
    def keywords
      'Mots clef'
    end
    def comments
      'Commentaires'
    end
    def cls_loc
      'Classification de la bibliothèque du congres'
    end
    def cls_dewey
      'Classification Dewey'
    end
    def cls_gutenberg
      'Classification du project Gutenberg'
    end
    def cls_isbn
      'Classification ISBN'
    end
    def prefix_a
      'Préfixe (a)'
    end
    def prefix_b
      'Préfixe (b)'
    end
    def sourcefile
      'Fichier source'
    end
    def word_count
      'Nombre approximatif de mots'
    end
    def sourcefile_digest
      'Condensé du fichier source'
    end
    def digest_md5
      'Condensé du fichier source (md5)'
    end
    def digest_sha256
      'Condensé du fichier source (sha256)'
    end
    def sc_number
      'Numéro (RCS/CVS) du document'
    end
    def sc_date
      'Numéro (RCS/CVS) du document'
    end
    def last_generated
      'Dernière production du document (metaverse)'
    end
    def sisu_version
      'Généré par'
    end
    def ruby_version
      'Version de Ruby'
    end
    def suggested_links
      'Liens suggérés'
    end
    def language_version_list
      'Versions des langues du document, manifestes'
    end
    def manifest_description_output
      'Manifeste SiSU du document généré'
    end
    def manifest_description_metadata
      'Manifeste SiSU des métadonnées du document'
    end
    def language_list_translated
      lang=case @trans_str
      when /American/i;                  'Anglais americain'                   # tag depreciated, see iso 639-2
      when /English/i;                   'Anglais'
      when /French/i;                    'Français'
      when /German/i;                    'Allemand'
      when /Italian/i;                   'Italien'
      when /Spanish/i;                   'Espagnol'
      when /Brazilian(?: Portuguese)?/i; 'Portugais brésilien'                 # tag depreciated, see iso 639-2
      when /Portuguese/i;                'Portugais'
      when /Swedish/i;                   'Suédois'
      when /Danish/i;                    'Danois'
      when /Finnish/i;                   'Finnois'
      when /Norwegian/i;                 'Norvégien'
      when /Icelandic/i;                 'Islandais'
      when /Dutch/i;                     'Néerlandais'
      when /Estonian/i;                  'Estonien'
      when /Hungarian/i;                 'Hongrois'
      when /Polish/i;                    'Polonais'
      when /Romanian/i;                  'Roumain'
      when /Russian/i;                   'Russe'
      when /Greek/i;                     'Grec'
      when /Ukranian/i;                  'Ukrainien'
      when /Turkish/i;                   'Turc'
      when /Slovenian/i;                 'Slovène'
      when /Croatian/i;                  'Croate'
      when /Slovak(?:ian)?/i;            'Slovaque'
      when /Czech/i;                     'Tcheque'
      when /Bulgarian/i;                 'Bulgare'
      else @trans_str
      end
    end
  end
  class German
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
      'Dateiname'
    end
    def description
      'Beschreibung'
    end
    def metadata
      'Metadata'
    end
    def file_size
      'Dateigrösse'
    end
    def dc_title
      'DC Titel'
    end
    def title
      'Titel'
    end
    def subtitle
      'Untertitel'
    end
    def creator
      'Autor'
    end
    def contributor
      'DC Mitautor'
    end
    def translator
      'Übersetzung'
    end
    def illustrator
      'Illustrator'
    end
    def publisher
      'Herausgeber'
    end
    def prepared_by
      'gesetzt von'
    end
    def digitized_by
      'digitalisiert von'
    end
    def subject
      'Titel'
    end
    def dc_description
      'Beschreibung'
    end
    def abstract
      'DC Abstract'
    end
    def type
      'Typ'
    end
    def rights
      'Rechte'
    end
    def date
      'Datum'
    end
    def date_created
      'Erstellung'
    end
    def date_issued
      'Herausgabe'
    end
    def date_available
      'Veröffentlichung'
    end
    def date_modified
      'Modifikation'
    end
    def date_valid
      'Gültigkeit'
    end
    def language
      'Sprache'
    end
    def language_original
      'Ursprungssprache'
    end
    def format
      'DC Format'
    end
    def identifier
      'DC Bezeichnung'
    end
    def source
      'DC Quelle'
    end
    def relation
      'DC Beziehung'
    end
    def coverage
      'DC Eingrenzung'
    end
    def keywords
      'Schlüsselwörter'
    end
    def comments
      'Kommentare'
    end
    def cls_loc
      'Klassifikation nach Library of Congress'
    end
    def cls_dewey
      'Klassifikation nach Dewey'
    end
    def cls_gutenberg
      'Klassifikation nach Projekt Gutenberg'
    end
    def cls_isbn
      'Klassifikation nach ISBN'
    end
    def prefix_a
      'Präfix (a)'
    end
    def prefix_b
      'Präfix (b)'
    end
    def sourcefile
      'Quelldatei'
    end
    def word_count
      'Anzahl Wörter'
    end
    def sourcefile_digest
      'Quelldatei Digest'
    end
    def digest_md5
      'Prüfsumme der Quelldatei (MD5)'
    end
    def digest_sha256
      'Prüfsumme der Quelldatei (SHA256)'
    end
    def sc_number
      'Dokumentversion (RCS/CVS)'
    end
    def sc_date
      'Dokumentdatum (RCS/CVS)'
    end
    def last_generated
      'Letzte Erstellung (metaverse)'
    end
    def sisu_version
      'erstellt bei'
    end
    def ruby_version
      'Ruby Version'
    end
    def suggested_links
      'empfohlene Links'
    end
    def language_version_list
      'verfügbare Sprachen'
    end
    def manifest_description_output
      'SiSU Zusammenfassung des Dokumentes'
    end
    def manifest_description_metadata
      'SiSU Zusammenfassung der Metadaten'
    end
    def language_list_translated
      lang=case @trans_str
      when /American/i;                  'Amerikanisch-Englisch'               # tag depreciated, see iso 639-2
      when /English/i;                   'Englisch'
      when /French/i;                    'Französisch'
      when /German/i;                    'Deutsch'
      when /Italian/i;                   'Italienisch'
      when /Spanish/i;                   'Spanisch'
      when /Brazilian(?: Portuguese)?/i; 'Brasilianisch-Portugiesisch'         # tag depreciated, see iso 639-2
      when /Portuguese/i;                'Portugiesisch'
      when /Swedish/i;                   'Schwedisch'
      when /Danish/i;                    'Dänisch'
      when /Finnish/i;                   'Finnisch'
      when /Norwegian/i;                 'Norwegisch'
      when /Icelandic/i;                 'Isländisch'
      when /Dutch/i;                     'Niederländisch'
      when /Estonian/i;                  'Estnisch'
      when /Hungarian/i;                 'Ungarisch'
      when /Polish/i;                    'Polnisch'
      when /Romanian/i;                  'Rumänisch'
      when /Russian/i;                   'Russisch'
      when /Greek/i;                     'Griechisch'
      when /Ukranian/i;                  'Ukrainisch'
      when /Turkish/i;                   'Türkisch'
      when /Slovenian/i;                 'Slovenisch'
      when /Croatian/i;                  'Kroatisch'
      when /Slovak(?:ian)?/i;            'Slovakisch'
      when /Czech/i;                     'Tschechisch'
      when /Bulgarian/i;                 'Bulgarisch'
      else @trans_str
      end
    end
  end
  class Spanish
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
     'nombre del fichero'
   end
   def description
     'descripción'
   end
   def metadata
     'metadatos'
   end
   def file_size
     'tamaño del fichero'
   end
   def dc_title
     'Título DC'
   end
   def title
     'Título'
   end
   def subtitle
     'Subtítulo'
   end
   def creator
     'Creador DC'
   end
   def contributor
     'Contribuidor DC'
   end
   def translator
     'Traductor'
   end
   def illustrator
     'Ilustrador'
   end
   def publisher
     'Editor DC'
   end
   def prepared_by
     'Preparado por'
   end
   def digitized_by
     'Digitalizado por'
   end
   def subject
     'Asunto DC'
   end
   def dc_description
     'Descripción DC'
   end
   def abstract
     'Resumen DC'
   end
   def type
     'Tipo DC'
   end
   def rights
     'Derechos DC'
   end
   def date
     'Fecha DC'
   end
   def date_created
     'Fecha de creación DC'
   end
   def date_issued
     'Fecha de publicación DC'
   end
   def date_available
     'Fecha de disponibilidad DC'
   end
   def date_modified
     'Fecha de modificación DC'
   end
   def date_valid
     'Fecha de valided DC'
   end
   def language
     'Idioma DC'
   end
   def language_original
     'Lenguaje original'
   end
   def format
     'Formato DC'
   end
   def identifier
     'Identificador DC'
   end
   def source
     'Fuente DC'
   end
   def relation
     'Relación DC'
   end
   def coverage
     'Cobertura DC'
   end
   def keywords
     'Palabras claves'
   end
   def comments
     'Comentarios'
   end
   def cls_loc
     'Clasificación Biblioteca del Congreso'
   end
   def cls_dewey
     'Clasificación Dewey'
   end
   def cls_gutenberg
     'Clasificación Proyecto Gutenberg'
   end
   def cls_isbn
     'Clasificación ISBN'
   end
   def prefix_a
     'Prefijo (a)'
   end
   def prefix_b
     'Prefijo (b)'
   end
   def sourcefile
     'Fichero fuente'
   end
   def word_count
     'Número de palabras apróximado'
   end
   def sourcefile_digest
     'Resumen del fichero fuente'
   end
   def digest_md5
     'Resumen del fichero fuente (md5)'
   end
   def digest_sha256
     'Resumen del fichero fuente (sha256)'
   end
   def sc_number
     'Versión (RCS/CVS) del documento'
   end
   def sc_date
     'Versión (RCS/CVS) del documento'
   end
   def last_generated
     'Última generación (metaverse) del documento'
   end
   def sisu_version
     'Generado por'
   end
   def ruby_version
     'Versión de Ruby'
   end
   def suggested_links
     'enlaces sugeridos de metadatos'
   end
   def language_version_list
     'Document Language Versions, manifests'
   end
   def manifest_description_output
     'Manifiesto SiSU de salida generada'
   end
   def manifest_description_metadata
     'Manifiesto SiSU de metadatos de documento'
   end
   def language_list_translated
     lang=case @trans_str
     when /American/i;                  'Inglés Americano'                     # tag depreciated, see iso 639-2
     when /English/i;                   'Inglés'
     when /French/i;                    'Francés'
     when /German/i;                    'Alemán'
     when /Italian/i;                   'Italiano'
     when /Spanish/i;                   'Español'
     when /Brazilian(?: Portuguese)?/i; 'Portugués de Brasil'                  # tag depreciated, see iso 639-2
     when /Portuguese/i;                'Portugués'
     when /Swedish/i;                   'Sueco'
     when /Danish/i;                    'Danés'
     when /Finnish/i;                   'Finés'
     when /Norwegian/i;                 'Noruego'
     when /Icelandic/i;                 'Islandés'
     when /Dutch/i;                     'Holandés'
     when /Estonian/i;                  'Estonio'
     when /Hungarian/i;                 'Húngaro'
     when /Polish/i;                    'Polaco'
     when /Romanian/i;                  'Rumano'
     when /Russian/i;                   'Ruso'
     when /Greek/i;                     'Griego'
     when /Ukranian/i;                  'Ucraniano'
     when /Turkish/i;                   'Turco'
     when /Slovenian/i;                 'Eslovaco'
     when /Croatian/i;                  'Croata'
     when /Slovak(?:ian)?/i;            'Eslovaco'
     when /Czech/i;                     'Checo'
     when /Bulgarian/i;                 'Búlgaro'
     else @trans_str
     end
   end
  end
  class Italian
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
      'nome del file'
    end
    def description
      'descrizione'
    end
    def metadata
      'metadati'
    end
    def file_size
      'dimensione'
    end
    def dc_title
      'Titolo (DC)'
    end
    def title
      'Titolo'
    end
    def subtitle
      'Sottotitolo'
    end
    def creator
      'Autore (DC)'
    end
    def contributor
      'Contributore (DC)'
    end
    def translator
      'Traduttore'
    end
    def illustrator
      'Illustratore'
    end
    def publisher
      'Casa editrice (DC)'
    end
    def prepared_by
      'Preparato da'
    end
    def digitized_by
      'Convertito in digitale da'
    end
    def subject
      'Oggetto (DC)'
    end
    def dc_description
      'Descrizione (DC)'
    end
    def abstract
      'Abstract (DC)'
    end
    def type
      'Tipo (DC)'
    end
    def rights
      'Diritti del lettore (DC)'
    end
    def date
      'Data (DC)'
    end
    def date_created
      'Data di creazione (DC)'
    end
    def date_issued
      'Data di pubblicazione (DC)'
    end
    def date_available
      'Data di effettiva disponibilità (DC)'
    end
    def date_modified
      'Data di ultima modifica (DC)'
    end
    def date_valid
      'Data di inizo validità (DC)'
    end
    def language
      'Lingua (DC)'
    end
    def language_original
      'Lingua originale'
    end
    def format
      'Formato (DC)'
    end
    def identifier
      'Indentificatore (DC)'
    end
    def source
      'Fonte (DC)'
    end
    def relation
      'Collegamento (DC)'
    end
    def coverage
      'Ambito (DC)'
    end
    def keywords
      'Parole chiave'
    end
    def comments
      'Commenti'
    end
    def cls_loc
      'Classificazione della Library of Congress'
    end
    def cls_dewey
      'Classificazione Dewey'
    end
    def cls_gutenberg
      'Classificazione del Progetto Gutenberg'
    end
    def cls_isbn
      'Numero ISBN'
    end
    def prefix_a
      'Premessa (a)'
    end
    def prefix_b
      'Premessa (b)'
    end
    def sourcefile
      'Sorgente'
    end
    def word_count
      'Numero approssimativo di parole'
    end
    def sourcefile_digest
      'Checksum file sorgente'
    end
    def digest_md5
      'Checksum file sorgente (md5)'
    end
    def digest_sha256
      'Checksum file sorgente (sha256)'
    end
    def sc_number
      'Numero di revisione (RCS/CVS)'
    end
    def sc_date
      'Numero di revisione (RCS/CVS)'
    end
    def last_generated
      'Data di ultima generazione (dal metaverse)'
    end
    def sisu_version
      'Generato da'
    end
    def ruby_version
      'Ruby versione'
    end
    def suggested_links
      'Link suggeriti'
    end
    def language_version_list
      'Traduzioni disponibili'
    end
    def manifest_description_output
      'Inventario SiSU dell\'output generato'
    end
    def manifest_description_metadata
      'Inventario SiSU dei metadati'
    end
    def language_list_translated
      lang=case @trans_str
      when /American/i;                  'Inglese USA'                         # tag depreciated, see iso 639-2
      when /English/i;                   'Inglese'
      when /French/i;                    'Francese'
      when /German/i;                    'Tedesco'
      when /Italian/i;                   'Italiano'
      when /Spanish/i;                   'Spagnolo'
      when /Brazilian(?: Portuguese)?/i; 'Portoguese (Brasile)'                # tag depreciated, see iso 639-2
      when /Portuguese/i;                'Portoguese'
      when /Swedish/i;                   'Svedese'
      when /Danish/i;                    'Danese'
      when /Finnish/i;                   'Finlandese'
      when /Norwegian/i;                 'Norvegese'
      when /Icelandic/i;                 'Islandese'
      when /Dutch/i;                     'Olandese'
      when /Estonian/i;                  'Estone'
      when /Hungarian/i;                 'Ungherese'
      when /Polish/i;                    'Polacco'
      when /Romanian/i;                  'Romeno'
      when /Russian/i;                   'Russo'
      when /Greek/i;                     'Greco'
      when /Ukranian/i;                  'Ucraino'
      when /Turkish/i;                   'Turco'
      when /Slovenian/i;                 'Sloveno'
      when /Croatian/i;                  'Croato'
      when /Slovak(?:ian)?/i;            'Slovacco'
      when /Czech/i;                     'Ceco'
      when /Bulgarian/i;                 'Bulgaro'
      else @trans_str
      end
    end
  end
  class Finnish
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
     'tiedostonimi'
    end
    def description
      'kuvaus'
    end
    def metadata
      'metadata'
    end
    def file_size
      'tiedoston koko'
    end
    def dc_title
      'DC-otsikko'
    end
    def title
      'Otsikko'
    end
    def subtitle
      'Alaotsikko'
    end
    def creator
      'DC-tekijä'
    end
    def contributor
      'DC-osallistuja'
    end
    def translator
      'Kääntäjä'
    end
    def illustrator
      'Kuvittaja'
    end
    def publisher
      'DC-julkaisija'
    end
    def prepared_by
      'Valmistaja'
    end
    def digitized_by
      'Digitalisoinut'
    end
    def subject
      'DC-aihe'
    end
    def dc_description
      'DC-kuvaus'
    end
    def abstract
      'DC-tiivistelmä'
    end
    def type
      'DC-tyyppi'
    end
    def rights
      'DC-oikeudet'
    end
    def date
      'DC-päiväys'
    end
    def date_created
      'DC-luontipäivä'
    end
    def date_issued
      'DC-julkaisupäivä'
    end
    def date_available
      'DC-saantipäivä'
    end
    def date_modified
      'DC-muokkauspäivä'
    end
    def date_valid
      'DC-kelpoisuuspäivä'
    end
    def language
      'DC-kieli'
    end
    def language_original
      'Alkuperäiskieli'
    end
    def format
      'DC-muoto'
    end
    def identifier
      'DC-tunnus'
    end
    def source
      'DC-lähde'
    end
    def relation
      'DC-suhde'
    end
    def coverage
      'DC-kattavuus'
    end
    def keywords
      'Avainsanat'
    end
    def comments
      'Kommentit'
    end
    def cls_loc
      'Classify Library of Congress'
    end
    def cls_dewey
      'Classify Dewey'
    end
    def cls_gutenberg
      'Classify Project Gutenberg'
    end
    def cls_isbn
      'Classify ISBN'
    end
    def prefix_a
      'Prefix (a)'
    end
    def prefix_b
      'Prefix (b)'
    end
    def sourcefile
      'Lähdetiedosto'
    end
    def word_count
      'Arvioitu sanamäärä'
    end
    def sourcefile_digest
      'Lähdetiedoston tiiviste'
    end
    def digest_md5
      'Lähdetiedoston tiiviste (md5)'
    end
    def digest_sha256
      'Lähdetiedoston tiiviste (sha256)'
    end
    def sc_number
      'Dokumentin RCS/CVS-numero'
    end
    def sc_date
      'Dokumentin RCS/CVS-päiväys'
    end
    def last_generated
      'Viimeksi tuotettu dokumentti (metaverse)'
    end
    def sisu_version
      'Generoinut'
    end
    def ruby_version
      'Ruby-versio'
    end
    def suggested_links
      'metadatan ehdottamat linkit'
    end
    def language_version_list
      'Dokumentin kieliversiot, manifestit'
    end
    def manifest_description_output
      'Tuotetun tuloksen SISU-manifesti'
    end
    def manifest_description_metadata
      'Dokumenttimetadatan SISU-manifesti'
    end
    def language_list_translated
      lang=case @trans_str
      when /American/i;                  'Amerikanenglanti'                    # tag depreciated, see iso 639-2
      when /English/i;                   'Englanti'
      when /French/i;                    'Ranska'
      when /German/i;                    'Saksa'
      when /Italian/i;                   'Italia'
      when /Spanish/i;                   'Espanja'
      when /Brazilian(?: Portuguese)?/i; 'Brasilian portugali'                 # tag depreciated, see iso 639-2
      when /Portuguese/i;                'Portugali'
      when /Swedish/i;                   'Ruotsi'
      when /Danish/i;                    'Tanska'
      when /Finnish/i;                   'Suomi'
      when /Norwegian/i;                 'Norja'
      when /Icelandic/i;                 'Islanti'
      when /Dutch/i;                     'Hollanti'
      when /Estonian/i;                  'Viro'
      when /Hungarian/i;                 'Unkari'
      when /Polish/i;                    'Puola'
      when /Romanian/i;                  'Romania'
      when /Russian/i;                   'Venäjä'
      when /Greek/i;                     'Kreikka'
      when /Ukranian/i;                  'Ukraina'
      when /Turkish/i;                   'Turkki'
      when /Slovenian/i;                 'Slovenia'
      when /Croatian/i;                  'Kroatia'
      when /Slovak(?:ian)?/i;            'Slovakki'
      when /Czech/i;                     'Tsekki'
      when /Bulgarian/i;                 'Bulgaria'
      else @trans_str
      end
    end
  end
  class Porguguese            < English
  end
  class Swedish               < English
  end
  class Danish                < English
  end
  class Norwegian             < English
  end
  class Icelandic             < English
  end
  class Dutch                 < English
  end
  class Estonian              < English
  end
  class Hungarian             < English
  end
  class Polish                < English
  end
  class Romanian              < English
  end
  class Russian               < English
  end
  class Greek                 < English
  end
  class Ukranian              < English
  end
  class Turkish               < English
  end
  class Croatian              < English
  end
  class Slovakian             < English
  end
  class Czech                 < English
  end
  class Bulgarian             < English
  end
end
__END__
