=begin
 * Name: SiSU information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: sitemap created from parameters extracted from input file(s)

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:

  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2007.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Sitemaps
  require "#{SiSU_lib}/param"
  require "#{SiSU_lib}/sysenv"
  require "#{SiSU_lib}/shared_xml"
  include SiSU_Env
  include SiSU_Param
  include SiSU_XML_munge
  class Source
    require 'fileutils'
    include FileUtils
    def initialize(opt)
      @opt=opt
    end
    def read
      songsheet
    end
    def songsheet
      begin
        @sys=SiSU_Env::System_call.new
        fn_set_lang=SiSU_Env::Standardise_language.new.file_to_language(@opt.fns)
        @fn=SiSU_Env::Env_call.new(@opt.fns).lang(fn_set_lang[:c])
        if @opt.cmd =~/Y/
          @md=SiSU_Param::Parameters.new(@opt).get
          @trans=SiSU_XML_munge::Trans.new(@md) #check @md is required
          @env=SiSU_Env::Info_env.new(@md.fns)
          @rdf=SiSU_XML_tags::RDF.new(@md)
          @fnb_utf8_xml=@md.fnb.dup
          @trans.char_enc.utf8(@fnb_utf8_xml) if @sys.locale =~/utf-?8/i #% utf8
          output_map(sitemap)
        elsif @opt.mod.inspect =~/--sitemaps/
          @sitemap_idx_fn='sitemapindex.xml'
          @env=SiSU_Env::Info_env.new
          output_idx(sitemap_index)
          tell=SiSU_Screen::Ansi.new(@opt.cmd,"sitemap index:","#{@env.path.output}/#@sitemap_idx_fn")
          tell.result unless @opt.cmd =~/q/
        end
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    def make_file(path,filename)
      if File.writable?("#{path}/."); File.new("#{path}/#{filename}",'w+')
      else
        SiSU_Screen::Ansi.new('',"is the file or directory writable?, could not create #{filename}").warn
      end
    end
    def make_path(path)
      File.mkpath(path) unless FileTest.directory?(path)
    end
    def output_map(sitemap)
      path="#{@env.path.output}/#{@md.fnb}"
      filename=@fn[:sitemap]
      touch_path=@env.path.sitemaps
      touch_filename=@fn[:sitemap_touch]
      SiSU_Env::SiSU_file.new(@md).make_path(path)
      file=SiSU_Env::SiSU_file.new(@md).make_file(path,filename)
      file << sitemap
      if FileTest.file?("#{touch_path}/#{touch_filename}")
        rm("#{touch_path}/#{touch_filename}")
      end
      SiSU_Env::SiSU_file.new(@md).touch_file(touch_path,touch_filename)
    end
    def output_idx(sitemap)
      path=@env.path.output
      filename=@sitemap_idx_fn
      make_path(path)
      file=make_file(path,filename)
      file << sitemap
      #cp("#{path}/#{filename}","#{@env.path.output}/#{filename}")
    end
    def sitemap_index
      sitemap_files=Dir.glob("#{@env.path.sitemaps}/sitemap_*.xml")
      sitemap_idx=[]
      sitemap_idx <<<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<sitemapindex xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
   xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemaps/0.9
   http://www.sitemaps.org/schemas/sitemaps/sitemap.xsd"
     xmlns="http://www.sitemaps.org/schemas/sitemapindex/0.9">
WOK
      sitemap_files.each do |s|
        f=s.gsub(/.+?\/sitemap_([^\/]+?)\.xml$/,'\1')
        @trans.char_enc.utf8(f) if @sys.locale =~/utf-?8/i #% utf8
sitemap_idx <<<<WOK
  <sitemap>
    <loc>#{@env.path.url.remote}/#{f}/sitemap.xml</loc>
  </sitemap>
WOK
#<lastmod>1993-10-03T16:00:16+00:00</lastmod>
      end
      sitemap_idx <<<<WOK
</sitemapindex>
WOK
      idx=sitemap_idx.join
    end
    def sitemap
      map=if @md.dc_date_modified and @md.dc_date_modified=~/\d{4}-\d{2}-\d{2}/
        sitemap_date_modified
      else sitemap_no_date
      end
    end
    def sitemap_date_modified
<<WOK
<?xml version='1.0' encoding='UTF-8'?>
<urlset xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemaps/0.9
  http://www.sitemaps.org/schemas/sitemaps/sitemap.xsd"
  xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
#{@rdf.comment_xml}
  <url>
    <loc>#{@env.path.url.remote}/#@fnb_utf8_xml/#{@fn[:toc]}</loc>
    <lastmod>#{@md.dc_date_modified}</lastmod>
    <changefreq>monthly</changefreq>
    <priority>0.7</priority>
  </url>
  <url>
    <loc>#{@env.path.url.remote}/#@fnb_utf8_xml/#{@fn[:doc]}</loc>
    <lastmod>#{@md.dc_date_modified}</lastmod>
    <priority>0.5</priority>
  </url>
  <url>
    <loc>#{@env.path.url.remote}/#@fnb_utf8_xml/#{@fn[:manifest]}</loc>
    <lastmod>#{@md.dc_date_modified}</lastmod>
    <priority>0.5</priority>
  </url>
</urlset>
WOK
    end
    def sitemap_no_date
<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
#{@rdf.comment_xml}
  <url>
    <loc>#{@env.path.url.remote}/#@fnb_utf8_xml/#{@fn[:toc]}</loc>
    <changefreq>monthly</changefreq>
    <priority>0.7</priority>
  </url>
  <url>
    <loc>#{@env.path.url.remote}/#@fnb_utf8_xml/#{@fn[:doc]}</loc>
    <priority>0.5</priority>
  </url>
  <url>
    <loc>#{@env.path.url.remote}/#@fnb_utf8_xml/#{@fn[:manifest]}</loc>
    <priority>0.5</priority>
  </url>
</urlset>
WOK
    end
  end
end
__END__
* sanitize xml, pass through filter to ensure is valid - done but needs testing
* remote placement of sitemaps --sitemaps -R (probably makes more sense than doing against -Y [filename/wildcard]) - done but needs testing
* gzip sitemaps - not before testing / after testing
* issue with master documnts, naming and mapping, check multilingual

<!-- Document processing information:
     * Generated by: SiSU 0.48.6 of 2006w45/6 (20061111)
     * Ruby version: ruby 1.8.5 (2006-08-25) [i486-linux]
     *
     * Last Generated on: Sat Nov 18 15:28:08 +0000 2006
     * SiSU http://www.jus.uio.no/sisu
-->

