=begin
 * Name: SiSU information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: simple xml representation (sax style)

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:

  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2007.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com

 * Notes: tidy -xml sax.xml >> index.tidy
=end
module SiSU_simple_xml_model_sax
  require "#{SiSU_lib}/defaults"
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  require "#{SiSU_lib}/dal_doc_str"
  require "#{SiSU_lib}/shared_xml"
  require "#{SiSU_lib}/xml_format"
  include SiSU_XML_format
  include SiSU_XML_munge
  require "#{SiSU_lib}/rexml"
  include SiSU_Rexml
  @@alt_id_count,@@tablehead,@@number_of_cols=0,0,0
  @@tablefoot=''
  class Convert
    @@fns=nil
    def initialize(opt)
      @opt=opt
    end
    def read
      begin
        @md=SiSU_Param::Parameters.new(@opt).get #bug, relies on info persistence, assumes -m has previously been run
        @env=SiSU_Env::Info_env.new(@opt.fns)
        path=@env.path.output_tell
        loc=@env.url.output_tell
        tool=if @opt.cmd =~/[MV]/; "#{Dir.pwd}/#{@md.fn[:sxs]}\n\t#{@env.program.xml_viewer} #{path}/#{@md.fnb}/#{@md.fn[:sxs]}"
        elsif @opt.cmd =~/v/; "#{@env.program.web_browser} #{Dir.pwd}/#{@md.fn[:sxs]}"
        else ''
        end
        SiSU_Screen::Ansi.new(@opt.cmd,'invert','XML SAX',"#{@md.fns} -> #{@md.fn[:sxs]}").colorize unless @opt.cmd =~/q/
        SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{Dir.pwd}/#{@md.fn[:sxs]}").flow if @opt.cmd =~/[MV]/
        unless @@fns==@opt.fns
          @@fns=@opt.fns
          @@dal_array=[]
        end
        @dal_array=if @@dal_array.empty?; read_fnm
        else @@dal_array.dup #check
        end
        SiSU_simple_xml_model_sax::Convert::Songsheet.new(@dal_array,@md,@env).songsheet
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure #file closed in songsheet
      end
    end
    def read_fnm
      dal=[]
      if FileTest.file?("#{Dir.pwd}/#{@opt.fns}")
        dal=IO.readlines("#{Dir.pwd}/#{@opt.fns}","\n\n")
      else  puts 'Error'
      end
    end
    private
    class Songsheet
      def initialize(data,md,dir)
        @data,@md,@env=data,md,dir
      end
      def songsheet
        begin
          SiSU_simple_xml_model_sax::Convert::Scroll.new(@data,@md).songsheet
          SiSU_simple_xml_model_sax::Convert::Tidy.new(@md,@env).xml if @md.cmd =~/[vVM]/ # test wellformedness, comment out when not in use
          SiSU_Rexml::Rexml.new(@md,@md.fn[:sxs]).xml if @md.cmd =~/M/ # test rexml parsing, comment out when not in use #debug
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
        ensure
        end
      end
    end
    class Scroll
      require "#{SiSU_lib}/shared_txt"
      require "#{SiSU_lib}/css"
      include SiSU_text_utils
      @@xml={ :body=>[],:open=>[],:close=>[],:head=>[] }
      def initialize(data='',md=nil)
        @data,@md=data,md
        @vz=SiSU_Env::Get_init.instance.skin
        @regx=/^(?:(?:<:p[bn]>\s*)?(?::?[A-C]~|\d~)(?:(\S+))?\s+)?(.+)/
        @tab="\t"
        if @md
          @env=SiSU_Env::Info_env.new(@md.fns)
          @trans=SiSU_XML_munge::Trans.new(@md)
        end
        @sys=SiSU_Env::System_call.new
      end
      def songsheet
        pre
        markup
        post
        publish
      end
    protected
      def embedded_endnotes(para='')
        para.gsub!(/~\{(.+?)\}~/,'<endnote symbol="norm">\1</endnote> ')
        para.gsub!(/~\[([*+])\s+(.+?)\]~/,'<endnote symbol="\1">\2</endnote> ')
      end
      def xml_head(meta)
        txt=meta.text
        txt.gsub!(/\/{(.+?)}\//,'<i>\1</i>')
        txt.gsub!(/[*!]{(.+?)}[*!]/,'<b>\1</b>')
        txt.gsub!(/_{(.+?)}_/,'<u>\1</u>')
        txt.gsub!(/-{(.+?)}-/,'<del>\1</del>')
        txt.gsub!(/<br(?: \/)?>/,'<br />')
        txt.gsub!(/ & /,' and ')
        @@xml[:head] <<<<WOK
#{@tab}<header class="#{meta.attrib}">
#{@tab*2}<#{meta.el}>
#{@tab*3}#{txt}
#{@tab*2}</#{meta.el}>
#{@tab}</header>
WOK
      end
      def xml_sc(md='')
        sc=if @md.sc_info
          <<WOK
    <source_control>
      <sc class="sourcefile">
        #{@md.sc_filename}
      </sc>
      <sc class="number">
        #{@md.sc_number}
      </sc>
      <sc class="date">
        #{@md.sc_date}
      </sc>
    </source_control>
WOK
        else ''
        end
        @@xml[:sc]=sc
      end
      def xml_structure(para='',lv='',hname='') #extracted endnotes
        lv=lv.to_i
        n=lv - 1
        n3=lv + 2
        lv=nil if lv == 0
        embedded_endnotes(para)
        if para[@regx]
          paragraph="#{para[@regx,2]}"
          util=SiSU_text_utils::Wrap.new(paragraph,70)
          wrapped=util.line_wrap
        end
        @@xml[:body] << "#{@tab*0}<object>" if para[@regx]
        #@@xml[:body] << "#{@tab*1}<heading>#{lv}</heading>" << "\n" if lv
        @@xml[:body] << "#{@tab*1}" << "\n" if para[@regx]
        @@xml[:body] << if lv; %{#{@tab*1}<text class="h#{lv}">\n#{@tab*2}#{wrapped}\n#{@tab*1}</text>\n} << "\n"
        elsif wrapped =~/\A%%?\s+/; %{<!--\n#{@tab*1}<text class="comment">\n#{@tab*2}#{wrapped}\n#{@tab*1}</text>\n-->\n} # comments
        else                   %{#{@tab*1}<text class="norm">\n#{@tab*2}#{wrapped}\n#{@tab*1}</text>\n} # main text, contents, body KEEP
        end
        #@@xml[:body] << "#{@tab*1}<text>\n#{@tab*2}#{wrapped}\n#{@tab*1}</text>\n" # main text, contents, body KEEP
        @@xml[:body] << "#{@endnotes}" if @endnotes # main text, endnotes KEEP
        ##@@xml[:body] << "#{@tab*1}<text>#{para[@regx,2]}</text>\n" if para[@regx,2] # old unwrapped main text, contents, body KEEP
        @@xml[:body] << "#{@tab*0}</object>" << "\n" if para[@regx]
        @endnotes=[]
      end
      def group_structure(para='')
        para.gsub!(/<:group(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*0}<object>}
        @@xml[:body] << %{#{@tab*1}<text class="group">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*2}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*1}</text>\n}
        @@xml[:body] << "#{@tab*0}</object>"
      end
      def poem_structure(para='')
        para.gsub!(/<:verse(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*0}<object>}
        @@xml[:body] << %{#{@tab*1}<text class="verse">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*2}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*1}</text>\n}
        @@xml[:body] << "#{@tab*0}</object>" << "\n"
      end
      def code_structure(para='')
        para.gsub!(/<:code(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*0}<object>}
        @@xml[:body] << %{#{@tab*1}<text class="code">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*2}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*1}</text>\n}
        @@xml[:body] << "#{@tab*0}</object>" << "\n"
      end
      def table_structure(table='') #tables
        @@xml[:body] << %{#{@tab*0}<object>}
        @@xml[:body] << %{#{@tab*1}#{table}\n#{@tab*1}\n} # unless lv  # main text, contents, body KEEP
        @@xml[:body] << "#{@tab*0}</object>" << "\n" #if para[@regx]
        @endnotes=[]
      end
      def tidywords(wordlist)
        wordlist.each do |x|
          x.gsub!(/&/,'&amp;') unless x =~/&\S+;/
        end
      end
      def markup
        data=[]
        #@data=@data.join.split("\n\n")
        dir=SiSU_Env::Info_env.new(@md.fns)
        xml_sc(@md)
        @endnotes,@level,@cont,@copen,@xml_contents_close=[],[],[],[],[]
        @rcdc=false
        (0..6).each { |x| @cont[x]=@level[x]=false }
        (4..6).each { |x| @xml_contents_close[x]='' }
        @data.each do |para|
          data << SiSU_document_structure::Structure.new(@md,para).structure
        end
        data.each do |para|
          para=@trans.markup_light(para)
          @trans.char_enc.utf8(para) if @sys.locale =~/utf-?8/i #% utf8
          if para =~/\A(?:@|0~)(\S+?):?\s+(.+?)\Z/m # for headers
            d_meta=SiSU_text_utils::Header_scan.new(@md,para).meta
            if d_meta; xml_head(d_meta)
	          end
          end
          @rcdc=true if @rcdc==false and (para =~/~metadata/ or para =~/^1~\s+Document Information/)
          if para !~/(^0~|^@\S+?:|^\s*$|<ENDNOTES>|<EOF>)/
            @sto=SiSU_text_parts::Split_text_object.new(@md,para).lev_segname_para
            unless @rcdc
              format_scroll=SiSU_XML_format::Format_scroll.new(@md,@sto.text) if @sto.format =~/i[12]|null/
              case @sto.format
              when /^(1)~(\S+)?/
                xml_structure(para,$1,$2)
                para=@sto.lev_para_ocn.heading_body1
              when /^(2)~(\S+)?/
                xml_structure(para,$1,$2)
                para=@sto.lev_para_ocn.heading_body2
              when /^(3)~(\S+)?/
                xml_structure(para,$1,$2)
                para=@sto.lev_para_ocn.heading_body3
              when /^(4)~(\S+)?/ # work on see Split_text_object
                xml_structure(para,$1,$2)
                para=@sto.lev_para_ocn.heading_body4
              when /^(5)~(\S+)?/
                xml_structure(para,$1,$2)
                para=@sto.lev_para_ocn.heading_body5
              when /^(6)~(\S+)?/
                xml_structure(para,$1,$2)
                para=@sto.lev_para_ocn.heading_body6
              #when /^(i1)$/i
              #  #format_scroll.gsubBody
              #  #para=@sto[:lev_para_ocn].scrIndent1
              #when /^(i2)$/i
              #  format_scroll.gsubBody
              #  para=@sto[:lev_para_ocn].scrIndent2
              #when /^(center)$/i
              #  para.gsub!(/(.+)/,
              #    %{<center>(\\1)</center>})
              #  para=@sto[:lev_para_ocn].scrPara
              #when /^(b|bold)$/i
              #  para.gsub!(/(.+)/,
              #    %{<b>(\\1)</b>})
              #  para=@sto[:lev_para_ocn].scrPara
              #when /null/ # see whether u can improve
              #    if (para !~/#{@vz.margin_txt_0}|#{@vz.margin_txt_1}|#{@vz.margin_txt_2}/)
              #      #format_scroll.gsubBody
              #      #para=@sto[:lev_para_ocn].scrPara
              #    end
              else
                if para =~ /<:verse>/
                  poem_structure(para)
                elsif para =~ /<:group>/
                  group_structure(para)
                elsif para =~ /<:code>/
                  para.gsub!(/</,'&lt;')
                  para.gsub!(/>/,'&gt;')
                  code_structure(para)
                elsif para =~/<!Th?.+/ # tables come as single block #work area 2005w13
                  table=SiSU_Tables::Table_xml.new(para)
                  para=table.table_split
                  table_structure(para)
                else xml_structure(para,nil,nil)
                end
              end
              para='' if para =~/<a name="n\d+">/ and para =~/^(-\{{2}~\d+|<!e[:_]\d+!>)/ # -endnote
              if para =~/.*<:#>.*$/
                para=case para
                when /<:i1>/
                  format_text=Format_text_object.new(para,'')
                  format_text.scr_inden_ocn_e_no_paranum
                when /<:i2>/
                  format_text=Format_text_object.new(para,'')
                  format_text.scr_inden_ocn_e_no_paranum
                end
              end
              if para !~/#{@vz.margin_txt_0}|#{@vz.margin_txt_1}|#{@vz.margin_txt_2}/
                # i don't get the condition for no paranum
              end
              if para =~/<:center>/
                one,two=/(.*)<:center>(.*)/.match(para)[1,2]
                format_text=Format_text_object.new(one,two)
                para=format_text.center
              end
            end
            para.gsub!(/<:\S+?>/,'')
            para.gsub!(/<!.+!>/,'') ## Clean Prepared Text #bugwatch reinstate
          end
        end
        6.downto(4) do |x|
          y=x - 1; v=x - 3
          @@xml[:body] << "#{@tab*5}</content>\n#{@tab*y}</contents#{v}>\n" if @level[x] == true
        end
        3.downto(1) do |x|
          y=x - 1
          @@xml[:body] << "#{@tab*y}</heading#{x}>\n" if @level[x] == true
        end
        #6.downto(1) { |x| y=x - 1; @@xml[:body] << "#{@tab*y}</level #{x}>\n" if @level[x] == true }
      end
      def pre
        rdf=SiSU_XML_tags::RDF.new(@md)
        dir=SiSU_Env::Info_env.new
        @@xml[:head],@@xml[:body]=[],[]
        css=SiSU_Env::CSS_select.new(@md).xml_sax
        encoding=if @sys.locale =~/utf-?8/i; '<?xml version="1.0" encoding="UTF-8" standalone="no"?>'
        else                                 '<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>'
        end
        @@xml[:open] =<<WOK
#{encoding}
<?xml-stylesheet type="text/css" href="../#{dir.path.style}/#{css}"?>
#{rdf.comment_xml_sax}
<document>
WOK
        @@xml[:head] << "<head>\n"
        @@xml[:body] << "<body>\n"
      end
      def post
        @@xml[:head] << @@xml[:sc]
        @@xml[:head] << "</head>\n"
        @@xml[:body] << "</body>\n"
        @@xml[:close] = "</document>\n"
      end
      def publish
        content=[]
        data=@data
        content << @@xml[:open] << @@xml[:head] << @@xml[:body] << @@xml[:metadata]
        content << @@xml[:owner_details] if @md.stmp =~/\w\w/
        content << @@xml[:tail] << @@xml[:close]
        Output.new(content.to_s,@md).xml
        @@xml={}
      end
    end
    class Output
      include SiSU_Param
      include SiSU_Env
      def initialize(data,md)
        @data,@md=data,md
      end
      def xml
        @sisu=[]
        @data.each do |para|
          para.gsub!(/<:\S+?>/,'')
          para.gsub!(/<!.+?!>/,'')
          para="#{para}\n" unless para.empty?
          @sisu << para
        end
        new_file_data=@sisu.to_s
        @sisu=new_file_data.scan(/.+/)
        SiSU_Env::SiSU_file.new(@md).mkdir
        filename_sxm=SiSU_Env::SiSU_file.new(@md,@md.fn[:sxs]).mkfile_pwd
        if filename_sxm.class == File
          @sisu.each {|para| filename_sxm.puts para}
          filename_sxm.close
        else puts 'file not created, is directory writable?'
        end
      end
    end
    class Tidy
      def initialize(md,dir)
        @md,@env=md,dir
        @prog=SiSU_Env::Info_program.new
      end
      def xml
        if @prog.tidy !=false #note values can be other than true
          if @md.cmd =~/[VM]/
            tell=SiSU_Screen::Ansi.new(@md.cmd,'invert','Using XML Tidy','check document structure')
            tell.colorize unless @md.cmd =~/q/
            tell.grey_open unless @md.cmd =~/q/
            tidyfile='/dev/null' #don't want one or screen output, check for alternative flags
            tidy =SiSU_Env::System_call.new("#{Dir.pwd}/#{@md.fn[:sxs]}",tidyfile)
            tidy.well_formed?
            tell.p_off unless @md.cmd =~/q/
          end
        end
      end
    end
  end
end
__END__
