=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>
   <http://www.jus.uio.no/sisu/gpl.fsf>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
    sqlite

=end
module SiSU_DB_drop
  class Drop
    def initialize(opt,conn='',sql_type='')
      @opt,@conn,@sql_type=opt,conn,sql_type
    end
    def drop
      def tables                                                              #% drop all tables
        begin
          case @sql_type
          when /sqlite/
            cascade=''
            commit=@conn.commit
          else
            cascade='CASCADE'
            commit=''
          end
          @conn.do(%{
            DROP TABLE metadata #{cascade};
            DROP TABLE documents #{cascade};
            DROP TABLE urls #{cascade};
            DROP TABLE endnotes #{cascade};
            DROP TABLE endnotes_asterisk #{cascade};
            DROP TABLE endnotes_plus #{cascade};
          })
          commit
        rescue
          @conn.do(%{
            DROP TABLE endnotes;
            DROP TABLE endnotes_asterisk;
            DROP TABLE endnotes_plus;
            DROP TABLE urls #{cascade};
            DROP TABLE documents #{cascade};
            DROP TABLE metadata #{cascade};
          })
        ensure
          commit
        end
      end
      def indexes                                                             #% drop all indexes
        #@conn.do(%{
        #  DROP INDEX object_nr ON documents(ocn);
        #  DROP INDEX body ON documents(body);
        #  DROP INDEX clean ON documents(clean);
        #  DROP INDEX lev1 ON documents(lev1);
        #  DROP INDEX lev2 ON documents(lev2);
        #  DROP INDEX lev3 ON documents(lev3);
        #  DROP INDEX lev4 ON documents(lev4);
        #  DROP INDEX lev5 ON documents(lev5);
        #  DROP INDEX lev6 ON documents(lev6);
        #  DROP INDEX endnote_nr ON endnotes(nr);
        #  DROP INDEX endnote ON endnotes(body);
        #  DROP INDEX title ON metadata(title);
        #  DROP INDEX filename ON metadata(filename)
        #  /*
        #  DROP INDEX object_nr ON documents(ocn) CASCADE;
        #  DROP INDEX body ON documents(body) CASCADE;
        #  DROP INDEX clean ON documents(clean) CASCADE;
        #  DROP INDEX lev1 ON documents(lev1) CASCADE;
        #  DROP INDEX lev2 ON documents(lev2) CASCADE;
        #  DROP INDEX lev3 ON documents(lev3) CASCADE;
        #  DROP INDEX lev4 ON documents(lev4) CASCADE;
        #  DROP INDEX lev5 ON documents(lev5) CASCADE;
        #  DROP INDEX lev6 ON documents(lev6) CASCADE;
        #  DROP INDEX endnote_nr ON endnotes(nr) CASCADE;
        #  DROP INDEX endnote ON endnotes(body) CASCADE;
        #  DROP INDEX title ON metadata(title) CASCADE;
        #  DROP INDEX filename ON metadata(filename) CASCADE
        #  */
        #})
      end
      self
    end
  end
end
__END__
