# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
    sqlite

=end
module SiSU_DB_drop
  class Drop
    require "#{SiSU_lib}/response"
    def initialize(opt,conn,db_info,sql_type='')
      @opt,@conn,@db_info,@sql_type=opt,conn,db_info,sql_type
      @ans=SiSU_Response::Response.new
      case @sql_type
      when /sqlite/
        cascade=''
      else
        cascade='CASCADE'
      end
      @drop_table=[
        "DROP TABLE metadata #{cascade};",
        "DROP TABLE documents #{cascade};",
        "DROP TABLE urls #{cascade};",
        "DROP TABLE endnotes #{cascade};",
        "DROP TABLE endnotes_asterisk #{cascade};",
        "DROP TABLE endnotes_plus #{cascade};",
      ]
    end
    def drop
      def tables                                                              #% drop all tables
        begin
          msg_sqlite="as not all disk space is recovered after dropping the database << #{@db_info.sqlite.db} >>, you may be better off deleting the file, and recreating it as necessary"
          case @sql_type
          when /sqlite/
            @conn.transaction
            @drop_table.each do |d|
              @conn.execute(d)
            end
            @conn.commit
            puts msg_sqlite
            ans=@ans.response?('remove sql database?')
            if ans and File.exist?(@db_info.sqlite.db)
              File.unlink(@db_info.sqlite.db)
            end
          else
            @conn.do(@drop_table.join(''))
          end
        rescue
          case @sql_type
          when /sqlite/
            #system("rm -vi #{@db_info.sqlite.db}")
            ans=@ans.response?('remove sql database?')
            if ans and File.exist?(@db_info.sqlite.db); File.unlink(@db_info.sqlite.db)
            end
          else
            @conn.do(@drop_table.join(''))
          end
        ensure
          #commit
        end
      end
      def indexes                                                             #% drop all indexes
        #@conn.do(%{
        #  DROP INDEX object_nr ON documents(ocn);
        #  DROP INDEX body ON documents(body);
        #  DROP INDEX clean ON documents(clean);
        #  DROP INDEX lev1 ON documents(lev1);
        #  DROP INDEX lev2 ON documents(lev2);
        #  DROP INDEX lev3 ON documents(lev3);
        #  DROP INDEX lev4 ON documents(lev4);
        #  DROP INDEX lev5 ON documents(lev5);
        #  DROP INDEX lev6 ON documents(lev6);
        #  DROP INDEX endnote_nr ON endnotes(nr);
        #  DROP INDEX endnote ON endnotes(body);
        #  DROP INDEX title ON metadata(title);
        #  DROP INDEX filename ON metadata(filename)
        #  /*
        #  DROP INDEX object_nr ON documents(ocn) CASCADE;
        #  DROP INDEX body ON documents(body) CASCADE;
        #  DROP INDEX clean ON documents(clean) CASCADE;
        #  DROP INDEX lev1 ON documents(lev1) CASCADE;
        #  DROP INDEX lev2 ON documents(lev2) CASCADE;
        #  DROP INDEX lev3 ON documents(lev3) CASCADE;
        #  DROP INDEX lev4 ON documents(lev4) CASCADE;
        #  DROP INDEX lev5 ON documents(lev5) CASCADE;
        #  DROP INDEX lev6 ON documents(lev6) CASCADE;
        #  DROP INDEX endnote_nr ON endnotes(nr) CASCADE;
        #  DROP INDEX endnote ON endnotes(body) CASCADE;
        #  DROP INDEX title ON metadata(title) CASCADE;
        #  DROP INDEX filename ON metadata(filename) CASCADE
        #  */
        #})
      end
      self
    end
  end
end
__END__
