# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: Default values (reset by skins)

=end
$latex_run=nil
module SiSU_Viz
  require 'uri'
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  require "#{SiSU_lib}/css"
  include SiSU_Style
  class Skin
    #attr_accessor :glyph,:html,:php,:javascript,:path,:text,:url,:color,:icon,:font,:markup,:paragraph,:table,:table_do,:indent,:margin,:png,:nav_txt,:nav_png,:banner,:widget
    def initialize
      #@css=SiSU_Env::CSS_default.new
      @fonts='verdana, arial, georgia, tahoma, sans-serif, helvetica, times, roman' # 'verdana, arial, georgia, tahoma, sans-serif, helvetica, "times new roman", times, roman'
      @dir=SiSU_Env::Info_env.new
      @date=SiSU_Env::Info_date.new #{@date.year}
    end
    #% glyph
    def glyph_bullet # &bullet;
      '&#149;&nbsp;' # [&#149; flagged]
    end
    #% html
    def html_hardspace
      '&nbsp;'
    end
    #% php
    def php_persist
    end
    #% javascript #kxjs knxjs
    def js_home
    end
    def js_infobox
    end
    def js_knxjs
    end
    def js_head
    end
    def js_top
    end
    def js_sisu
    end
    def js_home
    end
    def js_sponsor
    end
    def js_books
    end
    def js_journals
    end
    def js_conferences
    end
    def js_services
    end
    def js_catalogue
    end
    def js_doc
    end
    def js_toc
    end
    def js_seg
    end
    def js_mail
    end
    def js_manifest
    end
    def js_status
    end
    def js_next
    end
    def js_prev
    end
    def js_portrait
    end
    def js_landscape
    end
    def js_pdf
    end
    def js_odf
    end
    def js_concordance
    end
    def js_instruments
    end
    def js_external
    end
    def js_gopher
    end
    def js_ftp
    end
    def js_law
    end
    def js_disclaimer
    end
    def js_old
    end
    def semantic_tags
      def default
          #:f =>       'firstname',
          #:m =>       'middlename',
          #:l =>       'lastname',
          #:ed =>      'editor', #editor?
          #:v =>       'version', #edition
        {
          :pub =>     'publication',
          :conv =>    'convention',
          :vol =>     'volume',
          :pg =>      'page',
          :cty =>     'city',
          :org =>     'organization',
          :uni =>     'university',
          :dept =>    'department',
          :fac =>     'faculty',
          :inst =>    'institute',
          :co =>      'company',
          :com =>     'company',
          :conv =>    'convention',
          :dt =>      'date',
          :y =>       'year',
          :m =>       'month',
          :d =>       'day',
          :ti =>      'title',
          :au =>      'author',
          :ed =>      'editor', #editor?
          :v =>       'version', #edition
          :n =>       'name',
          :fn =>      'firstname',
          :mn =>      'middlename',
          :ln =>      'lastname',
          :in =>      'initials',
          :qt =>      'quote',
          :ct =>      'cite',
          :ref =>     'reference',
          :ab =>      'abreviation',
          :def =>     'define',
          :desc =>    'description',
          :trans =>   'translate',
        }
      end
      self
    end
    #% decorate
    def decorate_italics
      'title|article|book|journal'
    end
    def decorate_bold
    end
    def decorate_uppercase
      'surname'
    end
    #% semantic
    def sem_title #dc 1
      'title'
    end
    def sem_article
      'article'
    end
    def sem_book
      'book'
    end
    def sem_journal
      'journal'
    end
    def sem_fullname # (contains: firstname, surname) #issues arise as contains surname etc.
      'fullname'
    end
    def sem_first
      'first'
    end
    def sem_surname
      'surname'
    end
    def sem_middle
      'middle'
    end
    def sem_creator #dc 2 # == fullname (contains: firstname, surname)
      'creator'
    end
    def sem_author # == fullname (contains: firstname, surname)
      'author'
    end
    def sem_editor # == fullname (contains: firstname, surname)
      'editor'
    end
    def sem_illustrator # == fullname (contains: firstname, surname)
      'illustrator'
    end
    def sem_translator # == fullname (contains: firstname, surname)
      'translator'
    end
    def sem_isbn # 10 or 13
      'isbn'
    end
    def sem_isbn_10
      'isbn10'
    end
    def sem_isbn_13
      'isbn13'
    end
    def sem_loc # library of congress
      'loc'
    end
    def sem_dewey
      'dewey'
    end
    def sem_pg # project gutenberg number
      'pg'
    end
    def sem_subject #dc 3
      'subject'
    end
    def sem_date #dc 7
      'date'
    end
    def sem_date_created
      'date_created'
    end
    def sem_date_issued
      'date_issued'
    end
    def sem_date_available
      'date_available'
    end
    def sem_date_valid
      'date_valid'
    end
    def sem_date_modified
      'date_modified'
    end
    def sem_type #dc 8
      'type'
    end
    def sem_description #dc 4
      'description'
    end
    def sem_publisher #dc 5
      'publisher'
    end
    def sem_contributor #dc 6
      'contributor'
    end
    def sem_format #dc 9
      'format'
    end
    def sem_identifier #dc 10
      'identifier'
    end
    def sem_source #dc 11
      'source'
    end
    def sem_language #dc 12
      'language'
    end
    def sem_relation #dc 13
      'source'
    end
    def sem_coverage #dc 14
      'coverage'
    end
    def sem_rights #dc 15
      'rights'
    end
    def sem_copyright
      'copyright'
    end
    def sem_license
      'license'
    end
    def sem_prepared_by
      'prepared_by'
    end
    def sem_digitized_by
      'digitized_by'
    end
    def sem_keywords
      'keywords'
    end
    def sem_comments
      'comments'
    end
    def sem_abstract
      'abstract'
    end
    #% path
    def path_stylesheet_home
      %{  <link rel="stylesheet" href="./#{@dir.path.style}/homepage.css" type="text/css" />}
    end
    #% text #changed from txt to avoid naming conflicts #FOLLOW
    def txt_generator
      v=SiSU_Env::Info_version.new.get_version
      %{  <meta name="generator" content="#{v[:project]} #{v[:version]} of #{v[:date_stamp]} (#{v[:date]}) (n*x and Ruby!)" />
    <link rel="generator" href="http://www.jus.uio.no/sisu" />}
    end
    def txt_generator_comment
      v=SiSU_Env::Info_version.new.get_version
      %{  <!- #{v[:project]} #{v[:version]} of #{v[:date_stamp]} (#{v[:date]}) (n*x and Ruby!)" http://www.jus.uio.no/sisu ->}
    end
    def txt_hp
      '&nbsp;SiSU'
    end
    def txt_hp_alias
      'SiSU'
    end
    def txt_home
      'SiSU'
    end
    def txt_signature # used in latex/pdf footer
      'SiSU'
    end
    #% url
    def url_urify(uri)
      URI.parse(uri)
    end
    def url_sisu
      'http://www.jus.uio.no/sisu'
    end
    def url_sisudoc
      'http://www.sisudoc.org'
    end
    def url_root
      '/sisu' #watch
    end
    def url_root_http
      'http://www.jus.uio.no/sisu' #watch
    end
    def url_home
      'http://www.jus.uio.no/sisu' # used in pdf header
    end
    def url_site #used as stub... where there are subdirectories and is different from home
      url_home
      #'http://www.jus.uio.no/sisu' # used in pdf header
    end
    def url_txt
      'www.jus.uio.no/sisu'
    end
    def url_path_image_base #used for html image display
      '../_sisu/image'
    end
    def url_path_image #used for html image display
      '../_sisu/image'
    end
    def url_path_image_sys #used for html image display
      '../_sisu/image_sys'
    end
    def url_path_ebook_dir
      './ebook'
    end
    def url_path_ebook_images
      '.'
    end
    def url_promo
      ''
    end
    def url_promo_home
      ''
    end
    def url_decoration
      def tex_open
        '{\UseTextSymbol{OML}{<}}'
      end
      def tex_close
        '{\UseTextSymbol{OML}{>}}'
      end
      def xml_open
        '&lt;'
      end
      def xml_close
        '&gt;'
      end
      def txt_open
        '<'
      end
      def txt_close
        '>'
      end
      self
    end
    #% color
    def color_shadow
      '"4"'
    end
    def color_body
      %{<body bgcolor="#ffffff" text="#000000" link="#003090" lang="en" xml:lang="en">}
    end
    def color_white
      '"#ffffff"'
    end
    def color_black
      '#000000'
    end
    def color_shadow #hmmm
      '"4"'
    end
    def color_blue_dark
      '#000099'
    end
    def color_blue
      'blue'
    end
    def color_blue_base
      '#b9d4dd'
      #'#eff6ff' #light
      #'#c0d9d9' #light
      #'#0044cc' #pale
      #'#c0d9d9' #sky
    end
    def color_blue_ink
      '#003399'
    end
    def color_blue_tinge
      '#e3ecef'
      #'#d7dddd'
      #'#f2f5f7'
    end
    def color_blue_grey
      '#8faebf'
    end
    def color_blue_murky
      '#437389'
    end
    #def color_brown
    #  '#423a27'
    #end
    def color_beige
      '#f1e8de'
      #'#fff3b6'#custard
    end
    def color_subtleglow
      '#dddccc'
    end
    def color_glow
      '#fff0c3'
    end
    def color_rose
      '#ffdec9'
    end
    def color_turquoise
      '#1c869b'
    end
    def color_grey_pale
      '#eeeeee'
      # '#dddddd' #light
    end
    def color_grey_medium
      '#cccccc'
    end
    def color_grey
      '#999999'
    end
    def color_yellow_light
      '#fff3b6'
    end
    def color_yellow
      '#ffde14'
    end
    def color_yellow_dark
      '#ffcc00'
    end
    def color_green_light
      '#b7d398'  #  #e2efd5 #b7d398 #b1c999 # '#aed19e'
    end
    def color_green
      '#0a8400'
    end
    def color_green_dark
      '#086800'
    end
    def color_ruby
      '#a00000'
    end
    def color_maroon
      '#800000'
    end
    def color_paper
      %{"#{color_white}"}
    end
    def color_band1
      %{"#{color_white}"}
      #'"#777777"'
    end
    def color_band2
      %{"#{color_white}"}
      #'"#cccccc"'
    end
    def color_body
      %{\n<body bgcolor="#ffffff" text="#000000" link="#003090" lang="en" xml:lang="en">\n}
    end
    def color_font_face #was font WATCH
      "#{color_black}"
    end
    def color_surround
      %{"#{color_white}"}
    end
    def color_band
      %{"#{color_white}"}
    end
    def color_table1
      'ffffcc'
    end
    def color_table2
      'c0d0f0'
    end
    def color_band1
      '"#ffffff"'
    end
    def color_band2
      '"#ffffff"'
    end
    #% icon
    def icon_ico
      'rb7.ico'
    end
    def icon_sisu
      'sisu.png'
    end
    def icon_manifest
      'b_info.png'
    end
    def icon_doc
      'b_doc.png'
    end
    def icon_toc
      'b_toc.png'
    end
    def icon_wmp
      'b_wmp.png'
    end
    def icon_odf
      'b_odf.png'
    end
    def icon_pdf
      'b_pdf.png'
    end
    def icon_pdf_portrait
      'b_pdf.png'
    end
    def icon_pdf_landscape
      'b_pdf.png'
    end
    def icon_status
      'b_status.png'
    end
    def icon_external
      'b_ext.png'
    end
    def icon_external_toc
      'b_ext_toc.png'
    end
    def icon_seg_toc
      'b_bluebell.png'
    end
    def icon_crosslink_toc
      'b_amber.png'
    end
    def icon_mail
      'b_mail.png'
    end
    def icon_para
      'b_para.png'
    end
    def icon_pdf
      'b_pdf.png'
    end
    def icon_ftp
      'b_ftp.png'
    end
    def icon_gopher
      'b_gopher.png'
    end
    def icon_choice
      'b_choice.png'
    end
    def icon_new
      'b_new.png'
    end
    def icon_book
      'b_amber.png'
      # b_book.png
    end
    def icon_dot_clear
      'dot_clear.png'
    end
    def icon_dot_white
      'dot_white.png'
    end
    def icon_dot
      icon_dot_white
    end
    def icon_amber
      'b_amber.png'
    end
    def icon_rose
      'b_rose.png'
    end
    def icon_bluebell
      'b_bluebell.png'
    end
    def icon_home_button
      'sisu.png'
    end
    def icon_home_banner
      'sisu.png'
    end
    def icon_site
      'b_home.png'
    end
    def icon_bluedot
      'blueband.png'
    end
    def icon_next
      'arrow_next_red.png'
    end
    def icon_previous
      'arrow_prev_red.png'
    end
    def icon_up
      'arrow_up_red.png'
    end
    #% font
    def font_fonts
      @fonts
    end
    def font_face
      %{face="#{font_fonts}"}
    end
    def font_lmtoc_face
      %{face="#{font_fonts}"}
    end
    def font_ebook_face
      %{face="#{font_fonts}"}
    end
    def font_face_lmtoc
      %{face="#{font_fonts}"}
    end
    def font_color
      'color="#000000"'
    end
    def font_size
      'size="4"'
    end
    def font_size_txt
      'size="4"'
    end
    def font_size_txt_00
      'size="3"'
    end
    def font_size_endnote
      'size="3"'
    end
    def font_small
      'size="3"'
    end
    def font_tiny
      'size="2"'
    end
    #% markup
    def markup_italics_list #regular expression of words to be italised
    end
    def markup_bold_list #regular expression of words to be made bold
      'SiSU'
    end
    def markup_make_italic
      if defined? italics_list \
      and italics_list
        #make=italics_list.split(/;\s+/).join('|').strip
        make={}
        if italics_list
          r=italics_list.dup
          x=case r
          when /\/i$/; 'i'
          else         ''
          end
          r.gsub!(/^\/(.+?)\/i?/,'\1')
          r.gsub!(/\(/,'(?:') # avoid need to escape use of brackets within regex provided
          m='\b(' + r + ')\b'
          make[:str]
          make[:regx]=if x =~/i/; /#{m}/i
          else                    /#{m}/
          end
        else nil
        end
      end
    end
    def markup_make_bold
      if defined? bold_list \
      and not bold_list.empty?
        make={}
        if bold_list
          #make=bold_list.split(/;\s+/).join('|').strip
          r=bold_list.dup
          x=case r
          when /\/i$/; 'i'
          else         ''
          end
          r.gsub!(/^\/(.+?)\/i?/,'\1')
          r.gsub!(/\(/,'(?:') # avoid need to escape use of brackets within regex provided
          m='\b(' + r + ')\b'
          make[:str]
          make[:regx]=if x =~/i/; /#{m}/i
          else                    /#{m}/
          end
        else nil
        end
        make
      end
    end
    #% paragraph
    def paragraph_txt
      %{<p class="normal">}
    end
    def paragraph_txt_00
      %{<p class="justify">}
    end
    def paragraph_font_citation
      %{<font #{font_size_txt} #{font_face}>}
    end
    def paragraph_endnote
      %{<p class="endnote">}
    end
    def paragraph_table
      %{<p align="left"><font #{font_small} #{font_color} #{font_face}>}
    end
    def paragraph_table_xml
    end
    def paragraph_tiny
      %{<p class="tiny">}
    end
    def paragraph_small
      %{<p class="small">} # keep but not used?
    end
    def paragraph_font_tiny
      %{<font #{font_tiny} #{font_face}>}
    end
    def paragraph_font_small
      %{<font #{font_small} #{font_face}>}
    end
    def paragraph_heading_1
      %{<h1>}
    end
    def paragraph_heading_1_center
      %{<h1 class="center">}
    end
    #% table
    def table_close
      '</td></tr>
</table>'
    end
    def table_close_centered_table
    end
    def table_align_A
    end
    def table_align_B
    end
    def table_align_C
    end
    def table_width_1
      '"100%"'
    end
    def table_width_2
      '"99%"'
    end
    def table_width_3
      '"94%"'
    end
    def table_width_4
      '"90%"'
    end
    def table_width_txt
      '"94%"'
    end
    def table_width_txt_avgo
      '"100%"'
    end
    def table_width_txt_r
      '"96%"'
    end
    def table_cellpad_small_paper_margins
      '"6"'
    end
    def table_cellpad_paper_margins
      '"36"'
    end
    def table_cellpad_A
      '"0"'
    end
    def table_cellpad_B
      '"20"'
    end
    def table_cellpad_shadow
      '"4"'
    end
    def table_cellpad_band
      '"16"'
    end
    def table_cellpad_box
      '"20"'
    end
    def table_table_align_A
      '<center>'
    end
    def table_table_align_B
      '<center>'
    end
    def table_table_align_C
      ' '
    end
    #% table_do
    def table_do_table_paper
      %{#{table_align_C} <table summary="table paper" width=#{table_width_2} border="0" cellpadding=#{table_cellpad_paper_margins} bgcolor=#{color_paper} align="Justify"><tr><td>\n<font color="#000000"><p />\n}
    end
    def table_do_table_surround
      %{<table summary="table surround" width="100%" border="0" cellpadding="0" bgcolor="#ffffff" align="center"><tr><td>\n}
    end
    #% indent
    def indent_level_0
      '"1%"'
    end
    def indent_level_1
      '"4%"'
    end
    def indent_level_2
      '"6%"'
    end
    def indent_level_3
      '"8%"'
    end
    def indent_level_4
      '"10%"'
    end
    #% margin
    def margin_num
      '</p> </td><td width="4%" align="right" valign="top">'
    end
    def margin_numless
      '</td><td width="4%" align="right" valign="top">'
    end
    def margin_num_css
      '</td>
<td width="2%" align="right" valign="top">  '
    end
    def margin_num_header
      '</td>
<td width="4%" align="right" valign="top">'
    end
    def margin_txt_00_1
      %{<table summary="" width=#{table_width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{indent_level_1} align="right">
</td>
<td valign="top" align="left" width=#{indent_level_1_c2w100}>}
    end
    def margin_txt_w1
      %{<table summary="" width=#{table_width_txt_r} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width="6%" align="right">&nbsp;</td>
<td width="90%" valign="top" align="justify">}
    end
    def margin_txt_w2
      %{<table summary="" width=#{table_width_txt_r} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width="10%" align="right">&nbsp;</td>
<td width="86%" valign="top" align="justify">}
    end
    def margin_txt_0
      %{<table summary="" width=#{table_width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{indent_level_0} align="right">
</td><td valign="top" align="justify">}
    end
    def margin_txt_1
      %{<table summary="" width=#{table_width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{indent_level_1} align="right"></td><td valign="top" align="justify">}
    end
    def margin_txt_2
      %{<table summary="" width=#{table_width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{indent_level_2} align="right">
</td>
<td valign="top" align="justify">}
    end
    def margin_txt_3
      %{<table summary="" width=#{table_width_txt} border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td width=#{indent_level_3} align="right">
</td>
<td valign="top" align="justify">}
    end
    def margin_css #unused, check
      '<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
<tr><td valign="top" align="justify"> '
    end
    #% png
    def png_ico
      %{  <link rel="shortcut icon" href="../_sisu/image/#{icon_ico}" />}
    end
    def png_sisu #check url path
      %{  <a href="#{@url.sisu}">
    <img border="0" width="160" height="60" src="#{url_path_image}/#{icon_sisu}" alt="SiSU" />
    </a>}
    end
    def png_hp
      dir=SiSU_Env::Info_env.new #(@fns)
      %{  <a href="#{url.site}">
      <img border="0" width="160" height="60" src="#{@dir.url.images_local}/#{icon_home_banner}" alt="#{txt_home}" />
    </a>}
    end
    def png_site
      #dir=SiSU_Env::Info_env.new #(@fns)
      %{<img src="#{url_path_image}/#{icon_site}" alt="@" border="0" />}
    end
    def png_homepage
      png_site
    end
    def png_nav
      %{<img border="0" height="15" width="15" src="#{url_path_image_sys}/#{icon_bluebell}" alt="Contents" />}
    end
    def png_manifest
      %{<img border="0" height="15" width="15" src="#{url_path_image_sys}/#{icon_manifest}" alt="Document Manifest" />}
    end
    def png_doc
      %{<img border="0" height="15" width="15" src="#{url_path_image_sys}/#{icon_doc}" alt="Full Text" />}
    end
    def png_toc
      %{<img border="0" height="18" width="15" src="#{url_path_image_sys}/#{icon_toc}" alt="TOC linked" />}
    end
    def png_odf
      %{<img border="0" height="18" width="18" src="#{url_path_image_sys}/#{icon_odf}" alt="ODF/ODT" />}
    end
    def png_pdf
      %{<img border="0" height="18" width="15" src="#{url_path_image_sys}/#{icon_pdf}" alt="PDF" />}
    end
    def png_pdf_portrait
      %{<img border="0" height="18" width="15" src="#{url_path_image_sys}/#{icon_pdf}" alt="PDF portrait" />}
    end
    def png_pdf_landscape
      %{<img border="0" height="15" width="18" src="#{url_path_image_sys}/#{icon_pdf}" alt="PDF landscape" />}
    end
    def png_wmp
      %{<img border="0" height="15" width="15" src="#{url_path_image_sys}/#{icon_wmp}" alt="Concordance" />}
    end
    def png_para
      %{<img border="0" height="15" width="15" src="#{url_path_image_sys}/#{icon_para}" alt="Segment" />}
    end
    def png_status
      %{<img border="0" height="15" width="15" src="#{url_path_image_sys}/#{icon_status}" alt="Membership status" />}
    end
    def png_mark
      %{<img border="0" height="15" width="15" src="#{url_path_image_sys}/#{icon_rose}" alt="*" />}
    end
    def png_doc_tiny
      %{<img border="0" height="8" width="8" src="#{url_path_image_sys}/#{icon_doc}" alt="Doc" />}
    end
    def png_toc_tiny
      %{<img border="0" height="8" width="8" src="#{url_path_image_sys}/#{icon_toc}" alt="TOC" />}
    end
    def png_status_tiny
      %{<img border="0" height="8" width="8" src="#{url_path_image_sys}/#{icon_status}" alt="Status, Member States" />}
    end
    def png_ftp
      %{<img border="0" height="15" width="15" src="#{url_path_image_sys}/#{icon_ftp}" alt="FTP" />}
    end
    def png_gopher
      %{<img border="0" height="15" width="15" src="#{url_path_image_sys}/#{icon_gopher}" alt="Gopher" />}
    end
    def png_crosslink
      %{<img border="0" height="15" width="15" src="#{url_path_image_sys}/#{icon_crosslink_toc}" alt="lateral hop" />}
    end
    def png_crosslink_ext
      %{<img border="0" height="15" width="15" src="#{url_path_image_sys}/#{icon_external_toc}" alt="lateral hop" />}
    end
    def png_home
      dir=SiSU_Env::Info_env.new #(@fns)
      %{<img border="0" src="#{dir.url.images_local}/#{icon_home_button}" alt="#{txt_home} --&gt;" />}
    end
    def png_home_button
      #dir=SiSU_Env::Info_env.new #(@fns)
      %{<img border="0" src="#{url_path_image_base}/#{icon_home_button}" alt="#{txt_home} --&gt;" />}
    end
    def png_book
      %{<img border="2" height="15" width="15" src="#{url_path_image_sys}/#{icon_book}" alt="Cameron May Books" />}
    end
    #% png_nav
    def png_nav_home
    end
    def png_nav_toc
      %{<img border="0" width="22" height="22" src="#{url_path_image_sys}/#{icon_up}" alt="TOC" />}
    end
    def png_nav_doc
    end
    def png_nav_previous
      %{<img border="0" width="22" height="22" src="#{url_path_image_sys}/#{icon_previous}" alt="&lt;&lt;&nbsp;previous" />}
    end
    def png_nav_next
      %{<img border="0" width="22" height="22" src="#{url_path_image_sys}/#{icon_next}" alt="next&nbsp;&gt;&gt;" />}
    end
    def png_nav_pre
      png_nav_previous
    end
    def png_nav_nxt
      png_nav_next
    end
    def png_nav_pdf
      %{<img border="0" height="18" width="15" src="#{url_path_image_sys}/#{icon_pdf}" alt="PDF" />}
    end
    def png_nav_pdf_portrait
      %{<img border="0" width="15" height="18" src="#{url_path_image_sys}/#{icon_pdf}" alt="pdf portrait" />}
    end
    def png_nav_pdf_landscape
      %{<img border="0" width="18" height="15" src="#{url_path_image_sys}/#{icon_pdf}" alt="pdf landscape" />}
    end
    def png_nav_dot_toc
      %{<img border="0" width="100%" height="20" src="#{url_path_image_sys}/#{icon_dot}" alt="&#094;" />}
    end
    def png_nav_dot_previous
      %{<img border="0" width="100%" height="20" src="#{url_path_image_sys}/#{icon_dot}" alt="&lt;" />}
    end
    def png_nav_dot_next
      %{<img border="0" width="100%" height="20" src="#{url_path_image_sys}/#{icon_dot}" alt="&gt;" />}
    end
    def png_nav_dot_pre
      png_nav_dot_previous
    end
    def png_nav_dot_nxt
      png_nav_dot_next
    end
    #% nav_txt
    def nav_txt_home
      %{  <font face="#{font_fonts}" size="2">
    #{png_site}&nbsp;
  </font> }
    end
    def nav_txt_home_button
      %{  <font face="#{font_fonts}" size="2">
    #{png_home_button}&nbsp;
  </font> }
    end
    def nav_txt_homepage
      %{  <font face="#{font_fonts}" size="2">
    #{png_site}&nbsp;homepage&nbsp;
  </font> }
    end
    def nav_txt_toc_link
      %{  <font face="#{font_fonts}" size="2">
    #{png_toc}&nbsp;&nbsp;toc&nbsp;
  </font> }
    end
    def nav_txt_toc_link_verbose
      %{  <font face="#{font_fonts}" size="2">
    #{png_toc}&nbsp;&nbsp;segments'&nbsp;toc&nbsp;
  </font> }
    end
    def nav_txt_doc_link
      %{  <font face="#{font_fonts}" size="2">
    #{png_doc}&nbsp;&nbsp;scroll&nbsp;
  </font> }
    end
    def nav_txt_manifest
      %{  <font face="#{font_fonts}" size="2">
    #{png_manifest}&nbsp;
  </font> }
    end
    def nav_txt_concordance
      %{  <font face="#{font_fonts}" size="2">
    &nbsp;&nbsp;A-Z&nbsp;
  </font> }
    end
    def nav_txt_previous
      '  <font face="" size="2">
    &nbsp;&nbsp;<b>&lt;&lt;</b>&nbsp;Previous&nbsp;&nbsp;
  </font>
  Full&nbsp;Text&nbsp;'
    end
    def nav_txt_next
      %{  <font face="#{font_fonts}" size="2">
    &nbsp;&nbsp;Next&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>&gt;&gt;</b>&nbsp;&nbsp;
  </font> }
    end
    def nav_txt_odf
      %{  <font face="#{font_fonts}" size="2">
    #{png_odf}&nbsp;&nbsp;odt&nbsp;
  </font> }
    end
    def nav_txt_pdfs
      %{  <font face="#{font_fonts}" size="2">
    pdfs&nbsp;&nbsp;
  </font> }
    end
    def nav_txt_pdf_portrait
      %{  <font face="#{font_fonts}" size="2">
    #{png_pdf_portrait}
    &nbsp;&nbsp;pdf&nbsp;
  </font> }
    end
    def nav_txt_pdf_landscape
      %{  <font face="#{font_fonts}" size="2">
    #{png_pdf_landscape}
    &nbsp;&nbsp;pdf&nbsp;
  </font> }
    end
    #% banner
    def banner_home
      %{  <center>
    <a href="#{url_site}/" target="_top" #{js_home}>
      #{png_site}
    </a>
  <br />
  <font size="2" color="#444444">
    an
  <br />
    (&nbsp;international&nbsp;|&nbsp;transnational&nbsp;)
  <br />
    commercial&nbsp;law&nbsp;&&nbsp;e-commerce
  <br />
    infrastructure monitor</font></center>}
    end
    def banner_home_guide
      %{  <br />
    <a href="#{url_site}/" target="_top" #{js_home}>
      #{png_doc} LM toc
    </a>
    <a href="../treaties.and.organisations/lm.chronological" target="_top" #{js_instruments}>
      #{png_doc} LM 20**
    </a>
  <br />}
    end
    def banner_home_button_only
      %{<a href="#{url_site}/" #{js_home}>
    #{png_home_button}
  </a>}
    end
    def banner_home_button #yellow_dark now white
      %{<table summary="home button" width="100%" border="0" cellpadding="3" bgcolor= "#ffffff" align="center">
<tr><td align="left" valign="middle" bgcolor="#{color_white}" width="10%">
  <a href="#{url_site}/" #{js_home}>
    #{png_home_button}
  </a>
</td>
<td width="90%">
#{table_close}}
    end
    def banner_home_and_index_buttons #yellow_dark now white
      %{<table summary="home and index buttons" bgcolor=#{color_band1}>
<tr><td width="20%">
<table summary="home button" width="100%" border="0" cellpadding="3" align="center">
<tr><td align="center" valign="middle" bgcolor="#{color_white}">
  <a href="#{url_site}/" target="_top" #{js_home}>
    #{png_home}
  </a>
</td></tr>
</table>
</td>
<td width="60%">
<table summary="other contents buttons" border="0" cellpadding="3" cellspacing="0">
<tr><td align="center" bgcolor=#{color_band2}>
  <font face="arial" size="2">
    <a href="toc" target="_top" #{js_toc}>
      &nbsp;This&nbsp;text's&nbsp;sub-&nbsp;
    <br />
      &nbsp;Table&nbsp;of&nbsp;Contents&nbsp;
    </a>
  </font>
</td></tr>
</table>
</td>
<td width="20%">
  &nbsp;
#{table_close}}
    end
    def banner_url_txt_sisu
      %{<a href="#{url_sisu}/sisu" target="_top" #{js_home}>SiSU</a>}
    end
    def banner_band #yellow_dark now white
      %{<table summary="home button" width="100%" border="0" cellpadding="3" bgcolor= "#ffffff" align="center">
<tr><td align="left" valign="middle" bgcolor="#{color_white}">
  <a href="#{url_site}/" target="_top" #{js_home}>
    #{png_home}
  </a>
</td>
<td width="90%">
#{table_close}}
    end
    def banner_credit_band
      %{<table summary="credits table yellow" width="80%" border="1" cellpadding="0" bgcolor="#{color_yellow_dark}" align="center">
<tr><td align="center">
<table summary="salmon" width="100%" border="0" cellpadding="0" bgcolor="#ffdec9">
<tr><td align="center">
<table summary="credits white background" width="100%" border="0" cellpadding="6" bgcolor="#ffffff">
<tr><td align="center">}
    end
    def banner_instrument_cover_band_scr
      '<table summary="scroll instrument cover band" width="100%" border="0" cellpadding="8" bgcolor="#ffffff" align="center">
<tr><td align="center">'
    end
    def banner_instrument_cover_band_seg
      '<table summary="segment instrument cover band, title, author, location" width="100%" border="0" cellpadding="8" bgcolor="#ffffff" align="center">
<tr><td align="center">'
    end
    #% widget
    def widget_promo # Array used to build promo from list.yml and promo.yml
    #  ['sisu_icon','sisu','sisu_search_libre','open_society','fsf','ruby']
    end
    def widget_browsers
<<WOK
<tr align="center"><td align="center">
<table summary="browser suggestions" bgcolor="#ffffff" cellpadding="4" border="0">
<tr><td>
  <p>
  <font color="#666666" size="2">
    If you have problems viewing pages on this site please update your browser:
  </font>
  </p>
#{table_close}
<table summary="browser suggestions" bgcolor="#ffffff" cellpadding="4" border="0">
<tr><td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.gnome.org/projects/epiphany/" target="external">
        &nbsp;Epiphany
      </a>
      <sup>&reg;</sup>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://galeon.sourceforge.net/" target="external">
      &nbsp;Galeon
    </a>
    <sup>&reg;</sup>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.microsoft.com/windows/ie/default.asp" target="external">
      I-Explorer
    </a>
    <sup>&reg;</sup>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://kazehakase.sourceforge.jp/" target="external">
     Kazehakase</a>
    <sup>&reg;</sup>&nbsp;|</font></p></td>
<td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.konqueror.org/" target="external">
    Konqueror</a>
    <sup>&reg;</sup>&nbsp;|</font></p></td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.mozilla.org/" target="external">
      Mozilla
    </a>
    <a href="http://www.mozilla.org/products/firefox/" target="external">
      <b>Firefox</b>
    </a>
    <sup>&reg;</sup>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://home.netscape.com/comprod/mirror/client_download.html" target="external">
      Netscape
    </a>
    <sup>&reg;</sup>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.opera.com/" target="external">
      Opera
    </a>
    <sup>&reg;</sup>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.apple.com/safari/" target="external">
      Safari
    </a>
    <sup>&reg;</sup>
  </font>
  </p>
#{table_close}
<table summary="lightweight browser and text browser suggestions" bgcolor="#ffffff" cellpadding="4" border="0">
<tr><td>
  <p>
  <font color="#666666" size="1">
    for console/text viewing:
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://elinks.or.cz/" target="external">
      <b>elinks</b>
    </a>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://atrey.karlin.mff.cuni.cz/~clock/twibright/links" target="external">
      <b>links2</b>
    </a>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://w3m.sourceforge.net/" target="external">
      <b>w3m</b>
    </a>
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    for lightweight gui (X) viewing try:
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.dillo.org/" target="external">
      Dillo
    </a>
    &nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://www.gnome.org/projects/epiphany/" target="external">
      &nbsp;Epiphany
    </a>
    <sup>&reg;</sup>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://galeon.sourceforge.net/" target="external">
      &nbsp;Galeon
    </a>&nbsp;|
  </font>
  </p>
</td>
<td>
  <p>
  <font color="#666666" size="1">
    <a href="http://atrey.karlin.mff.cuni.cz/~clock/twibright/links" target="external">
      <b>links2 -g</b>
    </a>
  </font>
  </p>
#{table_close}
</td></tr>
WOK
    end
    def widgets_open
<<WOK
<table summary="SiSU summary" bgcolor="#ffffff" cellpadding="4" border="0">
WOK
    end
    def widget_pdfviewers
<<WOK
<tr align="center"><td align="center">
<!-- pdf viewer suggestions -->
<tr><td>
  <p class="center">
  <font color="#666666" size="1">
    &amp; for
    <a href="http://www.adobe.com/products/acrobat/adobepdf.html" target="external">
      pdf
    </a>
    viewings of this site we recommend stand alone viewers
    <br />
    (rather than web browser plugins):
  </font>
  </p>
</td></tr>
<tr align="center"><td align="center">
  <p class="center">
  <font color="#666666" size="1">
    <a href="http://www.adobe.com/products/acrobat/readstep2.html" target="external">
      Acrobat Reader
    </a>
    <sup>&reg;</sup>
    &nbsp;|
  </font>
  </p>
</td>
<td>
  <p class="center">
  <font color="#666666" size="1">
    <a href="http://www.gnome.org/projects/evince/" target="external">
      <b>Evince</b>
    </a>
    <sup>&reg;</sup>
  </font>
  </p>
</td>
<td>
  <p class="center"><font color="#666666" size="1">
    <a href="http://www.cs.wisc.edu/~ghost/gv/" target="external">
    &nbsp;GhostView<sup>&reg;</sup>&nbsp;</a>,
    <a href="http://wwwthep.physik.uni-mainz.de/~plass/gv/" target="external">
      GV<sup>&reg;</sup>
    </a>
    &amp;
    <a href="http://www.cs.wisc.edu/~ghost/gsview/" target="external">
      GSview<sup>&reg;</sup>
    </a>
    &nbsp;|
  </font>
  </p>
</td>
<td>
  <p class="center">
  <font color="#666666" size="1">
    <a href="http://www.foolabs.com/xpdf/" target="external">
      &nbsp;Xpdf
    </a>
    <sup>&reg;</sup>
  </font>
  </p>
</td></tr>
WOK
    end
    def widget_sisu
      v=SiSU_Env::Info_version.new.get_version
<<WOK
<!-- widget sisu -->
<tr><td valign="top" width="10%">
  <p class="tiny_left"><font color="#666666" size="2">
    <a href="#{url_sisu}" #{js_sisu}>
      <img border="0" src="../_sisu/image/sisu.png" alt="SiSU" width="120" height="39" />
    </a>
  </font></p>
</td><td valign="top" width="45%">
<!-- SiSU Rights -->
  <p class="tiny_left"><font color="#666666" size="2">
    Output generated by
    <a href="#{url_sisu}" #{js_sisu}>
      #{v[:project]}
    </a>
    #{v[:version]} #{v[:date]} (#{v[:date_stamp]})
    <br />
    <a href="#{url_sisu}" #{js_sisu}>
      <b>#{v[:project]}</b>
    </a>
    Copyright <sup>&copy;</sup> Ralph Amissah
    1997, current #{@date.year_static}.
    All Rights Reserved.
    <br />
    <a href="#{url_sisu}" #{js_sisu}>
      #{v[:project]}
    </a>
    is software for document structuring, publishing and search,
    <br />
    <a href="#{url_sisu}" #{js_sisu}>
      www.jus.uio.no/sisu
    </a>
    and
    <a href="#{url_sisudoc}" #{js_sisu}>
      www.sisudoc.org
    </a>
  <br />
    <i>w3 since October 3 1993</i>
    <a href="mailto://ralph@amissah.com" #{js_mail}>
      ralph@amissah.com
    </a>
  </font></p>
</td><td valign="top" width="45%">
  <p class="tiny_left"><font color="#666666" size="2">
    #{v[:project]} using:
    <br />Standard SiSU markup syntax,
    <br />Standard SiSU meta-markup syntax, and the
    <br />Standard SiSU <u>object citation numbering</u> and system, (object/text positioning system)
  <br />
    Copyright <sup>&copy;</sup> Ralph Amissah 1997, current #{@date.year_static}.
    All Rights Reserved.
  </font></p>
</td></tr>
WOK
    end
    def widget_way_better
      v=SiSU_Env::Info_version.new.get_version
      <<WOK
<!-- widget way better -->
<tr><td valign="top" width="10%">
  <p class="tiny_left"><font color="#666666" size="2">
    <a href="http://www.gnu.org/licenses/gpl.html">
      <img border="0" src="../_sisu/image/gplv3_free_software.png" alt="GPLv3" width="127" height="51" />
    </a>
  </font></p>
</td><td valign="top" width="45%">
  <p class="tiny_left"><font color="#666666" size="2">
    <a href="#{url_sisu}" #{js_sisu}>
      #{v[:project]}
    </a>
    is released under
    <a href="http://www.gnu.org/licenses/gpl.html">GPLv3</a>
    or later,
    #{url_decoration.xml_open}<a href="http://www.gnu.org/licenses/gpl.html">http://www.gnu.org/licenses/gpl.html</a>#{url_decoration.xml_close}
  </font></p>
</td><td valign="top" width="45%">
  <p class="tiny_left"><font color="#666666" size="2">
    #{v[:project]}, developed using
    <a href="http://www.ruby-lang.org/en/">
      Ruby
    </a>
    on
    <a href="http://www.debian.org/">
      Debian/Gnu/Linux
    </a>
    software infrastructure,
    with the usual GPL (or OSS) suspects.
  <br />
    Better - "performance, reliability, scalability, security &amp; total cost of ownership"
    [not to mention flexibility &amp; choice] use of and adherence to open standards (where practical and fair) and it is software libré.
  <br />
    Get With the Future
    <a href="http://www.jus.uio.no/sisu/">
      Way Better!
    </a>
  </font></p>
</td></tr>
WOK
    end
    def widget_wayBetter
      widget_way_better
    end
    #% credits
    def credits_itl_cover_band
      %{<table summary="itl cover band" width="88%" border="0" cellpadding="0" bgcolor="blue">
<tr><td>
<table summary="" width="100%" border="0" cellpadding="8" bgcolor="#000099">
<tr><td>
<table summary="" width="99%" border="1" cellpadding="0" bgcolor="#ffcc00">
<tr><td>
<table summary="" width="100%" border="1" cellpadding="0" bgcolor="#ffffff">
<tr><td align="center">
  <font #{font_face}>
    <br />
      \@
    <br />
      #{txt_home}
    <br />
      #{banner_url_txt_sisu}
    <br />
  </font>
#{table_close*4}}
    end
    def credits_sisu
      %{<div class="substance">
<table summary="SiSU summary" bgcolor="#ffffff" cellpadding="4" border="0">
<tr><td>
  #{widget_sisu}
  #{widget_way_better}
</table></div>}
    end
    def credits_splash
    end
    #% bottom
    def bottom_surround
      %{</td>
<td align="center" valign="bottom">#{table_close}<table summary="" border="0" width="100%" valign="top">
<tr><td valign="top" width="20%"><table summary="" width="100%" border="0" cellpadding="0" bgcolor="#e3ecef" align="center">
<tr><td valign="top">
#{table_close}
</td>
<td align="center" valign="top">
  #{banner_band}
#{table_close}
<table summary="" border="0" width="100%" valign="top">
<tr><td valign="top" width="20%">
<table summary="" width="100%" border="0" cellpadding="0" bgcolor="#e3ecef" align="center">
<tr><td valign="top">
  #{table_close}
</td>
<td align="center" valign="top">
  #{credits_splash}
#{table_close}
</body>
</html>}
    end
  end
  class Home < Skin
    def initialize
      @v=SiSU_Env::Info_version.new.get_version
      @dir=SiSU_Env::Info_env.new
      @date=SiSU_Env::Info_date.new #{@date.year}
    end
    def redirect
      <<WOK
<html><head>
<title>SiSU</title>
<meta http-equiv="refresh" content="0, url=http://www.jus.uio.no/sisu/SiSU/">
</head>
<body>
SiSU informtion provided at <a href="http://www.jus.uio.no/sisu/SiSU/">www.jus.uio.no/sisu/SiSU</a><p />
If your browser supports redirection, you will be escorted there shortly.
</body>
</html>
WOK
    end
    def homepage
      <<WOK
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>SiSU information Structuring Universe - Structured
information, Serialized Units - software for electronic texts,
documents, books, digital libraries in plaintext, html, XHTML, XML,
ODF (OpenDocument), LaTeX, PDF, SQL (PostgreSQL and SQLite), and
for search</title>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<meta name="dc.title" content="SiSU information Structuring Universe, Structured information Serialised Units, #{@date.year_static}" />
<meta name="dc.author" content="Ralph Amissah" />
<meta name="dc.subject" content=
"document structuring, ebook, publishing, PDF, LaTeX, XML, ODF, SQL, postgresql, sqlite, electronic book, electronic publishing, electronic document, electronic citation, data structure, citation systems, granular search, digital library" />
<meta name="dc.publisher" content=
"SiSU http://www.jus.uio.no/sisu" />
<meta name="dc.language" content="en" />
<meta name="dc.rights" content="Copyright Ralph Amissah" />
<meta name="generator" content="#{@v[:project]} #{@v[:version]} of #{@v[:date_stamp]} (#{@v[:date]}) (n*x and Ruby!)" />
<link rel="generator" href="http://www.jus.uio.no/sisu/SiSU" />
<link rel="stylesheet" href="./#{@dir.path.style}/html.css" type="text/css" />
<link rel="shortcut icon" href="./_sisu/image/rb7.ico" />
</head>
<body>
<div id="top_band">
<p class="top_band_image">
  <a href="http://www.jus.uio.no/sisu/SiSU" target="_top" >
    <img border="0" src="./_sisu/image/sisu.png" alt="SiSU &gt;&gt;">
  </a>
</p>
<h1 class="top_band">
  SiSU information Structuring Universe
</h1>
<h2 class="top_band_tiny">
  Structured information, Serialized Units
</h2>
<h2 class="top_band_tiny">
software for electronic texts, document collections, books, digital libraries, and search,
</h2>
<h2 class="top_band_tiny">
 with "atomic search" and text positioning system (shared text citation numbering: "<i>ocn</i>")
</h2>
<h2 class="top_band_tiny">
outputs include: plaintext, html, XHTML, XML, ODF (OpenDocument), LaTeX, PDF, SQL (PostgreSQL and SQLite)
</h2>
</div>
<div id="top_band_search">
<!-- SiSU Search -->
<a name="search"></a><form method="get" action="http://search.sisudoc.org" target="_top">
<input type="text" name="s1" size="24" maxlength="255" />
<br />
<input type="submit" name="ignore" value="search" />
<input type="hidden" name="db" value="SiSU_sisu" />
<input type="radio" name="view" value="index" checked="checked" /> idx
<input type="radio" name="view" value="text" /> txt
</form>
<!-- SiSU Search -->
</div>
<div id="column_left">
<p class="bold">
  <a href="http://www.jus.uio.no/sisu/SiSU" target="_top" >
    SiSU
  </a>
</p>
<p class="tiny">
  ---
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/sisu_manual/" target="_top" >
    SiSU Manual
  </a>
</p>
<p class="tiny">
  ---
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/SiSU/1.html#summary" target="_top" >
    What does SiSU do? Summary
  </a>
</p>
<p class="tiny">
  ---
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/SiSU/2.html" target="_top" >
    Book Samples and Markup Examples
  </a>
</p>
<p class="tiny">
  ---
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/SiSU/1.html#ocn" target="_top" >
    Object Citation Numbering - <i>ocn</i>
  </a>
</p>
<p class="tiny">(a text positioning system)</p>
<p class="tiny">
  ---
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/SiSU/1.html#search" target="_top" >
    Search - "<i>granular</i>"
  </a>
<p class="tiny">
  Of interest is the ease of streaming documents to a relational database, at an object (roughly paragraph) level and the potential for increased precision in the presentation of matches that results thereby. The ability to serialise html, LaTeX, XML, SQL, (whatever) is also inherent in / incidental to the design. For a description see the
  <a href="http://www.jus.uio.no/sisu/sisu_provisional_patent_application_200408" target="_top" >
    abandoned U.S. provisional patent application
  </a>
</p>
<p class="tiny">
  ---
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/SiSU/download.html" target="_top" >
    <b>Download</b>
  </a>
</p>
<p class="tiny">
  ---
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/SiSU/changelog.html" target="_top" >
    Changelog
  </a>
</p>
<p class="tiny">
  ---
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/SiSU/license.html" target="_top" >
    License
  </a>
</p>
<p class="tiny">
  Gnu / Linux / Unix
</p>
<p class="tiny">
  =============
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/man" target="_top" >
    sisu man pages
  </a>
</p>
<p class="tiny">
  ---
</p>
<p class="tiny">
  document preparation can be on any platform, in any editor:
  (syntax highlight support currently for: vim, kate, write, gedit, diakonos)
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/syntax_highlight" target="_top" >
    Syntax highlighting
  </a>
</p>
<p class="tiny">
  =============
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/SiSU" target="_top" >
    * Composite document
  </a>
</p>
<p class="tiny">
  the composite document is a superset of the following documents:
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/sisu_description" target="_top" >
    SiSU description
  </a>
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/sisu_examples" target="_top" >
    SiSU examples
  </a>
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/sisu_chronology" target="_top" >
    SiSU chronology
  </a>
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/sisu_technical_info" target="_top" >
    SiSU technical
  </a>
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/sisu_faq" target="_top" >
    SiSU FAQ
  </a>
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/sisu_download" target="_top" >
    SiSU download
  </a>
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/sisu_changelog" target="_top" >
    SiSU changelog
  </a>
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/sisu_license" target="_top" >
    SiSU license
  </a>
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/sisu_standard" target="_top" >
    SiSU standard
  </a>
</p>
<p class="small">
  <a href="http://www.jus.uio.no/sisu/sisu_provisional_patent_application_200408" target="_top" >
    SiSU abandoned provisional patent
  </a>
</p>
<p class="tiny">
  Note: the placement of SiSU documents on the Net predate the release of SiSU.
</p>
</div>
<div id="column_center">
<p class="bold">
  For less markup than the most elementary HTML you can have more.
</p>
<p><a href="http://www.jus.uio.no/sisu/SiSU" target="_top" ><b>SiSU</b> - Structured information, Serialized Units</a> for electronic documents, is an information structuring, transforming, publishing and search framework with the following features:</p>
<p>
<b>(i)</b> markup syntax:
<b>(a)</b>
simpler than html,
<b>(b)</b>
mnemonic, influenced by mail/messaging/wiki markup practices,
<b>(c)</b> human readable, and easily writable,</p>
<p><b>(ii)</b>
<b>(a)</b>
minimal markup requirement,
<b>(b)</b>
single file marked up for multiple outputs,</p>
<p><b>
notes
</b></p>
<p class="small">
<b>*</b>
documents are prepared in a single UTF-8 file using a minimalistic mnemonic syntax. Typical literature, documents like "War and Peace" require almost no markup, and most of the headers are optional.
</p>
<p class="small">
<b>*</b>
markup is easily readable/parsed by the human eye, (basic markup is simpler and more sparse than the most basic html), [this may also be converted to XML representations of the same input/source document].
</p>
<p class="small">
<b>*</b>
markup defines document structure (this may be done once in a header pattern-match description, or for heading levels individually); basic text attributes (bold, italics, underscore, strike-through etc.) as required; and semantic information related to the document (header information, extended beyond the Dublin core and easily further extended as required); the headers may also contain processing instructions.
</p>
<p><b>(iii)</b>
<b>(a)</b>
multiple outputs primarily industry established and institutionally accepted open standard formats, include amongst others: plaintext (UTF-8); html; (structured) XML; ODF (Open Document text)l; LaTeX; PDF (via LaTeX); SQL type databases (currently PostgreSQL and SQLite). Also produces: concordance files; document content certificates (md5 or sha256 digests of headings, paragraphs, images etc.) and html manifests (and sitemaps of content).

<b>(b)
</b>
takes advantage of the strengths implicit in these very different output types, (e.g. PDFs produced using typesetting of LaTeX, databases populated with documents at an individual object/paragraph level, making possible granular search (and related possibilities))</p>
<p><b>(iv)</b>
outputs share a common numbering system (dubbed "object citation numbering" (ocn)) that is meaningful (to man and machine) across various digital outputs whether paper, screen, or database oriented, (PDF, html, XML, sqlite, postgresql), this numbering system can be used to reference content.</p>
<p>
<b>(v)</b>
SQL databases are populated at an object level (roughly headings, paragraphs, verse, tables) and become searchable with that degree of granularity, the output information provides the object/paragraph numbers which are relevant across all generated outputs; it is also possible to look at just the matching paragraphs of the documents in the database; [output indexing also work well with search indexing tools like hyperesteier].</p>
<p>
<b>(vi)</b>
 use of semantic meta-tags in headers permit the addition of semantic information on documents, (the available fields are easily extended)</p>
<p>
<b>(vii)</b>
creates organised directory/file structure for (file-system) output, easily mapped with its clearly defined structure, with all text objects numbered, you know in advance where in each document output type, a bit of text will be found (e.g. from an SQL search, you know where to go to find the prepared html output or PDF etc.)... there is more; easy directory management and document associations, the document preparation (sub-)directory may be used to determine output (sub-)directory, the skin used, and the SQL database used,</p>
<p>
<b>(viii)</b>
"Concordance file" wordmap, consisting of all the words in a document and their (text/ object) locations within the text, (and the possibility of adding vocabularies),</p>
<p>
<b>(ix)</b>
document content certification and comparison considerations:
<b>(a)</b>
the document and each object within it stamped with an md5 hash making it possible to easily check or guarantee that the substantive content of a document is unchanged,
<b>(b)</b>
version control, documents integrated with time based source control system, default RCS or CVS with use of $Id$ tag, which SiSU checks
<p>
<b>(x)</b>
SiSU's minimalist markup makes for meaningful "diffing" of the substantive content of markup-files,</p>
<p>
<b>(xi)</b>
easily skinnable, document appearance on a project/site wide, directory wide, or document instance level easily controlled/changed,</p>
<p>
<b>(xii)</b>
in many cases a regular expression may be used (once in the document header) to define all or part of a documents structure obviating or reducing the need to provide structural markup within the document,</p>
<p>
<b>(xiii)</b>
prepared files may be batch process, documents produced are static files so this needs to be done only once but may be repeated for various reasons as desired (updated content, addition of new output formats, updated technology document presentations/representations)</p>
<p>
<b>(xiv)</b>
possible to pre-process, which permits: the easy creation of standard form documents, and templates/term-sheets, or; building of composite documents (master documents) from other sisu marked up documents, or marked up parts, i.e. import documents or parts of text into a main document should this be desired</p>
<p>
there is a considerable degree of future-proofing, output representations are "upgradeable", and new document formats may be added.
</p>
<p>
<b>(xv)</b>
there is a considerable degree of future-proofing, output representations are "upgradeable", and new document formats may be added:
<b>(a)</b>
modular, (thanks in no small part to Ruby) another output format required, write another module....
<b>(b)</b> easy to update output formats (eg html, XHTML, LaTeX/PDF produced can be updated in program and run against whole document set),
<b>(c)</b> easy to add, modify, or have alternative syntax rules for input, should you need to,</p>
<p>
<b>(xvi)</b>
scalability, dependent on your file-system (ext3, Reiserfs, XFS, whatever) and on the relational database used (currently Postgresql and SQLite), and your hardware,</p>
<p>
<b>(xvii)</b>
only marked up files need be backed up, to secure the larger document set produced,</p>
<p>
<b>(xviii)</b>
document management,</p>
<p>
<b>(xix)</b>
Syntax highlighting for SiSU markup is available for a number of text editors.</p>
<p><b>(xx)</b> remote operations:
<b>(a)</b>
run SiSU on a remote server, (having prepared sisu markup documents locally or on that server, i.e. this solution where sisu is installed on the remote server, would work whatever type of machine you chose to prepare your markup documents on),
<b>(b)</b>
generated document outputs may be posted by sisu to remote sites (using rsync/scp)
<b>(c)</b>
document source (plaintext utf-8) if shared on the net may be identified by its url and processed locally to produce the different document outputs.</p>
<p>
<b>(xxi)</b>
document source may be bundled together (automatically) with associated documents (multiple language versions or master document with inclusions) and images and sent as a zip file called a sisupod, if shared on the net these too may be processed locally to produce the desired document outputs, these may be downloaded, shared as email attachments, or processed by running sisu against them, either using a url or the filename.
</p>
<p>
<b>(xxii)</b>
for basic document generation, the only software dependency is Ruby, and a few standard Unix tools (this covers plaintext, html, XML, ODF, LaTeX). To use a database you of course need that, and to convert the LaTeX generated to PDF, a LaTeX processor like tetex or texlive.
</p>
<p>
as a developers tool it is flexible and extensible
</p>
<br />
<p class="small">
More information on <a href="http://www.jus.uio.no/sisu/SiSU/"><b>SiSU</b></a> provided at <a href="http://www.jus.uio.no/sisu/SiSU/">www.jus.uio.no/sisu/SiSU</a></p>
</div>
<div id="column_right">
<p class="tiny">
SiSU ("SiSU information Structuring Universe" or "Structured information, Serialized Units"),<sup>1</sup> is a Unix command line oriented framework for document structuring, publishing and search. Featuring minimalistic markup, multiple standard outputs, a common citation system, and granular search.
</p>
<p class="tiny">
 Using markup applied to a document, SiSU can produce plain text, HTML, XHTML, XML, OpenDocument, LaTeX or PDF files, and populate an SQL database with objects<sup>2</sup> (equating generally to paragraph-sized chunks) so searches may be performed and matches returned with that degree of granularity (e.g. your search criteria is met by these documents and at these locations within each document). Document output formats share a common object numbering system for locating content. This is particularly suitable for "published" works (finalized texts as opposed to works that are frequently changed or updated) for which it provides a fixed means of reference of content.
</p>

<p class="small">
How it works
</p>
<p class="tiny">
SiSU markup is fairly minimalistic, it consists of: a (largely optional) document header, made up of information about the document (such as when it was published, who authored it, and granting what rights) and any processing instructions; and markup within text which is related to document structure and typeface. SiSU must be able to discern the structure of a document, (text headings and their levels in relation to each other), either from information provided in the instruction header or from markup within the text (or from a combination of both). Processing is done against an abstraction of the document comprising of information on the document's structure and its objects,<sup>2</sup> which the program serializes (providing the object numbers) and which are assigned hash sum values based on their content. This abstraction of information about document structure, objects, (and hash sums), provides considerable flexibility in representing documents different ways and for different purposes (e.g. search, document layout, publishing, content certification, concordance etc.), and makes it possible to take advantage of some of the strengths of established ways of representing documents, (or indeed to create new ones).</p>
<p class="tiny">
<sup>1.</sup> also chosen for the meaning of the Finnish term "sisu".
</p>
<p class="tiny">
<sup>2</sup> objects include: headings, paragraphs, verse, tables, images, but not footnotes/endnotes which are numbered separately and tied to the object from which they are referenced.</p>
<p class="small">
  More information on <a href="http://www.jus.uio.no/sisu/SiSU/"><b>SiSU</b></a> provided at:
  <a href="http://www.jus.uio.no/sisu/SiSU/">
    www.jus.uio.no/sisu/SiSU
  </a>
<p class="tiny">
SiSU was developed in relation to legal documents, and is strong across a wide variety of texts (law, literature...(humanities, law and part of the social sciences)). SiSU handles images but is not suitable for formulae/ statistics, or for technical writing at this time.</p>
<p class="tiny">
SiSU has been developed and has been in use for several years. Requirements to cover a wide range of documents within its use domain have been explored.</p>
<p class="small">
<a href="mailto://ralph@amissah.com">
ralph@amissah.com
</a>
</p>
<p class="small">
<a href="mailto://ralph.amissah@gmail.com">
ralph.amissah@gmail.com
</a>
</p>
<p class="small">
#{@date.year_static}
</p>
<p class="tiny">
w3 since October 3 1993
</p>
</div>
</body>
</html>
WOK
    end
    def home_toc
      ' '
    end
  end
  class Inserts
  end
  class TeX < Skin
    def initialize(papersize='')
      @papersize=papersize
      #@vz=SiSU_Env::Get_init.instance.skin #used within skins, however pulls in much that is not otherwise needed
    end
    def a4
      def portrait
        def w
          160
        end
        def h
          228
        end
        def img_px
          450
        end
        self
      end
      def landscape
        def w
          238
        end
        def h
          160
        end
        def img_px
          348
        end
        self
      end
      self
    end
    def letter
      def portrait
        def w
          166
        end
        def h
          212
        end
        def img_px
          468
        end
        self
      end
      def landscape
        def w
          226
        end
        def h
          166
        end
        def img_px
          310
        end
        self
      end
      self
    end
    def legal
      def portrait
        def w
          168
        end
        def h
          286
        end
        def img_px
          474
        end
        self
      end
      def landscape
        def w
          296
        end
        def h
          166
        end
        def img_px
          420
        end
        self
      end
      self
    end
    def b5
      def portrait
        def w
          140
        end
        def h
          204
        end
        def img_px
          356
        end
        self
      end
      def landscape
        def w
          200
        end
        def h
          130
        end
        def img_px
          280
        end
        self
      end
      self
    end
    def a5
      def portrait
        def w
          112
        end
        def h
          162
        end
        def img_px
          280
        end
        self
      end
      def landscape
        def w
          152
        end
        def h
          100
        end
        def img_px
          230
        end
        self
      end
      self
    end
    def dimensions
      d=case @papersize
      when /a4/;     a4
      when /letter/; letter
      when /legal/;  legal
      when /b5/;     b5
      when /a5/;     a5
      else           a4
      end
    end
  end
end
__END__
