# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: texinfo formatting template

=end
module SiSU_Texinfo_format
  @@table_pg_break_counter=1
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  class Texinfo
    @@tex_backslash="\\\\"
    @@tex_1='\\\\~' #?? debug
    @@tabular="{tabular}"
    @@tex_pattern_margin_number="\\\\marginpar.+?\s+"
    @@dp=nil
    def initialize(md,t_o)
      @md,@t_o=md,t_o
      if t_o.class == Hash
        @txt =t_o[:txt]            || nil
        #@h_name =t_o[:h_name]      || nil
      #elsif t_o.class == Array
      #  @txt =txt[0]
      #elsif t_o.class == String
      #  @txt =txt
      else
        p t_o.class
        p caller
      end
      @vz=SiSU_Env::Get_init.instance.skin
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
    end
    def head
      t=Time.now
      year=t.year
      filename=%{#{@md.fns}}[/(.+?)\.\w\w\d\d$/,1]
      title=spec_char_string(@md.title)
      title=title.gsub(/<(br|p|i)>|<\/\s*(br|p|i)>|<(br|p)\s*\/>/," #{@@tex_backslash*2} ")
      title.gsub!(/\$/,"\\$")
      title.gsub!(/[,]\s*/,' - ')
      if @md.subtitle
        subtitle=spec_char_string(@md.subtitle)
        subtitle=subtitle.gsub(/<(br|p|i)>|<\/\s*(br|p|i)>|<(br|p)\s*\/>/," #{@@tex_backslash*2} ")
        subtitle.gsub!(/\$/,"\\$")
        subtitle.gsub!(/[,]\s*/,' - ')
        subtitle="@subtitle @value{VERSION}, @value{UPDATED}\n" #bugwatch
      end
      subtitle ||=''
      author=@md.author if @md.author
      author ||=''
      author.gsub!(/[\*]/,'') #if author
      v=SiSU_Env::Info_version.new.get_version
      #(version @value{VERSION} #{v[:version]}, @value{UPDATED} #{v[:date]})
      head =<<WOK
\\input texinfo   @c -*-texinfo-*-
@comment $Id$
@comment %**start of header
@setfilename #{@md.fnb}.info
@settitle #{title} @value{VERSION}
@syncodeindex pg cp
@comment %**end of header
@c %% 2
@copying
SiSU texinfo of #{title}

Copyright @copyright{} #{year} #{author}.

@quotation
Copyright #{author}, generated by ``SiSU''
@end quotation
@end copying

@dircategory SiSU Texinfo
@direntry
* sisu: SiSU texinfo file.
@end direntry
WOK
      if @md.subtitle
        titlepage=<<WOK
@c %% 3
@titlepage
@title #{title} #{subtitle}
@author #{author}
@page
@vskip 0pt plus 1filll
@insertcopying
@end titlepage
@contents
WOK
      else
        titlepage=<<WOK
@c %% 3
@titlepage
@title #{title}
@value{VERSION}, @value{UPDATED}
@author #{author}
@page
@vskip 0pt plus 1filll
@insertcopying
@end titlepage

@contents
WOK
      end
      "#{head}#{titlepage}"
    end
    def topnode
      txt=spec_char_string(@txt)
      txt=txt.gsub(/<(br|p|i)>|<\/\s*(br|p|i)>|<(br|p)\s*\/>/," #{@@tex_backslash*2} ")
      txt.gsub!(/\$/,"\\$")
      txt.gsub!(/[,]\s*/,' - ')
      "@c %% 4\n" +
        "@ifnottex\n" +
        "@node Top\n" +
        "@top #{txt}\n\n" +
        "@insertcopying\n" +
        "@end ifnottex\n\n" +
        "@menu\n"
    end
    def dublincore
      title=spec_char_string(@md.title) if @md.title
      subtitle=spec_char_string(@md.subtitle) if @md.subtitle
      full_title="#{title} - #{subtitle}"                                           #dc
      author=spec_char_string(@md.author) if @md.author                             #dc
      subject=spec_char_string(@md.subject) if @md.subject                          #dc
      description=spec_char_string(@md.description) if @md.description              #dc
      publisher=spec_char_string(@md.publisher) if @md.publisher                    #dc
      contributor=spec_char_string(@md.contributor) if @md.contributor              #dc
      date=spec_char_string(@md.date) if @md.date                                   #dc
      date_created=spec_char_string(@md.date_created) if @md.date_created           #dc
      date_issued=spec_char_string(@md.date_issued) if @md.date_issued              #dc
      date_available=spec_char_string(@md.date_available) if @md.date_available     #dc
      date_valid=spec_char_string(@md.date_valid) if @md.date_valid                 #dc
      date_modified=spec_char_string(@md.date_modified) if @md.date_modified        #dc
      type=spec_char_string(@md.type) if @md.type                                   #dc
      format=spec_char_string(@md.format) if @md.format                             #dc
      identifier=spec_char_string(@md.identifier) if @md.identifier                 #dc
      source=spec_char_string(@md.source) if @md.source                             #dc
      language=spec_char_string(@md.language[:name]) if @md.language[:name]         #dc
      #language_original=spec_char_string(@md.language_original[:name]) if @md.language_original[:name]
      relation=spec_char_string(@md.relation) if @md.relation                       #dc
      coverage=spec_char_string(@md.coverage) if @md.coverage                       #dc
      rights=spec_char_string(@md.rights) if @md.rights                             #dc
      full_title="Title: #{full_title}\n\n" if full_title                           #dc
      author="Author: #{author}\n\n" if author                                      #dc
      subject="Subject: #{subject}\n\n" if subject                                  #dc
      description="Description: #{description}\n\n" if description                  #dc
      publisher="Publisher: #{publisher}\n\n" if publisher                          #dc
      contributor="Contributor: #{contributor}\n\n" if contributor                  #dc
      date="Date: #{date}\n\n" if date                                              #dc
      date_created="Date Created: #{date_created}\n\n" if date_created              #dc
      date_issued="Date Issued: #{date_issued}\n\n" if date_issued                  #dc
      date_available="Date Available: #{date_available}\n\n" if date_available      #dc
      date_valid="Date Valid: #{date_valid}\n\n" if date_valid                      #dc
      date_modified="Date Modified: #{date_modified}\n\n" if date_modified          #dc
      format="Format: #{format}\n\n" if format                                      #dc
      identifier="Identifier: #{identifier}\n\n" if identifier #watch               #dc
      source="Source: #{source}\n\n" if source                                      #dc
      language="Language: #{language}\n\n" if language                              #dc
      relation="Relation: #{relation}\n\n" if relation                              #dc
      coverage="Coverage: #{coverage}\n\n" if coverage                              #dc
      rights="Rights: #{rights}\n\n" if rights                                      #dc
      "@node Dublin Core\n" +
        "@unnumbered Dublin Core\n" +
        "@cindex chapter, Dublin Core\n\n" +
        "#{full_title}" +
        "#{author}" +
        "#{subject}" +
        "#{description}" +
        "#{publisher}" +
        "#{contributor}" +
        "#{date}" +
        "#{date_created}" +
        "#{date_issued}" +
        "#{date_available}" +
        "#{date_valid}" +
        "#{date_modified}" +
        "#{format}" +
        "#{identifier}" +
        "#{source}" +
        "#{language}" +
        "#{relation}" +
        "#{coverage}" +
        "#{rights}" +
        "\n\n"
    end
    def tail
     "@c %% 6\n" +
      "@node Index\n" +
      "@unnumbered Index\n" +
      "@printindex cp\n\n" +
      "@bye"
    end
    def clean(para)
      para.gsub!(/#{Mx[:id_o]}\\~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/,'<\1>')
      para.gsub!(/\s*[,:]\s*/,' - ')
      para.gsub!(/<:#>/,'')
      para.strip!
      para
    end
    def menu
      para=clean(@txt)
      para=para.gsub(/@footnote\{.+?\}\s+/,'')
      "* #{para}::"
    end
    def level1
      @txt.gsub!(/#{Mx[:lv_o]}1:\S*?#{Mx[:lv_c]}\s*/,'')
      para=clean(@txt)
      nd=para.gsub(/@footnote\{.+?\}\s+/,'')
      para="@node #{nd}\n@unnumbered #{para}\n@cindex chapter, #{nd}\n"
      @txt.gsub!(/.+/,"#{para}")
    end
    def level2
      @txt.gsub!(/#{Mx[:lv_o]}2:\S*?#{Mx[:lv_c]}\s*/,'')
      para=clean(@txt)
      nd=para.gsub(/@footnote\{.+?\}\s+/,'')
      para="@node #{nd}\n@unnumbered #{para}\n@cindex chapter, #{nd}\n"
      @txt.gsub!(/.+/,"#{para}")
    end
    def level3
      @txt.gsub!(/#{Mx[:lv_o]}3:\S*?#{Mx[:lv_c]}\s*/,'')
      para=clean(@txt)
      nd=para.gsub(/@footnote\{.+?\}\s+/,'')
      #para=para.gsub(/(.+?)\s*(@footnote\{.+?\})\s*(.+)$/,"\\1 \\3\n\\2")
      #para=para.gsub(/(.+?)\s*(@footnote\{.+?\})\s*(.+)$/,'\1 \3 \2')
      para="@node #{nd}\n@unnumbered #{para}\n@cindex chapter, #{nd}\n"
      @txt.gsub!(/.+/,"#{para}")
    end
    def level4
      @txt.gsub!(/#{Mx[:lv_o]}4:\S+?#{Mx[:lv_c]}\s*/,'')
      para=clean(@txt)
      nd=para.gsub(/@footnote\{.+?\}\s+/,'')
      para="@node #{nd}\n@unnumbered #{para}\n@cindex chapter, #{nd}\n"
      @txt.gsub!(/.+/,"#{para}")
    end
    def level5
      @txt.gsub!(/#{Mx[:lv_o]}5:\S*?#{Mx[:lv_c]}\s*/,'')
      para=clean(@txt)
      nd=para.gsub(/@footnote\{.+?\}\s+/,'')
      para="@node #{nd}\n@unnumbered #{para}\n@cindex chapter, #{nd}\n"
      @txt.gsub!(/.+/,"#{para}")
    end
    def level6
      @txt.gsub!(/#{Mx[:lv_o]}6:\S*?#{Mx[:lv_c]}\s*/,'')
      para=clean(@txt)
      nd=para.gsub(/@footnote\{.+?\}\s+/,'')
      para="@node #{nd}\n@unnumbered #{para}\n@cindex chapter, #{nd}\n"
      @txt.gsub!(/.+/,"#{para}")
    end
    def submenu
      @txt=@txt.join("\n")
      @txt.gsub!(/[5]\\+~\S+/,'')
      para=clean(@txt)
      para="@menu\n#{para}\n@end menu\n\n"
      @txt.gsub!(/.+/m,"#{para}")
    end
    def subsubmenu
      @txt=@txt.join("\n")
      @txt.gsub!(/[6]\\+~\S+/,'')
      para=clean(@txt)
      para="@menu\n#{para}\n@end menu\n\n"
      @txt.gsub!(/.+/m,"#{para}")
    end
    def indent1
      @txt.gsub!(/<:i1>(.*)/,'\1')
    end
    def indent2
      @txt.gsub!(/<:i2>(.*)/,'\1')
    end
    def spec_char_string(txt) # special characters
      txt_obj={:txt =>txt}
      SiSU_Texinfo_format::Texinfo.new(@md,txt_obj).spec_char
    end
    def spec_char # special characters
      @txt.gsub!(/#{Mx[:br_eof]}/i,'')
      @txt.gsub!(/#{Mx[:gl_o]}#169#{Mx[:gl_c]}/,'(c)')
      @txt.gsub!(/#{Mx[:gl_o]}#(?:lt|060)#{Mx[:gl_c]}/,'<'); @txt.gsub!(/#{Mx[:gl_o]}(gt|#062)#{Mx[:gl_c]}/,'>')
      @txt.gsub!(/#{Mx[:gl_o]}#123#{Mx[:gl_c]}/,'{'); @txt.gsub!(/#{Mx[:gl_o]}#125#{Mx[:gl_c]}/,'}')
      @txt.gsub!(/#{Mx[:gl_o]}#(?:126|152)#{Mx[:gl_c]}/i,'~')
      @txt.gsub!(/#{Mx[:gl_o]}#033#{Mx[:gl_c]}/,'!')
      @txt.gsub!(/#{Mx[:gl_o]}#035#{Mx[:gl_c]}/,'#')
      @txt.gsub!(/#{Mx[:gl_o]}#042#{Mx[:gl_c]}/,'*')
      @txt.gsub!(/#{Mx[:gl_o]}#047#{Mx[:gl_c]}/,'/')
      @txt.gsub!(/#{Mx[:gl_o]}#095#{Mx[:gl_c]}/,'_')
      @txt.gsub!(/<sup><font face=symbol>&atild;<\/font><\/sup>/,' ')
      @txt.gsub!(/\\/,'\\backslash ')
      @txt.gsub!(/<:pb>/,'\\newpage')
      @txt.gsub!(/\\backslash copyright/,'\\copyright ')
      @txt.gsub!(/\^/,'\\wedge ')
      @txt.gsub!(/(\$)/,"\\$")
      @txt.gsub!(/\~/,'\\~')
      @txt.gsub!(/%/,"\\%")
      #if @txt !~ /^\s*<:image|\}:image\s/
      #  @txt.gsub!(/_/,'\_')
      #end
      @txt.gsub!(/_(https?:\/\/)/,'\1')
      @txt.gsub!(/§/i,'\S')
      @txt.gsub!(/£/i,'\pounds')
      @txt.gsub!(/å/i,'\aa')
      @txt.gsub!(/æ/i,'\ae')
      @txt.gsub!(/ø/i,'\o')
      @txt.gsub!(/Å/i,'\AA')
      @txt.gsub!(/Æ/i,'\AE')
      @txt.gsub!(/Ø/i,'\O')
      @txt.gsub!(/<a href=".+?">/i,' ')
      @txt.gsub!(/<\/a>/i,' ')
      @txt.gsub!(/<:ee>/i,'')
      @txt.gsub!(/<!>/i,' ')
      @txt.gsub!(/<b>(.+?)<\/b>/,'\*\1\*')
      @txt.gsub!(/<i>(.+?)<\/i>/,'\/\1\/')
      @txt.gsub!(/<u>(.+?)<\/u>/,'\_\1\_')
      @txt.gsub!(/@/i,'@@')
      @txt.gsub!(/\{/,'@{'); @txt.gsub!(/\}/,'@}')
      #@txt.gsub!(/(^|[\s*!\/#_-])\{/,'\1@{'); @txt.gsub!(/\}([\s*!\/#_-]|$)/,'@}\1')
      @txt.gsub!(/(?:&nbsp;|#{Mx[:nbsp]})+/,' ')        # ~ character for hardspace
      @txt.gsub!(/&(\S+?);/,' ')
      @txt.gsub!(/&/,'<=and>')
      @txt.gsub!(/(\s+&\s+)/,' and ')
      @txt.gsub!(/(\&)/,"\\&")
      @txt.gsub!(/"(.+?)"/,"`\\1'")                                        # open & close "
      @txt.gsub!(/\s+"/," `")                                              # open "
      @txt.gsub!(/^([1-6-]\\+(?:~\S+)?|<.+?>)?\s*"/,'\1`')       # open "
      @txt.gsub!(/"(\s|\.|,|:|;)/,"'\\1")                                  # close "
      @txt.gsub!(/"([1-6-]\\+(?:~\S+)?|<.+?>)?\s*$/,"'\\1")       # close "
      @txt.gsub!(/"(\.|,)/,"'")                                            # close "
      @txt.gsub!(/\s+'/," `")                                              # open '
      @txt.gsub!(/^([1-6-]\\+(?:~\S+)?|<.+?>)?\s*'/,'\1`')       # open '
      @txt.gsub!(/(<font.*?>|<\/font>)/,'')
      @txt.gsub!(/\s*<sup>(\S+?)<\/sup>/,'^\1')
      @txt.gsub!(/(<sup>|<\/sup>)/,'')
      @txt
    end
    def longtable
      @end_table="\\end{longtable}"
      @row_break='\\\\\\'
      if @txt[/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c(\d+);(.+?)#{Mx[:gr_c]}/ui] #CHECK !> closure
        no_of_cols,cols_width=$1,$2
        @@tableheader=1 if @txt =~ /#{Mx[:gr_o]}Th/i
        @w=cols_width.split(/;\s+/)
        @@number_of_cols=no_of_cols
        @colW=[]
        @colW << '{'
        @w.each  do |x|
          col_w=x.gsub(/.+/,'l\|') #unless x.nil?
          @colW << "#{col_w}" if col_w
        end
        @colW << '}'
        @colW=@colW.join
        @@start_table="\\setlength{\\LTleft}{0pt}\n\\setlength{\\LTright}{\\fill}\n" +
          "\\begin{longtable}[hb]#@colW\n"
        @txt.gsub!(/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c\d+?;.+#{Mx[:gr_c]}/u,"#{@@start_table}")
      end
      if @txt =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/
        @txt.gsub!(/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/," #@end_table")
      end
      @txt.gsub!(/#{Mx[:tc_o]}#{Mx[:tc_p]}/u,'')
      if @@tableheader==1
        if @txt =~/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u
          tablefoot=para[/\<!f(.+?)!\>/,1]
          @txt.gsub!(/\<!f(.+?)!\>/,'')
          @txt.gsub!(/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u,
          "{\\begin{tiny} {\\bfseries \\1}\\end{tiny}}&")
          @txt.gsub!(/&>\s*$/,
          " #@row_break \\hline\\endhead #@row_break")
          @txt="#{@txt} \\multicolumn{#{@@number_of_cols}}{l}{\\tiny #{tablefoot}} \\\\ \\hline\n\\endfoot\n\\hline\n" if tablefoot
          @@tableheader=0
          @@number_of_cols=0
        end
      else
        if @txt =~/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u
          @txt.gsub!(/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u,"\\begin{tiny}\\1\\end{tiny}&")
          @txt.gsub!(/&>\s*$/," #@row_break")
        end
      end
      @txt
    end
    def scopedtable
      # some features related to headers have been incorporated in longtable
      # that are not included yet here, so until synced is broken on some
      # input files, work needs to be done if is to work as before
      @end_table="\\end{tabular}"
      @row_break='\\\\\\\\'
      @break_page="#@row_break\n#@row_break \n"
      if @txt[/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c(\d+);(.+?)#{Mx[:gr_c]}/ui]
        no_of_cols,cols_width=$1,$2
        @w=cols_width.split(/;\s+/)
        @colW=[]
        @w.each  do |x|
          col_w=((x.to_i*12)/100.00).to_s #unless x.nil?
          @colW << "p{#{col_w}cm}" if col_w
        end
        @@start_table="\\begin{tabular}{#@colW}\n"
        @txt.gsub!(/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c\d+?;.+#{Mx[:gr_c]}/u,"#{@@start_table}")
      end
      if @txt =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/
        @txt.gsub!(/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/,"#@end_table")
        @@table_pg_break_counter=1
      end
      if @txt =~/#{Mx[:tc_o]}#{Mx[:tc_p]}/u
        if @@table_pg_break_counter==28 # taken from 34 ideal for portrait to 28 which suits landscape
          @txt =
            "\n\n#@end_table \n" +
            "#@break_page" +
            "#{@@start_table}\n"
          @@table_pg_break_counter=1
        else
          @txt.gsub!(/#{Mx[:tc_o]}#{Mx[:tc_p]}/u,'')
          @@table_pg_break_counter+=1
          tablefoot=@txt[/\<!f(.+?)!\>/]
          @txt.gsub!(/\<!f(.+?)!\>/,'')
        end
      end
      if @txt =~/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u
      @txt.gsub!(/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|!)/u,"\\begin{tiny}\\1\\end{tiny}&")
      @txt.gsub!(/&>\s*$/,"#@row_break")
      end
      @txt
    end
    def graphics
      dir=SiSU_Env::Info_env.new(@md.fns)
      @txt.gsub!(/<::\s+(\S+?)\s+>/i, #watch
        "\\includegraphics*[width=11pt]{#{dir.path.image_source_tex}/c_\\1.png}")
    end
    def image
      dir=SiSU_Env::Info_env.new(@md.fns)
      width="100"
      width=@txt[/<:image.+?width=``(\d+)''.+?>/im,1]
      width=width.to_i*0.4
      @txt.gsub!(/<:image\s+((?:https?|file|ftp)\S+)\s+(\S+)\s+.+\s+?>/i,
        "\\href{\\1}{\\includegraphics*[width=#{width}pt]{#{dir.path.image_source_tex}/\\2}}")
      @txt.gsub!(/<:image\s+(\S+)\s+.+\s+?>/i,
        "\\includegraphics*[width=#{width}pt]{#{dir.path.image_source_tex}/\\1}")
    end
    def png
      # very messy clean up ! - work area, testing
      z=@txt[/\\\{(.+?)\}(?:image|png)/,1] # match operator for z \\ fragile !
      image,w,x,y=z.scan(/\S+/)
      image.gsub!(/\\/,'')
      @txt.gsub!(/\\\{\S+\.(png|jpg|gif).+?\}(image|png)/,"<image #{image} not available>")  # fragile match operator\\ fragile !
    end
    def http
      # very messy clean up ! - work area, testing
      z=@txt[/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}(?:https?|file|ftp):\/\//,1] # match operator for z \\ fragile !
      url=@txt[/((?:https?|file|ftp):\S+)/im,1]
      if @txt =~/\.(png|jpg|gif)/
        image,w,x,y=z.scan(/\S+/)
        image.gsub!(/\\/,'')
        width=200
        width=z[/w=(\d+)/im,1] if z =~/w=(\d+)/
        width=width.to_i*0.8
        width=400 if width > 400
        c=z[/``(.+?)''/im,1]
        caption="{\\\\\\\ \n\\begin{scriptsize}#{c}\\end{scriptsize}&}" if c
      end
      if image
        dir=SiSU_Env::Info_env.new(@md.fns)
        @txt.gsub!(/#{Mx[:lnk_o]}\S+\.(png|jpg|gif).+?#{Mx[:lnk_c]}(?:https?|file|ftp):\/\/\S+/, # fragile match operator\\ fragile !
          "\n\\href{#{url}}{\\includegraphics*[width=#{width}pt]{#{dir.path.image_source_tex}/#{image}}}#{caption}")
      else
        link=z[/(.+?)\\/im,1]
        @txt.gsub!(/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}(?:https?|file|ftp):\/\/\S+/,"\n\\noindent\\href{#{url}}{#{link}}")  # fragile match operator\\ fragile !
      end
    end
  end
end
__END__
watch title, might need full_title
