# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: opendocument formatting, default opendocument template

=end
module SiSU_ODF_format
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  class Paragraph_number
    def initialize(paranum)
      @paranum=/(\d+)/m.match(paranum)[1]
    end
    def display
      @paranum.gsub(/(\d+)/,'<font size="1" color="#777777">&nbsp;&nbsp;\1</font>')
    end
    def name
      @paranum.gsub(/(\d+)/,'<a name="\1"></a>')
    end
    def goto
      @paranum.gsub(/(\d+)/,'<a href="#\1">')
    end
  end
  class Format_text_object
    @@dp=nil
    def initialize(md,t_o)
      @md,@t_o=md,t_o
      if t_o.class == Hash
        @txt =t_o[:txt]            || nil
      #elsif t_o.class == Array
      #  @txt =txt[0]
      #elsif t_o.class == String
      #  @txt =txt
      else
        #@one,@two,@three=one,two,three
        p t_o.class
        p caller
      end
      rgx=/^#{Mx[:lv_o]}[1-6-]:/
      @txt.gsub!(rgx,'') if @txt =~rgx
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
      rgx=/#{Mx[:en_a_o]}\d+\s+(.+?)#{Mx[:id_o]}#@dp#{Mx[:id_c]}#{Mx[:en_a_c]}/
      @txt.gsub!(rgx,'\1') if @txt =~rgx
      @vz=SiSU_Env::Get_init.instance.skin
    end
    def scr_endnote_body
      "<endnote>#@txt</endnote> "
    end
    def heading_body1
      #%{<text:h text:style-name="Heading_20_1" text:outline-level="1">#@two</text:h>}
    end
    def heading_body2
      #%{<text:h text:style-name="Heading_20_2" text:outline-level="2">#@two</text:h>}
    end
    def heading_body3
      #%{<text:h text:style-name="Heading_20_3" text:outline-level="3">#@two</text:h>}
    end
    def heading_body4
      #%{<text:h text:style-name="Heading_20_4" text:outline-level="4">#@two</text:h>}
    end
    def heading_body5
      #%{<text:h text:style-name="Heading_20_5" text:outline-level="5">#@two</text:h>}
    end
    def heading_body6
      #%{<text:h text:style-name="Heading_20_6" text:outline-level="6">#@two</text:h>}
    end
  end
  class Table
    @@tablehead,@@table_counter=0,0 #reinitialise on new file
    @@tablefoot=[] #watch
    @@fns=''
    @@dp=nil
    def initialize(md,t_o)
      @md,@t_o,@vz=md,t_o,SiSU_Env::Get_init.instance.skin
      if t_o.class == Hash
        @txt   =t_o[:txt]   || nil
        @table =t_o[:table] || nil
      #elsif t_o.class == Array
      #  @txt =txt[0]
      #elsif t_o.class == String
      #  @txt =txt
      else
        if @md.cmd =~/M/
          p t_o.class
          p caller
        end
      end
      if @md.fns != @@fns
        @@table_counter=0
        @@fns=@md.fns
        @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
      end
    end
    def table_head(count,col,h=false)
      type=if h; 1
      else       2
      end
      alpha=case col.to_i
      when  1; 'A'
      when  2; 'B'
      when  3; 'C'
      when  4; 'D'
      when  5; 'E'
      when  6; 'F'
      when  7; 'G'
      when  8; 'H'
      when  9; 'I'
      when 10; 'J'
      when 11; 'K'
      when 12; 'L'
      when 13; 'M'
      when 14; 'N'
      else     'D'
      end
      %{<table:table table:name="Table#{count}" table:style-name="Table#{type}">#@br} +
      %{<table:table-column table:style-name="Table#{type}.#{alpha}" table:number-columns-repeated="#{col}"/>#@br}
    end
    def table_end(tablefoot='')
      '</table:table>'
    end
    def table_row(inf,h=false)
      if h; %{<table:table-row>#@br} +
        %{<table:table-cell office:value-type="string">#@br} +
        %{<text:p text:style-name="Table_20_Heading">#@br}
      else %{<table:table-row>#@br} +
        %{<table:table-cell office:value-type="string">#@br} +
        %{<text:p text:style-name="P7">#@br}
      end
    end
    def table_cell(inf,h=false)
      if h; %{</text:p>#@br} +
        %{</table:table-cell>#@br} +
        %{<table:table-cell office:value-type="string">#@br} +
        %{<text:p text:style-name="Table_20_Heading">#@br}
      else %{</text:p>#@br} +
        %{</table:table-cell>#@br} +
        %{<table:table-cell office:value-type="string">#@br} +
        %{<text:p text:style-name="P7">#@br}
      end
    end
    def table_row_close(h=false)
      %{</text:p>#@br} +
      %{</table:table-cell>#@br} +
      %{</table:table-row>#@br}
    end
    def table
      @txt='' if @txt =~/^<!$/
      @txt.gsub!(/#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}/,'')
      m=@txt[/<!f(.+?)!>/,1]
      @@tablefoot << m if m
      @txt.gsub!(/<!f.+?!>/,'')
      @@tablehead=1 if @txt =~/#{Mx[:gr_o]}Th#{Mx[:tc_p]}/u
      @@table_counter+=1  if @txt =~/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}/u
      if @txt =~/#{Mx[:gr_o]}Th#{Mx[:tc_p]}\s+c(\d+).+?#{Mx[:tc_p]}~\d+;\w\d+;\w\d+#{Mx[:gr_c]}/u; @txt=table_head(@@table_counter,$1,true)
      elsif @txt =~/#{Mx[:gr_o]}T#{Mx[:tc_p]}\s+c(\d+).+?#{Mx[:tc_p]}~\d+;\w\d+;\w\d+#{Mx[:gr_c]}/u; @txt=table_head(@@table_counter,$1)
      end
      if @txt =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/
        tablefoot=[]
        @@tablefoot.each {|x| tablefoot << ''}
        @@tablefoot=[]
        if @txt =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/; @txt=table_end
        end
      end
      if @@tablehead == 1
        if @txt =~/#{Mx[:tc_p]}#{Mx[:tc_p]}/u
          if @txt =~/#{Mx[:tc_o]}#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u
            @txt.gsub!(/#{Mx[:tc_o]}#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u,table_row($1,true))
          end
          if @txt =~/#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u
            @txt.gsub!(/#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u,table_cell($1,true))
          end
          if @txt =~/#{Mx[:tc_c]}/
            @txt.gsub!(/#{Mx[:tc_c]}/,table_row_close(true))
          end
          @@tablehead=0
        end
        @txt
      else
        if @txt =~/#{Mx[:tc_o]}#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u
          @txt.gsub!(/#{Mx[:tc_o]}#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u,table_row($1))
        end
        if @txt =~/#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u
          @txt.gsub!(/#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u,table_cell($1))
        end
        if @txt =~/#{Mx[:tc_c]}/
          @txt.gsub!(/#{Mx[:tc_c]}/,table_row_close)
        end
        @txt
      end
      @txt
    end
    def table_split
      @new_content=[]
      @table.split(/\s*#{Mx[:tc_o]}/).each do |parablock|
        table=if parablock =~/#{Mx[:gr_o]}/
          txt_obj={:txt =>parablock}
          Table.new(@md,txt_obj)
        else
          txt_obj={:txt =>"#{Mx[:tc_o]}#{parablock}"}
          Table.new(@md,txt_obj)
        end
        @new_content << table.table
      end
      @new_content.join
    end
  end
  class XML
  end
end
__END__
