# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2011, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_insertions
  class Insertions
    def initialize(md,data)
      @md,@data=md,data
    end
    def output_filetypes_in_cmd(cmd_shortcut,source=nil) #make list of file types in shortcut command (as configured), e.g. when sisu -3 is used
      cf_defaults=SiSU_Env::Info_processing_flag.new
      cmd_list=case cmd_shortcut.inspect
      when /0/; cf_defaults.cf_0
      when /1/; cf_defaults.cf_1
      when /2/; cf_defaults.cf_2
      when /3/; cf_defaults.cf_3
      when /4/; cf_defaults.cf_4
      when /5/; cf_defaults.cf_5
      end
      file_type_names={}
      file_type_names[:gen],file_type_names[:src]=[],[]
      file_type_names[:gen] <<= if cmd_list =~ /y/; 'sisu_manifest.html'
      end
      file_type_names[:gen] <<= if cmd_list =~ /h/; ['toc.html', 'doc.html']
      end
      file_type_names[:gen] <<= if cmd_list =~ /e/; ['.epub']
      end
      file_type_names[:gen] <<= if cmd_list =~ /p/; ['landscape.pdf', 'portrait.pdf']
      end
      file_type_names[:gen] <<= if cmd_list =~ /o/; 'opendocument.odt'
      end
      file_type_names[:gen] <<= if cmd_list =~ /b/; 'scroll.xhtml'
      end
      file_type_names[:gen] <<= if cmd_list =~ /x/; 'sax.xml'
      end
      file_type_names[:gen] <<= if cmd_list =~ /X/; 'dom.xml'
      end
      file_type_names[:gen] <<= if cmd_list =~ /a/; 'plain.txt'
      end
      file_type_names[:gen] <<= if cmd_list =~ /g/; 'wiki.txt'
      end
      file_type_names[:gen] <<= if cmd_list =~ /w/; 'concordance.html'
      end
      file_type_names[:gen] <<= if cmd_list =~ /N/; 'digest.txt'
      end
      file_type_names[:src] <<= if source and cmd_shortcut =~ /s/; source
      end
      file_type_names[:src] <<= if cmd_shortcut =~ /S/; "#{source}.zip"
      end
      file_type_names[:gen]=file_type_names[:gen].flatten
      file_type_names[:src]=file_type_names[:src].flatten
      file_type_names
    end
    def expand_insertions?
      data=@data
      tuned_file,tuned_file_tmp=[],[]
      data.each do |para|
        if para !~/^%+\s/ \
        and para =~/\{(?:~\^\s+)?(.+?)\s\[(?:\d(?:[sS]*))\]\}(?:\.\.\/\S+?\/|\S+?\.ss[tm]\b)/
          txt,cmd,source,url_dir,note,manifest=nil,nil,nil,nil,nil,nil
          @u=SiSU_Env::Info_env.new.url
          if defined? @u.remote
            if para =~/(.+?)\{(.+?)\s\[(\d[sS]*)\]\}((\S+?)\.ss[tm]\b)(.*)/m
              pre,txt,cmd,source,url_dir,note="#{$1.strip} ",$2,$3,$4,$5,$6
            elsif para =~/\{(.+?)\s\[(\d[sS]*)\]\}((\S+?)\.ss[tm]\b)(.*)/
              pre,txt,cmd,source,url_dir,note='',$1,$2,$3,$4,$5
            end
            manifest="#{pre}{#{txt} }#{@u.remote}/#{url_dir}/toc.html#{note}\n\n"
          else
            puts "error, does currently support relative paths (reltive paths were removed, as had problems for citation, and was not suited to all output types should possibly reconsider) #{__FILE__} #{__LINE__}"
            if para =~/\{(?:~\^\s+)?(.+?)\s\[(\d[sS]*)\]\}\.\.\/(\S+?)\/(\s+#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]})?/
              txt,cmd,url_dir,note=$1,$2,$3,$4
              manifest="{ #{txt} }../#{url_dir}/toc.html#{note}\n\n"
            end
          end
          tuned_file_tmp << manifest
          output_filetypes=output_filetypes_in_cmd(cmd,source)
          output_filetypes[:gen].each do |o_f|
            describe = case o_f
            when /sisu_manifest.html/; "~^ { document manifest }#{@md.file.output_path.manifest.url}/#{@md.file.base_filename.manifest}"
            when /toc.html/;           " { html, segmented text }#{@md.file.output_path.html_seg.url}/#{@md.file.base_filename.html_segtoc}"
            when /doc.html/;           " { html, scroll, document in one }#{@md.file.output_path.html_scroll.url}/#{@md.file.base_filename.html_scroll}"
            when /\.epub/;             " { epub }#{@md.file.output_path.epub.url}/#{@md.file.base_filename.epub}"
            when /landscape.pdf/;      " { pdf, landscape }#{@md.file.output_path.pdf.url}/#{@md.file.base_filename.pdf_l_a4}" #chose a default pdf
            when /portrait.pdf/;       " { pdf, portrait }#{@md.file.output_path.pdf.url}/#{@md.file.base_filename.pdf_p_a4}" #chose a default pdf
            when /opendocument.odt/;   " { odf:odt, open document text }#{@md.file.output_path.odt.url}/#{@md.file.base_filename.odt}"
            when /scroll.xhtml/;       " { xhtml scroll }#{@md.file.output_path.xhtml.url}/#{@md.file.base_filename.xhtml}"
            when /sax.xml/;            " { xml, sax }#{@md.file.output_path.xml_sax.url}/#{@md.file.base_filename.xml_sax}"
            when /dom.xml/;            " { xml, dom }#{@md.file.output_path.xml_dom.url}/#{@md.file.base_filename.xml_dom}"
            when /plain.txt/;          " { plain text utf-8 }#{@md.file.output_path.txt.url}/#{@md.file.base_filename.txt}"
            #when /manpage.1/;          " man, 1"
            when /concordance.html/;   " { concordance }#{@md.file.output_path.html_concordance.url}/#{@md.file.base_filename.html_concordance}"
            when /digest.txt/;         " { dcc, document content certificate (digests) }#{@md.file.output_path.hash_digest.url}/#{@md.file.base_filename.hash_digest}"
            else nil
            end
            if describe
              tuned_file_tmp << if @u.remote #to double space <:br> at beginning of entry
                "#{Mx[:nbsp]*4} #{describe} "
              else # remove ...
                "[provide document placement host location]"
              end
            end
          end
          output_filetypes[:src].each do |o_f|
            describe=case o_f
            when /#{source}\.zip/;     " { markup source (zipped) pod }#{@md.file.output_path.sisupod.url}/#{@md.file.base_filename.sisupod}"
            when /#{source}/;          " { markup source text }#{@md.file.output_path.src.url}/#{@md.file.base_filename.src}"
            else nil
            end
            if describe
              tuned_file_tmp << if @u.remote
                "#{Mx[:nbsp]*4} #{describe} "
              else
                "[provide document placement host location]"
              end
            end
          end
          tuned_file << 'group{' << tuned_file_tmp.join("\n") << '}group'
          tuned_file_tmp=[]
        else tuned_file << para
        end
      end
      tuned_file
    end
  end
end
__END__
