# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/se_info_system.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_Info_Sys_Gen
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  class InfoSystemGen
    begin
      require 'rbconfig'
    rescue LoadError
      SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).error('rbconfig NOT FOUND (LoadError)')
    end
    @@user,       @@home,     @@hostname,     @@pwd,     @@sisu_etc,                            @@host,                @@arch,                @@rbver,          @@dir_arch,               @@dir_sitearch,               @@dir_bin,               @@locale,                @@rc,@@sisurc_path,@@ad=
      ENV['USER'],ENV['HOME'],ENV['HOSTNAME'],ENV['PWD'],Config::CONFIG['sysconfdir'] + '/sisu',Config::CONFIG['host'],Config::CONFIG['arch'],%x{ruby -v}.strip,Config::CONFIG['archdir'],Config::CONFIG['sitearchdir'],Config::CONFIG['bindir'],%x{locale charmap}.strip,nil, nil,          {} # %x{ruby -v}.strip # Config::CONFIG['rb_ver']
    out=Config::CONFIG['localstatedir']
    etc=Config::CONFIG['sysconfdir'] + '/sisu'
    share=Config::CONFIG['datadir']  + '/sisu'
    data=Config::CONFIG['datadir']   + '/doc/sisu'
    m=/.+\/(?:src\/)?(\S+)/m # m=/.+?\/(?:src\/)?([^\/]+)$/im # m=/.+\/(\S+)/m
    @stub_pwd ||=@@pwd[m,1]
    @base_markup_dir_stub=SiSU_Utils::Path.new.base_markup_stub
    prcss_dir='_sisu_processing_' + '.' + SiSU_is[:version_dir]
    prcss_dir_tmp_root="/tmp/#{prcss_dir}"
    prcss_dir_stub="#{prcss_dir}/#{@stub_pwd}"
    if @@user
      tmp_processing="#{prcss_dir_tmp_root}/#{@@user}/#{@base_markup_dir_stub}"
      tmp_processing_individual="#{prcss_dir_tmp_root}/#{@@user}/#{@base_markup_dir_stub}"
    else #error
      tmp_processing=tmp_processing_individual="/tmp/#{prcss_dir_stub}"
    end
    processing_pth=tmp_processing_individual
    processing_dir=prcss_dir
    processing_git="#{Dir.pwd}/#{Gt[:grotto]}"
    #user=ENV['USER']
    port_pgsql=if defined? ENV['PGPORT'] \
    and not (ENV['PGPORT'].nil? \
    || ENV['PGPORT'].empty?) \
    and ENV['PGPORT']=~/^\d+$/
      ENV['PGPORT']
    else '5432'
    end
    IMAGES=:images
    SISU_ETC=:sisu_etc
    SISU_SHARE=:sisu_share
    SAMPLE_DATA_PATH=:sample_data_path
    IMAGE_STUB=:image_stub
    STYLESHEET_STUB=:stylesheet_stub
    IMAGE_LOCAL=:image_local
    WEBSERV_PATH=:webserv_path
    WEBSERV_MAN=:webserv_man
    WEBSERV_PHP=:webserv_php
    WEBSERV_CGI=:webserv_cgi
    WEBSERV_RSS=:webserv_rss
    WEBSERV_SQLITE=:webserv_sqlite
    OUTPUT_LOCAL=:output_local
    PROCESSING_DIR=:processing_dir
    PROCESSING_PATH=:processing_path
    PROCESSING_DIR_TMP_ROOT=:processing_dir_tmp_root
    PROCESSING_PATH_TMP_BASE=:processing_path_tmp_base
    PROCESSING_AO=:processing_ao
    PROCESSING_TUNE=:processing_tune
    PROCESSING_LATEX=:processing_latex
    PROCESSING_TEXINFO=:processing_texinfo
    PROCESSING_LOUT=:processing_lout
    PROCESSING_SQLITE=:processing_sqlite
    PROCESSING_POSTGRESQL=:processing_postgresql
    PROCESSING_ENCODING=:processing_encoding
    PROCESSING_GIT=:processing_git
    PAPERSIZE=:papersize
    #LANGUAGE=:language
    #LANGUAGE_CODE=:language_code
    MULTILINGUAL=:multilingual
    BUNDLE=:bundle
    CONCORD_MAX=:concord_max
    DIGEST=:digest
    WEBSERV_HOST_CGI=:webserv_host_cgi
    WEBSERV_PORT_CGI=:webserv_port_cgi
    POSTGRESQL_USER=:postgresql_user
    POSTGRESQL_PORT=:postgresql_port
    SQLITE_USER=:sqlite_user
    SQLITE_PATH=:sqlite_path
    SQLITE_PORT=:sqlite_port
    DEFAULT_DIR={
      IMAGES =>                   '_sisu/image',
      SISU_ETC =>                 etc,
      SISU_SHARE =>               share,
      SAMPLE_DATA_PATH =>         data,
      IMAGE_STUB =>               '_sisu/image',
      STYLESHEET_STUB =>          '_sisu/css',
      IMAGE_LOCAL =>              @@pwd + '/_sisu/image',
      WEBSERV_PATH =>             out + '/www',
      #WEBSERV_DIR =>             www, # uncomment for urls...
      #WEBSERV_IMAGE =>            out + '/www/_sisu/image',
      WEBSERV_MAN =>              out + '/www/man', #alter
      WEBSERV_PHP =>              out + '/www/php',
      WEBSERV_CGI =>              '/usr/lib/cgi-bin',
      WEBSERV_RSS =>              out + '/www/feed',
      WEBSERV_SQLITE =>           out + '/www/sqlite',
      OUTPUT_LOCAL =>             @@home + '/sisu_www',
      PROCESSING_DIR =>           processing_dir,
      PROCESSING_PATH =>          processing_pth,
      PROCESSING_DIR_TMP_ROOT  => prcss_dir_tmp_root,
      PROCESSING_PATH_TMP_BASE => processing_pth,
      PROCESSING_AO =>            'ao',
      PROCESSING_TUNE =>          'tune',
      PROCESSING_LATEX =>         'tex',
      PROCESSING_TEXINFO =>       'texinfo',
      PROCESSING_SQLITE =>        'sqlite',
      PROCESSING_POSTGRESQL=>     'postgresql',
      PROCESSING_ENCODING =>      'encoding',
      PROCESSING_GIT =>           processing_git,
      #TEXINFO_STUB =>             'texinfo',
      PAPERSIZE =>                'A4', #A4, US_letter, book_b5, book_a5, US_legal
      #LANGUAGE =>                 'English',
      #LANGUAGE_CODE =>            'en', #change, unecessary duplication though currently used
      MULTILINGUAL =>             false,
      BUNDLE =>                   false,
      CONCORD_MAX =>              260000,
      DIGEST =>                   :sha256,
      WEBSERV_HOST_CGI =>         'http://localhost',
      WEBSERV_PORT_CGI =>         8081, #8111,8123,8081
      POSTGRESQL_USER =>          @@user, #'ralph', # change user !!!
      POSTGRESQL_PORT =>          port_pgsql,
      #POSGRESQL_LINKS_PATH =>    '',
      SQLITE_USER =>              @@user,
      SQLITE_PATH =>              @@user, #??
      SQLITE_PORT =>              '**',
    }
    @@default_dir=DEFAULT_DIR
    m=/.+\/(?:src\/)?(\S+)/m # m=/.+?\/(?:src\/)?([^\/]+)$/im # m=/.+\/(\S+)/m
    @@pwd=@pwd=SiSU_Utils::Path.new.base_markup
    attr_accessor :user,:home,:hostname,:pwd,:host,:arch,:rbver,:dir_arch,:dir_sitearch,:dir_bin,:locale,:webserv_path,:webserv_host_cgi,:webserv_port_cgi,:default_dir,:rc_path,:ad_path
    def initialize
      @user,   @home, @hostname, @pwd, @sisu_etc, @host, @arch, @rbver, @dir_arch, @dir_sitearch, @dir_bin, @locale, @default_dir=
        @@user,@@home,@@hostname,@@pwd,@@sisu_etc,@@host,@@arch,@@rbver,@@dir_arch,@@dir_sitearch,@@dir_bin,@@locale,@@default_dir
      #note rbver is duplicated in InfoVersion
    end
  end
end
module SiSU_Info_Sys
  class InfoSystem < SiSU_Info_Sys_Gen::InfoSystemGen
    include Singleton
    def initialize
      super()
    end
  end
end
__END__
