# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v6/db_drop.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
    sqlite

=end
module SiSU_DbDrop
  class Drop
    require_relative 'response'                          # response.rb
    def initialize(opt,conn,db_info,sql_type)
      @opt,@conn,@db_info,@sql_type=opt,conn,db_info,sql_type
      @ans=SiSU_Response::Response.new
      case @sql_type
      when :sqlite
        cascade=''
      else
        cascade='CASCADE'
      end
      @drop_table=[
        "DROP TABLE metadata_and_text #{cascade};",
        "DROP TABLE doc_objects #{cascade};",
        "DROP TABLE urls #{cascade};",
        "DROP TABLE endnotes #{cascade};",
        "DROP TABLE endnotes_asterisk #{cascade};",
        "DROP TABLE endnotes_plus #{cascade};",
      ]
    end
    def drop
      def tables                                                              #% drop all tables
        begin
          msg_sqlite="as not all disk space is recovered after dropping the database << #{@db_info.sqlite.db} >>, you may be better off deleting the file, and recreating it as necessary"
          case @sql_type
          when :sqlite
            puts msg_sqlite
            ans=@ans.response?('remove sql database?')
            if ans \
            and File.exist?(@db_info.sqlite.db)
              @conn.close
              File.unlink(@db_info.sqlite.db)
              db=SiSU_Env::InfoDb.new
              conn=db.sqlite.conn_sqlite3
              sdb=SiSU_DbDBI::Create.new(@opt,conn,@db_info,@sql_type)
              sdb_index=SiSU_DbDBI::Index.new(@opt,conn,@db_info,@sql_type)
              sdb.output_dir?
              begin
                sdb.create_db
                sdb.create_table.metadata_and_text
                sdb.create_table.doc_objects
                sdb.create_table.endnotes
                sdb.create_table.endnotes_asterisk
                sdb.create_table.endnotes_plus
                sdb.create_table.urls
                sdb_index.create_indexes
              rescue
                SiSU_Errors::Rescued.new($!,$@,'-D').location do
                  __LINE__.to_s + ':' + __FILE__
                end
                sdb.output_dir?
              end
              exit
            else
              @conn.transaction
              @drop_table.each do |d|
                begin
                  @conn.exec_params(d)
                rescue
                  next
                end
                end
              @conn.commit
            end
          when :pg
            @conn.transaction
            @drop_table.each do |d|
              begin
                @conn.exec_params(d)
              rescue
                next
              end
            end
            @conn.commit
          end
        rescue
          case @sql_type
          when :sqlite
            ans=@ans.response?('remove sql database?')
            if ans and File.exist?(@db_info.sqlite.db); File.unlink(@db_info.sqlite.db)
            end
          else
            @drop_table.each do |d|
              begin
                @conn.exec_params(d)
              rescue
                next
              end
            end
          end
        ensure
        end
      end
      def indexes
        def conn_execute_array(sql_arr)
          @conn.transaction do |conn|
            sql_arr.each do |sql|
              begin
                conn.exec_params(sql)
              rescue
                next
              end
            end
          end
        end
        def base                                                             #% drop base indexes
          print "\n          drop documents common indexes\n" unless @opt.act[:quiet][:set]==:on
          sql_arr=[
            %{DROP INDEX idx_title;},
            %{DROP INDEX idx_author;},
            %{DROP INDEX idx_filename;},
            %{DROP INDEX idx_topics;},
            %{DROP INDEX idx_ocn;},
            %{DROP INDEX idx_digest_clean;},
            %{DROP INDEX idx_digest_all;},
            %{DROP INDEX idx_lev0;},
            %{DROP INDEX idx_lev1;},
            %{DROP INDEX idx_lev2;},
            %{DROP INDEX idx_lev3;},
            %{DROP INDEX idx_lev4;},
            %{DROP INDEX idx_lev5;},
            %{DROP INDEX idx_lev6;},
            %{DROP INDEX idx_endnote_nr;},
            %{DROP INDEX idx_digest_en;},
            %{DROP INDEX idx_endnote_nr_asterisk;},
            %{DROP INDEX idx_endnote_asterisk;},
            %{DROP INDEX idx_digest_en_asterisk;},
            %{DROP INDEX idx_endnote_nr_plus;},
            %{DROP INDEX idx_endnote_plus;},
            %{DROP INDEX idx_digest_en_plus},
          ]
          conn_execute_array(sql_arr)
        end
        def text                                                             #% drop TEXT indexes, sqlite
          print "\n          drop documents TEXT indexes\n" unless @opt.act[:quiet][:set]==:on
          sql_arr=[
            %{DROP INDEX idx_clean;},
            %{DROP INDEX idx_endnote},
          ]
          conn_execute_array(sql_arr)
        end
        self
      end
      indexes.base
      @opt.act[:psql][:set]==:on ? '' : indexes.text
      self
    end
  end
end
__END__
