#===========================================================================
# almost straight from the HTML::Filter pod doc! Thanks to Gisle Aas for
# writing this.

package Sitescooper::StripTablesFilter;

use HTML::Filter;
use HTML::Parser;

BEGIN {
  @ISA = qw(HTML::Filter);
}

sub set_main {
  my ($self, $scoop) = @_;
  $self->{scoop} = $scoop;
}

sub start {
  my $self = shift;

  if ($_[0] eq "td") {
    if (!defined ($self->{td_strip})) { $self->{td_strip} = 0; }

    if ($self->{td_strip}) {
      $self->{td_strip}++;

    } elsif (defined (${_[1]}{'width'})) {
      my $width = ${_[1]}{'width'};
      my $omit = 0;

      if ($width =~ /^(\d+)%$/i) {
	if ($1+0 < 40) { $omit = 1; }
      } elsif ($width =~ /^(\d+)$/i) {
	if ($1+0 < 250) { $omit = 1; }
      }
      # note: there can also be "*" it seems
      if ($omit) {
	$self->{scoop}->dbg ("table item ".$_[3]." omitted");
	$self->{td_strip}++;
      }
    }
  }

  $self->SUPER::start(@_);
}

sub end {
  my $self = shift;
  $self->SUPER::end(@_);

  if (defined $_[0] && $_[0] eq "td") {
    if (defined $self->{td_strip} && $self->{td_strip} > 0)
    		{ $self->{td_strip}--; }
  }
}

sub output {
  my $self = shift;

  if (!defined $self->{td_strip} || $self->{td_strip} == 0) {
    push(@{$self->{fhtml}}, $_[0]);
  }
}

sub filtered_html {
  my $self = shift;
  if (!defined ${$self->{fhtml}}[0]) {
    "";
  } else {
    join("", @{$self->{fhtml}});
  }
}

1;

