#ifndef _SJOG_DEBUG_H
#define _SJOG_DEBUG_H 1

#include <unistd.h>
#include <stdio.h>

#ifdef DEBUG

#define D(fmt, args...) \
{ \
  if (debug) \
    { \
      printf("%s +%u %s() ",__FILE__,__LINE__,__FUNCTION__); \
      printf(fmt, ## args); \
    } \
}

#define D_ENTER \
{ \
  if (debug) \
    { \
      printf("%s +%u %s() ENTER\n",__FILE__,__LINE__,__FUNCTION__); \
    } \
}

#else
#define D(fmt, args...)
#define D_ENTER
#endif

#endif
