/* Public domain. */

/* MT-unsafe */

#include "stralloc.h"
#include "dns.h"

int dns_ip4b (stralloc *out, char const *fqdn, unsigned int fqdnlen)
{
  char *q = 0 ;
  unsigned int i = 0 ;
  char code = 0 ;

  if (!stralloc_ready(out, 8)) return -1 ;
  out->len = 0 ;
  for (; i <= fqdnlen ; i++)
  {
    char ch ;
    if (i < fqdnlen) ch = fqdn[i] ;
    else ch = '.' ;
    if ((ch == '[') || (ch == ']')) continue ;
    if (ch == '.')
    {
      if (!stralloc_catb(out, &code, 1)) goto err ;
      code = 0 ;
      continue ;
    }
    if ((ch >= '0') && (ch <= '9'))
    {
      code *= 10 ;
      code += ch - '0' ;
      continue ;
    }

    if (!dns_domain_fromdot(&q, fqdn, fqdnlen)) return -1 ;
    if (dns_resolve(q, DNS_T_A) == -1) goto err ;
    if (dns_ip4_packet(out, dns_resolve_tx.packet, dns_resolve_tx.packetlen) == -1)
    {
      dns_transmit_free(&dns_resolve_tx) ;
      goto err ;
    }
    dns_transmit_free(&dns_resolve_tx) ;
    dns_domain_free(&q) ;
    return 0 ;
  }
  out->len &= ~3 ;
  dns_domain_free(&q) ;
  return 0 ;

err:
  dns_domain_free(&q) ;
  return -1 ;
}
