/* Public domain. */

#ifndef DNS_TRANSMIT_H
#define DNS_TRANSMIT_H

#include "tai.h"
#include "iopause.h"
#include "gen_alloc.h"
#include "stralloc.h"


 /* DNS packet transmission, async primitives */

struct dns_transmit
{
  char *query ; /* 0, or dynamically allocated */
  unsigned int querylen ;
  char *packet ; /* 0, or dynamically allocated */
  unsigned int packetlen ;
  int s1 ; /* 0, or 1 + an open file descriptor */
  int tcpstate ;
  unsigned int udploop ;
  unsigned int curserver ;
  struct taia deadline ;
  unsigned int pos ;
  char const *servers ;
  char localip[4] ;
  char qtype[2] ;
} ;

#define DNS_TRANSMIT_ZERO {0, 0, 0, 0, 0, 0, 0, 0, TAIA_ZERO, 0, 0, "\0\0\0", "\0"}

extern int dns_transmit_start (struct dns_transmit *, char const *, int, char const *, char const *, char const *) ;
extern void dns_transmit_free (struct dns_transmit *) ;
extern void dns_transmit_io (struct dns_transmit *, iopause_fd *, struct taia *) ;
extern int dns_transmit_get (struct dns_transmit *, iopause_fd const *, struct taia const *) ;


 /* DNS resolution, sync primitives */

struct dns_rcip_info
{
  unsigned int uses ;
  struct taia deadline ;
  char ip[64] ;
} ;

#define DNS_RCIP_INFO_ZERO { 0, TAIA_ZERO, "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0" }

extern struct dns_rcip_info dns_rcip_info_here ;
extern int dns_resolvconfip (char *) ;
extern int dns_resolvconfipit (struct dns_rcip_info *) ;
extern int dns_resolvconfipit_tmp (struct dns_rcip_info *, stralloc *) ;

extern struct dns_transmit dns_resolve_tx ;
extern int dns_resolve (char const *, char const *) ;
extern int dns_resolve_r_tmp (char const *, char const *, struct dns_transmit *, struct dns_rcip_info *, stralloc *) ;

extern int dns_ip4 (stralloc *, stralloc const *) ;
extern int dns_ip4b (stralloc *, char const *, unsigned int) ;
extern int dns_name4 (stralloc *, char const *) ;
extern int dns_txt (stralloc *, stralloc const *) ;
extern int dns_mx (stralloc *, stralloc const *) ;


 /* Rewriting rules and resolution with qualification */

struct dns_rcrw_info
{
  unsigned int uses ;
  struct taia deadline ;
  stralloc rules ;
} ;

#define DNS_RCRW_INFO_ZERO { 0, TAIA_ZERO, GEN_ALLOC_ZERO }

extern struct dns_rcrw_info dns_rcrw_info_here ;
extern void dns_rcrw_info_free (struct dns_rcrw_info *) ;
extern int dns_resolvconfrewrite (stralloc *) ;
extern int dns_resolvconfrewriteit (struct dns_rcrw_info *) ;
extern int dns_resolvconfrewriteit_tmp (struct dns_rcrw_info *, stralloc *) ;

extern int dns_ip4_qualify (stralloc *, stralloc *, stralloc const *) ;
extern int dns_ip4_qualifyb (stralloc *, stralloc *, char const *, unsigned int) ;
extern int dns_ip4_qualifyb_r_tmp (stralloc *, stralloc *, char const *, unsigned int, struct dns_rcrw_info *, stralloc *) ;
extern int dns_ip4_qualify_rules (stralloc *, stralloc *, stralloc const *, stralloc const *) ;
extern int dns_ip4_qualify_rulesb (stralloc *, stralloc *, char const *, unsigned int, char const *, unsigned int) ;

#endif
