/* Public domain. */

#include "bytestr.h"

#ifdef USE_BASE_LIBC

#include <string.h>

int str_diffn (register char const *s, register char const *t, register unsigned int len)
{
  return strncmp(s, t, len) ;
}

#else

int str_diffn (register char const *s, register char const *t, register unsigned int len)
{
  while (len--)
  {
    if (*s != *t) return *s - *t ;
    if (!*s) break ;
    s++ ; t++ ;
  }
  return 0 ;
}

#endif
