;; skk-e18.el --- emacs 18 specific functions for skk.el
;; Copyright (C) 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997
;; Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>

;; Author: Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Version: 1.5.4
;; Keywords: japanese
;; Last Modified: Tue Dec 10 07:19:10 1996

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:
;; Following people contributed to skk-e18.el (Alphabetical order):
;;      Kiyotaka Sakai <ksakai@netwk.ntt-at.co.jp>
;;      Hitoshi SUZUKI <h-suzuki@ael.fujitsu.co.jp>
;;      Mikio Nakajima <gy2m-nkjm@asahi-net.or.jp>
;;      Murata Shuuichirou <mrt@mickey.ai.kyutech.ac.jp>
;;      NAMBA Seiich <pi9s-nnb@asahi-net.or.jp>
;;      Shuhei KOBAYASHI <shuhei-k@jaist.ac.jp>

;;; Change log:
;; version 1.5.4 released 1996.12.10 (derived from the skk.el 8.6)

;;; Code:
;; skk-e18.el  skk.el  require Τǡְ㤨Ƥ (require 'skk) 
;; ƤϤʤ
(require 'queue-m)

(defmacro skk-defvar (symbol initvalue docstring &optional tut-value)
  "\(defvar SYMBOL INITVALUE DOCSTRING\) ɾ塢SYMBOL  skktut-value
° INITVALUE Ϳ롣
ץʥ TUT-VALUE ꤹȡskktut-value ° INITVALUE 
 TUT-VALUE Ϳ롣
TUT-VALUE  nil ꤷϡ'false Ϥ"
  (list 'progn
    (list 'defvar symbol initvalue docstring)
    (list 'if (list 'eq
                    (list 'skk-get (list 'quote symbol) (list 'quote 'skktut-value)
                          (list 'quote 'false) )
                    (list 'quote 'false) )
          (list 'put (list 'quote symbol) (list 'quote 'skktut-value)
                (list 'cond (list (list 'not tut-value) initvalue)
                      (list (list 'eq tut-value (list 'quote 'false))
                            nil )
                      (list t tut-value) )))))
                ;;(cond ((not tut-value) initvalue)
                ;;      ((eq tut-value 'false)
                ;;            nil )
                ;;      (t tut-value) )))))

(put 'skk-defvar 'lisp-indent-function 'defun)

(defun skk-get (symbol property-name &optional default)
  ;; SYMBOL °ꥹȤ PROPERTY-NAME Ȥ°̾Ф°֤ͤ
  ;; ʤ DEFAULT ֤ (DEFAULT ꤵƤʤ NIL)°̾
  ;; Ӥϡeq ǹԤʤ
  (if default
      (let ((pl (memq property-name (symbol-plist symbol))))
        (if pl (nth 1 pl) default) )
    (get symbol property-name) ))

(put 'skk-get 'lisp-indent-function 'defun)

;;;; variable declaration
;;; user variables
(skk-defvar skk-e18-load-hook nil
  "*skk-e18.el ɤ˥뤵եå" )

;;; internal variables
(defconst skk-nemacs-v2 (not (boundp 'self-insert-after-hook))
  "Non-nil means that skk is running under Nemacs version 2." )

(defconst skk-background-mode nil)

(defvar skk-emacs19 nil
  "Non-nil ǤСEmacs 19  SKK ѤƤ뤳Ȥ򼨤" )

(defvar skk-mule24 nil)
(defvar skk-mule nil)

(defvar skk-coding-system-alist
  (if skk-mule
      '(("euc" . *euc-japan*) ("ujis" . *euc-japan*)
        ("sjis". *sjis*) ("jis" . *junet*) )
    '(("euc"  . 0) ("ujis"  . 0)
      ("sjis" . 1) ("jis"  . 2) )))

;; this modification is necessary since the variable
;; self-insert-after-hook is unbound in Nemacs v2 
(if skk-nemacs-v2 (setq self-insert-after-hook nil))


;;;; aliases.
;; Jamie Zawinski  byte-compiler ѤСEmacs 18 Ǥ
;; defsubst ѤǤ롣
(if (not (fboundp 'defsubst))(fset 'defsubst 'defun))

(fset 'defalias 'fset)
;; In Emacs 18, it is enough to return itself since all event is ascii
;; keystroke.
(fset 'skk-ascify-event 'identity)
(fset 'skk-buffer-substring 'buffer-substring)
(fset 'skk-eventp 'ignore)
(fset 'skk-read-char 'read-char)
(fset 'skk-insert-and-inherit 'insert)
(or (fboundp 'string-width)(fset 'string-width (symbol-function 'length)))
(or (fboundp 'eval-when-compile) (fset 'eval-when-compile 'progn))
(if (boundp 'select-window-hook)
    (fset 'skk-set-marker 'set-marker) )
(and (not (fboundp 'buffer-disable-undo))
     (fboundp 'buffer-flush-undo)
     (fset 'buffer-disable-undo 'buffer-flush-undo))

;;;; macros.
(eval-and-compile
  (if (not (boundp 'select-window-hook))
      (defmacro skk-set-marker (marker position &optional buffer)
        (list 'progn
              (list 'if (list 'not marker)
                    (list 'setq marker (list 'make-marker)) )
              (list 'set-marker marker position buffer) ))))

;; masahiko copied from emacs19
(defmacro save-match-data (&rest body)
  "Execute the BODY forms, restoring the global value of the match data."
  (let ((original (make-symbol "match-data")))
    (list 'let (list (list original '(match-data)))
          (list 'unwind-protect
                (cons 'progn body)
                (list 'store-match-data original) ))))

;;(defmacro skk-delete-henkan-region (start end)
;;  ;; Emacs 18 ǤϡOverlay ƤʤΤǡstart  end δ֤ä
;;  (list 'delete-region start end) )

(defmacro skk-unread-event (event)
  ;; "Unread single EVENT."
  (list 'setq 'unread-command-char event) )

;;(defmacro skk-minibuffer-origin ()
;;  (list 'car (list 'cdr (list 'buffer-list))) )

;;;; inline functions
;; from emacs-19.el
(defsubst member (x y)
  ;; Return non-nil if X is an element of Y.  Comparison done
  ;; with `equal'.
  ;; The value is actually the tail of Y whose car is X.
  ;; (member X Y)
  ;; string= is not good for add-hook.
  (while (and y (not (equal x (car y))))
    (setq y (cdr y)) )
  y )

;; Note that a certain version of Emacs does not provide us with `assoc' and
;; `delete', while Emacs 18.59 provides us with `assoc' and Emacs 19 provides
;; us with `delete' as C primitives.  As the following functions are just for
;; SKK use, so their behavior may not be quite equal to the Emacs's genuine
;; one.

;; From mew.el (mew-delq).  Welcome!
(defun delete (key list)
  (let* ((pointer (cons nil list))
	 (top pointer))
    (while (cdr pointer)
      (if (equal key (car (cdr pointer))) 
	  (progn
	    (setcdr pointer (cdr (cdr pointer)))
	    (setq pointer (cons nil nil)))
	(setq pointer (cdr pointer))))
    (cdr top)))

(defun rassoc (key alist)
  (cond ((null alist) nil)
        ((and (consp (car alist))
              (equal key (cdr (car alist))) (car alist)))
        (t (rassoc key (cdr alist))) ))

;;;; functions
(if (fboundp 'defadvice)
    ;; defadvice ȡǥ桼εǽդƹ defadvice 
    ;; Ƥư
    (progn
      (defadvice save-buffers-kill-emacs (before add-skk activate)
        "SKK 򥻡֤ơEmacs λ롣"
        (interactive "P")
        (skk-save-jisyo)
        (run-hooks 'skk-before-kill-emacs-hook) )

      (defun skk-kill-emacs-without-saving-jisyo (&optional query)
        "SKK 򥻡֤ʤǡEmacs λ롣"
        (interactive "P")
        (if (yes-or-no-p
             (format (if skk-japanese-message-and-error
                         "¸򤻤 %s λޤɤǤ"
                       "Do you really wish to kill %s without saving Jisyo? " )
                     (if skk-mule "Mule" "NEmacs") ))
            (let ((buff (skk-get-jisyo-buffer skk-jisyo 'nomsg)))
              (if buff
                  (progn (set-buffer buff)
                         (set-buffer-modified-p nil)
                         (kill-buffer buff) ))
              (run-hooks 'skk-before-kill-emacs-hook)
              (ad-deactivate 'save-buffers-kill-emacs)
              (save-buffers-kill-emacs query) )))

      (defadvice picture-mode-exit (before skk-add activate)
        "SKK ΥХåեѿ̵ˤpicture-mode-exit 򥳡뤹롣
      picture-mode ФȤˤΥХåե SKK ưν"
        (interactive "P")
        (if skk-mode
            (skk-kill-local-variables) ))

      (defadvice undo (before skk-add activate)
        "SKK ⡼ɤ on ʤ skk-self-insert-non-undo-count 롣"
        (if skk-mode
            (progn
              (setq skk-self-insert-non-undo-count 0) )))

      (defadvice use-local-map (after skk-add activate)
        "¾ѥå local map 򤹤ؤˡSKK ⡼ɤǤ뤳Ȥ򼨤ĳä"
        (if (and skk-mode (not (window-minibuffer-p (selected-window))))
            ;; SKK ⡼ɤưƤƥȥɥߥ˥ХåեǤʤ
            (let (;; (command (prin1-to-string this-command))
                  (map (ad-get-arg 0)) )
              ;; run-hooks ǸƤФ뤫⤷ʤΤǡΥåˡǤԽʬ
              ;;(if (and (> (length command) 3)
              ;;         (string= "skk" (substring command 0 3)) )
              ;;    nil
              ;; "skk-" ץեåդޥɰʳ use-local-map 
              ;; 뤵줿
              (if (or
                   ;; ϥ⡼ɤȥޥåפ԰ס
                   (and skk-j-mode
                        (not (where-is-internal 'skk-set-henkan-point map t))
                        (eq (nth 1 mode-line-format) 'skk-mode-line)
                        (or
                         (and skk-katakana
                              (not (string= skk-mode-line skk-katakana-mode-string)) )
                         (not (string= skk-mode-line skk-hirakana-mode-string)) ))
                   (and skk-zenkaku
                        (not (where-is-internal 'skk-zenkaku-insert map t))
                        (eq (nth 1 mode-line-format) 'skk-mode-line)
                        (not (string= skk-mode-line skk-zenei-mode-string)) )
                   (and skk-abbrev
                        (not (where-is-internal 'skk-abbrev-comma map t))
                        (eq (nth 1 mode-line-format) 'skk-mode-line)
                        (or
                         (and skk-katakana
                              (not (string= skk-mode-line skk-katakana-mode-string)) )
                         (not (string= skk-mode-line skk-hirakana-mode-string)) ))
                   ;; SKK ⡼ (SKK abbrev ⡼ɰʳSKK abbrev ⡼ɤʤ
                   ;; ϥ⡼ɤʤ) ޥåפ skk-kakutei 
                   ;; γդʤ
                   (and (not (or skk-j-mode skk-zenkaku skk-abbrev))
                        (not (where-is-internal 'skk-kakutei map t))
                        (eq (nth 1 mode-line-format) 'skk-mode-line)
                        (not (string= skk-mode-line skk-mode-string)) ))
                  (progn
                    (setq skk-mode nil
                          skk-j-mode nil
                          skk-zenkaku nil
                          skk-abbrev nil
                          ;;mode-line-format (cdr mode-line-format)
                          mode-line-format (delq 'skk-mode-line mode-line-format)
                          skk-org-mode-line-format nil )
                    (force-mode-line-update) ))
              (and skk-okurigana (skk-delete-okuri-mark))
              (skk-delete-henkan-markers 'nomsg)
              ;;(skk-kakutei-cleanup-henkan-buffer)
              (skk-kakutei-save-and-init-variables) ))))

  (if (fboundp 'skk-org-save-buffers-kill-emacs)
      nil
    (fset 'skk-org-save-buffers-kill-emacs
          (symbol-function 'save-buffers-kill-emacs) )
    (defun save-buffers-kill-emacs (&optional query)
      "SKK 򥻡֤ơEmacs λ롣"
      (interactive "P")
      (skk-save-jisyo)
      (run-hooks 'skk-before-kill-emacs-hook)
      (skk-org-save-buffers-kill-emacs query) )
    
    (defun skk-kill-emacs-without-saving-jisyo (&optional query)
      "SKK 򥻡֤ʤǡEmacs λ롣"
      (interactive "P")
      (if (yes-or-no-p
           (format (if skk-japanese-message-and-error
                       "¸򤻤 %s λޤɤǤ"
                     "Do you really wish to kill %s without saving Jisyo? " )
                   (if skk-mule "Mule" "NEmacs") ))
          (let ((buff (skk-get-jisyo-buffer skk-jisyo 'nomsg)))
            (if buff
                (progn (set-buffer buff)
                       (set-buffer-modified-p nil)
                       (kill-buffer buff) ))
            (run-hooks 'skk-before-kill-emacs-hook)
            (skk-org-save-buffers-kill-emacs query) )))
    
    (defalias 'skk-advertised-undo 'skk-undo)
    (defun skk-undo (&optional arg)
      "undo SKK ⡼ɤ on ʤ skk-self-insert-non-undo-count 롣"
      (interactive "*p")
      (if skk-mode
          (progn
            (setq skk-self-insert-non-undo-count 0)
            (undo arg) )
        (undo arg) )
      (setq this-command 'undo) )))

(defun skk-do-auto-fill ()
  (and auto-fill-hook
       (let* ((c (current-column)) (cont (> c fill-column)))
         (while cont
           (run-hooks 'auto-fill-hook)
           ;; if current-column doesn't change after do-auto-fill,
           ;; we exit from the while loop by setting cont to be nil.
           ;; also, it is necessary that current-column >
           ;; fill-column to continue the loop.
           (setq cont (and (< (current-column) c)
                           (> (current-column) fill-column) )
                 c (current-column) )))))

(defun skk-convert-to-vector (map)
  "convert a map in list form to a map in vector form."
  (if (not (vectorp map))
      (let ((new-map (make-keymap)) (l (cdr map)) def)
        (while l
          (setq def (cdr (car l)))
          (aset new-map (car (car l)) (if (keymapp def)
                                          (copy-keymap def)
                                        def))
          (setq l (cdr l)))
        new-map )
    (copy-keymap map) ))

(defun skk-use-local-map (map)
  (let (skk-mode) ; dummy for advised use-local-map.
    (use-local-map map) ))

(defun skk-set-jisyo-code ()
  (if (stringp skk-jisyo-code)
      (setq skk-jisyo-code (cdr (assoc skk-jisyo-code skk-coding-system-alist))) )
  (if skk-mule
      (set-file-coding-system skk-jisyo-code)
    (setq kanji-fileio-code skk-jisyo-code) ))

(if skk-mule
    (progn
      ;; functions for mule-1.x
      (fset 'skk-backward-char 'backward-char)
      (fset 'skk-forward-char 'forward-char) )

  ;; functions for Nemacs
  (defun skk-backward-char (n)
    "Move point left ARG characters (right if ARG negative).
  On attempt to pass beginning or end of buffer, stop and signal error.
  This version understands Zenkaku and Hankaku characters."
    (interactive "p")
    (let ((step (if (< n 0) -1 1))
          (count (if (< n 0) (- n) n)))
      (while (> count 0)
        (backward-char step)
        (setq count (1- count)) )))

  (defun skk-forward-char (n)
    "Move point right ARG characters (left if ARG negative).
  On reaching end of buffer, stop and signal error.
  This version understands Zenkaku and Hankaku characters."
    (interactive "p")
    (skk-backward-char (- n)) ))

(or (fboundp 'assoc)
    (defun assoc (key a-list)
      ;; Return non-nil if KEY is `string=' to the car of an element of LIST.
      ;; The value is actually the element of LIST whose car is KEY.
      ;;
      ;; Note that this function compares elements using `string=' while
      ;; Emacs's genuine `assoc' uses `equal'.
      (let ((list a-list) (cont t) (val nil))
        (while cont
          (if (null list)
              (setq cont nil)
            (let ((key2 (car (car list))))
              (if (string= key key2)
                  (setq cont nil
                        val (car list) )
                (setq list (cdr list))))))
        val )))

(defun force-mode-line-update (&optional all)
  "Force the mode-line of the current buffer to be redisplayed.
With optional non-nil ALL, force redisplay of all mode-lines."
  (if all (save-excursion (set-buffer (other-buffer))))
  (set-buffer-modified-p (buffer-modified-p)))

;; from subr.el of Emacs 19
(defun add-hook (hook function &optional append)
  "Add to the value of HOOK the function FUNCTION.
FUNCTION is not added if already present.
FUNCTION is added (if necessary) at the beginning of the hook list
unless the optional argument APPEND is non-nil, in which case
FUNCTION is added at the end.

HOOK should be a symbol, and FUNCTION may be any valid function.  If
HOOK is void, it is first set to nil.  If HOOK's value is a single
function, it is changed to a list of functions."
  (or (boundp hook) (set hook nil))
  ;; If the hook value is a single function, turn it into a list.
  (let ((old (symbol-value hook)))
    (if (or (not (listp old)) (eq (car old) 'lambda))
	(set hook (list old))))
  (or (if (consp function)
	  (member function (symbol-value hook))
	(memq function (symbol-value hook)))
      (set hook 
	   (if append
	       (nconc (symbol-value hook) (list function))
	     (cons function (symbol-value hook))))))

(defun remove-hook (hook function)
  "Remove from the value of HOOK the function FUNCTION.
HOOK should be a symbol, and FUNCTION may be any valid function.  If
FUNCTION isn't the value of HOOK, or, if FUNCTION doesn't appear in the
list of hooks to run in HOOK, then nothing is done.  See `add-hook'."
  (if (or (not (boundp hook))		;unbound symbol, or
	  (null (symbol-value hook))	;value is nil, or
	  (null function))		;function is nil, then
      nil				;Do nothing.
    (let ((hook-value (symbol-value hook)))
      (if (consp hook-value)
	  (setq hook-value (delete function hook-value))
	(if (equal hook-value function)
	    (setq hook-value nil)))
      (set hook hook-value))))

(if (boundp 'select-window-hook)
    (defun skk-select-window-func (old new)
      ;; select-window ؿ select-window-hook 򲼵Τ褦ˤƥ뤷
      ;; 뤳Ȥա
      ;;            call2 (Vselect_window_hook, oldwin, window);
      ;;
      ;; add-hook ȤäƤΥեå˴ؿɲä뤳ȤԲġޤ
      ;; ΥեåǤؿϡoldwin  window  2 Ĥ˻Ĵؿ
      ;; ΤߤǤ롣
      ;;
      ;; Mule  Emacs19 ؤȤǡselect-window-hook ⤷ʤʤ
      ;; 顢minibuffer-setup-hook бǤ롩
      (save-excursion
        ;; skk.el  require ǤʤΤǡޥѤߤǤ뤳Ȥݾڤ
        ;; ʤ
        (if ;;(skk-in-minibuffer-p)
            (eq (selected-window) (minibuffer-window))
            (skk-make-henkan-marker) )
        (if skk-other-select-window-hook-func-list
            (mapcar (function (lambda (func) (funcall func old new)))
                    skk-other-select-window-hook-func-list  )))))

(defun skk-keyboard-quit-1 ()
  (cond ;;(isearch-mode
   ;; (setq skk-isearch-message nil)
   ;; (isearch-abort) )
   ;; skk.el  require ǤʤΤǡޥѤߤǤ뤳Ȥݾڤ
   ;; ʤ
   ;;((not (skk-in-minibuffer-p))
   ((not (eq (selected-window) (minibuffer-window)))
    ;; ߥ˥Хåեʳ
    ;; keyboard.el 줿 mule-keyboard-quit ȤʤФʤʤȤ
    ;; Ϥʤ
    (keyboard-quit) )
   ;; νϡskk-henkan-in-minibuff ǹԤʤ
   ;;(save-excursion
   ;;  ;; Хåե겾̾Ϣե饰򥪥դˤ롣
   ;;  (set-buffer (skk-minibuffer-origin))
   ;;  (setq skk-okurigana nil
   ;;        skk-okuri-char nil
   ;;        skk-henkan-okurigana nil ))
   ;; delete-selection-mode ȤäƤƥߥ˥ХåեˤȤ
   ((and (boundp 'delete-selection-mode) delete-selection-mode
         transient-mark-mode mark-active )
    (setq deactivate-mark t) )
   ;; ߥ˥Хåե
   (t (abort-recursive-edit) )))

(add-hook 'edit-picture-hook
          (function
           (lambda ()
             (if (or (fboundp 'defadvice) (fboundp 'skk-org-picture-mode-exit))
                 nil
               (fset 'skk-org-picture-mode-exit
                     (symbol-function 'picture-mode-exit) )
               (defun picture-mode-exit (&optional nostrip)
                 "SKK ΥХåեѿ̵ˤpicture-mode-exit 򥳡뤹롣
               picture-mode ФȤˤΥХåե SKK ưν"
                 (interactive "P")
                 (if skk-mode
                     (skk-kill-local-variables) )
                 (skk-org-picture-mode-exit nostrip) )))))

(run-hooks 'skk-e18-load-hook)

(provide 'skk-e18)
;;; skk-e18.el ends here
