;*=====================================================================*/
;*    serrano/prgm/project/skribe/src/bigloo/main.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul 22 16:51:49 2003                          */
;*    Last change :  Wed Mar  3 10:17:15 2004 (serrano)                */
;*    Copyright   :  2003-04 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The Skribe main entry point                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module skribe_main
   
   (include "debug.sch")
   
   (import  skribe_types
	    skribe_parse-args
	    skribe_param
	    skribe_lib
	    skribe_eval
	    skribe_read
	    skribe_engine
	    skribe_evapi)
   
   (main    main))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main args)
   (with-debug 2 'main
      (debug-item "parse env variables...")
      (parse-env-variables)
      
      (debug-item "load rc file...")
      (load-rc)
      
      (debug-item "parse command line...")
      (parse-args args)
      
      (debug-item "load base...")
      (skribe-load "base.skr" :engine 'base)
      
      (debug-item "preload... (" *skribe-engine* ")")
      (for-each (lambda (f)
		   (skribe-load f :engine *skribe-engine*))
		*skribe-preload*)
      
      ;; Load the specified variants
      (debug-item "variant... (" *skribe-variants* ")")
      (for-each (lambda (x)
		   (skribe-load (format "~a.skr" x) :engine *skribe-engine*))
		(reverse! *skribe-variants*))

      (debug-item "body..." *skribe-engine*)
      (if (string? *skribe-dest*)
	  (try (with-output-to-file *skribe-dest* doskribe)
	       (lambda (e a b c)
		  (delete-file *skribe-dest*)
		  (let ((s (with-output-to-string (lambda () (write c)))))
		     (notify-error a b s))
		  (exit -1)))
	  (doskribe))))

;*---------------------------------------------------------------------*/
;*    doskribe ...                                                     */
;*---------------------------------------------------------------------*/
(define (doskribe)
   (let ((e (find-engine *skribe-engine*)))
      (if (and (engine? e) (pair? *skribe-precustom*))
	  (for-each (lambda (cv)
		       (engine-custom-set! e (car cv) (cdr cv)))
		    *skribe-precustom*))
      (if (pair? *skribe-src*)
	  (for-each (lambda (f) (skribe-load f :engine *skribe-engine*))
		    *skribe-src*)
	  (skribe-eval-port (current-input-port) *skribe-engine*))))
