/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGBOOKMARKPLUGINDOCKWIDGET_H
#define SKGBOOKMARKPLUGINDOCKWIDGET_H
/** @file
* This file is Skrooge plugin for bookmarks management.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "ui_skgbookmarkplugindockwidget_base.h"
#include "skgtabwidget.h"
#include "skgnodeobject.h"

class KMenu;

/**
 * This file is Skrooge plugin for undoredo management
 */
class SKGBookmarkPluginDockWidget : public SKGTabWidget
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGBookmarkPluginDockWidget(SKGMainPanel* iParent, SKGDocument* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGBookmarkPluginDockWidget();

        /**
         * Get the current selected bookmarks
         * @return selected bookmarks
         */
        virtual SKGObjectBase::SKGListSKGObjectBase getBookmarks();

        /**
         * Get the number of seleted bookmarks
         * @return number of selected bookmarks
         */
        virtual int getNbSelectedBookmarks();

        /**
         * Open a bookmark
         * @param iNode bookmark object to open
         * @param iFirstInNewPage to open first object in new page
         */
        virtual void openBookmark(const SKGNodeObject& iNode, bool iFirstInNewPage=false);

protected:
        /**
         * This event handler can be reimplemented in a subclass to receive widget resize events which are passed in the event parameter.
         * When resizeEvent() is called, the widget already has its new geometry. The old size is accessible through QResizeEvent::oldSize().
         * @param event the event pointer
         */
        virtual void resizeEvent(QResizeEvent *event);

public slots:
        /**
         * Refresh the content.
         */
        virtual void refresh();

private slots:
        void showMenu(const QPoint& pos);
        void onAddBookmarkGroup();
        void onAddBookmark();
        void onRemoveBookmark();
        void onRenameBookmark();
        void onOpenBookmark();
        void onBookmarkEditorChanged();
        void onBookmarkFilterRegExpChanged();
        void onSetAutostart();
        void onUnsetAutostart();

private:
        Q_DISABLE_COPY(SKGBookmarkPluginDockWidget);

        void setAutostart(const QString& value);

        Ui::skgbookmarkplugindockwidget_base ui;
        QString docUniqueIdentifier;
        KMenu* menu;
        QAction* actDelete;
        QAction* actAddBookmark;
        QAction* actAddBookmarkGroup;
        QAction* actSetAutostart;
        QAction* actUnsetAutostart;
        QSize minSize;
};

#endif // SKGBOOKMARKPLUGINDOCKWIDGET_H
