/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is part of Skrooge and defines classes SKGUnitValueObject.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgunitvalueobject.h"
#include "skgunitobject.h"

SKGUnitValueObject::SKGUnitValueObject(const SKGDocument* iDocument, int iID)
                : SKGObjectBase(iDocument, "v_unitvalue", iID)
{
}

SKGUnitValueObject::SKGUnitValueObject(const SKGUnitValueObject& iObject)
                : SKGObjectBase(iObject)
{
}

SKGUnitValueObject::SKGUnitValueObject(const SKGObjectBase& iObject)
{
        if (iObject.getRealTable()=="unitvalue") {
                copyFrom(iObject);
        } else {
                *this=SKGObjectBase::SKGObjectBase(iObject.getDocument(), "v_unitvalue", iObject.getID());
        }
}

const SKGUnitValueObject& SKGUnitValueObject::operator= (const SKGObjectBase& iObject)
{
        copyFrom(iObject);
        return *this;
}

SKGUnitValueObject::~SKGUnitValueObject()
{
}

SKGError SKGUnitValueObject::setQuantity(double iValue)
{
        return setAttribute("f_quantity", SKGServices::doubleToString(iValue));
}

double SKGUnitValueObject::getQuantity() const
{
        return SKGServices::stringToDouble(getAttribute("f_quantity"));
}

SKGError SKGUnitValueObject::setDate(const QDate& iDate)
{
        return setAttribute("d_date", SKGServices::dateToSqlString(QDateTime(iDate)));
}

QDate SKGUnitValueObject::getDate() const
{
        return SKGServices::stringToTime(getAttribute("d_date")).date();
}

QString SKGUnitValueObject::getWhereclauseId() const
{
        //Could we use the id
        QString output = SKGObjectBase::getWhereclauseId();
        if (output.isEmpty()) {
                //No, so we use the date and parent
                if (!(getAttribute("d_date").isEmpty()) && !(getAttribute("rd_unit_id").isEmpty())) {
                        output = "d_date='"+getAttribute("d_date")+"' AND rd_unit_id="+getAttribute("rd_unit_id");
                }
        }
        return output;
}

SKGError SKGUnitValueObject::getUnit(SKGUnitObject& oUnit) const
{
        SKGError err = getObject(getDocument(), "v_unit", "id=" + getAttribute("rd_unit_id"), oUnit);
        return err;
}
#include "skgunitvalueobject.moc"
