/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

#ifndef SKGAUTOHIDE_H
#define SKGAUTOHIDE_H
/** @file
 * This file is part of Skrooge and defines classes skrooge.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgdefine.h"

#include <QObject>
#include <QPoint>
/**
 * This class allows to manage auto hidden widgets.
 */
class QWidget;
class QTimer;
class KMenu;
class QAction;

class KDE_EXPORT SKGAutoHide : public QObject
{
        Q_OBJECT;

public:
        /**
         * Copy constructor
         * @param iAutoHiddenWidget the widget shown/hidden
         * @param iManager the widget managing the visibility of @p iAutoHiddenWidget
         * @param iMSec timeout to hide widget
         */
        SKGAutoHide ( QWidget* iAutoHiddenWidget, QWidget* iManager, int iMSec=3000 );

        /**
         * Destructor
         */
        virtual ~SKGAutoHide();

        /**
         * Reset the timer
         */
        virtual void resetTimer();

        /**
         * Set auto hide mode
         * @param iMode mode
         */
        virtual void setAutoHideMode ( bool iMode );

        /**
         * Get auto hide mode
         * @return mode
         */
        virtual bool autoHideMode();

private slots:
        void showContextMenu(const QPoint& pos);
        void hideWidget();

private:
        Q_DISABLE_COPY ( SKGAutoHide );

        bool eventFilter ( QObject *object, QEvent *event );

        QWidget* autoHiddenWidget;
        QWidget* manager;
        QTimer *timer;
        int mSec;
        KMenu* menu;
        QAction* actAutoHide;
};

#endif // SKGAUTOHIDE_H
