/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGDEFINE_H
#define SKGDEFINE_H
/** @file
 * This file defines some macros.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include <QString>


#ifndef KDE4_FOUND
#ifndef KDE_EXPORT
/**
 * @def KDE_EXPORT
 * For KDE build compatibility
 */
#define KDE_EXPORT
#endif
#else
#include <kglobal.h>
#endif
/**
 * @def OBJECTSEPARATOR
 * Define the separator between object and subobject
 */
#define OBJECTSEPARATOR		" > "

/**
 * @def DUMPSQLITE
 * To display SQLLITE internals (tables, views, indexes, ...)
 * @see dump
 */
#define DUMPSQLITE              (2<<0)

/**
 * @def DUMPPARAMETERS
 * To display parameters
 * @see dump
 */
#define DUMPPARAMETERS          (2<<1)

/**
 * @def DUMPTRANSACTIONS
 * To display transactions
 * @see dump
 */
#define DUMPTRANSACTIONS 	(2<<2)

/**
 * @def DUMPNODES
 * To display nodes
 * @see dump
 */
#define DUMPNODES 		(2<<3)

/**
 * @def DUMPALL
 * To display display all=@p DUMPSQLITE +@p DUMPPARAMETERS +@p DUMPTRANSACTIONS
 * @see dump
 */

#define DUMPALL   		((2<<10)-1)

/**
 * @def SKG_UNDO_MAX_DEPTH
 * Default value for the max depth for the undo / redo mechanism
 */
#define SKG_UNDO_MAX_DEPTH	50

/**
 * @def ERR_NOTIMPL
 * Error number
 */
#define ERR_NOTIMPL		1

/**
 * @def ERR_NOINTERFACE
 * Error number
 */
#define ERR_NOINTERFACE		2

/**
 * @def ERR_POINTER
 * Error number
 */
#define ERR_POINTER		3

/**
 * @def ERR_ABORT
 * Error number
 */
#define ERR_ABORT		4

/**
 * @def ERR_FAIL
 * Error number
 */
#define ERR_FAIL		5

/**
 * @def ERR_HANDLE
 * Error number
 */
#define ERR_HANDLE		6

/**
 * @def ERR_OUTOFMEMORY
 * Error number
 */
#define ERR_OUTOFMEMORY		7

/**
 * @def ERR_INVALIDARG
 * Error number
 */
#define ERR_INVALIDARG		8

/**
 * @def ERR_UNEXPECTED
 * Error number
 */
#define ERR_UNEXPECTED		9

/**
 * @def DELETECASCADE
 * Define a standard trigger for cascaded delete
 */
#define DELETECASCADE(TABLEPARENT,ATTPARENT,TABLECHILD,ATTCHILD)\
	QString()+\
	"DROP TRIGGER IF EXISTS fkdc_"+TABLEPARENT+"_"+TABLECHILD+"_"+ATTPARENT+"_"+ATTCHILD+";;" \
        "CREATE TRIGGER fkdc_"+TABLEPARENT+"_"+TABLECHILD+"_"+ATTPARENT+"_"+ATTCHILD+" "\
        "BEFORE DELETE ON "+TABLEPARENT+" "\
        "FOR EACH ROW BEGIN "\
        "    DELETE FROM "+TABLECHILD+" WHERE "+TABLECHILD+"."+ATTCHILD+" = OLD."+ATTPARENT+"; "\
        "END;; "

/**
 * @def INSERTUPDATECONSTRAINT
 * Define a standard trigger for foreign constraint
 */
#define INSERTUPDATECONSTRAINT(TABLEPARENT,ATTPARENT,TABLECHILD,ATTCHILD)\
	QString()+\
	"DROP TRIGGER IF EXISTS fki_"+TABLECHILD+"_"+TABLEPARENT+"_"+ATTCHILD+"_"+ATTPARENT+";;" \
        "CREATE TRIGGER fki_"+TABLECHILD+"_"+TABLEPARENT+"_"+ATTCHILD+"_"+ATTPARENT+" "\
        "BEFORE INSERT ON "+TABLECHILD+" "\
        "FOR EACH ROW BEGIN "\
        "  SELECT RAISE(ABORT, 'insert on table "+TABLECHILD+" violates foreign key constraint fki_"+TABLECHILD+"_"+TABLEPARENT+"_"+ATTCHILD+"_"+ATTPARENT+"') "\
        "  WHERE NEW."+ATTCHILD+"!=0 AND (SELECT "+ATTPARENT+" FROM "+TABLEPARENT+" WHERE "+ATTPARENT+" = NEW."+ATTCHILD+") IS NULL; "\
        "END;; "\
	"DROP TRIGGER IF EXISTS fku_"+TABLECHILD+"_"+TABLEPARENT+"_"+ATTCHILD+"_"+ATTPARENT+";;" \
        "CREATE TRIGGER fku_"+TABLECHILD+"_"+TABLEPARENT+"_"+ATTCHILD+"_"+ATTPARENT+" "\
        "BEFORE UPDATE ON "+TABLECHILD+" "\
        "FOR EACH ROW BEGIN "\
        "    SELECT RAISE(ABORT, 'update on table "+TABLECHILD+" violates foreign key constraint fku_"+TABLECHILD+"_"+TABLEPARENT+"_"+ATTCHILD+"_"+ATTPARENT+"') "\
        "      WHERE NEW."+ATTCHILD+"!=0 AND (SELECT "+ATTPARENT+" FROM "+TABLEPARENT+" WHERE "+ATTPARENT+" = NEW."+ATTCHILD+") IS NULL; "\
        "END;; "

/**
 * @def FOREIGNCONSTRAINT
 * Define a standard trigger for foreign constraint
 */
#define FOREIGNCONSTRAINT(TABLEPARENT,ATTPARENT,TABLECHILD,ATTCHILD)\
        INSERTUPDATECONSTRAINT(TABLEPARENT,ATTPARENT,TABLECHILD,ATTCHILD)+\
	"DROP TRIGGER IF EXISTS fkd_"+TABLECHILD+"_"+TABLEPARENT+"_"+ATTCHILD+"_"+ATTPARENT+";;" \
        "CREATE TRIGGER fkd_"+TABLECHILD+"_"+TABLEPARENT+"_"+ATTCHILD+"_"+ATTPARENT+" "\
	"BEFORE DELETE ON "+TABLEPARENT+" "\
	"FOR EACH ROW BEGIN "\
  	"    SELECT RAISE(ABORT, 'delete on table "+TABLEPARENT+" violates foreign key constraint fkd_"+TABLECHILD+"_"+TABLEPARENT+"_"+ATTCHILD+"_"+ATTPARENT+"') "\
  	"    WHERE (SELECT "+ATTCHILD+" FROM "+TABLECHILD+" WHERE "+ATTCHILD+" = OLD."+ATTPARENT+") IS NOT NULL; "\
	"END;; "

/**
 * @def FOREIGNCONSTRAINTCASCADE
 * Define a standard trigger for foreign constraint +cascade delete
 */
#define FOREIGNCONSTRAINTCASCADE(TABLEPARENT,ATTPARENT,TABLECHILD,ATTCHILD)\
        INSERTUPDATECONSTRAINT(TABLEPARENT,ATTPARENT,TABLECHILD,ATTCHILD)+\
        DELETECASCADE(TABLEPARENT,ATTPARENT,TABLECHILD,ATTCHILD)
/**
 * @def DELETECASCADEPARAMETER
 * Define a cascaded delete to delete parameters associated with an object
 */
#define DELETECASCADEPARAMETER(TABLE) \
	QString()+\
	"DROP TRIGGER IF EXISTS fkdc_"+TABLE+"_parameters_uuid;;" \
        "CREATE TRIGGER fkdc_"+TABLE+"_parameters_uuid "\
        "BEFORE DELETE ON "+TABLE+" "\
        "FOR EACH ROW BEGIN "\
        "    DELETE FROM parameters WHERE parameters.t_uuid_parent=OLD.id||'-'||'"+TABLE+"'; "\
        "END;; "

#endif
