/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for bank management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgbankboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgservices.h"

SKGBankBoardWidget::SKGBankBoardWidget (SKGDocument* iDocument )
                : SKGWidget (iDocument )
{
        SKGTRACEIN ( 10, "SKGBankBoardWidget::SKGBankBoardWidget" );

        ui.setupUi ( this );

        //Refresh
        connect ( ( const QObject* ) getDocument(), SIGNAL(tableModified(QString, int)), this, SLOT(dataModified(QString, int)), Qt::QueuedConnection );
        dataModified("", 0);
}

SKGBankBoardWidget::~SKGBankBoardWidget()
{
        SKGTRACEIN ( 10, "SKGBankBoardWidget::~SKGBankBoardWidget" );

}

void SKGBankBoardWidget::dataModified(const QString& iTableName, int iIdTransaction)
{
        SKGTRACEIN ( 10, "SKGBankBoardWidget::dataModified" );
        if (iTableName=="account" || iTableName.isEmpty()) {
                KLocale* locale=KGlobal::locale();
                QString primary=((SKGDocumentBank*) getDocument())->getPrimaryUnit();

                QString html;
                SKGStringListList listTmp;
                SKGError err=SKGServices::executeSelectSqliteOrder(getDocument(),
                                "SELECT t_name, t_TYPENLS, f_CURRENTAMOUNT, t_close  from v_account_display ORDER BY t_TYPENLS",
                                listTmp);
                if (err.isSucceeded()) {
                        html+="<html><body><table class=\"table\">";
                        double sumTypeV1=0;
                        double sumV1=0;
                        QString currentType;
                        int nb=listTmp.count();
                        for (int i=1; i<nb; ++i) { //Ignore header
                                QString name=listTmp.at(i).at(0);
                                QString type=listTmp.at(i).at(1);
                                double v1=SKGServices::stringToDouble(listTmp.at(i).at(2));
                                bool closed=(listTmp.at(i).at(3)=="Y");
                                if (type!=currentType) {
                                        if (!currentType.isEmpty()) {
                                                html+="<tr class=\"tabletotal\"><td><b>"+i18n("Total of %1", currentType)+"</b></td>"
                                                      "<td align=\"right\"><b><font color=\"" + ( sumTypeV1<0 ? "red" : "black" ) +"\">"+locale->formatMoney(sumTypeV1, primary,2)+"</font></b></td>"
                                                      "</tr>";
                                                sumTypeV1=0;
                                        }
                                        currentType=type;
                                }
                                if (!closed || abs(v1)>0.1) {
                                        html+=QString("<tr><td>")+(closed ? "<i>" : "")+name+(closed ? "</i>" : "")+"</td>"
                                              "<td align=\"right\"><font color=\"" + ( v1<0 ? "red" : "black" ) +"\">"+locale->formatMoney(v1, primary,2)+"</font></td>"
                                              "</tr>";
                                }
                                sumTypeV1+=v1;
                                sumV1+=v1;
                        }

                        if (!currentType.isEmpty()) {
                                html+="<tr class=\"tabletotal\"><td><b>"+i18n("Total of %1", currentType)+"</b></td>"
                                      "<td align=\"right\"><b><font color=\"" + ( sumTypeV1<0 ? "red" : "black" ) +"\">"+locale->formatMoney(sumTypeV1, primary,2)+"</b></font></td>"
                                      "</tr>";
                        }
                        html+="<tr class=\"tabletotal\"><td><b>"+i18n("Total")+"</b></td>"
                              "<td align=\"right\"><b><font color=\"" + ( sumV1<0 ? "red" : "black" ) +"\">"+locale->formatMoney(sumV1, primary,2)+"</b></font></td>"
                              "</tr></b>";
                        html+="</table></body><html>";

                        ui.kLabel->setText(html);
                }
        }
}

#include "skgbankboardwidget.moc"
