/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * Display a summary of your information.
 *
 * @author Guillaume DE BURE
 */
#include "skgdashboard2pluginwidget.h"
#include "skgmainpanel.h"
#include "skgtraces.h"
#include "skgdocument.h"

#include <QDomDocument>
#include <QGraphicsProxyWidget>

#include <QPushButton>

#include <plasma/corona.h>
#include <plasma/popupapplet.h>

SKGDashboard2PluginWidget::SKGDashboard2PluginWidget ( SKGDocument* iDocument )
        :SKGTabPage ( iDocument )
{
    SKGTRACEIN ( 1, "SKGDashboard2PluginWidget::SKGDashboard2PluginWidget" );

    ui.setupUi ( this );

    //Creation of the Corona
    Plasma::Corona* dashboardCorona = new Plasma::Corona ( this );
    if ( dashboardCorona )
    {
        //Creation of the plasma containment
        containment = dashboardCorona->addContainment ( "overallContainment" );

        //Add plasma view in page
        view=new Plasma::View ( containment, this );
        //view->setWallpaperEnabled(false);
        view->setTrackContainmentChanges ( true );
        ui.verticalLayout_6->addWidget ( view );

        view->installEventFilter ( this );

        //TODO: FOLLOWING CODE IS JUST FOR TEST
        // Add a dummy applet, just for the fun of it
        /*{
        QGraphicsProxyWidget* pWidget=new QGraphicsProxyWidget();
        pWidget->setWidget ( new QPushButton("test1") );
        pWidget->show();

        Plasma::PopupApplet* applet=new Plasma::PopupApplet(this, QVariantList());
        applet->setGraphicsWidget ( pWidget );
        applet->setWidget ( new QPushButton("test1") );
        applet->setPopupIcon ("apps-skrooge");
        containment->addApplet(applet);
        }
        {
        QGraphicsProxyWidget* pWidget=new QGraphicsProxyWidget();
        pWidget->setWidget ( new QPushButton("test2") );
        pWidget->show();
        containment->addApplet(new Plasma::Applet(pWidget));
        }*/
        containment->addApplet ( "calculator" );

        KAction* unlock = new KAction ( KIcon ( "document-decrypt" ),i18nc ( "Verb","Unlock Skroogoids" ),this );
        containment->addToolBoxAction ( unlock );
    }
}

SKGDashboard2PluginWidget::~SKGDashboard2PluginWidget()
{
    SKGTRACEIN ( 1, "SKGDashboard2PluginWidget::~SKGDashboard2PluginWidget" );
    containment=NULL;
    view=NULL;
}

QString SKGDashboard2PluginWidget::getState()
{
    SKGTRACEIN ( 10, "SKGDashboard2PluginWidget::getState" );
    QDomDocument doc ( "SKGML" );
    QDomElement root = doc.createElement ( "parameters" );
    doc.appendChild ( root );

    //Get state
    //Example: QString account=root.attribute ( "account");
    //         if (account.isEmpty()) root.setAttribute("account", ui.kDisplayAccountCombo->currentText());

    return doc.toString();
}

void SKGDashboard2PluginWidget::setState ( const QString& iState )
{
    SKGTRACEIN ( 10, "SKGDashboard2PluginWidget::setState" );
    QDomDocument doc ( "SKGML" );
    doc.setContent ( iState );
    QDomElement root = doc.documentElement();

    //Set state
    //Example: QString account=root.attribute ( "account");
}

QString SKGDashboard2PluginWidget::getDefaultStateAttribute()
{
    return "";
}

QWidget* SKGDashboard2PluginWidget::getWidgetForPrint()
{
    return this;
}

void SKGDashboard2PluginWidget::resizeContainment()
{
    SKGTRACEIN ( 1, "SKGDashboard2PluginWidget::resizeContainment" );
    // Set up the containment
    QSizeF parentSize = qobject_cast< const QWidget* > ( this )->size();
    containment->resize ( parentSize.width(),parentSize.height() );
}

bool SKGDashboard2PluginWidget::eventFilter ( QObject *object, QEvent *event )
{
    if ( object==view &&  event && event->type() ==QEvent::Resize )
    {
        resizeContainment();
    }
    return QWidget::eventFilter ( object, event );
}
#include "skgdashboard2pluginwidget.moc"


