/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for operation management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgsplittabledelegate.h"
#include "skgcombobox.h"
#include "skgcalculatoredit.h"
#include "skgmainpanel.h"
/**
 * Index for amount attribute
 */
#define AMOUNTINDEX 1
/**
 * Index for category attribute
 */
#define CATEGORYINDEX 0
/**
 * Index for comment attribute
 */
#define COMMENTINDEX 2
/**
 * Index for refund attribute
 */
#define REFUNDINDEX 3

SKGSplitTableDelegate::SKGSplitTableDelegate ( QObject* parent, const SKGDocument* iDoc ) : QItemDelegate ( parent ), document ( ( SKGDocument* ) iDoc ) {}

SKGSplitTableDelegate::~SKGSplitTableDelegate()
{
    document=NULL;
}

QWidget *SKGSplitTableDelegate::createEditor ( QWidget *parent,
        const QStyleOptionViewItem & option ,
        const QModelIndex & index ) const
{
    if ( index.column() == CATEGORYINDEX )
    {
        SKGComboBox *editor = new SKGComboBox ( parent );
        editor->setEditable ( true );
        if ( document ) SKGMainPanel::fillWithDistinctValue ( editor, document, "category", "t_fullname", "" );

        return editor;
    }
    else if ( index.column() == COMMENTINDEX )
    {
        SKGComboBox *editor = new SKGComboBox ( parent );
        editor->setEditable ( true );
        if ( document ) SKGMainPanel::fillWithDistinctValue ( editor, document, "operation", "t_comment", "" );

        return editor;
    }
    else if ( index.column() == AMOUNTINDEX )
    {
        SKGCalculatorEdit *editor = new SKGCalculatorEdit ( parent );
        editor->setMode ( SKGCalculatorEdit::EXPRESSION );

        return editor;
    }
    else if ( index.column() == REFUNDINDEX )
    {
        SKGComboBox *editor = new SKGComboBox ( parent );
        editor->setEditable ( true );
        if ( document ) SKGMainPanel::fillWithDistinctValue ( editor, document, "refund", "t_name", "t_close='N'" );

        return editor;
    }

    return QItemDelegate::createEditor ( parent, option , index );
}

void SKGSplitTableDelegate::setEditorData ( QWidget* editor, const QModelIndex& index ) const
{
    if ( index.column() == AMOUNTINDEX )
    {
        SKGCalculatorEdit *calculator = static_cast<SKGCalculatorEdit*> ( editor );
        if(calculator) calculator->setText ( index.model()->data ( index,Qt::EditRole ).toString() );
    }
    else
    {
        QItemDelegate::setEditorData ( editor, index );
    }
}

void SKGSplitTableDelegate::setModelData ( QWidget* editor, QAbstractItemModel* model, const QModelIndex& index ) const
{

    if ( index.column() == AMOUNTINDEX )
    {
        SKGCalculatorEdit *calculator = static_cast<SKGCalculatorEdit*> ( editor );
        if(calculator && model) model->setData ( index,calculator->text(),Qt::EditRole );
    }
    else
    {
        QItemDelegate::setModelData ( editor,model,index );
    }
}

#include "skgsplittabledelegate.moc"
