/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGPROPERTIESPLUGINDOCKWIDGET_H
#define SKGPROPERTIESPLUGINDOCKWIDGET_H
/** @file
 * A skrooge plugin to manage properties on objects
*
* @author Stephane MANKOWSKI
*/
#include "ui_skgpropertiesplugindockwidget_base.h"
#include "skgtabpage.h"

/**
 * A skrooge plugin to manage properties on objects
 */
class SKGPropertiesPluginDockWidget : public SKGTabPage
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGPropertiesPluginDockWidget(SKGDocument* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGPropertiesPluginDockWidget();

        /**
         * Get the current selection
         * @return selected objects
         */
        virtual SKGObjectBase::SKGListSKGObjectBase getSelectedObjects();

        /**
         * Get the number of seleted object
         * @return number of selected objects
         */
        virtual int getNbSelectedObjects();

public slots:
        /**
        * Refresh the content.
         */
        virtual void refresh();

private slots:
        void onSelectionChanged();
        void onAddProperty();
        void onRemoveProperty();
        void onSelectFile();
        void cleanEditor();

private:
        Q_DISABLE_COPY(SKGPropertiesPluginDockWidget);

        Ui::skgpropertiesdockplugin_base ui;

};

#endif // SKGPROPERTIESPLUGINDOCKWIDGET_H
