/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGUNITPLUGINWIDGET_H
#define SKGUNITPLUGINWIDGET_H
/** @file
* This file is Skrooge plugin for unit management.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "ui_skgunitpluginwidget_base.h"
#include "skgtabpage.h"
#include "skgunitobject.h"

class SKGDocumentBank;
class SKGObjectModel;

/**
 * This file is Skrooge plugin for unit management
 */
class SKGUnitPluginWidget : public SKGTabPage
{
    Q_OBJECT
    /**
     * This enumerate defines the mode of download
     */
    Q_ENUMS ( UnitDownloadMode );
public:
    /**
     * This enumerate defines the mode of download
     */
    enum UnitDownloadMode {AUTO, 		/**< automatic mode (use setting)*/
                           LAST, 		/**< last value only*/
                           LAST_MONTHLY, 	/**< one value par month since last download*/
                           LAST_WEEKLY, 	/**< one value par week since last download*/
                           LAST_DAILY, 	/**< one value par day since last download*/
                           ALL_MONTHLY, 	/**< one value par month*/
                           ALL_WEEKLY, 	/**< one value par week*/
                           ALL_DAILY 	/**< one value par day*/
                          };

    /**
     * Default Constructor
     */
    SKGUnitPluginWidget ( SKGDocumentBank* iDocument );

    /**
     * Default Destructor
     */
    virtual ~SKGUnitPluginWidget();

    /**
     * Get the current selection
     * @return selected objects
     */
    virtual SKGObjectBase::SKGListSKGObjectBase getSelectedObjects();

    /**
     * Get the number of seleted object
     * @return number of selected objects
     */
    virtual int getNbSelectedObjects();

    /**
     * Get the current state
     * MUST BE OVERWRITTEN
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
    virtual QString getState();

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
    virtual void setState ( const QString& iState );

    /**
     * Get attribute name to save the default state
     * MUST BE OVERWRITTEN
     * @return attribute name to save the default state.
     */
    virtual QString getDefaultStateAttribute();

    /**
     * Download values for a unit
     * @param iUnit unit
     * @param iMode download mode
     * @return an object managing the error
     *   @see SKGError
     */
    static SKGError downloadUnitValue ( const SKGUnitObject& iUnit, UnitDownloadMode iMode=AUTO );

protected:
    /**
     * Event filtering
     * @param object object
     * @param event event
     * @return In your reimplementation of this function, if you want to filter the event out, i.e. stop it being handled further, return true; otherwise return false.
     */
    virtual bool eventFilter ( QObject *object, QEvent *event );

private slots:
    void dataModified ( const QString& iTableName, int iIdTransaction );
    void onSelectionChanged();
    void onSelectionValueChanged();
    void onUnitCreatorModified();
    void onAddUnit();
    void onModifyUnit();
    void onDownloadUnitValue();
    void onDoubleClickUnit();
    void onBtnModeClicked();
    void cleanEditor();

private:
    Q_DISABLE_COPY ( SKGUnitPluginWidget );

    int getCurrentMode();
    void setCurrentMode ( int iMode );

    Ui::skgunitplugin_base ui;;
    SKGObjectModel* objectModel;
    int mode;
};

#endif // SKGDEBUGPLUGIN_H
