/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * Display a summary of your information.
 *
 * @author Siddharth SHARMA
 *
 */

#include "skgdashboard2pluginwidget.h"
#include "skgdashboard2applet.h"
#include "skgmainpanel.h"
#include "skgtraces.h"
#include "skgdocument.h"
#include "skginterfaceplugin.h"
//#include "skgdataengine.h"


#include <QDomDocument>
#include <QGraphicsProxyWidget>
#include <QtGui/QGraphicsLinearLayout>


#include <KAction>
#include <KMessageBox>

#include <Plasma/Applet>
#include <plasma/corona.h>
#include <plasma/popupapplet.h>
#include <Plasma/Corona>
#include <plasma/containmentactions.h>
#include <plasma/view.h>

//#include "skgdashboard2widgetwrapper.h"

SKGDashboard2PluginWidget::SKGDashboard2PluginWidget ( SKGDocument* iDocument )
        :SKGTabPage ( iDocument ) {
    SKGTRACEIN ( 1, "SKGDashboard2PluginWidget::SKGDashboard2PluginWidget" );

    ui.setupUi ( this );
    KService::Ptr service = KService::serviceByDesktopPath ( "plasma-kpart.desktop" );

    //SKGDataEngine* dataengine = new SKGDataEngine ( iDocument );

    if ( service ) {
        QVariantList args = QVariantList() << "Online Services";

        plasmadashboard = service->createInstance<KParts::Part> ( 0,args );

        if ( plasmadashboard ) {
            ui.verticalLayout_6->addWidget ( plasmadashboard->widget() );
        } else {

            KMessageBox::error ( this, i18n ( "Could not instantiate our Part!" ) );
        }
    } else {
        // if we couldn't find our Part, we exit since the Shell by
        // itself can't do anything useful
        KMessageBox::error ( this, i18n ( "Could not find our Part!" ) );
    }
}


SKGDashboard2PluginWidget::~SKGDashboard2PluginWidget() {

}
#include "skgdashboard2pluginwidget.moc"
