/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

/** @file
* This file is Plasma Applet for Account Skroogoid
*
* @author Siddharth SHARMA
*/

#include "accountskroogoid.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgservices.h"
#include "skgaccountobject.h"
#include "skgunitobject.h"
#include "skgmainpanel.h"

#include <QGraphicsLinearLayout>

AccountSkroogoid::AccountSkroogoid( QObject *parent, const QVariantList &args )
        : Plasma::PopupApplet( parent, args )
{
    setAspectRatioMode(Plasma::IgnoreAspectRatio);
    resize(300,300);
    displayLabel=new Plasma::Label();
    gl_layout=new QGraphicsLinearLayout();
    setLayout(gl_layout);

    KLocale* locale=KGlobal::locale();
    QString html;
    SKGMainPanel* panel=SKGMainPanel::getMainPanel();
    SKGDocumentBank* doc= dynamic_cast<SKGDocumentBank*> ( panel->getDocument() );
    if ( doc )
    {
        SKGServices::SKGUnitInfo primary=doc->getPrimaryUnit();
        int nbAccount=0;
        SKGError err=SKGObjectBase::getNbObjects ( doc, "account", "", nbAccount );
        SKGStringListList listTmp;
        err=SKGServices::executeSelectSqliteOrder ( doc,
                "SELECT t_name, t_TYPENLS, f_CURRENTAMOUNT, t_close  from v_account_display ORDER BY t_TYPENLS, t_name",
                listTmp );
        if ( err.isSucceeded() )
        {
            html+="<html><body><table class=\"table\">";
            double sumTypeV1=0;
            double sumV1=0;
            QString currentType;
            int nb=listTmp.count();
            for ( int i=1; i<nb; ++i ) //Ignore header
            {
                QString name=listTmp.at ( i ).at ( 0 );
                QString type=listTmp.at ( i ).at ( 1 );
                double v1=SKGServices::stringToDouble ( listTmp.at ( i ).at ( 2 ) );
                bool closed= ( listTmp.at ( i ).at ( 3 ) =="Y" );

                if ( type!=currentType )
                {
                    if ( !currentType.isEmpty() )
                    {
                        html+="<tr class=\"tabletotal\"><td><b>"+SKGServices::stringToHtml ( i18nc ("Message", "Total of %1", currentType ) ) +"</b></td>"
                              "<td align=\"right\"><b>"+doc->formatMoney ( sumTypeV1, primary ) +"</b></td></tr>";
                        sumTypeV1=0;
                    }
                    currentType=type;
                }
                if ( !closed || abs ( v1 ) >0.1 )
                {
                    SKGAccountObject account ( panel->getDocument() );
                    account.setName ( name );
                    account.load();

                    SKGUnitObject unitAccount;
                    account.getUnit ( unitAccount );
                    QString unitAccountSymbol=unitAccount.getSymbol();

                    html+=QString ( "<tr><td><a href=\""+SKGServices::stringToHtml ( name ) +"\">" ) + ( closed ? "<i>" : "" ) +SKGServices::stringToHtml ( name ) + ( closed ? "</i>" : "" ) +"</a></td>"
                          "<td align=\"right\"><font color=\"" + ( v1<0 ? "red" : "black" ) +"\">";

                    if ( !unitAccountSymbol.isEmpty() && primary.Symbol!=unitAccountSymbol )
                    {
                        double unitAccountValue=SKGServices::stringToDouble ( unitAccount.getAttribute ( "f_CURRENTAMOUNT" ) );
                        html+=SKGServices::stringToHtml ( locale->formatMoney ( v1/unitAccountValue, unitAccountSymbol,unitAccount.getNumberDecimal() ) );
                        html+='=';
                    }
                    html+=SKGServices::stringToHtml ( locale->formatMoney ( v1, primary.Symbol, primary.NbDecimal ) );
                    html+="</font></td></tr>";
                }
                sumTypeV1+=v1;
                sumV1+=v1;
            }

            if ( !currentType.isEmpty() )
            {
                html+="<tr class=\"tabletotal\"><td><b>"+SKGServices::stringToHtml ( i18nc ("the numerical total of a sum of values", "Total of %1", currentType ) ) +"</b></td>"
                      "<td align=\"right\"><b>"+doc->formatMoney ( sumTypeV1, primary ) +"</b></font></td>"
                      "</tr>";
            }
            html+="<tr class=\"tabletotal\"><td><b><a href=\""+SKGServices::stringToHtml ( i18nc ( "Noun, all items in a list","All" ) ) +
                  "\">"+SKGServices::stringToHtml ( i18nc ( "Noun, the numerical total of a sum of values","Total" ) ) +"</a></b></td>"
                  "<td align=\"right\"><b>"+doc->formatMoney ( sumV1, primary ) +"</b></font></td>"
                  "</tr></b>";
            html+="</table></body></html>";
        }
    }
    displayLabel->setText ( html );
    gl_layout->addItem(displayLabel);
}


AccountSkroogoid::~AccountSkroogoid()
{
}


#include "accountskroogoid.moc"
