/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

#ifndef BANKSKROOGOID_H
#define BANKSKROOGOID_H
/** @file
* This file is Plasma Applet for Bank Skroogoid
*
* @author Siddharth SHARMA
*/
#include <Plasma/PopupApplet>
#include <Plasma/Label>


class QGraphicsLinearLayout;
/**
 * Class BankSkroogoid
 */
class BankSkroogoid : public Plasma::PopupApplet
{
    Q_OBJECT

public:
     /**
       * Default Constructor
       */
    BankSkroogoid( QObject *parent, const QVariantList &args );
    
    /**
      * Default Destructor
      */
    ~BankSkroogoid();
    
private:
    /**
      * QGraphicsLinearLayout layout for adding items
      */
    QGraphicsLinearLayout *gl_layout;
    
    /**
      * Plasma Label that is used to display fetched result on to skroogoid
      */
    Plasma::Label* displayLabel;
};

/**
  * For exporting skroogoid as a registered Plasma Applet
  */
K_EXPORT_PLASMA_APPLET(bankskroogoid, BankSkroogoid)

#endif
