/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a query creator for skrooge
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgpropertyeditor.h"
#include <QListWidget>

SKGPropertyEditor::SKGPropertyEditor(QWidget* parent): QWidget(parent)
{
    ui.setupUi(this);

    ui.removeLineButton->setIcon( KIcon ( "list-remove" ) );

    listOperations << i18nc("Define a value in a text input","Set value...");
    listOperations << i18nc("Define an attribute's value using the value of another attribute","From attribute...");
    listOperations << i18nc("Change the case of a string, as in lowercase, uppercase...","Change case...");

    for ( int i=0 ; i<listOperations.count() ; i++ )
    {
        ui.operationSelect->addItem( listOperations.at(i) );
    }

    ui.caseSelect->addItem(i18nc("Change a string to lowercase","lowercase"));
    ui.caseSelect->addItem(i18nc("Change a string to uppercase","uppercase"));

    // Destroy me when clicking on the button
    connect(ui.removeLineButton,SIGNAL(clicked(bool)),this,SLOT(deleteLater()));

    // Display relevant widgets depending on attributes and operations
    connect(ui.attributeSelect,SIGNAL(currentIndexChanged(int)),this,SLOT(setupWidgets()));
    connect(ui.operationSelect,SIGNAL(currentIndexChanged(int)),this,SLOT(setupWidgets()));
    connect(ui.substringTextBox,SIGNAL(stateChanged(int)),this,SLOT(setupWidgets()));

}

SKGPropertyEditor::~SKGPropertyEditor()
{

}

void SKGPropertyEditor::setParameters(SKGDocument* iDocument, const QString& iTable, const QStringList& iEditableAttribute, const QStringList& iOtherAttributes)
{
    document=iDocument;
    table=iTable;

    if ( document )
    {
        //Keep only existing attribute
        SKGServices::SKGAttributesList attributes;
        SKGServices::getAttributesDescription ( document, table, attributes );
        foreach ( const SKGServices::SKGAttributeInfo& att, attributes )
        {
            if ( iEditableAttribute.count() ==0 || iEditableAttribute.contains ( att.name ) ) listAtts.push_back ( att );
        }


        int nbCol=listAtts.count();
        for ( int i=0; i<nbCol; ++i )
        {
            ui.attributeSelect->addItem(listAtts.at(i).icon, (QString) listAtts.at(i).display);
        }


        SKGServices::SKGAttributesList otherAttributes;
        SKGServices::getAttributesDescription ( document, table, otherAttributes );
        foreach ( const SKGServices::SKGAttributeInfo& att, otherAttributes )
        {
            if ( iOtherAttributes.count() ==0 || iOtherAttributes.contains ( att.name ) ) listOtherAtts.push_back ( att );
        }


        int nbOthCol=listOtherAtts.count();
        for ( int i=0; i<nbOthCol; ++i )
        {
            ui.otherAttributeSelect->addItem(listOtherAtts.at(i).icon, (QString) listOtherAtts.at(i).display);
        }

    }
}

void SKGPropertyEditor::setupWidgets()
{
    int attributeIndex = ui.attributeSelect->currentIndex();
    SKGServices::AttributeType attributeType;
    attributeType = listAtts.at(attributeIndex).type;

    int operationIndex = ui.operationSelect->currentIndex();

    ui.operationSelect->setVisible(attributeType == SKGServices::TEXT);
    ui.checkBox->setVisible(attributeType == SKGServices::BOOL || attributeType == SKGServices::TRISTATE);
    ui.checkBox->setTristate(attributeType == SKGServices::TRISTATE);

    ui.valueSelect->setVisible(attributeType == SKGServices::TEXT && operationIndex == 0);
    QStringList attributeValues;
    SKGServices::getDistinctValues(document,table,listAtts.at(attributeIndex).name,attributeValues);
    ui.valueSelect->clear();
    ui.valueSelect->addItem("");

    ui.valueSelect->addItems(attributeValues);

    ui.otherAttributeSelect->setVisible(attributeType == SKGServices::TEXT && operationIndex == 1);
    ui.substringWidget->setVisible(attributeType == SKGServices::TEXT && operationIndex == 1);
    ui.caseSelect->setVisible(attributeType == SKGServices::TEXT && operationIndex == 2);

    ui.intValueStart->setEnabled(ui.substringTextBox->isChecked());
    ui.toLabel->setEnabled(ui.substringTextBox->isChecked());
    ui.intValueEnd->setEnabled(ui.substringTextBox->isChecked());


}


void SKGPropertyEditor::setXMLCondition(QString iXML)
{

}

QString SKGPropertyEditor::getAttribute()
{
    int index = ui.attributeSelect->currentIndex();
    return listAtts.at(index).name;
}

QString SKGPropertyEditor::getOperator()
{
    if (ui.operationSelect->currentIndex() == 0) {
        return QString('=');
    }
    return "";
}
