/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A table widget with more features.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtablewidget.h"

#include <QKeyEvent>

SKGTableWidget::SKGTableWidget(QWidget *parent)
        : QTableWidget(parent)
{
    this->installEventFilter ( this );
}

SKGTableWidget::~SKGTableWidget()
{
}

bool SKGTableWidget::eventFilter ( QObject *object, QEvent *event )
{
    if (object==this)
    {
        QKeyEvent* kevent=dynamic_cast<QKeyEvent*>(event);
        if (kevent && kevent->key()==Qt::Key_Delete && state()!=QAbstractItemView::EditingState)
        {
            QList<QTableWidgetItem*> selectedItems = this->selectedItems();
            if (selectedItems.count() >0)
            {
                Q_EMIT removeSelectedItems();
                if (event) event->accept();
                return true; //stop the process
            }
        }
    }

    return false;
}

#include "skgtablewidget.moc"
