/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGMONTHLYPLUGINWIDGET_H
#define SKGMONTHLYPLUGINWIDGET_H
/** @file
 * A skrooge plugin for monthlu report
*
* @author Stephane MANKOWSKI
*/
#include "ui_skgmonthlypluginwidget_base.h"
#include "skgtabpage.h"

class SKGDocumentBank;
/**
 * A skrooge plugin for monthly report
 */
class SKGMonthlyPluginWidget : public SKGTabPage
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     */
    SKGMonthlyPluginWidget(SKGDocument* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGMonthlyPluginWidget();

    /**
     * Get the current state
     * MUST BE OVERWRITTEN
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
    virtual QString getState();

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
    virtual void setState(const QString& iState);

    /**
     * Get attribute name to save the default state
     * MUST BE OVERWRITTEN
     * @return attribute name to save the default state.
     */
    virtual QString getDefaultStateAttribute();

    /**
     * Get the main widget
     * @return a widget
     */
    virtual QWidget* mainWidget() const;

    /**
     * Get 5 main category report
     * @param iDocument the document
     * @param iMonth the month
     * @param iChart to add chart
     * @return the html report
     */
    static QString get5MainCategories(SKGDocumentBank* iDocument, const QString& iMonth, bool iChart=true);

    /**
     * Get 5 main variation of categories report
     * @param iDocument the document
     * @param iMonth the month
     * @param iPreviousMonth the previous month
     * @param iOnlyIssues only "Expenses increased" and "Incomes decreased"
     * @param oCategoryList to get the category for each variation
     * @return the list of variation string
     */
    static QStringList get5MainCategoriesVariationList (SKGDocumentBank* iDocument, const QString& iMonth, const QString& iPreviousMonth, bool iOnlyIssues=false, QStringList* oCategoryList=NULL );

    /**
     * Get 5 main variation of categories report
     * @param iDocument the document
     * @param iMonth the month
     * @param iPreviousMonth the previous month
     * @param iOnlyIssues only "Expenses increased" and "Incomes decreased"
     * @return the html report
     */
    static QString get5MainCategoriesVariation (SKGDocumentBank* iDocument, const QString& iMonth, const QString& iPreviousMonth, bool iOnlyIssues=false );

private Q_SLOTS:
    void dataModified(const QString& iTableName, int iIdTransaction);
    void onMonthChanged();
    void onReportRefresh();
    void onPrint();
private:
    Q_DISABLE_COPY(SKGMonthlyPluginWidget);


    QString getMonth();

    Ui::skgmonthlyplugin_base ui;
};

#endif // SKGMonthlyPLUGINWIDGET_H
